/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;

public enum ADTaskType {
    HISTORICAL,
    REALTIME_SINGLE_ENTITY,
    REALTIME_HC_DETECTOR,
    HISTORICAL_SINGLE_ENTITY,
    HISTORICAL_HC_DETECTOR,
    HISTORICAL_HC_ENTITY;

    public static List<ADTaskType> HISTORICAL_DETECTOR_TASK_TYPES;
    public static List<ADTaskType> ALL_HISTORICAL_TASK_TYPES;
    public static List<ADTaskType> REALTIME_TASK_TYPES;
    public static List<ADTaskType> ALL_DETECTOR_TASK_TYPES;

    public static List<String> taskTypeToString(List<ADTaskType> adTaskTypes) {
        return adTaskTypes.stream().map(type -> type.name()).collect(Collectors.toList());
    }

    static {
        HISTORICAL_DETECTOR_TASK_TYPES = ImmutableList.of((Object)((Object)HISTORICAL_HC_DETECTOR), (Object)((Object)HISTORICAL_SINGLE_ENTITY), (Object)((Object)HISTORICAL));
        ALL_HISTORICAL_TASK_TYPES = ImmutableList.of((Object)((Object)HISTORICAL_HC_DETECTOR), (Object)((Object)HISTORICAL_SINGLE_ENTITY), (Object)((Object)HISTORICAL_HC_ENTITY), (Object)((Object)HISTORICAL));
        REALTIME_TASK_TYPES = ImmutableList.of((Object)((Object)REALTIME_SINGLE_ENTITY), (Object)((Object)REALTIME_HC_DETECTOR));
        ALL_DETECTOR_TASK_TYPES = ImmutableList.of((Object)((Object)REALTIME_SINGLE_ENTITY), (Object)((Object)REALTIME_HC_DETECTOR), (Object)((Object)HISTORICAL_SINGLE_ENTITY), (Object)((Object)HISTORICAL_HC_DETECTOR), (Object)((Object)HISTORICAL));
    }
}

