/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.util.SetOnce;
import org.opensearch.ad.annotation.Generated;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.common.Numbers;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.TermQueryBuilder;

public class Entity
implements ToXContentObject,
Writeable {
    private static final long RANDOM_SEED = 42L;
    private static final String MODEL_ID_INFIX = "_entity_";
    public static final String ATTRIBUTE_NAME_FIELD = "name";
    public static final String ATTRIBUTE_VALUE_FIELD = "value";
    private SetOnce<String> modelId = new SetOnce();
    private final SortedMap<String, String> attributes;

    public static Entity createEntityByReordering(Map<String, Object> attrs) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        for (Map.Entry<String, Object> categoryValuePair : attrs.entrySet()) {
            sortedMap.put(categoryValuePair.getKey(), categoryValuePair.getValue().toString());
        }
        return new Entity(sortedMap);
    }

    public static Entity createSingleAttributeEntity(String attributeName, String attributeVal) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.put(attributeName, attributeVal);
        return new Entity(sortedMap);
    }

    public static Entity createEntityFromOrderedMap(SortedMap<String, String> attrs) {
        return new Entity(attrs);
    }

    private Entity(SortedMap<String, String> orderedAttrs) {
        this.attributes = orderedAttrs;
    }

    public Entity(StreamInput input) throws IOException {
        this.attributes = new TreeMap<String, String>(input.readMap(StreamInput::readString, StreamInput::readString));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            builder.startObject().field(ATTRIBUTE_NAME_FIELD, attr.getKey()).field(ATTRIBUTE_VALUE_FIELD, attr.getValue()).endObject();
        }
        builder.endArray();
        return builder;
    }

    public List<Map<String, String>> toStat() {
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(this.attributes.size() * 2);
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            TreeMap<String, String> elements = new TreeMap<String, String>();
            elements.put(ATTRIBUTE_NAME_FIELD, attr.getKey());
            elements.put(ATTRIBUTE_VALUE_FIELD, attr.getValue());
            res.add(elements);
        }
        return res;
    }

    public static Entity parse(XContentParser parser) throws IOException {
        TreeMap<String, String> entities = new TreeMap<String, String>();
        String parsedValue = null;
        String parsedName = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                switch (fieldName) {
                    case "name": {
                        parsedName = parser.text();
                        break;
                    }
                    case "value": {
                        parsedValue = parser.text();
                        break;
                    }
                }
            }
            if (parsedName == null || parsedValue == null) continue;
            entities.put(parsedName, parsedValue);
            parsedValue = null;
            parsedName = null;
        }
        return new Entity(entities);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity that = (Entity)o;
        return Objects.equal(this.attributes, that.attributes);
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attributes});
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeString);
    }

    public String toString() {
        return Entity.normalizedAttributes(this.attributes);
    }

    private static String normalizedAttributes(SortedMap<String, String> attributes) {
        return Joiner.on((String)",").withKeyValueSeparator("=").join(attributes);
    }

    public static Optional<String> getModelId(String detectorId, SortedMap<String, String> attributes) {
        if (attributes.isEmpty()) {
            return Optional.empty();
        }
        if (attributes.size() == 1) {
            Iterator<Map.Entry<String, String>> iterator = attributes.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, String> categoryValuePair = iterator.next();
                String categoricalValue = categoryValuePair.getValue().toString();
                if (categoricalValue.length() > AnomalyDetectorSettings.MAX_ENTITY_LENGTH) {
                    return Optional.empty();
                }
                return Optional.of(detectorId + MODEL_ID_INFIX + categoricalValue);
            }
            return Optional.empty();
        }
        String normalizedFields = Entity.normalizedAttributes(attributes);
        MurmurHash3.Hash128 hashFunc = MurmurHash3.hash128((byte[])normalizedFields.getBytes(StandardCharsets.UTF_8), (int)0, (int)normalizedFields.length(), (long)42L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
        byte[] bytes = new byte[16];
        System.arraycopy(Numbers.longToBytes((long)hashFunc.h1), 0, bytes, 0, 8);
        System.arraycopy(Numbers.longToBytes((long)hashFunc.h2), 0, bytes, 8, 8);
        return Optional.of(detectorId + MODEL_ID_INFIX + Base64.getUrlEncoder().withoutPadding().encodeToString(bytes));
    }

    public Optional<String> getModelId(String detectorId) {
        if (this.modelId.get() == null) {
            Optional<String> computedModelId = Entity.getModelId(detectorId, this.attributes);
            if (computedModelId.isPresent()) {
                this.modelId.set((Object)computedModelId.get());
            } else {
                this.modelId.set(null);
            }
        }
        return Optional.ofNullable((String)this.modelId.get());
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<TermQueryBuilder> getTermQueryBuilders() {
        ArrayList<TermQueryBuilder> res = new ArrayList<TermQueryBuilder>();
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            res.add(new TermQueryBuilder(attribute.getKey(), attribute.getValue()));
        }
        return res;
    }

    public List<TermQueryBuilder> getTermQueryBuilders(String pathPrefix) {
        ArrayList<TermQueryBuilder> res = new ArrayList<TermQueryBuilder>();
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            res.add(new TermQueryBuilder(pathPrefix + attribute.getKey(), attribute.getValue()));
        }
        return res;
    }

    public static Entity fromJsonArray(Object entityValue) throws IOException {
        XContentBuilder content = JsonXContent.contentBuilder();
        content.startObject();
        content.field("entity", entityValue);
        content.endObject();
        try (StreamInput stream = BytesReference.bytes((XContentBuilder)content).streamInput();){
            Entity entity;
            block12: {
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    parser.nextToken();
                    parser.nextToken();
                    parser.nextToken();
                    entity = Entity.parse(parser);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return entity;
        }
    }

    public static Optional<Entity> fromJsonObject(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (!"entity".equals(parser.currentName())) {
                return Optional.empty();
            }
            parser.nextToken();
            return Optional.of(Entity.parse(parser));
        }
        return Optional.empty();
    }
}

