
#ifndef KCRASH_EXPORT_H
#define KCRASH_EXPORT_H

#ifdef KCRASH_STATIC_DEFINE
#  define KCRASH_EXPORT
#  define KCRASH_NO_EXPORT
#else
#  ifndef KCRASH_EXPORT
#    ifdef KF6Crash_EXPORTS
        /* We are building this library */
#      define KCRASH_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KCRASH_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KCRASH_NO_EXPORT
#    define KCRASH_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KCRASH_DECL_DEPRECATED
#  define KCRASH_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KCRASH_DECL_DEPRECATED_EXPORT
#  define KCRASH_DECL_DEPRECATED_EXPORT KCRASH_EXPORT KCRASH_DECL_DEPRECATED
#endif

#ifndef KCRASH_DECL_DEPRECATED_NO_EXPORT
#  define KCRASH_DECL_DEPRECATED_NO_EXPORT KCRASH_NO_EXPORT KCRASH_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCRASH_NO_DEPRECATED
#    define KCRASH_NO_DEPRECATED
#  endif
#endif
#include <kcrash_version.h>

#define KCRASH_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KCRASH_NO_DEPRECATED) && !defined(KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCRASH_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCRASH_NO_DEPRECATED_WARNINGS) && !defined(KCRASH_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCRASH_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCRASH_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCRASH_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCRASH_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCRASH_NO_DEPRECATED)
#  undef KCRASH_DEPRECATED
#  define KCRASH_DEPRECATED_EXPORT KCRASH_EXPORT
#  define KCRASH_DEPRECATED_NO_EXPORT KCRASH_NO_EXPORT
#elif defined(KCRASH_NO_DEPRECATED_WARNINGS)
#  define KCRASH_DEPRECATED
#  define KCRASH_DEPRECATED_EXPORT KCRASH_EXPORT
#  define KCRASH_DEPRECATED_NO_EXPORT KCRASH_NO_EXPORT
#else
#  define KCRASH_DEPRECATED KCRASH_DECL_DEPRECATED
#  define KCRASH_DEPRECATED_EXPORT KCRASH_DECL_DEPRECATED_EXPORT
#  define KCRASH_DEPRECATED_NO_EXPORT KCRASH_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCRASH_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCRASH_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCRASH_NO_DEPRECATED
#  define KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT KCRASH_VERSION
#endif
#ifdef KCRASH_NO_DEPRECATED_WARNINGS
#  define KCRASH_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCRASH_DEPRECATED_WARNINGS_SINCE
#  ifdef KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCRASH_DEPRECATED_WARNINGS_SINCE KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCRASH_DEPRECATED_WARNINGS_SINCE KCRASH_VERSION
#  endif
#endif

#ifndef KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCRASH_DEPRECATED
#  define KCRASH_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCRASH_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCRASH_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KCRASH_EXPORT_H */
