"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspacePlugin = void 0;
var _operators = require("rxjs/operators");
var _constants = require("../common/constants");
var _workspace_client = require("./workspace_client");
var _routes = require("./routes");
var _saved_objects = require("./saved_objects");
var _utils = require("../../../core/server/utils");
var _saved_objects_wrapper_for_check_workspace_conflict = require("./saved_objects/saved_objects_wrapper_for_check_workspace_conflict");
var _client = require("./permission_control/client");
var _workspace_id_consumer_wrapper = require("./saved_objects/workspace_id_consumer_wrapper");
var _workspace_ui_settings_client_wrapper = require("./saved_objects/workspace_ui_settings_client_wrapper");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class WorkspacePlugin {
  proxyWorkspaceTrafficToRealHandler(setupDeps) {
    /**
     * Proxy all {basePath}/w/{workspaceId}{osdPath*} paths to {basePath}{osdPath*}
     */
    setupDeps.http.registerOnPreRouting(async (request, response, toolkit) => {
      const workspaceId = (0, _utils.getWorkspaceIdFromUrl)(request.url.toString(), '' // No need to pass basePath here because the request.url will be rewrite by registerOnPreRouting method in `src/core/server/http/http_server.ts`
      );

      if (workspaceId) {
        (0, _utils.updateWorkspaceState)(request, {
          requestWorkspaceId: workspaceId
        });
        const requestUrl = new URL(request.url.toString());
        requestUrl.pathname = (0, _utils.cleanWorkspaceId)(requestUrl.pathname);
        return toolkit.rewriteUrl(requestUrl.toString());
      }
      return toolkit.next();
    });
  }
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "workspaceConflictControl", void 0);
    _defineProperty(this, "permissionControl", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    _defineProperty(this, "workspaceSavedObjectsClientWrapper", void 0);
    _defineProperty(this, "workspaceUiSettingsClientWrapper", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core) {
    this.logger.debug('Setting up Workspaces service');
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const isPermissionControlEnabled = globalConfig.savedObjects.permission.enabled === true;
    this.client = new _workspace_client.WorkspaceClient(core);
    await this.client.setup(core);
    this.workspaceConflictControl = new _saved_objects_wrapper_for_check_workspace_conflict.WorkspaceConflictSavedObjectsClientWrapper();
    core.savedObjects.addClientWrapper(_constants.PRIORITY_FOR_WORKSPACE_CONFLICT_CONTROL_WRAPPER, _constants.WORKSPACE_CONFLICT_CONTROL_SAVED_OBJECTS_CLIENT_WRAPPER_ID, this.workspaceConflictControl.wrapperFactory);
    this.proxyWorkspaceTrafficToRealHandler(core);
    const workspaceUiSettingsClientWrapper = new _workspace_ui_settings_client_wrapper.WorkspaceUiSettingsClientWrapper(this.logger);
    this.workspaceUiSettingsClientWrapper = workspaceUiSettingsClientWrapper;
    core.savedObjects.addClientWrapper(_constants.PRIORITY_FOR_WORKSPACE_UI_SETTINGS_WRAPPER, _constants.WORKSPACE_UI_SETTINGS_CLIENT_WRAPPER_ID, workspaceUiSettingsClientWrapper.wrapperFactory);
    core.savedObjects.addClientWrapper(_constants.PRIORITY_FOR_WORKSPACE_ID_CONSUMER_WRAPPER, _constants.WORKSPACE_ID_CONSUMER_WRAPPER_ID, new _workspace_id_consumer_wrapper.WorkspaceIdConsumerWrapper(isPermissionControlEnabled).wrapperFactory);
    const maxImportExportSize = core.savedObjects.getImportExportObjectLimit();
    this.logger.info('Workspace permission control enabled:' + isPermissionControlEnabled);
    if (isPermissionControlEnabled) {
      this.permissionControl = new _client.SavedObjectsPermissionControl(this.logger);
      this.workspaceSavedObjectsClientWrapper = new _saved_objects.WorkspaceSavedObjectsClientWrapper(this.permissionControl);
      core.savedObjects.addClientWrapper(_constants.PRIORITY_FOR_PERMISSION_CONTROL_WRAPPER, _constants.WORKSPACE_SAVED_OBJECTS_CLIENT_WRAPPER_ID, this.workspaceSavedObjectsClientWrapper.wrapperFactory);
    }
    (0, _routes.registerRoutes)({
      http: core.http,
      logger: this.logger,
      client: this.client,
      maxImportExportSize,
      permissionControlClient: this.permissionControl,
      isPermissionControlEnabled
    });
    core.capabilities.registerProvider(() => ({
      workspaces: {
        enabled: true,
        permissionEnabled: isPermissionControlEnabled
      }
    }));
    return {
      client: this.client
    };
  }
  start(core) {
    var _this$permissionContr, _this$client, _this$workspaceConfli, _this$workspaceSavedO, _this$workspaceUiSett;
    this.logger.debug('Starting Workspace service');
    (_this$permissionContr = this.permissionControl) === null || _this$permissionContr === void 0 || _this$permissionContr.setup(core.savedObjects.getScopedClient, core.http.auth);
    (_this$client = this.client) === null || _this$client === void 0 || _this$client.setSavedObjects(core.savedObjects);
    (_this$workspaceConfli = this.workspaceConflictControl) === null || _this$workspaceConfli === void 0 || _this$workspaceConfli.setSerializer(core.savedObjects.createSerializer());
    (_this$workspaceSavedO = this.workspaceSavedObjectsClientWrapper) === null || _this$workspaceSavedO === void 0 || _this$workspaceSavedO.setScopedClient(core.savedObjects.getScopedClient);
    (_this$workspaceUiSett = this.workspaceUiSettingsClientWrapper) === null || _this$workspaceUiSett === void 0 || _this$workspaceUiSett.setScopedClient(core.savedObjects.getScopedClient);
    return {
      client: this.client
    };
  }
  stop() {}
}
exports.WorkspacePlugin = WorkspacePlugin;