/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint.operation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.client.EMRServerlessClient;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexState;
import org.opensearch.sql.spark.flint.FlintIndexStateModel;
import org.opensearch.sql.spark.flint.operation.FlintIndexOp;

public class FlintIndexOpCancel
extends FlintIndexOp {
    private static final Logger LOG = LogManager.getLogger();
    private final EMRServerlessClient emrServerlessClient;

    public FlintIndexOpCancel(StateStore stateStore, String datasourceName, EMRServerlessClient emrServerlessClient) {
        super(stateStore, datasourceName);
        this.emrServerlessClient = emrServerlessClient;
    }

    @Override
    public boolean validate(FlintIndexState state) {
        return state == FlintIndexState.REFRESHING;
    }

    @Override
    FlintIndexState transitioningState() {
        return FlintIndexState.CANCELLING;
    }

    @Override
    void runOp(FlintIndexMetadata flintIndexMetadata, FlintIndexStateModel flintIndexStateModel) {
        LOG.debug("Performing drop index operation for index: {}", (Object)flintIndexMetadata.getOpensearchIndexName());
        this.cancelStreamingJob(this.emrServerlessClient, flintIndexStateModel);
    }

    @Override
    FlintIndexState stableState() {
        return FlintIndexState.ACTIVE;
    }
}

