# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AuthInfoBase(_serialization.Model):
    """The authentication info.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AccessKeyInfoBase, EasyAuthMicrosoftEntraIDAuthInfo, SecretAuthInfo,
    ServicePrincipalCertificateAuthInfo, ServicePrincipalSecretAuthInfo,
    SystemAssignedIdentityAuthInfo, UserAccountAuthInfo, UserAssignedIdentityAuthInfo

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
    }

    _subtype_map = {
        "auth_type": {
            "accessKey": "AccessKeyInfoBase",
            "easyAuthMicrosoftEntraID": "EasyAuthMicrosoftEntraIDAuthInfo",
            "secret": "SecretAuthInfo",
            "servicePrincipalCertificate": "ServicePrincipalCertificateAuthInfo",
            "servicePrincipalSecret": "ServicePrincipalSecretAuthInfo",
            "systemAssignedIdentity": "SystemAssignedIdentityAuthInfo",
            "userAccount": "UserAccountAuthInfo",
            "userAssignedIdentity": "UserAssignedIdentityAuthInfo",
        }
    }

    def __init__(self, *, auth_mode: Optional[Union[str, "_models.AuthMode"]] = None, **kwargs: Any) -> None:
        """
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        """
        super().__init__(**kwargs)
        self.auth_type: Optional[str] = None
        self.auth_mode = auth_mode


class AccessKeyInfoBase(AuthInfoBase):
    """The access key directly from target resource properties, which target service is Azure
    Resource, such as Microsoft.Storage.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    :ivar permissions: Permissions of the accessKey. ``Read`` and ``Write`` are for Azure Cosmos DB
     and Azure App Configuration, ``Listen``\ , ``Send`` and ``Manage`` are for Azure Event Hub and
     Azure Service Bus.
    :vartype permissions: list[str or ~azure.mgmt.servicelinker.models.AccessKeyPermissions]
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
        "permissions": {"key": "permissions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        auth_mode: Optional[Union[str, "_models.AuthMode"]] = None,
        permissions: Optional[List[Union[str, "_models.AccessKeyPermissions"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        :keyword permissions: Permissions of the accessKey. ``Read`` and ``Write`` are for Azure Cosmos
         DB and Azure App Configuration, ``Listen``\ , ``Send`` and ``Manage`` are for Azure Event Hub
         and Azure Service Bus.
        :paramtype permissions: list[str or ~azure.mgmt.servicelinker.models.AccessKeyPermissions]
        """
        super().__init__(auth_mode=auth_mode, **kwargs)
        self.auth_type: str = "accessKey"
        self.permissions = permissions


class AzureResourcePropertiesBase(_serialization.Model):
    """The azure resource properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureKeyVaultProperties

    All required parameters must be populated in order to send to Azure.

    :ivar type: The azure resource type. Required. "KeyVault"
    :vartype type: str or ~azure.mgmt.servicelinker.models.AzureResourceType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"KeyVault": "AzureKeyVaultProperties"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class AzureKeyVaultProperties(AzureResourcePropertiesBase):
    """The resource properties when type is Azure Key Vault.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The azure resource type. Required. "KeyVault"
    :vartype type: str or ~azure.mgmt.servicelinker.models.AzureResourceType
    :ivar connect_as_kubernetes_csi_driver: True if connect via Kubernetes CSI Driver.
    :vartype connect_as_kubernetes_csi_driver: bool
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "connect_as_kubernetes_csi_driver": {"key": "connectAsKubernetesCsiDriver", "type": "bool"},
    }

    def __init__(self, *, connect_as_kubernetes_csi_driver: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword connect_as_kubernetes_csi_driver: True if connect via Kubernetes CSI Driver.
        :paramtype connect_as_kubernetes_csi_driver: bool
        """
        super().__init__(**kwargs)
        self.type: str = "KeyVault"
        self.connect_as_kubernetes_csi_driver = connect_as_kubernetes_csi_driver


class TargetServiceBase(_serialization.Model):
    """The target service properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureResource, ConfluentBootstrapServer, ConfluentSchemaRegistry, SelfHostedServer

    All required parameters must be populated in order to send to Azure.

    :ivar type: The target service type. Required. Known values are: "AzureResource",
     "ConfluentBootstrapServer", "ConfluentSchemaRegistry", and "SelfHostedServer".
    :vartype type: str or ~azure.mgmt.servicelinker.models.TargetServiceType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "AzureResource": "AzureResource",
            "ConfluentBootstrapServer": "ConfluentBootstrapServer",
            "ConfluentSchemaRegistry": "ConfluentSchemaRegistry",
            "SelfHostedServer": "SelfHostedServer",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class AzureResource(TargetServiceBase):
    """The azure resource info when target service type is AzureResource.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The target service type. Required. Known values are: "AzureResource",
     "ConfluentBootstrapServer", "ConfluentSchemaRegistry", and "SelfHostedServer".
    :vartype type: str or ~azure.mgmt.servicelinker.models.TargetServiceType
    :ivar id: The Id of azure resource.
    :vartype id: str
    :ivar resource_properties: The azure resource connection related properties.
    :vartype resource_properties: ~azure.mgmt.servicelinker.models.AzureResourcePropertiesBase
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "resource_properties": {"key": "resourceProperties", "type": "AzureResourcePropertiesBase"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        resource_properties: Optional["_models.AzureResourcePropertiesBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The Id of azure resource.
        :paramtype id: str
        :keyword resource_properties: The azure resource connection related properties.
        :paramtype resource_properties: ~azure.mgmt.servicelinker.models.AzureResourcePropertiesBase
        """
        super().__init__(**kwargs)
        self.type: str = "AzureResource"
        self.id = id
        self.resource_properties = resource_properties


class DryrunPrerequisiteResult(_serialization.Model):
    """A result of dryrun.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BasicErrorDryrunPrerequisiteResult, PermissionsMissingDryrunPrerequisiteResult

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of dryrun result. Required. Known values are: "basicError" and
     "permissionsMissing".
    :vartype type: str or ~azure.mgmt.servicelinker.models.DryrunPrerequisiteResultType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "basicError": "BasicErrorDryrunPrerequisiteResult",
            "permissionsMissing": "PermissionsMissingDryrunPrerequisiteResult",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class BasicErrorDryrunPrerequisiteResult(DryrunPrerequisiteResult):
    """The represent of basic error.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of dryrun result. Required. Known values are: "basicError" and
     "permissionsMissing".
    :vartype type: str or ~azure.mgmt.servicelinker.models.DryrunPrerequisiteResultType
    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.type: str = "basicError"
        self.code = code
        self.message = message


class ConfigurationInfo(_serialization.Model):
    """The configuration information, used to generate configurations or save to applications.

    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation when Linker
     is updating or deleting. Known values are: "Default" and "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    :ivar action: Optional, indicate whether to apply configurations on source application. If
     enable, generate configurations and applied to the source application. Default is enable. If
     optOut, no configuration change will be made on source. Known values are: "Internal", "enable",
     and "optOut".
    :vartype action: str or ~azure.mgmt.servicelinker.models.ActionType
    :ivar customized_keys: Optional. A dictionary of default key name and customized key name
     mapping. If not specified, default key name will be used for generate configurations.
    :vartype customized_keys: dict[str, str]
    :ivar dapr_properties: Indicates some additional properties for dapr client type.
    :vartype dapr_properties: ~azure.mgmt.servicelinker.models.DaprProperties
    :ivar additional_configurations: A dictionary of additional configurations to be added. Service
     will auto generate a set of basic configurations and this property is to full fill more
     customized configurations.
    :vartype additional_configurations: dict[str, str]
    :ivar additional_connection_string_properties: A dictionary of additional properties to be
     added in the end of connection string.
    :vartype additional_connection_string_properties: dict[str, str]
    :ivar configuration_store: An option to store configuration into different place.
    :vartype configuration_store: ~azure.mgmt.servicelinker.models.ConfigurationStore
    """

    _attribute_map = {
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "customized_keys": {"key": "customizedKeys", "type": "{str}"},
        "dapr_properties": {"key": "daprProperties", "type": "DaprProperties"},
        "additional_configurations": {"key": "additionalConfigurations", "type": "{str}"},
        "additional_connection_string_properties": {"key": "additionalConnectionStringProperties", "type": "{str}"},
        "configuration_store": {"key": "configurationStore", "type": "ConfigurationStore"},
    }

    def __init__(
        self,
        *,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        action: Optional[Union[str, "_models.ActionType"]] = None,
        customized_keys: Optional[Dict[str, str]] = None,
        dapr_properties: Optional["_models.DaprProperties"] = None,
        additional_configurations: Optional[Dict[str, str]] = None,
        additional_connection_string_properties: Optional[Dict[str, str]] = None,
        configuration_store: Optional["_models.ConfigurationStore"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation when
         Linker is updating or deleting. Known values are: "Default" and "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        :keyword action: Optional, indicate whether to apply configurations on source application. If
         enable, generate configurations and applied to the source application. Default is enable. If
         optOut, no configuration change will be made on source. Known values are: "Internal", "enable",
         and "optOut".
        :paramtype action: str or ~azure.mgmt.servicelinker.models.ActionType
        :keyword customized_keys: Optional. A dictionary of default key name and customized key name
         mapping. If not specified, default key name will be used for generate configurations.
        :paramtype customized_keys: dict[str, str]
        :keyword dapr_properties: Indicates some additional properties for dapr client type.
        :paramtype dapr_properties: ~azure.mgmt.servicelinker.models.DaprProperties
        :keyword additional_configurations: A dictionary of additional configurations to be added.
         Service will auto generate a set of basic configurations and this property is to full fill more
         customized configurations.
        :paramtype additional_configurations: dict[str, str]
        :keyword additional_connection_string_properties: A dictionary of additional properties to be
         added in the end of connection string.
        :paramtype additional_connection_string_properties: dict[str, str]
        :keyword configuration_store: An option to store configuration into different place.
        :paramtype configuration_store: ~azure.mgmt.servicelinker.models.ConfigurationStore
        """
        super().__init__(**kwargs)
        self.delete_or_update_behavior = delete_or_update_behavior
        self.action = action
        self.customized_keys = customized_keys
        self.dapr_properties = dapr_properties
        self.additional_configurations = additional_configurations
        self.additional_connection_string_properties = additional_connection_string_properties
        self.configuration_store = configuration_store


class ConfigurationName(_serialization.Model):
    """The configuration names.

    :ivar value:
    :vartype value: str
    :ivar description: Description for the configuration name.
    :vartype description: str
    :ivar required: Represent the configuration is required or not.
    :vartype required: bool
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "required": {"key": "required", "type": "bool"},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        description: Optional[str] = None,
        required: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: str
        :keyword description: Description for the configuration name.
        :paramtype description: str
        :keyword required: Represent the configuration is required or not.
        :paramtype required: bool
        """
        super().__init__(**kwargs)
        self.value = value
        self.description = description
        self.required = required


class ConfigurationNameItem(_serialization.Model):
    """ConfigurationNameItem.

    :ivar target_service: The target service provider name and resource name.
    :vartype target_service: str
    :ivar client_type: The client type for configuration names. Known values are: "none", "dotnet",
     "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
     "jms-springBoot", and "dapr".
    :vartype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
    :ivar auth_type: The auth type. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar secret_type: Indicates where the secrets in configuration from. Used when secrets are
     from Keyvault. Known values are: "rawValue" and "keyVaultSecret".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretSourceType
    :ivar dapr_properties: Deprecated, please use #/definitions/DaprConfigurationList instead.
    :vartype dapr_properties: ~azure.mgmt.servicelinker.models.DaprProperties
    :ivar names: The configuration names to be set in compute service environment.
    :vartype names: list[~azure.mgmt.servicelinker.models.ConfigurationName]
    """

    _attribute_map = {
        "target_service": {"key": "properties.targetService", "type": "str"},
        "client_type": {"key": "properties.clientType", "type": "str"},
        "auth_type": {"key": "properties.authType", "type": "str"},
        "secret_type": {"key": "properties.secretType", "type": "str"},
        "dapr_properties": {"key": "properties.daprProperties", "type": "DaprProperties"},
        "names": {"key": "properties.names", "type": "[ConfigurationName]"},
    }

    def __init__(
        self,
        *,
        target_service: Optional[str] = None,
        client_type: Optional[Union[str, "_models.ClientType"]] = None,
        auth_type: Optional[Union[str, "_models.AuthType"]] = None,
        secret_type: Optional[Union[str, "_models.SecretSourceType"]] = None,
        dapr_properties: Optional["_models.DaprProperties"] = None,
        names: Optional[List["_models.ConfigurationName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_service: The target service provider name and resource name.
        :paramtype target_service: str
        :keyword client_type: The client type for configuration names. Known values are: "none",
         "dotnet", "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot",
         "kafka-springBoot", "jms-springBoot", and "dapr".
        :paramtype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
        :keyword auth_type: The auth type. Known values are: "systemAssignedIdentity",
         "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
         "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
        :paramtype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
        :keyword secret_type: Indicates where the secrets in configuration from. Used when secrets are
         from Keyvault. Known values are: "rawValue" and "keyVaultSecret".
        :paramtype secret_type: str or ~azure.mgmt.servicelinker.models.SecretSourceType
        :keyword dapr_properties: Deprecated, please use #/definitions/DaprConfigurationList instead.
        :paramtype dapr_properties: ~azure.mgmt.servicelinker.models.DaprProperties
        :keyword names: The configuration names to be set in compute service environment.
        :paramtype names: list[~azure.mgmt.servicelinker.models.ConfigurationName]
        """
        super().__init__(**kwargs)
        self.target_service = target_service
        self.client_type = client_type
        self.auth_type = auth_type
        self.secret_type = secret_type
        self.dapr_properties = dapr_properties
        self.names = names


class ConfigurationNameResult(_serialization.Model):
    """Configuration Name list which will be set based on different target resource, client type, auth
    type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Expected configuration names for each target service.
    :vartype value: list[~azure.mgmt.servicelinker.models.ConfigurationNameItem]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfigurationNameItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ConfigurationNameItem"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Expected configuration names for each target service.
        :paramtype value: list[~azure.mgmt.servicelinker.models.ConfigurationNameItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ConfigurationResult(_serialization.Model):
    """Configurations for source resource, include appSettings, connectionString and serviceBindings.

    :ivar configurations: The configuration properties for source resource.
    :vartype configurations: list[~azure.mgmt.servicelinker.models.SourceConfiguration]
    """

    _attribute_map = {
        "configurations": {"key": "configurations", "type": "[SourceConfiguration]"},
    }

    def __init__(self, *, configurations: Optional[List["_models.SourceConfiguration"]] = None, **kwargs: Any) -> None:
        """
        :keyword configurations: The configuration properties for source resource.
        :paramtype configurations: list[~azure.mgmt.servicelinker.models.SourceConfiguration]
        """
        super().__init__(**kwargs)
        self.configurations = configurations


class ConfigurationStore(_serialization.Model):
    """An option to store configuration into different place.

    :ivar app_configuration_id: The app configuration id to store configuration.
    :vartype app_configuration_id: str
    """

    _attribute_map = {
        "app_configuration_id": {"key": "appConfigurationId", "type": "str"},
    }

    def __init__(self, *, app_configuration_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword app_configuration_id: The app configuration id to store configuration.
        :paramtype app_configuration_id: str
        """
        super().__init__(**kwargs)
        self.app_configuration_id = app_configuration_id


class ConfluentBootstrapServer(TargetServiceBase):
    """The service properties when target service type is ConfluentBootstrapServer.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The target service type. Required. Known values are: "AzureResource",
     "ConfluentBootstrapServer", "ConfluentSchemaRegistry", and "SelfHostedServer".
    :vartype type: str or ~azure.mgmt.servicelinker.models.TargetServiceType
    :ivar endpoint: The endpoint of service.
    :vartype endpoint: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, *, endpoint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword endpoint: The endpoint of service.
        :paramtype endpoint: str
        """
        super().__init__(**kwargs)
        self.type: str = "ConfluentBootstrapServer"
        self.endpoint = endpoint


class ConfluentSchemaRegistry(TargetServiceBase):
    """The service properties when target service type is ConfluentSchemaRegistry.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The target service type. Required. Known values are: "AzureResource",
     "ConfluentBootstrapServer", "ConfluentSchemaRegistry", and "SelfHostedServer".
    :vartype type: str or ~azure.mgmt.servicelinker.models.TargetServiceType
    :ivar endpoint: The endpoint of service.
    :vartype endpoint: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, *, endpoint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword endpoint: The endpoint of service.
        :paramtype endpoint: str
        """
        super().__init__(**kwargs)
        self.type: str = "ConfluentSchemaRegistry"
        self.endpoint = endpoint


class LinkerProperties(_serialization.Model):
    """The properties of the Linker.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_service: The target service properties.
    :vartype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
    :ivar auth_info: The authentication type.
    :vartype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
    :ivar client_type: The application client type. Known values are: "none", "dotnet", "java",
     "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
     "jms-springBoot", and "dapr".
    :vartype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar v_net_solution: The VNet solution.
    :vartype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
    :ivar secret_store: An option to store secret value in secure place.
    :vartype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
    :ivar scope: connection scope in source service.
    :vartype scope: str
    :ivar public_network_solution: The network solution.
    :vartype public_network_solution: ~azure.mgmt.servicelinker.models.PublicNetworkSolution
    :ivar configuration_info: The connection information consumed by applications, including
     secrets, connection strings.
    :vartype configuration_info: ~azure.mgmt.servicelinker.models.ConfigurationInfo
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "target_service": {"key": "targetService", "type": "TargetServiceBase"},
        "auth_info": {"key": "authInfo", "type": "AuthInfoBase"},
        "client_type": {"key": "clientType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "v_net_solution": {"key": "vNetSolution", "type": "VNetSolution"},
        "secret_store": {"key": "secretStore", "type": "SecretStore"},
        "scope": {"key": "scope", "type": "str"},
        "public_network_solution": {"key": "publicNetworkSolution", "type": "PublicNetworkSolution"},
        "configuration_info": {"key": "configurationInfo", "type": "ConfigurationInfo"},
    }

    def __init__(
        self,
        *,
        target_service: Optional["_models.TargetServiceBase"] = None,
        auth_info: Optional["_models.AuthInfoBase"] = None,
        client_type: Optional[Union[str, "_models.ClientType"]] = None,
        v_net_solution: Optional["_models.VNetSolution"] = None,
        secret_store: Optional["_models.SecretStore"] = None,
        scope: Optional[str] = None,
        public_network_solution: Optional["_models.PublicNetworkSolution"] = None,
        configuration_info: Optional["_models.ConfigurationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_service: The target service properties.
        :paramtype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
        :keyword auth_info: The authentication type.
        :paramtype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
        :keyword client_type: The application client type. Known values are: "none", "dotnet", "java",
         "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
         "jms-springBoot", and "dapr".
        :paramtype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
        :keyword v_net_solution: The VNet solution.
        :paramtype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
        :keyword secret_store: An option to store secret value in secure place.
        :paramtype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
        :keyword scope: connection scope in source service.
        :paramtype scope: str
        :keyword public_network_solution: The network solution.
        :paramtype public_network_solution: ~azure.mgmt.servicelinker.models.PublicNetworkSolution
        :keyword configuration_info: The connection information consumed by applications, including
         secrets, connection strings.
        :paramtype configuration_info: ~azure.mgmt.servicelinker.models.ConfigurationInfo
        """
        super().__init__(**kwargs)
        self.target_service = target_service
        self.auth_info = auth_info
        self.client_type = client_type
        self.provisioning_state = None
        self.v_net_solution = v_net_solution
        self.secret_store = secret_store
        self.scope = scope
        self.public_network_solution = public_network_solution
        self.configuration_info = configuration_info


class DryrunParameters(_serialization.Model):
    """The parameters of the dryrun.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CreateOrUpdateDryrunParameters

    All required parameters must be populated in order to send to Azure.

    :ivar action_name: The name of action for you dryrun job. Required. "createOrUpdate"
    :vartype action_name: str or ~azure.mgmt.servicelinker.models.DryrunActionName
    """

    _validation = {
        "action_name": {"required": True},
    }

    _attribute_map = {
        "action_name": {"key": "actionName", "type": "str"},
    }

    _subtype_map = {"action_name": {"createOrUpdate": "CreateOrUpdateDryrunParameters"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.action_name: Optional[str] = None


class CreateOrUpdateDryrunParameters(DryrunParameters, LinkerProperties):
    """The dryrun parameters for creation or update a linker.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_service: The target service properties.
    :vartype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
    :ivar auth_info: The authentication type.
    :vartype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
    :ivar client_type: The application client type. Known values are: "none", "dotnet", "java",
     "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
     "jms-springBoot", and "dapr".
    :vartype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar v_net_solution: The VNet solution.
    :vartype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
    :ivar secret_store: An option to store secret value in secure place.
    :vartype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
    :ivar scope: connection scope in source service.
    :vartype scope: str
    :ivar public_network_solution: The network solution.
    :vartype public_network_solution: ~azure.mgmt.servicelinker.models.PublicNetworkSolution
    :ivar configuration_info: The connection information consumed by applications, including
     secrets, connection strings.
    :vartype configuration_info: ~azure.mgmt.servicelinker.models.ConfigurationInfo
    :ivar action_name: The name of action for you dryrun job. Required. "createOrUpdate"
    :vartype action_name: str or ~azure.mgmt.servicelinker.models.DryrunActionName
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "action_name": {"required": True},
    }

    _attribute_map = {
        "target_service": {"key": "targetService", "type": "TargetServiceBase"},
        "auth_info": {"key": "authInfo", "type": "AuthInfoBase"},
        "client_type": {"key": "clientType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "v_net_solution": {"key": "vNetSolution", "type": "VNetSolution"},
        "secret_store": {"key": "secretStore", "type": "SecretStore"},
        "scope": {"key": "scope", "type": "str"},
        "public_network_solution": {"key": "publicNetworkSolution", "type": "PublicNetworkSolution"},
        "configuration_info": {"key": "configurationInfo", "type": "ConfigurationInfo"},
        "action_name": {"key": "actionName", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_service: Optional["_models.TargetServiceBase"] = None,
        auth_info: Optional["_models.AuthInfoBase"] = None,
        client_type: Optional[Union[str, "_models.ClientType"]] = None,
        v_net_solution: Optional["_models.VNetSolution"] = None,
        secret_store: Optional["_models.SecretStore"] = None,
        scope: Optional[str] = None,
        public_network_solution: Optional["_models.PublicNetworkSolution"] = None,
        configuration_info: Optional["_models.ConfigurationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_service: The target service properties.
        :paramtype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
        :keyword auth_info: The authentication type.
        :paramtype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
        :keyword client_type: The application client type. Known values are: "none", "dotnet", "java",
         "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
         "jms-springBoot", and "dapr".
        :paramtype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
        :keyword v_net_solution: The VNet solution.
        :paramtype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
        :keyword secret_store: An option to store secret value in secure place.
        :paramtype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
        :keyword scope: connection scope in source service.
        :paramtype scope: str
        :keyword public_network_solution: The network solution.
        :paramtype public_network_solution: ~azure.mgmt.servicelinker.models.PublicNetworkSolution
        :keyword configuration_info: The connection information consumed by applications, including
         secrets, connection strings.
        :paramtype configuration_info: ~azure.mgmt.servicelinker.models.ConfigurationInfo
        """
        super().__init__(
            target_service=target_service,
            auth_info=auth_info,
            client_type=client_type,
            v_net_solution=v_net_solution,
            secret_store=secret_store,
            scope=scope,
            public_network_solution=public_network_solution,
            configuration_info=configuration_info,
            **kwargs
        )
        self.target_service = target_service
        self.auth_info = auth_info
        self.client_type = client_type
        self.provisioning_state = None
        self.v_net_solution = v_net_solution
        self.secret_store = secret_store
        self.scope = scope
        self.public_network_solution = public_network_solution
        self.configuration_info = configuration_info
        self.action_name: str = "createOrUpdate"


class DaprConfigurationList(_serialization.Model):
    """Dapr configuration list supported by Service Connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of dapr configurations.
    :vartype value: list[~azure.mgmt.servicelinker.models.DaprConfigurationResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DaprConfigurationResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DaprConfigurationResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of dapr configurations.
        :paramtype value: list[~azure.mgmt.servicelinker.models.DaprConfigurationResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DaprConfigurationResource(_serialization.Model):
    """Represent one resource of the dapr configuration list.

    :ivar target_type: Supported target resource type, extract from resource id, uppercase.
    :vartype target_type: str
    :ivar auth_type: The authentication type. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar dapr_properties: Indicates some additional properties for dapr client type.
    :vartype dapr_properties: ~azure.mgmt.servicelinker.models.DaprProperties
    """

    _attribute_map = {
        "target_type": {"key": "properties.targetType", "type": "str"},
        "auth_type": {"key": "properties.authType", "type": "str"},
        "dapr_properties": {"key": "properties.daprProperties", "type": "DaprProperties"},
    }

    def __init__(
        self,
        *,
        target_type: Optional[str] = None,
        auth_type: Optional[Union[str, "_models.AuthType"]] = None,
        dapr_properties: Optional["_models.DaprProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_type: Supported target resource type, extract from resource id, uppercase.
        :paramtype target_type: str
        :keyword auth_type: The authentication type. Known values are: "systemAssignedIdentity",
         "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
         "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
        :paramtype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
        :keyword dapr_properties: Indicates some additional properties for dapr client type.
        :paramtype dapr_properties: ~azure.mgmt.servicelinker.models.DaprProperties
        """
        super().__init__(**kwargs)
        self.target_type = target_type
        self.auth_type = auth_type
        self.dapr_properties = dapr_properties


class DaprMetadata(_serialization.Model):
    """The dapr component metadata.

    :ivar name: Metadata property name.
    :vartype name: str
    :ivar value: Metadata property value.
    :vartype value: str
    :ivar secret_ref: The secret name where dapr could get value.
    :vartype secret_ref: str
    :ivar description: The description of the metadata, returned from configuration api.
    :vartype description: str
    :ivar required: The value indicating whether the metadata is required or not. Known values are:
     "true" and "false".
    :vartype required: str or ~azure.mgmt.servicelinker.models.DaprMetadataRequired
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "secret_ref": {"key": "secretRef", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "required": {"key": "required", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        description: Optional[str] = None,
        required: Optional[Union[str, "_models.DaprMetadataRequired"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Metadata property name.
        :paramtype name: str
        :keyword value: Metadata property value.
        :paramtype value: str
        :keyword secret_ref: The secret name where dapr could get value.
        :paramtype secret_ref: str
        :keyword description: The description of the metadata, returned from configuration api.
        :paramtype description: str
        :keyword required: The value indicating whether the metadata is required or not. Known values
         are: "true" and "false".
        :paramtype required: str or ~azure.mgmt.servicelinker.models.DaprMetadataRequired
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref
        self.description = description
        self.required = required


class DaprProperties(_serialization.Model):
    """Indicates some additional properties for dapr client type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The dapr component version.
    :vartype version: str
    :ivar component_type: The dapr component type.
    :vartype component_type: str
    :ivar secret_store_component: The name of a secret store dapr to retrieve secret.
    :vartype secret_store_component: str
    :ivar metadata: Additional dapr metadata.
    :vartype metadata: list[~azure.mgmt.servicelinker.models.DaprMetadata]
    :ivar scopes: The dapr component scopes.
    :vartype scopes: list[str]
    :ivar runtime_version: The runtime version supported by the properties.
    :vartype runtime_version: str
    :ivar binding_component_direction: The direction supported by the dapr binding component. Known
     values are: "input" and "output".
    :vartype binding_component_direction: str or
     ~azure.mgmt.servicelinker.models.DaprBindingComponentDirection
    """

    _validation = {
        "runtime_version": {"readonly": True},
        "binding_component_direction": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "component_type": {"key": "componentType", "type": "str"},
        "secret_store_component": {"key": "secretStoreComponent", "type": "str"},
        "metadata": {"key": "metadata", "type": "[DaprMetadata]"},
        "scopes": {"key": "scopes", "type": "[str]"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "binding_component_direction": {"key": "bindingComponentDirection", "type": "str"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        component_type: Optional[str] = None,
        secret_store_component: Optional[str] = None,
        metadata: Optional[List["_models.DaprMetadata"]] = None,
        scopes: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: The dapr component version.
        :paramtype version: str
        :keyword component_type: The dapr component type.
        :paramtype component_type: str
        :keyword secret_store_component: The name of a secret store dapr to retrieve secret.
        :paramtype secret_store_component: str
        :keyword metadata: Additional dapr metadata.
        :paramtype metadata: list[~azure.mgmt.servicelinker.models.DaprMetadata]
        :keyword scopes: The dapr component scopes.
        :paramtype scopes: list[str]
        """
        super().__init__(**kwargs)
        self.version = version
        self.component_type = component_type
        self.secret_store_component = secret_store_component
        self.metadata = metadata
        self.scopes = scopes
        self.runtime_version = None
        self.binding_component_direction = None


class DatabaseAadAuthInfo(_serialization.Model):
    """The extra auth info required by Database AAD authentication.

    :ivar user_name: Username created in the database which is mapped to a user in AAD.
    :vartype user_name: str
    """

    _attribute_map = {
        "user_name": {"key": "userName", "type": "str"},
    }

    def __init__(self, *, user_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_name: Username created in the database which is mapped to a user in AAD.
        :paramtype user_name: str
        """
        super().__init__(**kwargs)
        self.user_name = user_name


class DryrunList(_serialization.Model):
    """The list of dryrun.

    :ivar next_link: The link used to get the next page of dryrun list.
    :vartype next_link: str
    :ivar value: The list of dryrun.
    :vartype value: list[~azure.mgmt.servicelinker.models.DryrunResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DryrunResource]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.DryrunResource"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of dryrun list.
        :paramtype next_link: str
        :keyword value: The list of dryrun.
        :paramtype value: list[~azure.mgmt.servicelinker.models.DryrunResource]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DryrunOperationPreview(_serialization.Model):
    """The preview of the operations for creation.

    :ivar name: The operation name.
    :vartype name: str
    :ivar operation_type: The operation type. Known values are: "configConnection",
     "configNetwork", and "configAuth".
    :vartype operation_type: str or ~azure.mgmt.servicelinker.models.DryrunPreviewOperationType
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar action: The action defined by RBAC, refer
     https://docs.microsoft.com/azure/role-based-access-control/role-definitions#actions-format.
    :vartype action: str
    :ivar scope: The scope of the operation, refer
     https://docs.microsoft.com/azure/role-based-access-control/scope-overview.
    :vartype scope: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        operation_type: Optional[Union[str, "_models.DryrunPreviewOperationType"]] = None,
        description: Optional[str] = None,
        action: Optional[str] = None,
        scope: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The operation name.
        :paramtype name: str
        :keyword operation_type: The operation type. Known values are: "configConnection",
         "configNetwork", and "configAuth".
        :paramtype operation_type: str or ~azure.mgmt.servicelinker.models.DryrunPreviewOperationType
        :keyword description: The description of the operation.
        :paramtype description: str
        :keyword action: The action defined by RBAC, refer
         https://docs.microsoft.com/azure/role-based-access-control/role-definitions#actions-format.
        :paramtype action: str
        :keyword scope: The scope of the operation, refer
         https://docs.microsoft.com/azure/role-based-access-control/scope-overview.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.operation_type = operation_type
        self.description = description
        self.action = action
        self.scope = scope


class DryrunPatch(_serialization.Model):
    """a dryrun job to be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar parameters: The parameters of the dryrun.
    :vartype parameters: ~azure.mgmt.servicelinker.models.DryrunParameters
    :ivar prerequisite_results: the result of the dryrun.
    :vartype prerequisite_results: list[~azure.mgmt.servicelinker.models.DryrunPrerequisiteResult]
    :ivar operation_previews: the preview of the operations for creation.
    :vartype operation_previews: list[~azure.mgmt.servicelinker.models.DryrunOperationPreview]
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "prerequisite_results": {"readonly": True},
        "operation_previews": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "parameters": {"key": "properties.parameters", "type": "DryrunParameters"},
        "prerequisite_results": {"key": "properties.prerequisiteResults", "type": "[DryrunPrerequisiteResult]"},
        "operation_previews": {"key": "properties.operationPreviews", "type": "[DryrunOperationPreview]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, parameters: Optional["_models.DryrunParameters"] = None, **kwargs: Any) -> None:
        """
        :keyword parameters: The parameters of the dryrun.
        :paramtype parameters: ~azure.mgmt.servicelinker.models.DryrunParameters
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.prerequisite_results = None
        self.operation_previews = None
        self.provisioning_state = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicelinker.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicelinker.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class DryrunResource(ProxyResource):
    """a dryrun job resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicelinker.models.SystemData
    :ivar parameters: The parameters of the dryrun.
    :vartype parameters: ~azure.mgmt.servicelinker.models.DryrunParameters
    :ivar prerequisite_results: the result of the dryrun.
    :vartype prerequisite_results: list[~azure.mgmt.servicelinker.models.DryrunPrerequisiteResult]
    :ivar operation_previews: the preview of the operations for creation.
    :vartype operation_previews: list[~azure.mgmt.servicelinker.models.DryrunOperationPreview]
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "prerequisite_results": {"readonly": True},
        "operation_previews": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "parameters": {"key": "properties.parameters", "type": "DryrunParameters"},
        "prerequisite_results": {"key": "properties.prerequisiteResults", "type": "[DryrunPrerequisiteResult]"},
        "operation_previews": {"key": "properties.operationPreviews", "type": "[DryrunOperationPreview]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, parameters: Optional["_models.DryrunParameters"] = None, **kwargs: Any) -> None:
        """
        :keyword parameters: The parameters of the dryrun.
        :paramtype parameters: ~azure.mgmt.servicelinker.models.DryrunParameters
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.prerequisite_results = None
        self.operation_previews = None
        self.provisioning_state = None


class EasyAuthMicrosoftEntraIDAuthInfo(AuthInfoBase):
    """The authentication info when authType is EasyAuth Microsoft Entra ID.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    :ivar client_id: Application clientId for EasyAuth Microsoft Entra ID.
    :vartype client_id: str
    :ivar secret: Application Secret for EasyAuth Microsoft Entra ID.
    :vartype secret: str
    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation when Linker
     is updating or deleting. Known values are: "Default" and "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
    }

    def __init__(
        self,
        *,
        auth_mode: Optional[Union[str, "_models.AuthMode"]] = None,
        client_id: Optional[str] = None,
        secret: Optional[str] = None,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        :keyword client_id: Application clientId for EasyAuth Microsoft Entra ID.
        :paramtype client_id: str
        :keyword secret: Application Secret for EasyAuth Microsoft Entra ID.
        :paramtype secret: str
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation when
         Linker is updating or deleting. Known values are: "Default" and "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        """
        super().__init__(auth_mode=auth_mode, **kwargs)
        self.auth_type: str = "easyAuthMicrosoftEntraID"
        self.client_id = client_id
        self.secret = secret
        self.delete_or_update_behavior = delete_or_update_behavior


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.servicelinker.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.servicelinker.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.servicelinker.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.servicelinker.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FirewallRules(_serialization.Model):
    """Target service's firewall rules. to allow connections from source service.

    :ivar ip_ranges: This value specifies the set of IP addresses or IP address ranges in CIDR form
     to be included as the allowed list of client IPs for a given database account.
    :vartype ip_ranges: list[str]
    :ivar azure_services: Allow Azure services to access the target service if true. Known values
     are: "true" and "false".
    :vartype azure_services: str or ~azure.mgmt.servicelinker.models.AllowType
    :ivar caller_client_ip: Allow caller client IP to access the target service if true. the
     property is used when connecting local application to target service. Known values are: "true"
     and "false".
    :vartype caller_client_ip: str or ~azure.mgmt.servicelinker.models.AllowType
    """

    _attribute_map = {
        "ip_ranges": {"key": "ipRanges", "type": "[str]"},
        "azure_services": {"key": "azureServices", "type": "str"},
        "caller_client_ip": {"key": "callerClientIP", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_ranges: Optional[List[str]] = None,
        azure_services: Optional[Union[str, "_models.AllowType"]] = None,
        caller_client_ip: Optional[Union[str, "_models.AllowType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_ranges: This value specifies the set of IP addresses or IP address ranges in CIDR
         form to be included as the allowed list of client IPs for a given database account.
        :paramtype ip_ranges: list[str]
        :keyword azure_services: Allow Azure services to access the target service if true. Known
         values are: "true" and "false".
        :paramtype azure_services: str or ~azure.mgmt.servicelinker.models.AllowType
        :keyword caller_client_ip: Allow caller client IP to access the target service if true. the
         property is used when connecting local application to target service. Known values are: "true"
         and "false".
        :paramtype caller_client_ip: str or ~azure.mgmt.servicelinker.models.AllowType
        """
        super().__init__(**kwargs)
        self.ip_ranges = ip_ranges
        self.azure_services = azure_services
        self.caller_client_ip = caller_client_ip


class SecretInfoBase(_serialization.Model):
    """The secret info.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KeyVaultSecretReferenceSecretInfo, KeyVaultSecretUriSecretInfo, ValueSecretInfo

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: The secret type. Required. Known values are: "rawValue",
     "keyVaultSecretUri", and "keyVaultSecretReference".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretType
    """

    _validation = {
        "secret_type": {"required": True},
    }

    _attribute_map = {
        "secret_type": {"key": "secretType", "type": "str"},
    }

    _subtype_map = {
        "secret_type": {
            "keyVaultSecretReference": "KeyVaultSecretReferenceSecretInfo",
            "keyVaultSecretUri": "KeyVaultSecretUriSecretInfo",
            "rawValue": "ValueSecretInfo",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.secret_type: Optional[str] = None


class KeyVaultSecretReferenceSecretInfo(SecretInfoBase):
    """The secret info when type is keyVaultSecretReference. It's for scenario that user provides a
    secret stored in user's keyvault and source is Azure Kubernetes. The key Vault's resource id is
    linked to secretStore.keyVaultId.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: The secret type. Required. Known values are: "rawValue",
     "keyVaultSecretUri", and "keyVaultSecretReference".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretType
    :ivar name: Name of the Key Vault secret.
    :vartype name: str
    :ivar version: Version of the Key Vault secret.
    :vartype version: str
    """

    _validation = {
        "secret_type": {"required": True},
    }

    _attribute_map = {
        "secret_type": {"key": "secretType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the Key Vault secret.
        :paramtype name: str
        :keyword version: Version of the Key Vault secret.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.secret_type: str = "keyVaultSecretReference"
        self.name = name
        self.version = version


class KeyVaultSecretUriSecretInfo(SecretInfoBase):
    """The secret info when type is keyVaultSecretUri. It's for scenario that user provides a secret
    stored in user's keyvault and source is Web App, Spring Cloud or Container App.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: The secret type. Required. Known values are: "rawValue",
     "keyVaultSecretUri", and "keyVaultSecretReference".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretType
    :ivar value: URI to the keyvault secret.
    :vartype value: str
    """

    _validation = {
        "secret_type": {"required": True},
    }

    _attribute_map = {
        "secret_type": {"key": "secretType", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: URI to the keyvault secret.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.secret_type: str = "keyVaultSecretUri"
        self.value = value


class LinkerPatch(_serialization.Model):
    """A Linker to be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_service: The target service properties.
    :vartype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
    :ivar auth_info: The authentication type.
    :vartype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
    :ivar client_type: The application client type. Known values are: "none", "dotnet", "java",
     "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
     "jms-springBoot", and "dapr".
    :vartype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar v_net_solution: The VNet solution.
    :vartype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
    :ivar secret_store: An option to store secret value in secure place.
    :vartype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
    :ivar scope: connection scope in source service.
    :vartype scope: str
    :ivar public_network_solution: The network solution.
    :vartype public_network_solution: ~azure.mgmt.servicelinker.models.PublicNetworkSolution
    :ivar configuration_info: The connection information consumed by applications, including
     secrets, connection strings.
    :vartype configuration_info: ~azure.mgmt.servicelinker.models.ConfigurationInfo
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "target_service": {"key": "properties.targetService", "type": "TargetServiceBase"},
        "auth_info": {"key": "properties.authInfo", "type": "AuthInfoBase"},
        "client_type": {"key": "properties.clientType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "v_net_solution": {"key": "properties.vNetSolution", "type": "VNetSolution"},
        "secret_store": {"key": "properties.secretStore", "type": "SecretStore"},
        "scope": {"key": "properties.scope", "type": "str"},
        "public_network_solution": {"key": "properties.publicNetworkSolution", "type": "PublicNetworkSolution"},
        "configuration_info": {"key": "properties.configurationInfo", "type": "ConfigurationInfo"},
    }

    def __init__(
        self,
        *,
        target_service: Optional["_models.TargetServiceBase"] = None,
        auth_info: Optional["_models.AuthInfoBase"] = None,
        client_type: Optional[Union[str, "_models.ClientType"]] = None,
        v_net_solution: Optional["_models.VNetSolution"] = None,
        secret_store: Optional["_models.SecretStore"] = None,
        scope: Optional[str] = None,
        public_network_solution: Optional["_models.PublicNetworkSolution"] = None,
        configuration_info: Optional["_models.ConfigurationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_service: The target service properties.
        :paramtype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
        :keyword auth_info: The authentication type.
        :paramtype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
        :keyword client_type: The application client type. Known values are: "none", "dotnet", "java",
         "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
         "jms-springBoot", and "dapr".
        :paramtype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
        :keyword v_net_solution: The VNet solution.
        :paramtype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
        :keyword secret_store: An option to store secret value in secure place.
        :paramtype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
        :keyword scope: connection scope in source service.
        :paramtype scope: str
        :keyword public_network_solution: The network solution.
        :paramtype public_network_solution: ~azure.mgmt.servicelinker.models.PublicNetworkSolution
        :keyword configuration_info: The connection information consumed by applications, including
         secrets, connection strings.
        :paramtype configuration_info: ~azure.mgmt.servicelinker.models.ConfigurationInfo
        """
        super().__init__(**kwargs)
        self.target_service = target_service
        self.auth_info = auth_info
        self.client_type = client_type
        self.provisioning_state = None
        self.v_net_solution = v_net_solution
        self.secret_store = secret_store
        self.scope = scope
        self.public_network_solution = public_network_solution
        self.configuration_info = configuration_info


class LinkerResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Linker of source and target resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicelinker.models.SystemData
    :ivar target_service: The target service properties.
    :vartype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
    :ivar auth_info: The authentication type.
    :vartype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
    :ivar client_type: The application client type. Known values are: "none", "dotnet", "java",
     "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
     "jms-springBoot", and "dapr".
    :vartype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar v_net_solution: The VNet solution.
    :vartype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
    :ivar secret_store: An option to store secret value in secure place.
    :vartype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
    :ivar scope: connection scope in source service.
    :vartype scope: str
    :ivar public_network_solution: The network solution.
    :vartype public_network_solution: ~azure.mgmt.servicelinker.models.PublicNetworkSolution
    :ivar configuration_info: The connection information consumed by applications, including
     secrets, connection strings.
    :vartype configuration_info: ~azure.mgmt.servicelinker.models.ConfigurationInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "target_service": {"key": "properties.targetService", "type": "TargetServiceBase"},
        "auth_info": {"key": "properties.authInfo", "type": "AuthInfoBase"},
        "client_type": {"key": "properties.clientType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "v_net_solution": {"key": "properties.vNetSolution", "type": "VNetSolution"},
        "secret_store": {"key": "properties.secretStore", "type": "SecretStore"},
        "scope": {"key": "properties.scope", "type": "str"},
        "public_network_solution": {"key": "properties.publicNetworkSolution", "type": "PublicNetworkSolution"},
        "configuration_info": {"key": "properties.configurationInfo", "type": "ConfigurationInfo"},
    }

    def __init__(
        self,
        *,
        target_service: Optional["_models.TargetServiceBase"] = None,
        auth_info: Optional["_models.AuthInfoBase"] = None,
        client_type: Optional[Union[str, "_models.ClientType"]] = None,
        v_net_solution: Optional["_models.VNetSolution"] = None,
        secret_store: Optional["_models.SecretStore"] = None,
        scope: Optional[str] = None,
        public_network_solution: Optional["_models.PublicNetworkSolution"] = None,
        configuration_info: Optional["_models.ConfigurationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_service: The target service properties.
        :paramtype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
        :keyword auth_info: The authentication type.
        :paramtype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
        :keyword client_type: The application client type. Known values are: "none", "dotnet", "java",
         "python", "go", "php", "ruby", "django", "nodejs", "springBoot", "kafka-springBoot",
         "jms-springBoot", and "dapr".
        :paramtype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
        :keyword v_net_solution: The VNet solution.
        :paramtype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
        :keyword secret_store: An option to store secret value in secure place.
        :paramtype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
        :keyword scope: connection scope in source service.
        :paramtype scope: str
        :keyword public_network_solution: The network solution.
        :paramtype public_network_solution: ~azure.mgmt.servicelinker.models.PublicNetworkSolution
        :keyword configuration_info: The connection information consumed by applications, including
         secrets, connection strings.
        :paramtype configuration_info: ~azure.mgmt.servicelinker.models.ConfigurationInfo
        """
        super().__init__(**kwargs)
        self.target_service = target_service
        self.auth_info = auth_info
        self.client_type = client_type
        self.provisioning_state = None
        self.v_net_solution = v_net_solution
        self.secret_store = secret_store
        self.scope = scope
        self.public_network_solution = public_network_solution
        self.configuration_info = configuration_info


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.servicelinker.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.servicelinker.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Known values are: "Internal", "enable", and "optOut".
    :vartype action_type: str or ~azure.mgmt.servicelinker.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.servicelinker.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.servicelinker.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PermissionsMissingDryrunPrerequisiteResult(DryrunPrerequisiteResult):
    """The represent of missing permissions.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of dryrun result. Required. Known values are: "basicError" and
     "permissionsMissing".
    :vartype type: str or ~azure.mgmt.servicelinker.models.DryrunPrerequisiteResultType
    :ivar scope: The permission scope.
    :vartype scope: str
    :ivar permissions: The permission list.
    :vartype permissions: list[str]
    :ivar recommended_role: The recommended role to resolve permissions missing.
    :vartype recommended_role: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "permissions": {"key": "permissions", "type": "[str]"},
        "recommended_role": {"key": "recommendedRole", "type": "str"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        permissions: Optional[List[str]] = None,
        recommended_role: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: The permission scope.
        :paramtype scope: str
        :keyword permissions: The permission list.
        :paramtype permissions: list[str]
        :keyword recommended_role: The recommended role to resolve permissions missing.
        :paramtype recommended_role: str
        """
        super().__init__(**kwargs)
        self.type: str = "permissionsMissing"
        self.scope = scope
        self.permissions = permissions
        self.recommended_role = recommended_role


class PublicNetworkSolution(_serialization.Model):
    """Indicates public network solution, include firewall rules.

    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation(such as
     firewall rules) when Linker is updating or deleting. Known values are: "Default" and
     "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    :ivar action: Optional. Indicates public network solution. If enable, enable public network
     access of target service with best try. Default is enable. If optOut, opt out public network
     access configuration. Known values are: "Internal", "enable", and "optOut".
    :vartype action: str or ~azure.mgmt.servicelinker.models.ActionType
    :ivar firewall_rules: Describe firewall rules of target service to make sure source application
     could connect to the target.
    :vartype firewall_rules: ~azure.mgmt.servicelinker.models.FirewallRules
    """

    _attribute_map = {
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "firewall_rules": {"key": "firewallRules", "type": "FirewallRules"},
    }

    def __init__(
        self,
        *,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        action: Optional[Union[str, "_models.ActionType"]] = None,
        firewall_rules: Optional["_models.FirewallRules"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation(such as
         firewall rules) when Linker is updating or deleting. Known values are: "Default" and
         "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        :keyword action: Optional. Indicates public network solution. If enable, enable public network
         access of target service with best try. Default is enable. If optOut, opt out public network
         access configuration. Known values are: "Internal", "enable", and "optOut".
        :paramtype action: str or ~azure.mgmt.servicelinker.models.ActionType
        :keyword firewall_rules: Describe firewall rules of target service to make sure source
         application could connect to the target.
        :paramtype firewall_rules: ~azure.mgmt.servicelinker.models.FirewallRules
        """
        super().__init__(**kwargs)
        self.delete_or_update_behavior = delete_or_update_behavior
        self.action = action
        self.firewall_rules = firewall_rules


class ResourceList(_serialization.Model):
    """The list of Linker.

    :ivar next_link: The Linker used to get the next page of Linker list.
    :vartype next_link: str
    :ivar value: The list of Linkers.
    :vartype value: list[~azure.mgmt.servicelinker.models.LinkerResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[LinkerResource]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.LinkerResource"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The Linker used to get the next page of Linker list.
        :paramtype next_link: str
        :keyword value: The list of Linkers.
        :paramtype value: list[~azure.mgmt.servicelinker.models.LinkerResource]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SecretAuthInfo(AuthInfoBase):
    """The authentication info when authType is secret.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    :ivar name: Username or account name for secret auth.
    :vartype name: str
    :ivar secret_info: Password or key vault secret for secret auth.
    :vartype secret_info: ~azure.mgmt.servicelinker.models.SecretInfoBase
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "secret_info": {"key": "secretInfo", "type": "SecretInfoBase"},
    }

    def __init__(
        self,
        *,
        auth_mode: Optional[Union[str, "_models.AuthMode"]] = None,
        name: Optional[str] = None,
        secret_info: Optional["_models.SecretInfoBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        :keyword name: Username or account name for secret auth.
        :paramtype name: str
        :keyword secret_info: Password or key vault secret for secret auth.
        :paramtype secret_info: ~azure.mgmt.servicelinker.models.SecretInfoBase
        """
        super().__init__(auth_mode=auth_mode, **kwargs)
        self.auth_type: str = "secret"
        self.name = name
        self.secret_info = secret_info


class SecretStore(_serialization.Model):
    """An option to store secret value in secure place.

    :ivar key_vault_id: The key vault id to store secret.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: The key vault secret name to store secret, only valid when storing
     one secret.
    :vartype key_vault_secret_name: str
    """

    _attribute_map = {
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "keyVaultSecretName", "type": "str"},
    }

    def __init__(
        self, *, key_vault_id: Optional[str] = None, key_vault_secret_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_id: The key vault id to store secret.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: The key vault secret name to store secret, only valid when
         storing one secret.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name


class SelfHostedServer(TargetServiceBase):
    """The service properties when target service type is SelfHostedServer.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The target service type. Required. Known values are: "AzureResource",
     "ConfluentBootstrapServer", "ConfluentSchemaRegistry", and "SelfHostedServer".
    :vartype type: str or ~azure.mgmt.servicelinker.models.TargetServiceType
    :ivar endpoint: The endpoint of service.
    :vartype endpoint: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, *, endpoint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword endpoint: The endpoint of service.
        :paramtype endpoint: str
        """
        super().__init__(**kwargs)
        self.type: str = "SelfHostedServer"
        self.endpoint = endpoint


class ServicePrincipalCertificateAuthInfo(AuthInfoBase):
    """The authentication info when authType is servicePrincipal certificate.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    :ivar client_id: Application clientId for servicePrincipal auth. Required.
    :vartype client_id: str
    :ivar principal_id: Principal Id for servicePrincipal auth. Required.
    :vartype principal_id: str
    :ivar certificate: ServicePrincipal certificate for servicePrincipal auth. Required.
    :vartype certificate: str
    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation when Linker
     is updating or deleting. Known values are: "Default" and "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    :ivar roles: Optional, this value specifies the Azure roles to be assigned. Automatically.
    :vartype roles: list[str]
    """

    _validation = {
        "auth_type": {"required": True},
        "client_id": {"required": True},
        "principal_id": {"required": True},
        "certificate": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "certificate": {"key": "certificate", "type": "str"},
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        client_id: str,
        principal_id: str,
        certificate: str,
        auth_mode: Optional[Union[str, "_models.AuthMode"]] = None,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        roles: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        :keyword client_id: Application clientId for servicePrincipal auth. Required.
        :paramtype client_id: str
        :keyword principal_id: Principal Id for servicePrincipal auth. Required.
        :paramtype principal_id: str
        :keyword certificate: ServicePrincipal certificate for servicePrincipal auth. Required.
        :paramtype certificate: str
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation when
         Linker is updating or deleting. Known values are: "Default" and "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        :keyword roles: Optional, this value specifies the Azure roles to be assigned. Automatically.
        :paramtype roles: list[str]
        """
        super().__init__(auth_mode=auth_mode, **kwargs)
        self.auth_type: str = "servicePrincipalCertificate"
        self.client_id = client_id
        self.principal_id = principal_id
        self.certificate = certificate
        self.delete_or_update_behavior = delete_or_update_behavior
        self.roles = roles


class ServicePrincipalSecretAuthInfo(AuthInfoBase, DatabaseAadAuthInfo):
    """The authentication info when authType is servicePrincipal secret.

    All required parameters must be populated in order to send to Azure.

    :ivar user_name: Username created in the database which is mapped to a user in AAD.
    :vartype user_name: str
    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    :ivar client_id: ServicePrincipal application clientId for servicePrincipal auth. Required.
    :vartype client_id: str
    :ivar principal_id: Principal Id for servicePrincipal auth. Required.
    :vartype principal_id: str
    :ivar secret: Secret for servicePrincipal auth. Required.
    :vartype secret: str
    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation when Linker
     is updating or deleting. Known values are: "Default" and "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    :ivar roles: Optional, this value specifies the Azure roles to be assigned. Automatically.
    :vartype roles: list[str]
    """

    _validation = {
        "auth_type": {"required": True},
        "client_id": {"required": True},
        "principal_id": {"required": True},
        "secret": {"required": True},
    }

    _attribute_map = {
        "user_name": {"key": "userName", "type": "str"},
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        client_id: str,
        principal_id: str,
        secret: str,
        user_name: Optional[str] = None,
        auth_mode: Optional[Union[str, "_models.AuthMode"]] = None,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        roles: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: Username created in the database which is mapped to a user in AAD.
        :paramtype user_name: str
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        :keyword client_id: ServicePrincipal application clientId for servicePrincipal auth. Required.
        :paramtype client_id: str
        :keyword principal_id: Principal Id for servicePrincipal auth. Required.
        :paramtype principal_id: str
        :keyword secret: Secret for servicePrincipal auth. Required.
        :paramtype secret: str
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation when
         Linker is updating or deleting. Known values are: "Default" and "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        :keyword roles: Optional, this value specifies the Azure roles to be assigned. Automatically.
        :paramtype roles: list[str]
        """
        super().__init__(auth_mode=auth_mode, user_name=user_name, **kwargs)
        self.user_name = user_name
        self.auth_type: str = "servicePrincipalSecret"
        self.client_id = client_id
        self.principal_id = principal_id
        self.secret = secret
        self.delete_or_update_behavior = delete_or_update_behavior
        self.roles = roles
        self.auth_mode = auth_mode


class SourceConfiguration(_serialization.Model):
    """A configuration item for source resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of setting.
    :vartype name: str
    :ivar value: The value of setting.
    :vartype value: str
    :ivar config_type: The type of setting. Known values are: "Default" and "KeyVaultSecret".
    :vartype config_type: str or ~azure.mgmt.servicelinker.models.LinkerConfigurationType
    :ivar key_vault_reference_identity: The identity for key vault reference, system or
     user-assigned managed identity ID.
    :vartype key_vault_reference_identity: str
    :ivar description: Descriptive information for the configuration.
    :vartype description: str
    """

    _validation = {
        "config_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "config_type": {"key": "configType", "type": "str"},
        "key_vault_reference_identity": {"key": "keyVaultReferenceIdentity", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        key_vault_reference_identity: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of setting.
        :paramtype name: str
        :keyword value: The value of setting.
        :paramtype value: str
        :keyword key_vault_reference_identity: The identity for key vault reference, system or
         user-assigned managed identity ID.
        :paramtype key_vault_reference_identity: str
        :keyword description: Descriptive information for the configuration.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.config_type = None
        self.key_vault_reference_identity = key_vault_reference_identity
        self.description = description


class SystemAssignedIdentityAuthInfo(AuthInfoBase, DatabaseAadAuthInfo):
    """The authentication info when authType is systemAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar user_name: Username created in the database which is mapped to a user in AAD.
    :vartype user_name: str
    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation when Linker
     is updating or deleting. Known values are: "Default" and "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    :ivar roles: Optional, this value specifies the Azure role to be assigned.
    :vartype roles: list[str]
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "user_name": {"key": "userName", "type": "str"},
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        auth_mode: Optional[Union[str, "_models.AuthMode"]] = None,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        roles: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: Username created in the database which is mapped to a user in AAD.
        :paramtype user_name: str
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation when
         Linker is updating or deleting. Known values are: "Default" and "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        :keyword roles: Optional, this value specifies the Azure role to be assigned.
        :paramtype roles: list[str]
        """
        super().__init__(auth_mode=auth_mode, user_name=user_name, **kwargs)
        self.user_name = user_name
        self.auth_type: str = "systemAssignedIdentity"
        self.delete_or_update_behavior = delete_or_update_behavior
        self.roles = roles
        self.auth_mode = auth_mode


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.servicelinker.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.servicelinker.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.servicelinker.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.servicelinker.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAccountAuthInfo(AuthInfoBase, DatabaseAadAuthInfo):
    """The authentication info when authType is user account.

    All required parameters must be populated in order to send to Azure.

    :ivar user_name: Username created in the database which is mapped to a user in AAD.
    :vartype user_name: str
    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    :ivar principal_id: Principal Id for user account.
    :vartype principal_id: str
    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation when Linker
     is updating or deleting. Known values are: "Default" and "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    :ivar roles: Optional, this value specifies the Azure roles to be assigned. Automatically.
    :vartype roles: list[str]
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "user_name": {"key": "userName", "type": "str"},
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        auth_mode: Optional[Union[str, "_models.AuthMode"]] = None,
        principal_id: Optional[str] = None,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        roles: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: Username created in the database which is mapped to a user in AAD.
        :paramtype user_name: str
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        :keyword principal_id: Principal Id for user account.
        :paramtype principal_id: str
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation when
         Linker is updating or deleting. Known values are: "Default" and "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        :keyword roles: Optional, this value specifies the Azure roles to be assigned. Automatically.
        :paramtype roles: list[str]
        """
        super().__init__(auth_mode=auth_mode, user_name=user_name, **kwargs)
        self.user_name = user_name
        self.auth_type: str = "userAccount"
        self.principal_id = principal_id
        self.delete_or_update_behavior = delete_or_update_behavior
        self.roles = roles
        self.auth_mode = auth_mode


class UserAssignedIdentityAuthInfo(AuthInfoBase, DatabaseAadAuthInfo):
    """The authentication info when authType is userAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar user_name: Username created in the database which is mapped to a user in AAD.
    :vartype user_name: str
    :ivar auth_type: The authentication type. Required. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth, service
     linker configures authentication such as enabling identity on source resource and granting RBAC
     roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth. Known values
     are: "optInAllAuth" and "optOutAllAuth".
    :vartype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
    :ivar client_id: Client Id for userAssignedIdentity.
    :vartype client_id: str
    :ivar subscription_id: Subscription id for userAssignedIdentity.
    :vartype subscription_id: str
    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation when Linker
     is updating or deleting. Known values are: "Default" and "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    :ivar roles: Optional, this value specifies the Azure role to be assigned.
    :vartype roles: list[str]
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "user_name": {"key": "userName", "type": "str"},
        "auth_type": {"key": "authType", "type": "str"},
        "auth_mode": {"key": "authMode", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        auth_mode: Optional[Union[str, "_models.AuthMode"]] = None,
        client_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        roles: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: Username created in the database which is mapped to a user in AAD.
        :paramtype user_name: str
        :keyword auth_mode: Optional. Indicates how to configure authentication. If optInAllAuth,
         service linker configures authentication such as enabling identity on source resource and
         granting RBAC roles. If optOutAllAuth, opt out authentication setup. Default is optInAllAuth.
         Known values are: "optInAllAuth" and "optOutAllAuth".
        :paramtype auth_mode: str or ~azure.mgmt.servicelinker.models.AuthMode
        :keyword client_id: Client Id for userAssignedIdentity.
        :paramtype client_id: str
        :keyword subscription_id: Subscription id for userAssignedIdentity.
        :paramtype subscription_id: str
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation when
         Linker is updating or deleting. Known values are: "Default" and "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        :keyword roles: Optional, this value specifies the Azure role to be assigned.
        :paramtype roles: list[str]
        """
        super().__init__(auth_mode=auth_mode, user_name=user_name, **kwargs)
        self.user_name = user_name
        self.auth_type: str = "userAssignedIdentity"
        self.client_id = client_id
        self.subscription_id = subscription_id
        self.delete_or_update_behavior = delete_or_update_behavior
        self.roles = roles
        self.auth_mode = auth_mode


class ValidateOperationResult(_serialization.Model):
    """The validation operation result for a Linker.

    :ivar resource_id: Validated Linker id.
    :vartype resource_id: str
    :ivar status: Validation operation status.
    :vartype status: str
    :ivar linker_name: The linker name.
    :vartype linker_name: str
    :ivar is_connection_available: A boolean value indicating whether the connection is available
     or not.
    :vartype is_connection_available: bool
    :ivar report_start_time_utc: The start time of the validation report.
    :vartype report_start_time_utc: ~datetime.datetime
    :ivar report_end_time_utc: The end time of the validation report.
    :vartype report_end_time_utc: ~datetime.datetime
    :ivar source_id: The resource id of the Linker source application.
    :vartype source_id: str
    :ivar target_id: The resource Id of target service.
    :vartype target_id: str
    :ivar auth_type: The authentication type. Known values are: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
     "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar validation_detail: The detail of validation result.
    :vartype validation_detail: list[~azure.mgmt.servicelinker.models.ValidationResultItem]
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "linker_name": {"key": "properties.linkerName", "type": "str"},
        "is_connection_available": {"key": "properties.isConnectionAvailable", "type": "bool"},
        "report_start_time_utc": {"key": "properties.reportStartTimeUtc", "type": "iso-8601"},
        "report_end_time_utc": {"key": "properties.reportEndTimeUtc", "type": "iso-8601"},
        "source_id": {"key": "properties.sourceId", "type": "str"},
        "target_id": {"key": "properties.targetId", "type": "str"},
        "auth_type": {"key": "properties.authType", "type": "str"},
        "validation_detail": {"key": "properties.validationDetail", "type": "[ValidationResultItem]"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        status: Optional[str] = None,
        linker_name: Optional[str] = None,
        is_connection_available: Optional[bool] = None,
        report_start_time_utc: Optional[datetime.datetime] = None,
        report_end_time_utc: Optional[datetime.datetime] = None,
        source_id: Optional[str] = None,
        target_id: Optional[str] = None,
        auth_type: Optional[Union[str, "_models.AuthType"]] = None,
        validation_detail: Optional[List["_models.ValidationResultItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: Validated Linker id.
        :paramtype resource_id: str
        :keyword status: Validation operation status.
        :paramtype status: str
        :keyword linker_name: The linker name.
        :paramtype linker_name: str
        :keyword is_connection_available: A boolean value indicating whether the connection is
         available or not.
        :paramtype is_connection_available: bool
        :keyword report_start_time_utc: The start time of the validation report.
        :paramtype report_start_time_utc: ~datetime.datetime
        :keyword report_end_time_utc: The end time of the validation report.
        :paramtype report_end_time_utc: ~datetime.datetime
        :keyword source_id: The resource id of the Linker source application.
        :paramtype source_id: str
        :keyword target_id: The resource Id of target service.
        :paramtype target_id: str
        :keyword auth_type: The authentication type. Known values are: "systemAssignedIdentity",
         "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret",
         "accessKey", "userAccount", and "easyAuthMicrosoftEntraID".
        :paramtype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
        :keyword validation_detail: The detail of validation result.
        :paramtype validation_detail: list[~azure.mgmt.servicelinker.models.ValidationResultItem]
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.status = status
        self.linker_name = linker_name
        self.is_connection_available = is_connection_available
        self.report_start_time_utc = report_start_time_utc
        self.report_end_time_utc = report_end_time_utc
        self.source_id = source_id
        self.target_id = target_id
        self.auth_type = auth_type
        self.validation_detail = validation_detail


class ValidationResultItem(_serialization.Model):
    """The validation item for a Linker.

    :ivar name: The validation item name.
    :vartype name: str
    :ivar description: The display name of validation item.
    :vartype description: str
    :ivar result: The result of validation. Known values are: "success", "failure", and "warning".
    :vartype result: str or ~azure.mgmt.servicelinker.models.ValidationResultStatus
    :ivar error_message: The error message of validation result.
    :vartype error_message: str
    :ivar error_code: The error code of validation result.
    :vartype error_code: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "result": {"key": "result", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        result: Optional[Union[str, "_models.ValidationResultStatus"]] = None,
        error_message: Optional[str] = None,
        error_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The validation item name.
        :paramtype name: str
        :keyword description: The display name of validation item.
        :paramtype description: str
        :keyword result: The result of validation. Known values are: "success", "failure", and
         "warning".
        :paramtype result: str or ~azure.mgmt.servicelinker.models.ValidationResultStatus
        :keyword error_message: The error message of validation result.
        :paramtype error_message: str
        :keyword error_code: The error code of validation result.
        :paramtype error_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.result = result
        self.error_message = error_message
        self.error_code = error_code


class ValueSecretInfo(SecretInfoBase):
    """The secret info when type is rawValue. It's for scenarios that user input the secret.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: The secret type. Required. Known values are: "rawValue",
     "keyVaultSecretUri", and "keyVaultSecretReference".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretType
    :ivar value: The actual value of the secret.
    :vartype value: str
    """

    _validation = {
        "secret_type": {"required": True},
    }

    _attribute_map = {
        "secret_type": {"key": "secretType", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The actual value of the secret.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.secret_type: str = "rawValue"
        self.value = value


class VNetSolution(_serialization.Model):
    """The VNet solution for linker.

    :ivar type: Type of VNet solution. Known values are: "serviceEndpoint" and "privateLink".
    :vartype type: str or ~azure.mgmt.servicelinker.models.VNetSolutionType
    :ivar delete_or_update_behavior: Indicates whether to clean up previous operation when Linker
     is updating or deleting. Known values are: "Default" and "ForcedCleanup".
    :vartype delete_or_update_behavior: str or
     ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "delete_or_update_behavior": {"key": "deleteOrUpdateBehavior", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.VNetSolutionType"]] = None,
        delete_or_update_behavior: Optional[Union[str, "_models.DeleteOrUpdateBehavior"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of VNet solution. Known values are: "serviceEndpoint" and "privateLink".
        :paramtype type: str or ~azure.mgmt.servicelinker.models.VNetSolutionType
        :keyword delete_or_update_behavior: Indicates whether to clean up previous operation when
         Linker is updating or deleting. Known values are: "Default" and "ForcedCleanup".
        :paramtype delete_or_update_behavior: str or
         ~azure.mgmt.servicelinker.models.DeleteOrUpdateBehavior
        """
        super().__init__(**kwargs)
        self.type = type
        self.delete_or_update_behavior = delete_or_update_behavior
