/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.ClusterDimensionalSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactClusterLevelNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import org.opensearch.performanceanalyzer.rca.framework.util.SQLiteQueryUtils;

public class ClusterTemperatureSummary
extends GenericSummary {
    public static final String TABLE_NAME = ClusterTemperatureSummary.class.getSimpleName();
    public static final String NUM_NODES = "num_nodes";
    private final ClusterDimensionalSummary[] nodeDimensionalTemperatureSummaries;
    private final CompactClusterLevelNodeSummary[] nodes;
    private int numberOfNodes;

    public ClusterTemperatureSummary(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        this.nodeDimensionalTemperatureSummaries = new ClusterDimensionalSummary[TemperatureDimension.values().length];
        this.nodes = new CompactClusterLevelNodeSummary[this.numberOfNodes];
    }

    public void createClusterDimensionalTemperature(TemperatureDimension dimension, TemperatureVector.NormalizedValue mean, double totalUsage) {
        ClusterDimensionalSummary summary = new ClusterDimensionalSummary(dimension);
        summary.setMeanTemperature(mean);
        summary.setTotalUsage(totalUsage);
        this.nodeDimensionalTemperatureSummaries[dimension.ordinal()] = summary;
    }

    public void addNodesSummaries(Map<String, CompactClusterLevelNodeSummary> nodeTemperatureSummaries) {
        int i = 0;
        for (CompactClusterLevelNodeSummary nodeTemperatureSummaryVal : nodeTemperatureSummaries.values()) {
            for (TemperatureDimension dimension : TemperatureDimension.values()) {
                this.nodeDimensionalTemperatureSummaries[dimension.ordinal()].addNodeToZone(nodeTemperatureSummaryVal);
            }
            this.nodes[i] = nodeTemperatureSummaryVal;
            ++i;
        }
    }

    public void addNodeSummaries(List<CompactClusterLevelNodeSummary> nodeSummaries) {
        int i = 0;
        Iterator<CompactClusterLevelNodeSummary> iterator = nodeSummaries.iterator();
        while (iterator.hasNext()) {
            CompactClusterLevelNodeSummary nodeSummary;
            this.nodes[i] = nodeSummary = iterator.next();
            ++i;
        }
    }

    @Override
    public List<GenericSummary> getNestedSummaryList() {
        ArrayList<GenericSummary> summaries = new ArrayList<GenericSummary>();
        for (ClusterDimensionalSummary clusterDimensionalSummary : this.nodeDimensionalTemperatureSummaries) {
            summaries.add(clusterDimensionalSummary);
        }
        for (GenericSummary genericSummary : this.nodes) {
            summaries.add(genericSummary);
        }
        return summaries;
    }

    @Override
    public <T extends GeneratedMessageV3> T buildSummaryMessage() {
        throw new IllegalArgumentException();
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        throw new IllegalArgumentException();
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    private static List<Field<?>> getColumns() {
        ArrayList schema = new ArrayList();
        schema.add(DSL.field((Name)DSL.name((String)NUM_NODES), Short.class));
        return schema;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        return ClusterTemperatureSummary.getColumns();
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(this.numberOfNodes);
        return values;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        JsonArray dimTempArray = new JsonArray();
        for (ClusterDimensionalSummary summary : this.nodeDimensionalTemperatureSummaries) {
            dimTempArray.add(summary.toJson());
        }
        if (dimTempArray.size() > 0) {
            summaryObj.add(ClusterDimensionalSummary.TABLE_NAME, (JsonElement)dimTempArray);
        }
        JsonArray nodesArr = new JsonArray();
        String elemName = "";
        for (CompactClusterLevelNodeSummary nodeSummary : this.nodes) {
            if (nodeSummary == null) continue;
            nodesArr.add(nodeSummary.toJson());
            elemName = nodeSummary.TABLE_NAME;
        }
        if (!elemName.isEmpty()) {
            summaryObj.add(elemName, (JsonElement)nodesArr);
        }
        return summaryObj;
    }

    public static ClusterTemperatureSummary buildSummaryFromDatabase(Result<Record> records, DSLContext context) {
        int numNodes = -1;
        if (records.size() > 1) {
            throw new IllegalArgumentException("Only 1 ClusterTemperatureSummary expected." + records);
        }
        Record record = (Record)records.get(0);
        for (Field<?> field : ClusterTemperatureSummary.getColumns()) {
            numNodes = (Integer)record.get(field, Integer.class);
        }
        ClusterTemperatureSummary summary = new ClusterTemperatureSummary(numNodes);
        String dimensionalTablename = ClusterDimensionalSummary.TABLE_NAME;
        int clusterTemperatureID = (Integer)record.get(SQLiteQueryUtils.getPrimaryKeyColumnName(TABLE_NAME), Integer.class);
        Field foreignKeyForDimensionalTable = DSL.field((String)SQLiteQueryUtils.getPrimaryKeyColumnName(TABLE_NAME), Integer.class);
        SelectJoinStep<Record> rcaQuery = SQLiteQueryUtils.buildSummaryQuery(context, dimensionalTablename, clusterTemperatureID, (Field<Integer>)foreignKeyForDimensionalTable);
        Result recordList = rcaQuery.fetch();
        for (Record record1 : recordList) {
            ClusterDimensionalSummary dimSummary;
            summary.nodeDimensionalTemperatureSummaries[dimSummary.getProfileForDimension().ordinal()] = dimSummary = ClusterDimensionalSummary.build(record1, context);
        }
        rcaQuery = SQLiteQueryUtils.buildSummaryQuery(context, CompactClusterLevelNodeSummary.class.getSimpleName(), clusterTemperatureID, (Field<Integer>)foreignKeyForDimensionalTable);
        recordList = rcaQuery.fetch();
        ArrayList<CompactClusterLevelNodeSummary> nodeSummaries = new ArrayList<CompactClusterLevelNodeSummary>();
        for (Record record1 : recordList) {
            CompactClusterLevelNodeSummary nodeSummary = CompactClusterLevelNodeSummary.build(record1);
            nodeSummaries.add(nodeSummary);
        }
        summary.addNodeSummaries(nodeSummaries);
        return summary;
    }
}

