/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;

public class GroupTitle {
    protected String title;
    protected String actual;
    protected String type;
    protected String parent;
    private long id;
    private boolean done = false;
    protected boolean supportsHierarchy = false;
    protected int level = 0;
    private int startIndex = -1;
    private int endIndex = -1;
    protected Bib2Gls bib2gls;

    public GroupTitle(Bib2Gls bib2Gls, String string, String string2, long l, String string3, String string4) {
        this.bib2gls = bib2Gls;
        this.title = string;
        this.actual = string2;
        this.id = l;
        this.type = string3;
        this.parent = string4;
    }

    public void setSupportsHierarchy(boolean bl, int n) {
        this.supportsHierarchy = bl;
        this.level = n;
    }

    public boolean hasHierarchySupport() {
        return this.supportsHierarchy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getActual() {
        return this.actual;
    }

    public void setActual(String string) {
        this.actual = string;
    }

    public String getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public String getParent() {
        return this.parent;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof GroupTitle && this.getKey().equals(((GroupTitle)object).getKey());
    }

    public String getKey() {
        return GroupTitle.getKey(this.type, this.id, this.parent);
    }

    public static String getKey(String string, long l, String string2) {
        String string3 = "";
        string3 = string == null || string.isEmpty() ? string3 + l : String.format("%s.%d", string, l);
        if (string2 != null && !string2.isEmpty()) {
            string3 = string3 + "|" + string2;
        }
        return string3;
    }

    protected String getNonHierCsSetName() {
        return "bibglssetlettergrouptitle";
    }

    public String getCsSetName() {
        return this.supportsHierarchy ? this.getNonHierCsSetName() + "hier" : this.getNonHierCsSetName();
    }

    protected String getNonHierCsLabelName() {
        return "bibglslettergroup";
    }

    public String getCsLabelName() {
        return this.supportsHierarchy ? this.getNonHierCsLabelName() + "hier" : this.getNonHierCsLabelName();
    }

    public String getCsTitleName() {
        return this.supportsHierarchy ? this.getNonHierCsLabelName() + "titlehier" : this.getNonHierCsLabelName() + "title";
    }

    public String toString() {
        return this.format(this.actual);
    }

    public String format() {
        return this.format(this.actual);
    }

    public String format(String string) {
        if (this.supportsHierarchy) {
            return String.format("{%s}{%s}{%d}{%s}{%s}{%d}", this.title, this.bib2gls.replaceSpecialChars(string), this.id, this.type == null ? "" : this.type, this.parent == null ? "" : this.parent, this.level);
        }
        return String.format("{%s}{%s}{%d}{%s}", this.title, this.bib2gls.replaceSpecialChars(string), this.id, this.type == null ? "" : this.type);
    }

    public void mark() {
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setStartIndex(int n) {
        this.startIndex = n;
    }

    public void setEndIndex(int n) {
        this.endIndex = n;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void resetIndexes() {
        this.startIndex = -1;
        this.endIndex = -1;
    }
}

