/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.text;

import javax.swing.ImageIcon;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.model.TextModel;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.text.ColorMode;
import org.gephi.visualization.text.TextManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ObjectColorMode
implements ColorMode {
    private final VizConfig vizConfig = VizController.getInstance().getVizConfig();

    @Override
    public void defaultEdgeColor(TextManager.Renderer renderer) {
    }

    @Override
    public void defaultNodeColor(TextManager.Renderer renderer) {
    }

    @Override
    public void textNodeColor(TextManager.Renderer renderer, NodeModel nodeModel) {
        this.textColor(renderer, nodeModel, nodeModel.isSelected() || nodeModel.isHighlight());
    }

    @Override
    public void textEdgeColor(TextManager.Renderer renderer, EdgeModel edgeModel) {
        float[] cl = edgeModel.getColor();
        renderer.setColor(cl[0], cl[1], cl[2], cl[3]);
    }

    protected void textColor(TextManager.Renderer renderer, TextModel text, boolean selected) {
        if (this.vizConfig.isLightenNonSelected()) {
            if (!selected) {
                float lightColorFactor = 1.0f - this.vizConfig.getLightenNonSelectedFactor();
                renderer.setColor(text.getElementProperties().r(), text.getElementProperties().g(), text.getElementProperties().b(), lightColorFactor);
            } else {
                renderer.setColor(text.getElementProperties().r(), text.getElementProperties().g(), text.getElementProperties().b(), 1.0f);
            }
        } else {
            renderer.setColor(text.getElementProperties().r(), text.getElementProperties().g(), text.getElementProperties().b(), text.getElementProperties().alpha());
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ObjectColorMode.class, (String)"ObjectColorMode.name");
    }

    @Override
    public ImageIcon getIcon() {
        return ImageUtilities.loadImageIcon((String)"VisualizationImpl/ObjectColorMode.png", (boolean)false);
    }

    public String toString() {
        return this.getName();
    }
}

