"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingPlugin = void 0;
var _operators = require("rxjs/operators");
var _clusters = require("./clusters");
var _services = require("./services");
var _routes = require("../server/routes");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class AlertingPlugin {
  constructor(initializerContext) {
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core) {
    // Get the global configuration settings of the cluster
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();

    // Create clusters
    const alertingESClient = (0, _clusters.createAlertingCluster)(core, globalConfig);
    const adESClient = (0, _clusters.createAlertingADCluster)(core, globalConfig);

    // Initialize services
    const alertService = new _services.AlertService(alertingESClient);
    const opensearchService = new _services.OpensearchService(alertingESClient);
    const monitorService = new _services.MonitorService(alertingESClient);
    const destinationsService = new _services.DestinationsService(alertingESClient);
    const anomalyDetectorService = new _services.AnomalyDetectorService(adESClient);
    const findingService = new _services.FindingService(alertingESClient);
    const crossClusterService = new _services.CrossClusterService(alertingESClient);
    const services = {
      alertService,
      destinationsService,
      opensearchService,
      monitorService,
      anomalyDetectorService,
      findingService,
      crossClusterService
    };

    // Create router
    const router = core.http.createRouter();
    // Add server routes
    (0, _routes.alerts)(services, router);
    (0, _routes.destinations)(services, router);
    (0, _routes.opensearch)(services, router);
    (0, _routes.monitors)(services, router);
    (0, _routes.detectors)(services, router);
    (0, _routes.findings)(services, router);
    (0, _routes.crossCluster)(services, router);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.AlertingPlugin = AlertingPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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