"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    alertService
  } = services;
  router.get({
    path: '/api/alerting/alerts',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.maybe(_configSchema.schema.number()),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        severityLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
        alertState: _configSchema.schema.maybe(_configSchema.schema.string()),
        monitorIds: _configSchema.schema.maybe(_configSchema.schema.string()),
        monitorType: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, alertService.getAlerts);
  router.get({
    path: '/api/alerting/workflows/alerts',
    validate: {
      query: _configSchema.schema.object({
        workflowIds: _configSchema.schema.string(),
        getAssociatedAlerts: _configSchema.schema.boolean(),
        sortString: _configSchema.schema.string(),
        sortOrder: _configSchema.schema.string(),
        startIndex: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        severityLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
        alertState: _configSchema.schema.maybe(_configSchema.schema.string()),
        searchString: _configSchema.schema.maybe(_configSchema.schema.string()),
        alertIds: _configSchema.schema.string()
      })
    }
  }, alertService.getWorkflowAlerts);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9kZWZhdWx0Iiwic2VydmljZXMiLCJyb3V0ZXIiLCJhbGVydFNlcnZpY2UiLCJnZXQiLCJwYXRoIiwidmFsaWRhdGUiLCJxdWVyeSIsInNjaGVtYSIsIm9iamVjdCIsImZyb20iLCJtYXliZSIsIm51bWJlciIsInNpemUiLCJzZWFyY2giLCJzdHJpbmciLCJzb3J0RmllbGQiLCJzb3J0RGlyZWN0aW9uIiwic2V2ZXJpdHlMZXZlbCIsImFsZXJ0U3RhdGUiLCJtb25pdG9ySWRzIiwibW9uaXRvclR5cGUiLCJnZXRBbGVydHMiLCJ3b3JrZmxvd0lkcyIsImdldEFzc29jaWF0ZWRBbGVydHMiLCJib29sZWFuIiwic29ydFN0cmluZyIsInNvcnRPcmRlciIsInN0YXJ0SW5kZXgiLCJzZWFyY2hTdHJpbmciLCJhbGVydElkcyIsImdldFdvcmtmbG93QWxlcnRzIiwibW9kdWxlIiwiZXhwb3J0cyIsImRlZmF1bHQiXSwic291cmNlcyI6WyJhbGVydHMuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAoc2VydmljZXMsIHJvdXRlcikge1xuICBjb25zdCB7IGFsZXJ0U2VydmljZSB9ID0gc2VydmljZXM7XG5cbiAgcm91dGVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiAnL2FwaS9hbGVydGluZy9hbGVydHMnLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGZyb206IHNjaGVtYS5tYXliZShzY2hlbWEubnVtYmVyKCkpLFxuICAgICAgICAgIHNpemU6IHNjaGVtYS5udW1iZXIoKSxcbiAgICAgICAgICBzZWFyY2g6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKCkpLFxuICAgICAgICAgIHNvcnRGaWVsZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgIHNvcnREaXJlY3Rpb246IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICBzZXZlcml0eUxldmVsOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgICAgICAgICBhbGVydFN0YXRlOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgICAgICAgICBtb25pdG9ySWRzOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgICAgICAgICBtb25pdG9yVHlwZTogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoKSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFsZXJ0U2VydmljZS5nZXRBbGVydHNcbiAgKTtcblxuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6ICcvYXBpL2FsZXJ0aW5nL3dvcmtmbG93cy9hbGVydHMnLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIHdvcmtmbG93SWRzOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgZ2V0QXNzb2NpYXRlZEFsZXJ0czogc2NoZW1hLmJvb2xlYW4oKSxcbiAgICAgICAgICBzb3J0U3RyaW5nOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgc29ydE9yZGVyOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgc3RhcnRJbmRleDogc2NoZW1hLm51bWJlcigpLFxuICAgICAgICAgIHNpemU6IHNjaGVtYS5udW1iZXIoKSxcbiAgICAgICAgICBzZXZlcml0eUxldmVsOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgICAgICAgICBhbGVydFN0YXRlOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgICAgICAgICBzZWFyY2hTdHJpbmc6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKCkpLFxuICAgICAgICAgIGFsZXJ0SWRzOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFsZXJ0U2VydmljZS5nZXRXb3JrZmxvd0FsZXJ0c1xuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFMQTtBQUNBO0FBQ0E7QUFDQTs7QUFJZSxTQUFBQyxTQUFVQyxRQUFRLEVBQUVDLE1BQU0sRUFBRTtFQUN6QyxNQUFNO0lBQUVDO0VBQWEsQ0FBQyxHQUFHRixRQUFRO0VBRWpDQyxNQUFNLENBQUNFLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUUsc0JBQXNCO0lBQzVCQyxRQUFRLEVBQUU7TUFDUkMsS0FBSyxFQUFFQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbkJDLElBQUksRUFBRUYsb0JBQU0sQ0FBQ0csS0FBSyxDQUFDSCxvQkFBTSxDQUFDSSxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQ25DQyxJQUFJLEVBQUVMLG9CQUFNLENBQUNJLE1BQU0sQ0FBQyxDQUFDO1FBQ3JCRSxNQUFNLEVBQUVOLG9CQUFNLENBQUNHLEtBQUssQ0FBQ0gsb0JBQU0sQ0FBQ08sTUFBTSxDQUFDLENBQUMsQ0FBQztRQUNyQ0MsU0FBUyxFQUFFUixvQkFBTSxDQUFDTyxNQUFNLENBQUMsQ0FBQztRQUMxQkUsYUFBYSxFQUFFVCxvQkFBTSxDQUFDTyxNQUFNLENBQUMsQ0FBQztRQUM5QkcsYUFBYSxFQUFFVixvQkFBTSxDQUFDRyxLQUFLLENBQUNILG9CQUFNLENBQUNPLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDNUNJLFVBQVUsRUFBRVgsb0JBQU0sQ0FBQ0csS0FBSyxDQUFDSCxvQkFBTSxDQUFDTyxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQ3pDSyxVQUFVLEVBQUVaLG9CQUFNLENBQUNHLEtBQUssQ0FBQ0gsb0JBQU0sQ0FBQ08sTUFBTSxDQUFDLENBQUMsQ0FBQztRQUN6Q00sV0FBVyxFQUFFYixvQkFBTSxDQUFDRyxLQUFLLENBQUNILG9CQUFNLENBQUNPLE1BQU0sQ0FBQyxDQUFDO01BQzNDLENBQUM7SUFDSDtFQUNGLENBQUMsRUFDRFosWUFBWSxDQUFDbUIsU0FDZixDQUFDO0VBRURwQixNQUFNLENBQUNFLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUUsZ0NBQWdDO0lBQ3RDQyxRQUFRLEVBQUU7TUFDUkMsS0FBSyxFQUFFQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbkJjLFdBQVcsRUFBRWYsb0JBQU0sQ0FBQ08sTUFBTSxDQUFDLENBQUM7UUFDNUJTLG1CQUFtQixFQUFFaEIsb0JBQU0sQ0FBQ2lCLE9BQU8sQ0FBQyxDQUFDO1FBQ3JDQyxVQUFVLEVBQUVsQixvQkFBTSxDQUFDTyxNQUFNLENBQUMsQ0FBQztRQUMzQlksU0FBUyxFQUFFbkIsb0JBQU0sQ0FBQ08sTUFBTSxDQUFDLENBQUM7UUFDMUJhLFVBQVUsRUFBRXBCLG9CQUFNLENBQUNJLE1BQU0sQ0FBQyxDQUFDO1FBQzNCQyxJQUFJLEVBQUVMLG9CQUFNLENBQUNJLE1BQU0sQ0FBQyxDQUFDO1FBQ3JCTSxhQUFhLEVBQUVWLG9CQUFNLENBQUNHLEtBQUssQ0FBQ0gsb0JBQU0sQ0FBQ08sTUFBTSxDQUFDLENBQUMsQ0FBQztRQUM1Q0ksVUFBVSxFQUFFWCxvQkFBTSxDQUFDRyxLQUFLLENBQUNILG9CQUFNLENBQUNPLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDekNjLFlBQVksRUFBRXJCLG9CQUFNLENBQUNHLEtBQUssQ0FBQ0gsb0JBQU0sQ0FBQ08sTUFBTSxDQUFDLENBQUMsQ0FBQztRQUMzQ2UsUUFBUSxFQUFFdEIsb0JBQU0sQ0FBQ08sTUFBTSxDQUFDO01BQzFCLENBQUM7SUFDSDtFQUNGLENBQUMsRUFDRFosWUFBWSxDQUFDNEIsaUJBQ2YsQ0FBQztBQUNIO0FBQUNDLE1BQUEsQ0FBQUMsT0FBQSxHQUFBQSxPQUFBLENBQUFDLE9BQUEifQ==