"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WRONG_THROTTLE_WARNING = exports.URL = exports.PLUGIN_NAME = exports.OPEN_SEARCH_PREFIX = exports.MAX_THROTTLE_VALUE = exports.INDEX_PREFIX = exports.INDEX = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Keeping index prefix as 'opendistro' as migrating the system index is currently difficult to complete
const OPEN_SEARCH_PREFIX = exports.OPEN_SEARCH_PREFIX = 'opendistro';
const PLUGIN_NAME = exports.PLUGIN_NAME = `alerting`;
const INDEX_PREFIX = exports.INDEX_PREFIX = `${OPEN_SEARCH_PREFIX}-alerting`;
const INDEX = exports.INDEX = {
  SCHEDULED_JOBS: `.${INDEX_PREFIX}-config`,
  ALERTS: `.${INDEX_PREFIX}-alerts`,
  ALL_ALERTS: `.${INDEX_PREFIX}-alert*`,
  ALERT_HISTORY_WRITE: `.${INDEX_PREFIX}-alert-history-write`
};
const URL = exports.URL = {
  MUSTACHE: 'https://mustache.github.io/mustache.5.html',
  DOCUMENTATION: 'https://docs-beta.opensearch.org/monitoring-plugins/alerting/',
  CREATE_MONITOR_DOCUMENTATION: 'https://opensearch.org/docs/monitoring-plugins/alerting/monitors/#create-monitors'
};
const MAX_THROTTLE_VALUE = exports.MAX_THROTTLE_VALUE = 1440;
const WRONG_THROTTLE_WARNING = exports.WRONG_THROTTLE_WARNING = `Throttle value must be greater than 0 and less than ${MAX_THROTTLE_VALUE}.`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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