"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pageStyles = exports.observabilityTracesTitle = exports.observabilityTracesPluginOrder = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityNotebookTitle = exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityDataConnectionsTitle = exports.observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.TIMESTAMP_DATETIME_TYPES = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SECURITY_ROLES = exports.SECURITY_PLUGIN_ACCOUNT_API = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.S3_DATA_SOURCE_TYPE = exports.QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_END_TIME = exports.PROMQL_METRIC_SUBTYPE = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_METRIC_SUBTYPE = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OPENSEARCH_PANELS_API = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.JOB_RESULT_ENDPOINT = exports.JOBS_ENDPOINT_BASE = exports.JOBS_BASE = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.EDIT = exports.DSL_SETTINGS = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DIRECT_DUMMY_QUERY = exports.DEFAULT_START_TIME = exports.DEFAULT_CHART_STYLES = exports.DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_BASE = exports.CONSOLE_PROXY = exports.BarOrientation = exports.ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = void 0;
exports.queryWorkbenchPluginID = exports.queryWorkbenchPluginCheck = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Client route
const PPL_BASE = exports.PPL_BASE = '/api/ppl';
const PPL_SEARCH = exports.PPL_SEARCH = '/search';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const DSL_CAT = exports.DSL_CAT = '/cat.indices';
const DSL_MAPPING = exports.DSL_MAPPING = '/indices.getFieldMapping';
const DSL_SETTINGS = exports.DSL_SETTINGS = '/indices.getFieldSettings';
const OBSERVABILITY_BASE = exports.OBSERVABILITY_BASE = '/api/observability';
const INTEGRATIONS_BASE = exports.INTEGRATIONS_BASE = '/api/integrations';
const JOBS_BASE = exports.JOBS_BASE = '/query/jobs';
const DATACONNECTIONS_BASE = exports.DATACONNECTIONS_BASE = '/api/dataconnections';
const EDIT = exports.EDIT = '/edit';
const DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_UPDATE_STATUS = '/status';
const SECURITY_ROLES = exports.SECURITY_ROLES = '/api/v1/configuration/roles';
const EVENT_ANALYTICS = exports.EVENT_ANALYTICS = '/event_analytics';
const SAVED_OBJECTS = exports.SAVED_OBJECTS = '/saved_objects';
const SAVED_QUERY = exports.SAVED_QUERY = '/query';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = '/vis';
const CONSOLE_PROXY = exports.CONSOLE_PROXY = '/api/console/proxy';
const SECURITY_PLUGIN_ACCOUNT_API = exports.SECURITY_PLUGIN_ACCOUNT_API = '/api/v1/configuration/account';

// Server route
const PPL_ENDPOINT = exports.PPL_ENDPOINT = '/_plugins/_ppl';
const SQL_ENDPOINT = exports.SQL_ENDPOINT = '/_plugins/_sql';
const DSL_ENDPOINT = exports.DSL_ENDPOINT = '/_plugins/_dsl';
const DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_ENDPOINT = '/_plugins/_query/_datasources';
const JOBS_ENDPOINT_BASE = exports.JOBS_ENDPOINT_BASE = '/_plugins/_async_query';
const JOB_RESULT_ENDPOINT = exports.JOB_RESULT_ENDPOINT = '/result';
const observabilityID = exports.observabilityID = 'observability-logs';
const observabilityTitle = exports.observabilityTitle = 'Observability';
const observabilityPluginOrder = exports.observabilityPluginOrder = 1500;
const observabilityApplicationsID = exports.observabilityApplicationsID = 'observability-applications';
const observabilityApplicationsTitle = exports.observabilityApplicationsTitle = 'Applications';
const observabilityApplicationsPluginOrder = exports.observabilityApplicationsPluginOrder = 5090;
const observabilityLogsID = exports.observabilityLogsID = 'observability-logs';
const observabilityLogsTitle = exports.observabilityLogsTitle = 'Logs';
const observabilityLogsPluginOrder = exports.observabilityLogsPluginOrder = 5091;
const observabilityMetricsID = exports.observabilityMetricsID = 'observability-metrics';
const observabilityMetricsTitle = exports.observabilityMetricsTitle = 'Metrics';
const observabilityMetricsPluginOrder = exports.observabilityMetricsPluginOrder = 5092;
const observabilityTracesID = exports.observabilityTracesID = 'observability-traces';
const observabilityTracesTitle = exports.observabilityTracesTitle = 'Traces';
const observabilityTracesPluginOrder = exports.observabilityTracesPluginOrder = 5093;
const observabilityNotebookID = exports.observabilityNotebookID = 'observability-notebooks';
const observabilityNotebookTitle = exports.observabilityNotebookTitle = 'Notebooks';
const observabilityNotebookPluginOrder = exports.observabilityNotebookPluginOrder = 5094;
const observabilityPanelsID = exports.observabilityPanelsID = 'observability-dashboards';
const observabilityPanelsTitle = exports.observabilityPanelsTitle = 'Dashboards';
const observabilityPanelsPluginOrder = exports.observabilityPanelsPluginOrder = 5095;
const observabilityIntegrationsID = exports.observabilityIntegrationsID = 'integrations';
const observabilityIntegrationsTitle = exports.observabilityIntegrationsTitle = 'Integrations';
const observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsPluginOrder = 9020;
const observabilityDataConnectionsID = exports.observabilityDataConnectionsID = 'datasources';
const observabilityDataConnectionsTitle = exports.observabilityDataConnectionsTitle = 'Data sources';
const observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsPluginOrder = 9030;
const queryWorkbenchPluginID = exports.queryWorkbenchPluginID = 'opensearch-query-workbench';
const queryWorkbenchPluginCheck = exports.queryWorkbenchPluginCheck = 'plugin:queryWorkbenchDashboards';

// Shared Constants
const SQL_DOCUMENTATION_URL = exports.SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
const PPL_DOCUMENTATION_URL = exports.PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
const PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
const UI_DATE_FORMAT = exports.UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
const PPL_DATE_FORMAT = exports.PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
const SPAN_REGEX = exports.SPAN_REGEX = /span/;
const PROMQL_METRIC_SUBTYPE = exports.PROMQL_METRIC_SUBTYPE = 'promqlmetric';
const PPL_METRIC_SUBTYPE = exports.PPL_METRIC_SUBTYPE = 'metric';
const PPL_SPAN_REGEX = exports.PPL_SPAN_REGEX = /by\s*span/i;
const PPL_STATS_REGEX = exports.PPL_STATS_REGEX = /\|\s*stats/i;
const PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
const PPL_INDEX_REGEX = exports.PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
const PPL_WHERE_CLAUSE_REGEX = exports.PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
const PPL_NEWLINE_REGEX = exports.PPL_NEWLINE_REGEX = /[\n\r]+/g;
const PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DESCRIBE_INDEX_REGEX = /(describe)\s+([^|\s]+)/i;

// Observability plugin URI
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_PANELS_API = exports.OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
};
const OPENSEARCH_DATACONNECTIONS_API = exports.OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
};

// Saved Objects
const SAVED_OBJECT = exports.SAVED_OBJECT = '/object';

// Color Constants
const PLOTLY_COLOR = exports.PLOTLY_COLOR = ['#3CA1C7', '#54B399', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
const LONG_CHART_COLOR = exports.LONG_CHART_COLOR = PLOTLY_COLOR[1];
const pageStyles = exports.pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
let VIS_CHART_TYPES = exports.VIS_CHART_TYPES = /*#__PURE__*/function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
  return VIS_CHART_TYPES;
}({});
const NUMERICAL_FIELDS = exports.NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
const ENABLED_VIS_TYPES = exports.ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text];

// Live tail constants
const LIVE_OPTIONS = exports.LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
const LIVE_END_TIME = exports.LIVE_END_TIME = 'now';
const DEFAULT_CHART_STYLES = exports.DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines+markers',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 25,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
const FILLOPACITY_DIV_FACTOR = exports.FILLOPACITY_DIV_FACTOR = 200;
const SLIDER_MIN_VALUE = exports.SLIDER_MIN_VALUE = 0;
const SLIDER_MAX_VALUE = exports.SLIDER_MAX_VALUE = 100;
const SLIDER_STEP = exports.SLIDER_STEP = 1;
const THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_WIDTH = 3;
const THRESHOLD_LINE_OPACITY = exports.THRESHOLD_LINE_OPACITY = 0.7;
const MAX_BUCKET_LENGTH = exports.MAX_BUCKET_LENGTH = 16;
let BarOrientation = exports.BarOrientation = /*#__PURE__*/function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
  return BarOrientation;
}({});
const PLOT_MARGIN = exports.PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
const WAITING_TIME_ON_USER_ACTIONS = exports.WAITING_TIME_ON_USER_ACTIONS = 300;
const VISUALIZATION_ERROR = exports.VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data',
  NO_SERIES: 'Add a field to start',
  NO_METRIC: 'Invalid Metric MetaData'
};
const S3_DATA_SOURCE_TYPE = exports.S3_DATA_SOURCE_TYPE = 's3glue';
const ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_SESSION_ID = 'async-query-session-id';
const ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_DATASOURCE_CACHE = 'async-query-catalog-cache';
const ASYNC_QUERY_ACCELERATIONS_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = 'async-query-acclerations-cache';
const DIRECT_DUMMY_QUERY = exports.DIRECT_DUMMY_QUERY = 'select 1';
const DEFAULT_START_TIME = exports.DEFAULT_START_TIME = 'now-15m';
const QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_START_TIME = 'now-40y';
const QUERY_ASSIST_END_TIME = exports.QUERY_ASSIST_END_TIME = 'now';
const TIMESTAMP_DATETIME_TYPES = exports.TIMESTAMP_DATETIME_TYPES = ['date', 'date_nanos'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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