"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _dsl_facet = require("../services/facets/dsl_facet");
var _ppl_facet = require("../services/facets/ppl_facet");
var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));
var _queryService = require("../services/queryService");
var _app_analytics_router = require("./application_analytics/app_analytics_router");
var _panels_router = require("./custom_panels/panels_router");
var _visualizations_router = require("./custom_panels/visualizations_router");
var _data_connections_router = require("./data_connections/data_connections_router");
var _datasources_router = require("./datasources/datasources_router");
var _dsl = require("./dsl");
var _event_analytics_router = require("./event_analytics/event_analytics_router");
var _integrations_router = require("./integrations/integrations_router");
var _metrics_rounter = require("./metrics/metrics_rounter");
var _noteRouter = require("./notebooks/noteRouter");
var _paraRouter = require("./notebooks/paraRouter");
var _sqlRouter = require("./notebooks/sqlRouter");
var _vizRouter = require("./notebooks/vizRouter");
var _ppl = require("./ppl");
var _routes = require("./query_assist/routes");
var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupRoutes({
  router,
  client,
  dataSourceEnabled
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.PPLFacet(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.DSLFacet(client)
  });
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router);

  // TODO remove trace analytics route when DSL route for autocomplete is added
  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router, dataSourceEnabled);

  // notebooks routes
  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router);
  const queryService = new _queryService.QueryService(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService);
  (0, _metrics_rounter.registerMetricsRoute)(router);
  (0, _integrations_router.registerIntegrationsRoute)(router);
  (0, _data_connections_router.registerDataConnectionsRoute)(router, dataSourceEnabled);
  (0, _datasources_router.registerDatasourcesRoute)(router, dataSourceEnabled);
  (0, _routes.registerQueryAssistRoutes)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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