/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Map;
import org.opensearch.knn.index.codec.util.KNNVectorAsArraySerializer;
import org.opensearch.knn.index.codec.util.KNNVectorAsCollectionOfFloatsSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.SerializationMode;

public class KNNVectorSerializerFactory {
    private static Map<SerializationMode, KNNVectorSerializer> VECTOR_SERIALIZER_BY_TYPE = ImmutableMap.of((Object)((Object)SerializationMode.ARRAY), (Object)new KNNVectorAsArraySerializer(), (Object)((Object)SerializationMode.COLLECTION_OF_FLOATS), (Object)new KNNVectorAsCollectionOfFloatsSerializer());
    private static final int ARRAY_HEADER_OFFSET = 27;
    private static final int BYTES_IN_FLOAT = 4;
    private static final int BITS_IN_ONE_BYTE = 8;
    private static final byte[] SERIALIZATION_PROTOCOL_HEADER_PREFIX = new byte[]{KNNVectorSerializerFactory.highByte((short)-21267), KNNVectorSerializerFactory.lowByte((short)-21267), KNNVectorSerializerFactory.highByte((short)5), KNNVectorSerializerFactory.lowByte((short)5), 117, 114};

    public static KNNVectorSerializer getSerializerBySerializationMode(SerializationMode serializationMode) {
        return VECTOR_SERIALIZER_BY_TYPE.getOrDefault((Object)serializationMode, new KNNVectorAsCollectionOfFloatsSerializer());
    }

    public static KNNVectorSerializer getDefaultSerializer() {
        return KNNVectorSerializerFactory.getSerializerBySerializationMode(SerializationMode.COLLECTION_OF_FLOATS);
    }

    public static KNNVectorSerializer getSerializerByStreamContent(ByteArrayInputStream byteStream) {
        SerializationMode serializationMode = KNNVectorSerializerFactory.serializerModeFromStream(byteStream);
        return KNNVectorSerializerFactory.getSerializerBySerializationMode(serializationMode);
    }

    static SerializationMode serializerModeFromStream(ByteArrayInputStream byteStream) {
        int numberOfAvailableBytesInStream = byteStream.available();
        if (numberOfAvailableBytesInStream < 27) {
            return KNNVectorSerializerFactory.getSerializerOrThrowError(numberOfAvailableBytesInStream, SerializationMode.COLLECTION_OF_FLOATS);
        }
        byte[] byteArray = new byte[SERIALIZATION_PROTOCOL_HEADER_PREFIX.length];
        byteStream.read(byteArray, 0, SERIALIZATION_PROTOCOL_HEADER_PREFIX.length);
        byteStream.reset();
        if (Arrays.equals(SERIALIZATION_PROTOCOL_HEADER_PREFIX, byteArray)) {
            int numberOfAvailableBytesAfterHeader = numberOfAvailableBytesInStream - 27;
            return KNNVectorSerializerFactory.getSerializerOrThrowError(numberOfAvailableBytesAfterHeader, SerializationMode.ARRAY);
        }
        return KNNVectorSerializerFactory.getSerializerOrThrowError(numberOfAvailableBytesInStream, SerializationMode.COLLECTION_OF_FLOATS);
    }

    private static SerializationMode getSerializerOrThrowError(int numberOfRemainingBytes, SerializationMode serializationMode) {
        if (numberOfRemainingBytes % 4 == 0) {
            return serializationMode;
        }
        throw new IllegalArgumentException(String.format("Byte stream cannot be deserialized to array of floats due to invalid length %d", numberOfRemainingBytes));
    }

    private static byte highByte(short shortValue) {
        return (byte)(shortValue >> 8);
    }

    private static byte lowByte(short shortValue) {
        return (byte)shortValue;
    }
}

