/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.common;

import java.util.Locale;
import lombok.Generated;
import org.opensearch.knn.index.VectorDataType;

public class KNNValidationUtil {
    public static void validateFloatVectorValue(float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("KNN vector values cannot be NaN");
        }
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException("KNN vector values cannot be infinity");
        }
    }

    public static void validateByteVectorValue(float value) {
        KNNValidationUtil.validateFloatVectorValue(value);
        if (value % 1.0f != 0.0f) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field was set as [%s] in index mapping. But, KNN vector values are floats instead of byte integers", "data_type", VectorDataType.BYTE.getValue()));
        }
        if ((int)value < -128 || (int)value > 127) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field was set as [%s] in index mapping. But, KNN vector values are not within in the byte range [%d, %d]", "data_type", VectorDataType.BYTE.getValue(), (byte)-128, (byte)127));
        }
    }

    public static void validateVectorDimension(int dimension, int vectorSize) {
        if (dimension != vectorSize) {
            String errorMessage = String.format(Locale.ROOT, "Vector dimension mismatch. Expected: %d, Given: %d", dimension, vectorSize);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Generated
    private KNNValidationUtil() {
    }
}

