/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;

public class FilteredIdsKNNIterator {
    protected final BitSet filterIdsBitSet;
    protected final BitSetIterator bitSetIterator;
    protected final float[] queryVector;
    protected final BinaryDocValues binaryDocValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;

    public FilteredIdsKNNIterator(BitSet filterIdsBitSet, float[] queryVector, BinaryDocValues binaryDocValues, SpaceType spaceType) {
        this.filterIdsBitSet = filterIdsBitSet;
        this.bitSetIterator = new BitSetIterator(filterIdsBitSet, (long)filterIdsBitSet.length());
        this.queryVector = queryVector;
        this.binaryDocValues = binaryDocValues;
        this.spaceType = spaceType;
        this.docId = this.bitSetIterator.nextDoc();
    }

    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int doc = this.binaryDocValues.advance(this.docId);
        this.currentScore = this.computeScore();
        this.docId = this.bitSetIterator.nextDoc();
        return doc;
    }

    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        BytesRef value = this.binaryDocValues.binaryValue();
        ByteArrayInputStream byteStream = new ByteArrayInputStream(value.bytes, value.offset, value.length);
        KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByStreamContent(byteStream);
        float[] vector = vectorSerializer.byteToFloatArray(byteStream);
        return this.spaceType.getVectorSimilarityFunction().compare(this.queryVector, vector);
    }
}

