/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.exceptions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import lombok.Generated;
import org.opensearch.core.rest.RestStatus;

public class ErrorMessage {
    protected Throwable exception;
    private final int status;
    private final String type;
    private final String reason;
    private final String details;

    public ErrorMessage(Throwable exception, int status) {
        this.exception = exception;
        this.status = status;
        this.type = this.fetchType();
        this.reason = this.fetchReason();
        this.details = this.fetchDetails();
    }

    private String fetchType() {
        return this.exception.getClass().getSimpleName();
    }

    protected String fetchReason() {
        if (this.status == RestStatus.TOO_MANY_REQUESTS.getStatus()) {
            return "Too Many Requests";
        }
        return this.status == RestStatus.BAD_REQUEST.getStatus() ? "Invalid Request" : "There was internal problem at backend";
    }

    protected String fetchDetails() {
        return this.emptyStringIfNull(this.exception.getLocalizedMessage());
    }

    private String emptyStringIfNull(String str) {
        return str != null ? str : "";
    }

    public String toString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("status", (Number)this.status);
        jsonObject.add("error", (JsonElement)this.getErrorAsJson());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }

    private JsonObject getErrorAsJson() {
        JsonObject errorJson = new JsonObject();
        errorJson.addProperty("type", this.type);
        errorJson.addProperty("reason", this.reason);
        errorJson.addProperty("details", this.details);
        return errorJson;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getDetails() {
        return this.details;
    }
}

