import { GridOptions } from '../entities/gridOptions';
import { GridApi } from '../gridApi';
export declare class ComponentUtil {
    static EVENTS: string[];
    static VUE_OMITTED_PROPERTY: string;
    /** Exclude the following internal events from code generation to prevent exposing these events via framework components */
    static EXCLUDED_INTERNAL_EVENTS: string[];
    /** EVENTS that should be exposed via code generation for the framework components.  */
    static PUBLIC_EVENTS: string[];
    static getCallbackForEvent(eventName: string): string;
    static EVENT_CALLBACKS: string[];
    static STRING_PROPERTIES: ("api" | "tooltipTrigger" | "tooltipShowMode" | "clipboardDelimiter" | "pivotPanelShow" | "domLayout" | "groupDisplayType" | "rowGroupPanelShow" | "rowModelType" | "serverSidePivotResultFieldSeparator" | "fillHandleDirection" | "sideBar" | "columnMenu" | "colResizeDefault" | "editType" | "quickFilterText" | "chartThemeOverrides" | "overlayLoadingTemplate" | "overlayNoRowsTemplate" | "pivotColumnGroupTotals" | "pivotRowTotals" | "rowSelection" | "multiSortKey" | "rowClass" | "gridId" | "treeDataDisplayType" | "columnApi")[];
    static OBJECT_PROPERTIES: ("api" | "statusBar" | "sideBar" | "popupParent" | "columnDefs" | "defaultColDef" | "defaultColGroupDef" | "columnTypes" | "dataTypeDefinitions" | "autoSizeStrategy" | "components" | "defaultCsvExportParams" | "defaultExcelExportParams" | "excelStyles" | "quickFilterParser" | "quickFilterMatcher" | "advancedFilterModel" | "advancedFilterParent" | "advancedFilterBuilderParams" | "chartThemes" | "customChartThemes" | "chartThemeOverrides" | "chartToolPanelsDef" | "chartMenuItems" | "loadingCellRenderer" | "loadingCellRendererParams" | "loadingCellRendererSelector" | "localeText" | "detailCellRenderer" | "detailCellRendererParams" | "context" | "alignedGrids" | "loadingOverlayComponent" | "loadingOverlayComponentParams" | "noRowsOverlayComponent" | "noRowsOverlayComponentParams" | "aggFuncs" | "rowDragText" | "fullWidthCellRenderer" | "fullWidthCellRendererParams" | "autoGroupColumnDef" | "groupRowRenderer" | "groupRowRendererParams" | "pinnedTopRowData" | "pinnedBottomRowData" | "rowData" | "datasource" | "serverSideDatasource" | "viewportDatasource" | "sortingOrder" | "icons" | "rowStyle" | "rowClassRules" | "initialState" | "getContextMenuItems" | "getMainMenuItems" | "postProcessPopup" | "processUnpinnedColumns" | "processCellForClipboard" | "processHeaderForClipboard" | "processGroupHeaderForClipboard" | "processCellFromClipboard" | "sendToClipboard" | "processDataFromClipboard" | "isExternalFilterPresent" | "doesExternalFilterPass" | "getChartToolbarItems" | "createChartContainer" | "navigateToNextHeader" | "tabToNextHeader" | "navigateToNextCell" | "tabToNextCell" | "getLocaleText" | "getDocument" | "paginationNumberFormatter" | "getGroupRowAgg" | "isGroupOpenByDefault" | "initialGroupOrderComparator" | "processPivotResultColDef" | "processPivotResultColGroupDef" | "getDataPath" | "getChildCount" | "getServerSideGroupLevelParams" | "isServerSideGroupOpenByDefault" | "isApplyServerSideTransaction" | "isServerSideGroup" | "getServerSideGroupKey" | "getBusinessKeyForNode" | "getRowId" | "processRowPostCreate" | "isRowSelectable" | "isRowMaster" | "fillOperation" | "postSortRows" | "getRowStyle" | "getRowClass" | "getRowHeight" | "isFullWidthRow" | "onToolPanelVisibleChanged" | "onToolPanelSizeChanged" | "onColumnMenuVisibleChanged" | "onCutStart" | "onCutEnd" | "onPasteStart" | "onPasteEnd" | "onColumnVisible" | "onColumnPinned" | "onColumnResized" | "onColumnMoved" | "onColumnValueChanged" | "onColumnPivotModeChanged" | "onColumnPivotChanged" | "onColumnGroupOpened" | "onNewColumnsLoaded" | "onGridColumnsChanged" | "onDisplayedColumnsChanged" | "onVirtualColumnsChanged" | "onColumnEverythingChanged" | "onColumnHeaderMouseOver" | "onColumnHeaderMouseLeave" | "onColumnHeaderClicked" | "onColumnHeaderContextMenu" | "onComponentStateChanged" | "onCellValueChanged" | "onCellEditRequest" | "onRowValueChanged" | "onCellEditingStarted" | "onCellEditingStopped" | "onRowEditingStarted" | "onRowEditingStopped" | "onUndoStarted" | "onUndoEnded" | "onRedoStarted" | "onRedoEnded" | "onRangeDeleteStart" | "onRangeDeleteEnd" | "onFilterOpened" | "onFilterChanged" | "onFilterModified" | "onAdvancedFilterBuilderVisibleChanged" | "onChartCreated" | "onChartRangeSelectionChanged" | "onChartOptionsChanged" | "onChartDestroyed" | "onCellKeyDown" | "onGridReady" | "onGridPreDestroyed" | "onFirstDataRendered" | "onGridSizeChanged" | "onModelUpdated" | "onVirtualRowRemoved" | "onViewportChanged" | "onBodyScroll" | "onBodyScrollEnd" | "onDragStarted" | "onDragStopped" | "onStateUpdated" | "onPaginationChanged" | "onRowDragEnter" | "onRowDragMove" | "onRowDragLeave" | "onRowDragEnd" | "onColumnRowGroupChanged" | "onRowGroupOpened" | "onExpandOrCollapseAll" | "onPivotMaxColumnsExceeded" | "onPinnedRowDataChanged" | "onRowDataUpdated" | "onAsyncTransactionsFlushed" | "onStoreRefreshed" | "onCellClicked" | "onCellDoubleClicked" | "onCellFocused" | "onCellMouseOver" | "onCellMouseOut" | "onCellMouseDown" | "onRowClicked" | "onRowDoubleClicked" | "onRowSelected" | "onSelectionChanged" | "onCellContextMenu" | "onRangeSelectionChanged" | "onTooltipShow" | "onTooltipHide" | "onSortChanged" | "onColumnRowGroupChangeRequest" | "onColumnPivotChangeRequest" | "onColumnValueChangeRequest" | "onColumnAggFuncChangeRequest" | "columnApi")[];
    static ARRAY_PROPERTIES: ("api" | "paginationPageSizeSelector" | "sideBar" | "columnDefs" | "components" | "excelStyles" | "chartThemes" | "chartThemeOverrides" | "chartMenuItems" | "alignedGrids" | "pinnedTopRowData" | "pinnedBottomRowData" | "rowData" | "sortingOrder" | "rowClass" | "columnApi")[];
    static NUMBER_PROPERTIES: ("tabIndex" | "api" | "tooltipShowDelay" | "tooltipHideDelay" | "autoSizePadding" | "undoRedoCellEditingLimit" | "keepDetailRowsCount" | "rowBuffer" | "paginationPageSize" | "pivotDefaultExpanded" | "cellFlashDelay" | "cellFlashDuration" | "cellFadeDelay" | "cellFadeDuration" | "groupDefaultExpanded" | "asyncTransactionWaitMillis" | "cacheOverflowSize" | "infiniteInitialRowCount" | "serverSideInitialRowCount" | "cacheBlockSize" | "maxBlocksInCache" | "maxConcurrentDatasourceRequests" | "blockLoadDebounceMillis" | "viewportRowModelPageSize" | "viewportRowModelBufferSize" | "groupLockGroupColumns" | "pivotMaxGeneratedColumns" | "headerHeight" | "groupHeaderHeight" | "floatingFiltersHeight" | "pivotHeaderHeight" | "pivotGroupHeaderHeight" | "chartThemeOverrides" | "detailRowHeight" | "scrollbarWidth" | "rowHeight" | "columnApi")[];
    static BOOLEAN_PROPERTIES: ("api" | "valueCache" | "suppressContextMenu" | "preventDefaultOnContextMenu" | "allowContextMenuWithControlKey" | "suppressMenuHide" | "enableBrowserTooltips" | "tooltipMouseTrack" | "tooltipInteraction" | "copyHeadersToClipboard" | "copyGroupHeadersToClipboard" | "suppressCopyRowsToClipboard" | "suppressCopySingleCellRanges" | "suppressLastEmptyLineOnPaste" | "suppressClipboardPaste" | "suppressClipboardApi" | "suppressCutToClipboard" | "maintainColumnOrder" | "suppressFieldDotNotation" | "allowDragFromColumnsToolPanel" | "suppressMovableColumns" | "suppressColumnMoveAnimation" | "suppressDragLeaveHidesColumns" | "suppressRowGroupHidesColumns" | "suppressAutoSize" | "skipHeaderOnAutoSize" | "singleClickEdit" | "suppressClickEdit" | "readOnlyEdit" | "stopEditingWhenCellsLoseFocus" | "enterNavigatesVertically" | "enterNavigatesVerticallyAfterEdit" | "enableCellEditingOnBackspace" | "undoRedoCellEditing" | "suppressCsvExport" | "suppressExcelExport" | "cacheQuickFilter" | "includeHiddenColumnsInQuickFilter" | "excludeChildrenWhenTreeDataFiltering" | "enableAdvancedFilter" | "includeHiddenColumnsInAdvancedFilter" | "enableCharts" | "suppressChartToolPanelsButton" | "masterDetail" | "keepDetailRows" | "detailRowAutoHeight" | "valueCacheNeverExpires" | "enableCellExpressions" | "suppressTouch" | "suppressFocusAfterRefresh" | "suppressAsyncEvents" | "suppressBrowserResizeObserver" | "suppressPropertyNamesCheck" | "suppressChangeDetection" | "debug" | "suppressLoadingOverlay" | "suppressNoRowsOverlay" | "pagination" | "paginationPageSizeSelector" | "paginationAutoPageSize" | "paginateChildRows" | "suppressPaginationPanel" | "pivotMode" | "pivotSuppressAutoColumn" | "suppressExpandablePivotGroups" | "functionsReadOnly" | "suppressAggFuncInHeader" | "alwaysAggregateAtRootLevel" | "aggregateOnlyChangedColumns" | "suppressAggFilteredOnly" | "removePivotHeaderRowWhenSingleValueColumn" | "animateRows" | "enableCellChangeFlash" | "allowShowChangeAfterFilter" | "ensureDomOrder" | "enableRtl" | "suppressColumnVirtualisation" | "suppressMaxRenderedRowRestriction" | "suppressRowVirtualisation" | "rowDragManaged" | "suppressRowDrag" | "suppressMoveWhenRowDragging" | "rowDragEntireRow" | "rowDragMultiRow" | "embedFullWidthRows" | "groupMaintainOrder" | "groupSelectsChildren" | "groupIncludeTotalFooter" | "groupSuppressBlankHeader" | "groupSelectsFiltered" | "showOpenedGroup" | "groupRemoveSingleChildren" | "groupRemoveLowestSingleChildren" | "groupHideOpenParents" | "groupAllowUnbalanced" | "suppressMakeColumnVisibleAfterUnGroup" | "treeData" | "rowGroupPanelSuppressSort" | "suppressGroupRowsSticky" | "suppressModelUpdateAfterUpdateTransaction" | "suppressServerSideInfiniteScroll" | "purgeClosedRowNodes" | "serverSideSortAllLevels" | "serverSideOnlyRefreshFilteredGroups" | "serverSideSortOnServer" | "serverSideFilterOnServer" | "alwaysShowHorizontalScroll" | "alwaysShowVerticalScroll" | "debounceVerticalScrollbar" | "suppressHorizontalScroll" | "suppressScrollOnNewData" | "suppressScrollWhenPopupsAreOpen" | "suppressAnimationFrame" | "suppressMiddleClickScrolls" | "suppressPreventDefaultOnMouseWheel" | "rowMultiSelectWithClick" | "suppressRowDeselection" | "suppressRowClickSelection" | "suppressCellFocus" | "suppressHeaderFocus" | "suppressMultiRangeSelection" | "enableCellTextSelection" | "enableRangeSelection" | "enableRangeHandle" | "enableFillHandle" | "suppressClearOnFillReduction" | "accentedSort" | "unSortIcon" | "suppressMultiSort" | "alwaysMultiSort" | "suppressMaintainUnsortedOrder" | "suppressRowHoverHighlight" | "suppressRowTransform" | "columnHoverHighlight" | "deltaSort" | "enableGroupEdit" | "suppressGroupMaintainValueType" | "functionsPassive" | "serverSideEnableClientSideSort" | "sideBar" | "enterMovesDown" | "enterMovesDownAfterEdit" | "excludeHiddenColumnsFromQuickFilter" | "chartThemeOverrides" | "enableChartToolPanelsButton" | "suppressParentsInRowNodes" | "suppressAggAtRootLevel" | "groupAggFiltering" | "groupIncludeFooter" | "serverSideFilterAllLevels" | "reactiveCustomComponents" | "resetRowDataOnUpdate" | "columnApi")[];
    static FUNCTION_PROPERTIES: (keyof GridOptions<any>)[];
    static ALL_PROPERTIES: (keyof GridOptions<any>)[];
    static ALL_PROPERTIES_AND_CALLBACKS: string[];
    static ALL_PROPERTIES_AND_CALLBACKS_SET: Set<string>;
    private static getGridOptionKeys;
    /** Combines component props / attributes with the provided gridOptions returning a new combined gridOptions object */
    static combineAttributesAndGridOptions(gridOptions: GridOptions | undefined, component: any): GridOptions;
    static processOnChange(changes: any, api: GridApi): void;
}
