"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = query;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function query(server, service) {
  server.post({
    path: _constants.ROUTE_PATH_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_QUERY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_CSV,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLCsv(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_CSV,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLCsv(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_JSON,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLJson(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_JSON,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLJson(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_TEXT,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLText(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_TEXT,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLText(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SPARK_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.get({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + "/{id}",
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncGetQuery(request, request.params.id);
    return response.ok({
      body: retVal
    });
  });
  server.delete({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + "/{id}",
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeAsyncDeleteQuery(request, request.params.id);
    return response.ok({
      body: retVal
    });
  });
  server.get({
    path: _constants.ROUTE_PATH_GET_DATASOURCES,
    validate: {}
  }, async (context, request, response) => {
    const retVal = await service.describeSyncQueryDataSources(request);
    return response.ok({
      body: retVal
    });
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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