"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class TranslateService {
  constructor(client) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "translateSQL", async request => {
      try {
        const queryRequest = {
          query: request.body.query
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser('sql.translateSQL', params);
        const ret = {
          data: {
            ok: true,
            resp: queryResponse
          }
        };
        return ret;
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message
          }
        };
      }
    });
    _defineProperty(this, "translatePPL", async request => {
      try {
        const queryRequest = {
          query: request.body.query
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser('sql.translatePPL', params);
        return {
          data: {
            ok: true,
            resp: queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message
          }
        };
      }
    });
    this.client = client;
  }
}
exports.default = TranslateService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJUcmFuc2xhdGVTZXJ2aWNlIiwiY29uc3RydWN0b3IiLCJjbGllbnQiLCJfZGVmaW5lUHJvcGVydHkiLCJyZXF1ZXN0IiwicXVlcnlSZXF1ZXN0IiwicXVlcnkiLCJib2R5IiwicGFyYW1zIiwiSlNPTiIsInN0cmluZ2lmeSIsInF1ZXJ5UmVzcG9uc2UiLCJhc1Njb3BlZCIsImNhbGxBc0N1cnJlbnRVc2VyIiwicmV0IiwiZGF0YSIsIm9rIiwicmVzcCIsImVyciIsImNvbnNvbGUiLCJsb2ciLCJtZXNzYWdlIiwiZXhwb3J0cyIsImRlZmF1bHQiLCJtb2R1bGUiXSwic291cmNlcyI6WyJUcmFuc2xhdGVTZXJ2aWNlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBUcmFuc2xhdGVTZXJ2aWNlIHtcbiAgcHJpdmF0ZSBjbGllbnQ6IGFueTtcblxuICBjb25zdHJ1Y3RvcihjbGllbnQ6IGFueSkge1xuICAgIHRoaXMuY2xpZW50ID0gY2xpZW50O1xuICB9XG5cbiAgdHJhbnNsYXRlU1FMID0gYXN5bmMgKHJlcXVlc3Q6IGFueSkgPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCBxdWVyeVJlcXVlc3QgPSB7XG4gICAgICAgIHF1ZXJ5OiByZXF1ZXN0LmJvZHkucXVlcnksXG4gICAgICB9O1xuXG4gICAgICBjb25zdCBwYXJhbXMgPSB7XG4gICAgICAgIGJvZHk6IEpTT04uc3RyaW5naWZ5KHF1ZXJ5UmVxdWVzdCksXG4gICAgICB9O1xuXG4gICAgICBjb25zdCBxdWVyeVJlc3BvbnNlID0gYXdhaXQgdGhpcy5jbGllbnRcbiAgICAgICAgLmFzU2NvcGVkKHJlcXVlc3QpXG4gICAgICAgIC5jYWxsQXNDdXJyZW50VXNlcignc3FsLnRyYW5zbGF0ZVNRTCcsIHBhcmFtcyk7XG4gICAgICBjb25zdCByZXQgPSB7XG4gICAgICAgIGRhdGE6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwOiBxdWVyeVJlc3BvbnNlLFxuICAgICAgICB9LFxuICAgICAgfTtcbiAgICAgIHJldHVybiByZXQ7XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICBjb25zb2xlLmxvZyhlcnIpO1xuICAgICAgcmV0dXJuIHtcbiAgICAgICAgZGF0YToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICByZXNwOiBlcnIubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH07XG4gICAgfVxuICB9O1xuXG4gIHRyYW5zbGF0ZVBQTCA9IGFzeW5jIChyZXF1ZXN0OiBhbnkpID0+IHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgcXVlcnlSZXF1ZXN0ID0ge1xuICAgICAgICBxdWVyeTogcmVxdWVzdC5ib2R5LnF1ZXJ5LFxuICAgICAgfTtcblxuICAgICAgY29uc3QgcGFyYW1zID0ge1xuICAgICAgICBib2R5OiBKU09OLnN0cmluZ2lmeShxdWVyeVJlcXVlc3QpLFxuICAgICAgfTtcblxuICAgICAgY29uc3QgcXVlcnlSZXNwb25zZSA9IGF3YWl0IHRoaXMuY2xpZW50XG4gICAgICAgIC5hc1Njb3BlZChyZXF1ZXN0KVxuICAgICAgICAuY2FsbEFzQ3VycmVudFVzZXIoJ3NxbC50cmFuc2xhdGVQUEwnLCBwYXJhbXMpO1xuICAgICAgcmV0dXJuIHtcbiAgICAgICAgZGF0YToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3A6IHF1ZXJ5UmVzcG9uc2UsXG4gICAgICAgIH0sXG4gICAgICB9O1xuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgY29uc29sZS5sb2coZXJyKTtcbiAgICAgIHJldHVybiB7XG4gICAgICAgIGRhdGE6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgcmVzcDogZXJyLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9O1xuICAgIH1cbiAgfTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBR2UsTUFBTUEsZ0JBQWdCLENBQUM7RUFHcENDLFdBQVdBLENBQUNDLE1BQVcsRUFBRTtJQUFBQyxlQUFBO0lBQUFBLGVBQUEsdUJBSVYsTUFBT0MsT0FBWSxJQUFLO01BQ3JDLElBQUk7UUFDRixNQUFNQyxZQUFZLEdBQUc7VUFDbkJDLEtBQUssRUFBRUYsT0FBTyxDQUFDRyxJQUFJLENBQUNEO1FBQ3RCLENBQUM7UUFFRCxNQUFNRSxNQUFNLEdBQUc7VUFDYkQsSUFBSSxFQUFFRSxJQUFJLENBQUNDLFNBQVMsQ0FBQ0wsWUFBWTtRQUNuQyxDQUFDO1FBRUQsTUFBTU0sYUFBYSxHQUFHLE1BQU0sSUFBSSxDQUFDVCxNQUFNLENBQ3BDVSxRQUFRLENBQUNSLE9BQU8sQ0FBQyxDQUNqQlMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUVMLE1BQU0sQ0FBQztRQUNoRCxNQUFNTSxHQUFHLEdBQUc7VUFDVkMsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxJQUFJO1lBQ1JDLElBQUksRUFBRU47VUFDUjtRQUNGLENBQUM7UUFDRCxPQUFPRyxHQUFHO01BQ1osQ0FBQyxDQUFDLE9BQU9JLEdBQUcsRUFBRTtRQUNaQyxPQUFPLENBQUNDLEdBQUcsQ0FBQ0YsR0FBRyxDQUFDO1FBQ2hCLE9BQU87VUFDTEgsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxLQUFLO1lBQ1RDLElBQUksRUFBRUMsR0FBRyxDQUFDRztVQUNaO1FBQ0YsQ0FBQztNQUNIO0lBQ0YsQ0FBQztJQUFBbEIsZUFBQSx1QkFFYyxNQUFPQyxPQUFZLElBQUs7TUFDckMsSUFBSTtRQUNGLE1BQU1DLFlBQVksR0FBRztVQUNuQkMsS0FBSyxFQUFFRixPQUFPLENBQUNHLElBQUksQ0FBQ0Q7UUFDdEIsQ0FBQztRQUVELE1BQU1FLE1BQU0sR0FBRztVQUNiRCxJQUFJLEVBQUVFLElBQUksQ0FBQ0MsU0FBUyxDQUFDTCxZQUFZO1FBQ25DLENBQUM7UUFFRCxNQUFNTSxhQUFhLEdBQUcsTUFBTSxJQUFJLENBQUNULE1BQU0sQ0FDcENVLFFBQVEsQ0FBQ1IsT0FBTyxDQUFDLENBQ2pCUyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRUwsTUFBTSxDQUFDO1FBQ2hELE9BQU87VUFDTE8sSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxJQUFJO1lBQ1JDLElBQUksRUFBRU47VUFDUjtRQUNGLENBQUM7TUFDSCxDQUFDLENBQUMsT0FBT08sR0FBRyxFQUFFO1FBQ1pDLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDRixHQUFHLENBQUM7UUFDaEIsT0FBTztVQUNMSCxJQUFJLEVBQUU7WUFDSkMsRUFBRSxFQUFFLEtBQUs7WUFDVEMsSUFBSSxFQUFFQyxHQUFHLENBQUNHO1VBQ1o7UUFDRixDQUFDO01BQ0g7SUFDRixDQUFDO0lBOURDLElBQUksQ0FBQ25CLE1BQU0sR0FBR0EsTUFBTTtFQUN0QjtBQThERjtBQUFDb0IsT0FBQSxDQUFBQyxPQUFBLEdBQUF2QixnQkFBQTtBQUFBd0IsTUFBQSxDQUFBRixPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9