/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.Map;
import java.util.function.Predicate;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.MethodComponent;
import org.opensearch.knn.index.MethodComponentContext;

public abstract class Parameter<T> {
    private String name;
    private T defaultValue;
    protected Predicate<T> validator;

    public Parameter(String name, T defaultValue, Predicate<T> validator) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.validator = validator;
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public abstract ValidationException validate(Object var1);

    public static class MethodComponentContextParameter
    extends Parameter<MethodComponentContext> {
        private Map<String, MethodComponent> methodComponents;

        public MethodComponentContextParameter(String name, MethodComponentContext defaultValue, Map<String, MethodComponent> methodComponents) {
            super(name, defaultValue, (T methodComponentContext) -> {
                if (!methodComponents.containsKey(methodComponentContext.getName())) {
                    return false;
                }
                return ((MethodComponent)methodComponents.get(methodComponentContext.getName())).validate((MethodComponentContext)methodComponentContext) == null;
            });
            this.methodComponents = methodComponents;
        }

        @Override
        public ValidationException validate(Object value) {
            ValidationException validationException = null;
            if (!(value instanceof MethodComponentContext)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Value not of type MethodComponentContext for MethodComponentContext parameter \"%s\".", this.getName()));
                return validationException;
            }
            if (!this.validator.test((MethodComponentContext)value)) {
                validationException = new ValidationException();
                validationException.addValidationError("Parameter validation failed.");
                validationException.addValidationError(String.format("Parameter validation failed for MethodComponentContext parameter \"%s\".", this.getName()));
            }
            return validationException;
        }

        public MethodComponent getMethodComponent(String name) {
            return this.methodComponents.get(name);
        }
    }

    public static class StringParameter
    extends Parameter<String> {
        public StringParameter(String name, String defaultValue, Predicate<String> validator) {
            super(name, defaultValue, validator);
        }

        @Override
        public ValidationException validate(Object value) {
            ValidationException validationException = null;
            if (!(value instanceof String)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Value not of type String for String parameter \"%s\".", this.getName()));
                return validationException;
            }
            if (!this.validator.test((String)value)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Parameter validation failed for String parameter \"%s\".", this.getName()));
            }
            return validationException;
        }
    }

    public static class IntegerParameter
    extends Parameter<Integer> {
        public IntegerParameter(String name, Integer defaultValue, Predicate<Integer> validator) {
            super(name, defaultValue, validator);
        }

        @Override
        public ValidationException validate(Object value) {
            ValidationException validationException = null;
            if (!(value instanceof Integer)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Value not of type Integer for Integer parameter \"%s\".", this.getName()));
                return validationException;
            }
            if (!this.validator.test((Integer)value)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Parameter validation failed for Integer parameter \"%s\".", this.getName()));
            }
            return validationException;
        }
    }

    public static class BooleanParameter
    extends Parameter<Boolean> {
        public BooleanParameter(String name, Boolean defaultValue, Predicate<Boolean> validator) {
            super(name, defaultValue, validator);
        }

        @Override
        public ValidationException validate(Object value) {
            ValidationException validationException = null;
            if (!(value instanceof Boolean)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value not of type Boolean for Boolean parameter [%s].", this.getName()));
                return validationException;
            }
            if (!this.validator.test((Boolean)value)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for Boolean parameter [%s].", this.getName()));
            }
            return validationException;
        }
    }
}

