/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.common.TriFunction;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.KNNMethod;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.MethodComponent;
import org.opensearch.knn.index.MethodComponentContext;
import org.opensearch.knn.index.Parameter;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.util.NativeLibrary;

class Faiss
extends NativeLibrary {
    Map<SpaceType, Function<Float, Float>> scoreTransform;
    private static final String CURRENT_VERSION = "165";
    private static final Map<SpaceType, Function<Float, Float>> SCORE_TRANSLATIONS = ImmutableMap.of((Object)((Object)SpaceType.INNER_PRODUCT), rawScore -> Float.valueOf(SpaceType.INNER_PRODUCT.scoreTranslation(-1.0f * rawScore.floatValue())));
    private static final Map<SpaceType, Function<Float, Float>> SCORE_TO_DISTANCE_TRANSFORMATIONS = ImmutableMap.builder().put((Object)SpaceType.INNER_PRODUCT, score -> Float.valueOf(score.floatValue() > 1.0f ? 1.0f - score.floatValue() : 1.0f / score.floatValue() - 1.0f)).build();
    private static final MethodComponentContext ENCODER_DEFAULT = new MethodComponentContext("flat", Collections.emptyMap());
    private static final Map<String, MethodComponent> COMMON_ENCODERS = ImmutableMap.of((Object)"flat", (Object)MethodComponent.Builder.builder("flat").setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("Flat", methodComponent, methodComponentContext).build()).build(), (Object)"sq", (Object)MethodComponent.Builder.builder("sq").addParameter("type", new Parameter.StringParameter("type", "fp16", KNNConstants.FAISS_SQ_ENCODER_TYPES::contains)).addParameter("clip", new Parameter.BooleanParameter("clip", false, Objects::nonNull)).setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("SQ", methodComponent, methodComponentContext).addParameter("type", "", "").build()).build());
    private static final Map<String, MethodComponent> HNSW_ENCODERS = ImmutableMap.builder().putAll((Map)ImmutableMap.of((Object)"pq", (Object)MethodComponent.Builder.builder("pq").addParameter("m", new Parameter.IntegerParameter("m", KNNConstants.ENCODER_PARAMETER_PQ_CODE_COUNT_DEFAULT, v -> v > 0 && v < KNNConstants.ENCODER_PARAMETER_PQ_CODE_COUNT_LIMIT)).addParameter("code_size", new Parameter.IntegerParameter("code_size", KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_DEFAULT, v -> Objects.equals(v, KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_DEFAULT))).setRequiresTraining(true).setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("PQ", methodComponent, methodComponentContext).addParameter("m", "", "").build()).setOverheadInKBEstimator((TriFunction<MethodComponent, MethodComponentContext, Integer, Long>)((TriFunction)(methodComponent, methodComponentContext, dimension) -> {
        int codeSize = KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_DEFAULT;
        return 4L * (1L << codeSize) * (long)dimension.intValue() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L;
    })).build())).putAll(COMMON_ENCODERS).build();
    private static final Map<String, MethodComponent> IVF_ENCODERS = ImmutableMap.builder().putAll((Map)ImmutableMap.of((Object)"pq", (Object)MethodComponent.Builder.builder("pq").addParameter("m", new Parameter.IntegerParameter("m", KNNConstants.ENCODER_PARAMETER_PQ_CODE_COUNT_DEFAULT, v -> v > 0 && v < KNNConstants.ENCODER_PARAMETER_PQ_CODE_COUNT_LIMIT)).addParameter("code_size", new Parameter.IntegerParameter("code_size", KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_DEFAULT, v -> v > 0 && v < KNNConstants.ENCODER_PARAMETER_PQ_CODE_SIZE_LIMIT)).setRequiresTraining(true).setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("PQ", methodComponent, methodComponentContext).addParameter("m", "", "").addParameter("code_size", "x", "").build()).setOverheadInKBEstimator((TriFunction<MethodComponent, MethodComponentContext, Integer, Long>)((TriFunction)(methodComponent, methodComponentContext, dimension) -> {
        Object codeSizeObject = methodComponentContext.getParameters().get("code_size");
        if (codeSizeObject == null) {
            Parameter<?> codeSizeParameter = methodComponent.getParameters().get("code_size");
            if (codeSizeParameter == null) {
                throw new IllegalStateException(String.format("%s  is not a valid parameter. This is a bug.", "code_size"));
            }
            codeSizeObject = codeSizeParameter.getDefaultValue();
        }
        if (!(codeSizeObject instanceof Integer)) {
            throw new IllegalStateException(String.format("%s must be an integer.", "code_size"));
        }
        int codeSize = (Integer)codeSizeObject;
        return 4L * (1L << codeSize) * (long)dimension.intValue() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L;
    })).build())).putAll(COMMON_ENCODERS).build();
    private static final Map<String, KNNMethod> METHODS = ImmutableMap.of((Object)"hnsw", (Object)KNNMethod.Builder.builder(MethodComponent.Builder.builder("hnsw").addParameter("m", new Parameter.IntegerParameter("m", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M, v -> v > 0)).addParameter("ef_construction", new Parameter.IntegerParameter("ef_construction", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION, v -> v > 0)).addParameter("ef_search", new Parameter.IntegerParameter("ef_search", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH, v -> v > 0)).addParameter("encoder", new Parameter.MethodComponentContextParameter("encoder", ENCODER_DEFAULT, HNSW_ENCODERS)).setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("HNSW", methodComponent, methodComponentContext).addParameter("m", "", "").addParameter("encoder", ",", "").build()).build()).addSpaces(SpaceType.L2, SpaceType.INNER_PRODUCT).build(), (Object)"ivf", (Object)KNNMethod.Builder.builder(MethodComponent.Builder.builder("ivf").addParameter("nprobes", new Parameter.IntegerParameter("nprobes", KNNConstants.METHOD_PARAMETER_NPROBES_DEFAULT, v -> v > 0 && v < KNNConstants.METHOD_PARAMETER_NPROBES_LIMIT)).addParameter("nlist", new Parameter.IntegerParameter("nlist", KNNConstants.METHOD_PARAMETER_NLIST_DEFAULT, v -> v > 0 && v < KNNConstants.METHOD_PARAMETER_NLIST_LIMIT)).addParameter("encoder", new Parameter.MethodComponentContextParameter("encoder", ENCODER_DEFAULT, IVF_ENCODERS)).setRequiresTraining(true).setMapGenerator((methodComponent, methodComponentContext) -> MethodAsMapBuilder.builder("IVF", methodComponent, methodComponentContext).addParameter("nlist", "", "").addParameter("encoder", ",", "").build()).setOverheadInKBEstimator((TriFunction<MethodComponent, MethodComponentContext, Integer, Long>)((TriFunction)(methodComponent, methodComponentContext, dimension) -> {
        Object nlistObject = methodComponentContext.getParameters().get("nlist");
        if (nlistObject == null) {
            Parameter<?> nlistParameter = methodComponent.getParameters().get("nlist");
            if (nlistParameter == null) {
                throw new IllegalStateException(String.format("%s  is not a valid parameter. This is a bug.", "nlist"));
            }
            nlistObject = nlistParameter.getDefaultValue();
        }
        if (!(nlistObject instanceof Integer)) {
            throw new IllegalStateException(String.format("%s must be an integer.", "nlist"));
        }
        int centroids = (Integer)nlistObject;
        return 4L * (long)centroids * (long)dimension.intValue() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L;
    })).build()).addSpaces(SpaceType.L2, SpaceType.INNER_PRODUCT).build());
    static final Faiss INSTANCE = new Faiss(METHODS, SCORE_TRANSLATIONS, "165", ".faiss", SCORE_TO_DISTANCE_TRANSFORMATIONS);

    private Faiss(Map<String, KNNMethod> methods, Map<SpaceType, Function<Float, Float>> scoreTranslation, String currentVersion, String extension, Map<SpaceType, Function<Float, Float>> scoreTransform) {
        super(methods, scoreTranslation, currentVersion, extension);
        this.scoreTransform = scoreTransform;
    }

    @Override
    public Float distanceToRadialThreshold(Float distance, SpaceType spaceType) {
        return distance;
    }

    @Override
    public Float scoreToRadialThreshold(Float score, SpaceType spaceType) {
        if (this.scoreTransform.containsKey((Object)spaceType)) {
            return this.scoreTransform.get((Object)spaceType).apply(score);
        }
        return Float.valueOf(spaceType.scoreToDistanceTranslation(score.floatValue()));
    }

    static class MethodAsMapBuilder {
        String indexDescription;
        MethodComponent methodComponent;
        Map<String, Object> methodAsMap;

        MethodAsMapBuilder addParameter(String parameterName, String prefix, String suffix) {
            Object value;
            this.indexDescription = this.indexDescription + prefix;
            Map methodParameters = (Map)this.methodAsMap.get("parameters");
            Parameter<?> parameter = this.methodComponent.getParameters().get(parameterName);
            Object object = value = methodParameters.containsKey(parameterName) ? methodParameters.get(parameterName) : parameter.getDefaultValue();
            if (parameter instanceof Parameter.MethodComponentContextParameter) {
                MethodComponentContext subMethodComponentContext = (MethodComponentContext)value;
                MethodComponent subMethodComponent = ((Parameter.MethodComponentContextParameter)parameter).getMethodComponent(subMethodComponentContext.getName());
                Map<String, Object> subMethodAsMap = subMethodComponent.getAsMap(subMethodComponentContext);
                this.indexDescription = this.indexDescription + subMethodAsMap.get("index_description");
                subMethodAsMap.remove("index_description");
                methodParameters.put(parameterName, subMethodAsMap);
            } else {
                this.indexDescription = this.indexDescription + value;
                methodParameters.remove(parameterName);
            }
            this.indexDescription = this.indexDescription + suffix;
            return this;
        }

        Map<String, Object> build() {
            this.methodAsMap.put("index_description", this.indexDescription);
            return this.methodAsMap;
        }

        static MethodAsMapBuilder builder(String baseDescription, MethodComponent methodComponent, MethodComponentContext methodComponentContext) {
            HashMap<String, Object> initialMap = new HashMap<String, Object>();
            initialMap.put("name", methodComponent.getName());
            initialMap.put("parameters", MethodComponent.getParameterMapWithDefaultsAdded(methodComponentContext, methodComponent));
            return new MethodAsMapBuilder(baseDescription, methodComponent, initialMap);
        }

        @Generated
        public MethodAsMapBuilder(String indexDescription, MethodComponent methodComponent, Map<String, Object> methodAsMap) {
            this.indexDescription = indexDescription;
            this.methodComponent = methodComponent;
            this.methodAsMap = methodAsMap;
        }
    }
}

