/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.jni;

import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.opensearch.knn.index.query.KNNQueryResult;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.jni.FaissService;
import org.opensearch.knn.jni.NmslibService;

public class JNIService {
    public static void createIndex(int[] ids, long vectorsAddress, int dim, String indexPath, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.NMSLIB == knnEngine) {
            NmslibService.createIndex(ids, vectorsAddress, dim, indexPath, parameters);
            return;
        }
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.createIndex(ids, vectorsAddress, dim, indexPath, parameters);
            return;
        }
        throw new IllegalArgumentException(String.format("CreateIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void createIndexFromTemplate(int[] ids, long vectorsAddress, int dim, String indexPath, byte[] templateIndex, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.createIndexFromTemplate(ids, vectorsAddress, dim, indexPath, templateIndex, parameters);
            return;
        }
        throw new IllegalArgumentException(String.format("CreateIndexFromTemplate not supported for provided engine : %s", knnEngine.getName()));
    }

    public static long loadIndex(String indexPath, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.NMSLIB == knnEngine) {
            return NmslibService.loadIndex(indexPath, parameters);
        }
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.loadIndex(indexPath);
        }
        throw new IllegalArgumentException(String.format("LoadIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static boolean isSharedIndexStateRequired(long indexAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.isSharedIndexStateRequired(indexAddr);
        }
        return false;
    }

    public static long initSharedIndexState(long indexAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.initSharedIndexState(indexAddr);
        }
        throw new IllegalArgumentException(String.format("InitSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void setSharedIndexState(long indexAddr, long shareIndexStateAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.setSharedIndexState(indexAddr, shareIndexStateAddr);
            return;
        }
        throw new IllegalArgumentException(String.format("SetSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static KNNQueryResult[] queryIndex(long indexPointer, float[] queryVector, int k, KNNEngine knnEngine, long[] filteredIds, int filterIdsType, int[] parentIds) {
        if (KNNEngine.NMSLIB == knnEngine) {
            return NmslibService.queryIndex(indexPointer, queryVector, k);
        }
        if (KNNEngine.FAISS == knnEngine) {
            if (ArrayUtils.isNotEmpty((long[])filteredIds)) {
                return FaissService.queryIndexWithFilter(indexPointer, queryVector, k, filteredIds, filterIdsType, parentIds);
            }
            return FaissService.queryIndex(indexPointer, queryVector, k, parentIds);
        }
        throw new IllegalArgumentException(String.format("QueryIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void free(long indexPointer, KNNEngine knnEngine) {
        if (KNNEngine.NMSLIB == knnEngine) {
            NmslibService.free(indexPointer);
            return;
        }
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.free(indexPointer);
            return;
        }
        throw new IllegalArgumentException(String.format("Free not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void freeSharedIndexState(long shareIndexStateAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.freeSharedIndexState(shareIndexStateAddr);
            return;
        }
        throw new IllegalArgumentException(String.format("FreeSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static byte[] trainIndex(Map<String, Object> indexParameters, int dimension, long trainVectorsPointer, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.trainIndex(indexParameters, dimension, trainVectorsPointer);
        }
        throw new IllegalArgumentException(String.format("TrainIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    @Deprecated(since="2.14.0", forRemoval=true)
    public static long transferVectors(long vectorsPointer, float[][] trainingData) {
        return FaissService.transferVectors(vectorsPointer, trainingData);
    }

    public static KNNQueryResult[] radiusQueryIndex(long indexPointer, float[] queryVector, float radius, KNNEngine knnEngine, int indexMaxResultWindow, long[] filteredIds, int filterIdsType, int[] parentIds) {
        if (KNNEngine.FAISS == knnEngine) {
            if (ArrayUtils.isNotEmpty((long[])filteredIds)) {
                return FaissService.rangeSearchIndexWithFilter(indexPointer, queryVector, radius, indexMaxResultWindow, filteredIds, filterIdsType, parentIds);
            }
            return FaissService.rangeSearchIndex(indexPointer, queryVector, radius, indexMaxResultWindow, parentIds);
        }
        throw new IllegalArgumentException("RadiusQueryIndex not supported for provided engine");
    }
}

