"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateWorkspaceState = exports.getWorkspaceState = void 0;
var _router = require("../http/router");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * This function will be used as a proxy
 * because `ensureRequest` is only importable from core module.
 *
 * @param workspaceId string
 * @returns void
 */
const updateWorkspaceState = (request, payload) => {
  const rawRequest = (0, _router.ensureRawRequest)(request);
  rawRequest.app = {
    ...rawRequest.app,
    ...payload
  };
};
exports.updateWorkspaceState = updateWorkspaceState;
const getWorkspaceState = request => {
  const {
    requestWorkspaceId
  } = (0, _router.ensureRawRequest)(request).app;
  return {
    requestWorkspaceId
  };
};
exports.getWorkspaceState = getWorkspaceState;