/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher;

import java.util.Map;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.client.EMRServerlessClient;
import org.opensearch.sql.spark.dispatcher.BatchQueryHandler;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryResponse;
import org.opensearch.sql.spark.dispatcher.model.JobType;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexMetadataService;
import org.opensearch.sql.spark.flint.operation.FlintIndexOpCancel;
import org.opensearch.sql.spark.leasemanager.LeaseManager;
import org.opensearch.sql.spark.response.JobExecutionResponseReader;

public class RefreshQueryHandler
extends BatchQueryHandler {
    private final FlintIndexMetadataService flintIndexMetadataService;
    private final StateStore stateStore;
    private final EMRServerlessClient emrServerlessClient;

    public RefreshQueryHandler(EMRServerlessClient emrServerlessClient, JobExecutionResponseReader jobExecutionResponseReader, FlintIndexMetadataService flintIndexMetadataService, StateStore stateStore, LeaseManager leaseManager) {
        super(emrServerlessClient, jobExecutionResponseReader, leaseManager);
        this.flintIndexMetadataService = flintIndexMetadataService;
        this.stateStore = stateStore;
        this.emrServerlessClient = emrServerlessClient;
    }

    @Override
    public String cancelJob(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        String datasourceName = asyncQueryJobMetadata.getDatasourceName();
        Map<String, FlintIndexMetadata> indexMetadataMap = this.flintIndexMetadataService.getFlintIndexMetadata(asyncQueryJobMetadata.getIndexName());
        if (!indexMetadataMap.containsKey(asyncQueryJobMetadata.getIndexName())) {
            throw new IllegalStateException(String.format("Couldn't fetch flint index: %s details", asyncQueryJobMetadata.getIndexName()));
        }
        FlintIndexMetadata indexMetadata = indexMetadataMap.get(asyncQueryJobMetadata.getIndexName());
        FlintIndexOpCancel jobCancelOp = new FlintIndexOpCancel(this.stateStore, datasourceName, this.emrServerlessClient);
        jobCancelOp.apply(indexMetadata);
        return asyncQueryJobMetadata.getQueryId().getId();
    }

    @Override
    public DispatchQueryResponse submit(DispatchQueryRequest dispatchQueryRequest, DispatchQueryContext context) {
        DispatchQueryResponse resp = super.submit(dispatchQueryRequest, context);
        DataSourceMetadata dataSourceMetadata = context.getDataSourceMetadata();
        return new DispatchQueryResponse(resp.getQueryId(), resp.getJobId(), resp.getResultIndex(), resp.getSessionId(), dataSourceMetadata.getName(), JobType.BATCH, context.getIndexQueryDetails().openSearchIndexName());
    }
}

