/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.sampler.ApplicationSamplerView;
import org.graalvm.visualvm.sampler.ApplicationSamplerViewProvider;
import org.graalvm.visualvm.sampler.cpu.CPUSamplerParameters;
import org.graalvm.visualvm.sampler.memory.MemorySamplerParameters;

public final class SamplerSupport {
    private static SamplerSupport instance;
    private final ApplicationSamplerViewProvider samplerViewProvider = new ApplicationSamplerViewProvider();

    public static synchronized SamplerSupport getInstance() {
        if (instance == null) {
            instance = new SamplerSupport();
        }
        return instance;
    }

    boolean supportsProfiling(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        return JvmFactory.getJVMFor((Application)application).isBasicInfoSupported();
    }

    void selectSamplerView(Application application) {
        ApplicationSamplerView view = this.getSamplerView(application);
        if (view != null) {
            DataSourceWindowManager.sharedInstance().selectView((DataSourceView)view);
        }
    }

    void startCPU(Application application, String settings) {
        ApplicationSamplerView view = this.getSamplerView(application);
        if (view != null) {
            DataSourceWindowManager.sharedInstance().selectView((DataSourceView)view);
            view.startCPU(CPUSamplerParameters.parse(settings));
        }
    }

    void startMemory(Application application, String settings) {
        ApplicationSamplerView view = this.getSamplerView(application);
        if (view != null) {
            DataSourceWindowManager.sharedInstance().selectView((DataSourceView)view);
            view.startMemory(MemorySamplerParameters.parse(settings));
        }
    }

    void takeSnapshot(Application application, boolean openView) {
        ApplicationSamplerView view = this.getSamplerView(application);
        if (view != null) {
            DataSourceWindowManager.sharedInstance().selectView((DataSourceView)view);
            view.takeSnapshot(openView);
        }
    }

    void stop(Application application) {
        ApplicationSamplerView view = this.getSamplerView(application);
        if (view != null) {
            DataSourceWindowManager.sharedInstance().selectView((DataSourceView)view);
            view.stop();
        }
    }

    private ApplicationSamplerView getSamplerView(Application application) {
        if (application == null) {
            return null;
        }
        DataSourceView activeView = this.samplerViewProvider.view(application);
        if (activeView == null) {
            return null;
        }
        return (ApplicationSamplerView)activeView;
    }

    private SamplerSupport() {
        this.samplerViewProvider.initialize();
    }
}

