
#ifndef KPKPASS_EXPORT_H
#define KPKPASS_EXPORT_H

#ifdef KPKPASS_STATIC_DEFINE
#  define KPKPASS_EXPORT
#  define KPKPASS_NO_EXPORT
#else
#  ifndef KPKPASS_EXPORT
#    ifdef KPim6PkPass_EXPORTS
        /* We are building this library */
#      define KPKPASS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KPKPASS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KPKPASS_NO_EXPORT
#    define KPKPASS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KPKPASS_DECL_DEPRECATED
#  define KPKPASS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KPKPASS_DECL_DEPRECATED_EXPORT
#  define KPKPASS_DECL_DEPRECATED_EXPORT KPKPASS_EXPORT KPKPASS_DECL_DEPRECATED
#endif

#ifndef KPKPASS_DECL_DEPRECATED_NO_EXPORT
#  define KPKPASS_DECL_DEPRECATED_NO_EXPORT KPKPASS_NO_EXPORT KPKPASS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KPKPASS_NO_DEPRECATED
#    define KPKPASS_NO_DEPRECATED
#  endif
#endif
#include "kpkpass_version.h"

#define KPKPASS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KPKPASS_NO_DEPRECATED)
#  undef KPKPASS_DEPRECATED
#  define KPKPASS_DEPRECATED_EXPORT KPKPASS_EXPORT
#  define KPKPASS_DEPRECATED_NO_EXPORT KPKPASS_NO_EXPORT
#elif defined(KPKPASS_NO_DEPRECATED_WARNINGS)
#  define KPKPASS_DEPRECATED
#  define KPKPASS_DEPRECATED_EXPORT KPKPASS_EXPORT
#  define KPKPASS_DEPRECATED_NO_EXPORT KPKPASS_NO_EXPORT
#else
#  define KPKPASS_DEPRECATED KPKPASS_DECL_DEPRECATED
#  define KPKPASS_DEPRECATED_EXPORT KPKPASS_DECL_DEPRECATED_EXPORT
#  define KPKPASS_DEPRECATED_NO_EXPORT KPKPASS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KPKPASS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KPKPASS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KPKPASS_NO_DEPRECATED
#  define KPKPASS_DISABLE_DEPRECATED_BEFORE_AND_AT KPKPASS_VERSION
#endif
#ifdef KPKPASS_NO_DEPRECATED_WARNINGS
#  define KPKPASS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KPKPASS_DEPRECATED_WARNINGS_SINCE
#  ifdef KPKPASS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KPKPASS_DEPRECATED_WARNINGS_SINCE KPKPASS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KPKPASS_DEPRECATED_WARNINGS_SINCE KPKPASS_VERSION
#  endif
#endif

#ifndef KPKPASS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KPKPASS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KPKPASS_DEPRECATED
#  define KPKPASS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KPKPASS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KPKPASS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KPKPASS_EXPORT_H */
