
#ifndef MAILIMPORTER_EXPORT_H
#define MAILIMPORTER_EXPORT_H

#ifdef MAILIMPORTER_STATIC_DEFINE
#  define MAILIMPORTER_EXPORT
#  define MAILIMPORTER_NO_EXPORT
#else
#  ifndef MAILIMPORTER_EXPORT
#    ifdef KPim6MailImporter_EXPORTS
        /* We are building this library */
#      define MAILIMPORTER_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define MAILIMPORTER_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef MAILIMPORTER_NO_EXPORT
#    define MAILIMPORTER_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef MAILIMPORTER_DECL_DEPRECATED
#  define MAILIMPORTER_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef MAILIMPORTER_DECL_DEPRECATED_EXPORT
#  define MAILIMPORTER_DECL_DEPRECATED_EXPORT MAILIMPORTER_EXPORT MAILIMPORTER_DECL_DEPRECATED
#endif

#ifndef MAILIMPORTER_DECL_DEPRECATED_NO_EXPORT
#  define MAILIMPORTER_DECL_DEPRECATED_NO_EXPORT MAILIMPORTER_NO_EXPORT MAILIMPORTER_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef MAILIMPORTER_NO_DEPRECATED
#    define MAILIMPORTER_NO_DEPRECATED
#  endif
#endif
#include <mailimporter_version.h>

#define MAILIMPORTER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(MAILIMPORTER_NO_DEPRECATED)
#  undef MAILIMPORTER_DEPRECATED
#  define MAILIMPORTER_DEPRECATED_EXPORT MAILIMPORTER_EXPORT
#  define MAILIMPORTER_DEPRECATED_NO_EXPORT MAILIMPORTER_NO_EXPORT
#elif defined(MAILIMPORTER_NO_DEPRECATED_WARNINGS)
#  define MAILIMPORTER_DEPRECATED
#  define MAILIMPORTER_DEPRECATED_EXPORT MAILIMPORTER_EXPORT
#  define MAILIMPORTER_DEPRECATED_NO_EXPORT MAILIMPORTER_NO_EXPORT
#else
#  define MAILIMPORTER_DEPRECATED MAILIMPORTER_DECL_DEPRECATED
#  define MAILIMPORTER_DEPRECATED_EXPORT MAILIMPORTER_DECL_DEPRECATED_EXPORT
#  define MAILIMPORTER_DEPRECATED_NO_EXPORT MAILIMPORTER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define MAILIMPORTER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define MAILIMPORTER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef MAILIMPORTER_NO_DEPRECATED
#  define MAILIMPORTER_DISABLE_DEPRECATED_BEFORE_AND_AT MAILIMPORTER_VERSION
#endif
#ifdef MAILIMPORTER_NO_DEPRECATED_WARNINGS
#  define MAILIMPORTER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef MAILIMPORTER_DEPRECATED_WARNINGS_SINCE
#  ifdef MAILIMPORTER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define MAILIMPORTER_DEPRECATED_WARNINGS_SINCE MAILIMPORTER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define MAILIMPORTER_DEPRECATED_WARNINGS_SINCE MAILIMPORTER_VERSION
#  endif
#endif

#ifndef MAILIMPORTER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define MAILIMPORTER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef MAILIMPORTER_DEPRECATED
#  define MAILIMPORTER_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > MAILIMPORTER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define MAILIMPORTER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* MAILIMPORTER_EXPORT_H */
