/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;

public final class JDBCUtil {
    static void throwError(HsqlException hsqlException) throws SQLException {
        throw JDBCUtil.sqlException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode(), hsqlException);
    }

    static void throwError(Result result) throws SQLException {
        throw JDBCUtil.sqlException(result.getMainString(), result.getSubString(), result.getErrorCode(), result.getException());
    }

    public static SQLException sqlException(HsqlException hsqlException) {
        return JDBCUtil.sqlException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode(), hsqlException);
    }

    public static SQLException sqlException(HsqlException hsqlException, Throwable throwable) {
        return JDBCUtil.sqlException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode(), throwable);
    }

    public static SQLException sqlException(int n) {
        return JDBCUtil.sqlException(Error.error(n));
    }

    public static SQLException sqlExceptionSQL(int n) {
        return JDBCUtil.sqlException(Error.error(n));
    }

    public static SQLException sqlException(int n, String string) {
        return JDBCUtil.sqlException(Error.error(n, string));
    }

    public static SQLException sqlException(int n, String string, Throwable throwable) {
        return JDBCUtil.sqlException(Error.error(n, string), throwable);
    }

    public static SQLException sqlException(int n, int n2) {
        return JDBCUtil.sqlException(Error.error(n, n2));
    }

    static SQLException sqlException(int n, int n2, Object[] objectArray) {
        return JDBCUtil.sqlException(Error.error(null, n, n2, objectArray));
    }

    static SQLException notSupported() {
        HsqlException hsqlException = Error.error(1500);
        return new SQLFeatureNotSupportedException(hsqlException.getMessage(), hsqlException.getSQLState(), -1500);
    }

    static SQLException notUpdatableColumn() {
        return JDBCUtil.sqlException(2500);
    }

    public static SQLException nullArgument() {
        return JDBCUtil.sqlException(423);
    }

    static SQLException nullArgument(String string) {
        return JDBCUtil.sqlException(423, string + ": null");
    }

    public static SQLException invalidArgument() {
        return JDBCUtil.sqlException(423);
    }

    public static SQLException invalidArgument(String string) {
        return JDBCUtil.sqlException(423, string);
    }

    public static SQLException outOfRangeArgument() {
        return JDBCUtil.sqlException(423);
    }

    public static SQLException outOfRangeArgument(String string) {
        return JDBCUtil.sqlException(423, string);
    }

    public static SQLException connectionClosedException() {
        return JDBCUtil.sqlException(1303);
    }

    public static SQLWarning sqlWarning(Result result) {
        return new SQLWarning(result.getMainString(), result.getSubString(), result.getErrorCode());
    }

    public static SQLException sqlException(Throwable throwable) {
        return new SQLNonTransientConnectionException(throwable);
    }

    public static SQLException sqlException(Result result) {
        return JDBCUtil.sqlException(result.getMainString(), result.getSubString(), result.getErrorCode(), result.getException());
    }

    public static SQLException sqlException(String string, String string2, int n, Throwable throwable) {
        if (string2.startsWith("08")) {
            if (!string2.endsWith("3")) {
                return new SQLTransientConnectionException(string, string2, n, throwable);
            }
            return new SQLNonTransientConnectionException(string, string2, n, throwable);
        }
        if (string2.startsWith("22")) {
            return new SQLDataException(string, string2, n, throwable);
        }
        if (string2.startsWith("23")) {
            return new SQLIntegrityConstraintViolationException(string, string2, n, throwable);
        }
        if (string2.startsWith("28")) {
            return new SQLInvalidAuthorizationSpecException(string, string2, n, throwable);
        }
        if (string2.startsWith("42") || string2.startsWith("37") || string2.startsWith("2A")) {
            return new SQLSyntaxErrorException(string, string2, n, throwable);
        }
        if (string2.startsWith("40")) {
            return new SQLTransactionRollbackException(string, string2, n, throwable);
        }
        if (string2.startsWith("0A")) {
            return new SQLFeatureNotSupportedException(string, string2, n, throwable);
        }
        return new SQLException(string, string2, n, throwable);
    }
}

