/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid;

import java.io.File;
import java.io.IOException;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.client.RuntimeProfilingPoint;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.global.Platform;
import org.graalvm.visualvm.lib.jfluid.marker.Marker;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;

public final class ProfilerEngineSettings
implements CommonConstants,
Cloneable {
    private InstrumentationFilter instrumentationFilter = new InstrumentationFilter();
    private Marker methodMarker = Marker.DEFAULT;
    private String jFluidRootDirName;
    private String jvmArgs;
    private String mainArgs;
    private String mainClassName;
    private String mainClassPath = "";
    private String remoteHost = "";
    private String targetJDKVersion = "jdk15";
    private String targetJVMExeFile;
    private String targetJVMStartupDirName;
    private String workingDir = System.getProperty("user.dir");
    private ClientUtils.SourceCodeSelection[] instrumentationRootMethods = new ClientUtils.SourceCodeSelection[0];
    private RuntimeProfilingPoint[] profilingPoints = new RuntimeProfilingPoint[0];
    private String[] vmClassPaths = new String[3];
    private boolean absoluteTimerOn = true;
    private boolean dontShowZeroLiveObjAllocPaths = true;
    private boolean excludeWaitTime = true;
    private boolean instrumentEmptyMethods = false;
    private boolean instrumentGetterSetterMethods = false;
    private boolean instrumentMethodInvoke = true;
    private boolean instrumentSpawnedThreads = false;
    private boolean runGCOnGetResultsInMemoryProfiling = false;
    private boolean instrumentObjectInit = false;
    private boolean separateConsole = true;
    private boolean sortResultsByThreadCPUTime = false;
    private boolean suspendTargetApp = false;
    private boolean targetWindowRemains = false;
    private boolean threadCPUTimerOn = false;
    private boolean threadsMonitoringEnabled;
    private boolean lockContentionMonitoringEnabled;
    private boolean threadsSamplingEnabled;
    private int allocStackTraceLimit = -5;
    private int maxStringLength = 1024;
    private int allocTrackEvery = 10;
    private int architecture;
    private int codeRegionCPUResBufSize = 1000;
    private int cpuProfilingType = 0;
    private int instrScheme = 1;
    private int nProfiledThreadsLimit = 32;
    private int stackDepthLimit = Integer.MAX_VALUE;
    private int portNo = 5140;
    private int samplingInterval = 10;
    private int samplingFrequency = 10;

    public void setAbsoluteTimerOn(boolean v) {
        this.absoluteTimerOn = v;
    }

    public boolean getAbsoluteTimerOn() {
        return this.absoluteTimerOn;
    }

    public void setAllocStackTraceLimit(int depth) {
        this.allocStackTraceLimit = depth;
    }

    public int getAllocStackTraceLimit() {
        return this.allocStackTraceLimit;
    }

    public void setAllocTrackEvery(int interval) {
        if (interval < 1) {
            interval = 1;
        }
        this.allocTrackEvery = interval;
    }

    public int getAllocTrackEvery() {
        return this.allocTrackEvery;
    }

    public void setCPUProfilingType(int v) {
        this.cpuProfilingType = v;
    }

    public int getCPUProfilingType() {
        return this.cpuProfilingType;
    }

    public void setCodeRegionCPUResBufSize(int size) {
        this.codeRegionCPUResBufSize = size;
    }

    public int getCodeRegionCPUResBufSize() {
        return this.codeRegionCPUResBufSize;
    }

    public void setDontShowZeroLiveObjAllocPaths(boolean v) {
        this.dontShowZeroLiveObjAllocPaths = v;
    }

    public boolean getDontShowZeroLiveObjAllocPaths() {
        return this.dontShowZeroLiveObjAllocPaths;
    }

    public void setExcludeWaitTime(boolean b) {
        this.excludeWaitTime = b;
    }

    public boolean getExcludeWaitTime() {
        return this.excludeWaitTime;
    }

    public void setInstrScheme(int scheme) {
        this.instrScheme = scheme;
    }

    public int getInstrScheme() {
        return this.instrScheme;
    }

    public void setInstrumentEmptyMethods(boolean b) {
        this.instrumentEmptyMethods = b;
    }

    public boolean getInstrumentEmptyMethods() {
        return this.instrumentEmptyMethods;
    }

    public void setInstrumentGetterSetterMethods(boolean b) {
        this.instrumentGetterSetterMethods = b;
    }

    public boolean getInstrumentGetterSetterMethods() {
        return this.instrumentGetterSetterMethods;
    }

    public void setInstrumentMethodInvoke(boolean b) {
        this.instrumentMethodInvoke = b;
    }

    public boolean getInstrumentMethodInvoke() {
        return this.instrumentMethodInvoke;
    }

    public void setInstrumentSpawnedThreads(boolean b) {
        this.instrumentSpawnedThreads = b;
    }

    public boolean getInstrumentSpawnedThreads() {
        return this.instrumentSpawnedThreads;
    }

    public void setInstrumentationFilter(GenericFilter f) {
        this.instrumentationFilter = new InstrumentationFilter(f);
    }

    public InstrumentationFilter getInstrumentationFilter() {
        return this.instrumentationFilter;
    }

    public void setInstrumentationRootMethods(ClientUtils.SourceCodeSelection[] methods) {
        this.instrumentationRootMethods = methods;
    }

    public ClientUtils.SourceCodeSelection[] getInstrumentationRootMethods() {
        return this.instrumentationRootMethods;
    }

    public String getJFluidRootDirName() {
        return this.jFluidRootDirName;
    }

    public void setJVMArgs(String args) {
        this.jvmArgs = args;
    }

    public String[] getJVMArgs() {
        return StringUtils.parseArgsString(this.jvmArgs);
    }

    public String getJVMArgsAsSingleString() {
        return this.jvmArgs;
    }

    public void setMainArgs(String args) {
        this.mainArgs = args;
    }

    public String[] getMainArgs() {
        return StringUtils.parseArgsString(this.mainArgs);
    }

    public String getMainArgsAsSingleString() {
        return this.mainArgs;
    }

    public void setMainClass(String name) {
        this.mainClassName = name;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassPath(String cp) {
        this.mainClassPath = cp;
    }

    public String getMainClassPath() {
        return this.mainClassPath;
    }

    public void setMethodMarker(Marker marker) {
        this.methodMarker = marker;
    }

    public Marker getMethodMarker() {
        return this.methodMarker;
    }

    public void setNProfiledThreadsLimit(int num) {
        this.nProfiledThreadsLimit = num;
    }

    public int getNProfiledThreadsLimit() {
        return this.nProfiledThreadsLimit;
    }

    public void setMaxStringLength(int maxLength) {
        if (maxLength > 4200) {
            throw new IllegalArgumentException(maxLength + " is over top limit " + 4200);
        }
        this.maxStringLength = maxLength;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setStackDepthLimit(int num) {
        this.stackDepthLimit = num;
    }

    public int getStackDepthLimit() {
        return this.stackDepthLimit;
    }

    public void setPortNo(int pNo) {
        this.portNo = pNo;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRunGCOnGetResultsInMemoryProfiling(boolean v) {
        this.runGCOnGetResultsInMemoryProfiling = v;
    }

    public boolean getRunGCOnGetResultsInMemoryProfiling() {
        return this.runGCOnGetResultsInMemoryProfiling;
    }

    public boolean isInstrumentArrayAllocation() {
        return this.instrumentationFilter.hasArray();
    }

    public boolean isInstrumentObjectInit() {
        return this.instrumentObjectInit;
    }

    public void setInstrumentObjectInit(boolean v) {
        this.instrumentObjectInit = v;
    }

    public void setRuntimeProfilingPoints(RuntimeProfilingPoint[] profilingPoints) {
        this.profilingPoints = profilingPoints;
    }

    public RuntimeProfilingPoint[] getRuntimeProfilingPoints() {
        return this.profilingPoints;
    }

    public void setSamplingInterval(int num) {
        this.samplingInterval = num;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSamplingFrequency(int num) {
        this.samplingFrequency = num;
    }

    public int getSamplingFrequency() {
        return this.samplingFrequency;
    }

    public void setSeparateConsole(boolean separateConsole) {
        this.separateConsole = separateConsole;
    }

    public boolean getSeparateConsole() {
        return this.separateConsole;
    }

    public void setSortResultsByThreadCPUTime(boolean v) {
        this.sortResultsByThreadCPUTime = v;
    }

    public boolean getSortResultsByThreadCPUTime() {
        return this.sortResultsByThreadCPUTime;
    }

    public void setSuspendTargetApp(boolean b) {
        this.suspendTargetApp = b;
    }

    public boolean getSuspendTargetApp() {
        return this.suspendTargetApp;
    }

    public void setSystemArchitecture(int arch) {
        this.architecture = arch;
    }

    public int getSystemArchitecture() {
        return this.architecture;
    }

    public void setTargetJDKVersionString(String ver) {
        this.targetJDKVersion = ver;
    }

    public String getTargetJDKVersionString() {
        return this.targetJDKVersion;
    }

    public void setTargetJVMExeFile(String name) {
        this.targetJVMExeFile = name;
    }

    public String getTargetJVMExeFile() {
        return this.targetJVMExeFile;
    }

    public void setTargetJVMStartupDirName(String dir) {
        this.targetJVMStartupDirName = dir;
    }

    public String getTargetJVMStartupDirName() {
        return this.targetJVMStartupDirName;
    }

    public void setTargetWindowRemains(boolean b) {
        this.targetWindowRemains = b;
    }

    public boolean getTargetWindowRemains() {
        return this.targetWindowRemains;
    }

    public void setThreadCPUTimerOn(boolean v) {
        this.threadCPUTimerOn = v;
    }

    public boolean getThreadCPUTimerOn() {
        return this.threadCPUTimerOn;
    }

    public void setThreadsMonitoringEnabled(boolean b) {
        this.threadsMonitoringEnabled = b;
    }

    public boolean isThreadsMonitoringEnabled() {
        return this.threadsMonitoringEnabled;
    }

    public void setLockContentionMonitoringEnabled(boolean b) {
        this.lockContentionMonitoringEnabled = b;
    }

    public boolean isLockContentionMonitoringEnabled() {
        return this.lockContentionMonitoringEnabled;
    }

    public void setThreadsSamplingEnabled(boolean b) {
        this.threadsSamplingEnabled = b;
    }

    public boolean isThreadsSamplingEnabled() {
        return this.threadsSamplingEnabled;
    }

    public void setVMClassPaths(String javaClassPath, String javaExtDirs, String bootClassPath) {
        this.vmClassPaths[0] = MiscUtils.getLiveClassPathSubset(javaClassPath, this.getWorkingDir());
        this.vmClassPaths[1] = javaExtDirs;
        this.vmClassPaths[2] = bootClassPath;
        try {
            this.setMainClassPath(this.vmClassPaths[0]);
        }
        catch (Exception ex) {
            throw new InternalError("Should not happen");
        }
    }

    public String[] getVMClassPaths() {
        this.vmClassPaths[0] = this.getMainClassPath();
        return this.vmClassPaths;
    }

    public void setWorkingDir(String name) {
        this.workingDir = name;
        if (this.workingDir == null || "".equals(this.workingDir)) {
            this.workingDir = System.getProperty("user.dir");
        }
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public Object clone() {
        ProfilerEngineSettings clone = null;
        try {
            clone = (ProfilerEngineSettings)super.clone();
            clone.instrumentationRootMethods = new ClientUtils.SourceCodeSelection[this.instrumentationRootMethods.length];
            for (int i = 0; i < this.instrumentationRootMethods.length; ++i) {
                clone.instrumentationRootMethods[i] = (ClientUtils.SourceCodeSelection)this.instrumentationRootMethods[i].clone();
            }
            clone.instrumentationFilter = new InstrumentationFilter(this.instrumentationFilter);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Should never happen: ProfilerEngineSettings.clone");
        }
    }

    public void initialize(String rootDirName) throws RuntimeException, IOException {
        String jFluidNativeLibFullName = Platform.getAgentNativeLibFullName(rootDirName, false, null, -1);
        String jFluidNativeLibDirName = jFluidNativeLibFullName.substring(0, jFluidNativeLibFullName.lastIndexOf(47));
        String checkedPath = "";
        try {
            checkedPath = rootDirName;
            File rootDir = MiscUtils.checkDirForName(checkedPath);
            checkedPath = jFluidNativeLibDirName;
            MiscUtils.checkDirForName(checkedPath);
            checkedPath = jFluidNativeLibFullName;
            MiscUtils.checkFile(new File(checkedPath), false);
            this.jFluidRootDirName = rootDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IOException("Problem with a required JFluid installation directory or file " + checkedPath, e);
        }
    }
}

