/* GuestSessionToggle.c generated by valac 0.56.3, the Vala compiler
 * generated from GuestSessionToggle.vala, do not modify */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sys/types.h>
#include <unistd.h>
#include <glib/gstdio.h>

#define GUEST_SESSION_TOGGLE_LIGHTDM_CONF "/etc/lightdm/lightdm.conf"
#define GUEST_SESSION_TOGGLE_LIGHTDM_CONF_D "/etc/lightdm/lightdm.conf.d"
#define GUEST_SESSION_TOGGLE_GUEST_SESSION_CONF "/usr/share/lightdm/lightdm.conf.d/60-guest-session.conf"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

VALA_EXTERN gboolean guest_session_toggle_show;
VALA_EXTERN gboolean guest_session_toggle_show_autologin;
VALA_EXTERN gboolean guest_session_toggle_on;
VALA_EXTERN gboolean guest_session_toggle_off;
VALA_EXTERN gboolean guest_session_toggle_autologin_on;
VALA_EXTERN gboolean guest_session_toggle_autologin_off;
gboolean guest_session_toggle_show = FALSE;
gboolean guest_session_toggle_show_autologin = FALSE;
gboolean guest_session_toggle_on = FALSE;
gboolean guest_session_toggle_off = FALSE;
gboolean guest_session_toggle_autologin_on = FALSE;
gboolean guest_session_toggle_autologin_off = FALSE;

static gint guest_session_toggle_main (gchar** args,
                                gint args_length1);
VALA_EXTERN gboolean guest_session_toggle_get_allow_guest (void);
VALA_EXTERN gboolean guest_session_toggle_get_guest_autologin (void);
VALA_EXTERN gboolean guest_session_toggle_set_allow_guest (gboolean enable);
VALA_EXTERN gboolean guest_session_toggle_set_guest_autologin (gboolean enable);
VALA_EXTERN gboolean guest_session_toggle_set_setting (const gchar* group,
                                           const gchar* key,
                                           const gchar* value,
                                           const gchar* fallback_path);
VALA_EXTERN gchar* guest_session_toggle_get_setting (const gchar* group,
                                         const gchar* key,
                                         const gchar* default_value);
VALA_EXTERN gchar* guest_session_toggle_get_config_from_file (const gchar* path,
                                                  const gchar* group,
                                                  const gchar* key);
VALA_EXTERN gchar* guest_session_toggle_get_config_from_directory (const gchar* path,
                                                       const gchar* group,
                                                       const gchar* key);
VALA_EXTERN gchar* guest_session_toggle_get_config_from_directories (gchar** dirs,
                                                         gint dirs_length1,
                                                         const gchar* group,
                                                         const gchar* key);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN gboolean guest_session_toggle_set_config_in_file (const gchar* path,
                                                  const gchar* group,
                                                  const gchar* key,
                                                  const gchar* value,
                                                  gboolean create);
VALA_EXTERN gboolean guest_session_toggle_set_config_in_directory (const gchar* path,
                                                       const gchar* group,
                                                       const gchar* key,
                                                       const gchar* value);
VALA_EXTERN gboolean guest_session_toggle_set_config_in_directories (gchar** dirs,
                                                         gint dirs_length1,
                                                         const gchar* group,
                                                         const gchar* key,
                                                         const gchar* value);
static gssize _vala_array_length (gpointer array);

const GOptionEntry GUEST_SESSION_TOGGLE_OPTIONS[7] = {{"show", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &guest_session_toggle_show, "Show whether guest-session is enabled", NULL}, {"show-autologin", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &guest_session_toggle_show_autologin, "Show whether guest will be logged in automatically", NULL}, {"on", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &guest_session_toggle_on, "Enable guest-session", NULL}, {"off", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &guest_session_toggle_off, "Disable guest-session", NULL}, {"autologin-on", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &guest_session_toggle_autologin_on, "Enable guest autologin", NULL}, {"autologin-off", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &guest_session_toggle_autologin_off, "Disable guest autologin", NULL}, {NULL}};

static gint
guest_session_toggle_main (gchar** args,
                           gint args_length1)
{
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	gboolean enabled = FALSE;
	gboolean autologin_enabled = FALSE;
	uid_t uid = {0};
	gboolean _tmp7_ = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, GUEST_SESSION_TOGGLE_OPTIONS, NULL);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_printerr ("%s\n", _tmp5_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp6_ = -1;
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	if (guest_session_toggle_show) {
		enabled = guest_session_toggle_get_allow_guest ();
		if (enabled) {
			g_print ("on\n");
		} else {
			g_print ("off\n");
		}
		result = EXIT_SUCCESS;
		_g_option_context_free0 (context);
		return result;
	} else {
		if (guest_session_toggle_show_autologin) {
			autologin_enabled = guest_session_toggle_get_guest_autologin ();
			if (autologin_enabled) {
				g_print ("on\n");
			} else {
				g_print ("off\n");
			}
			result = EXIT_SUCCESS;
			_g_option_context_free0 (context);
			return result;
		}
	}
	uid = getuid ();
	if (uid > ((uid_t) 0)) {
		g_printerr ("Must be run from administrative context\n");
		result = EXIT_FAILURE;
		_g_option_context_free0 (context);
		return result;
	}
	enabled = guest_session_toggle_get_allow_guest ();
	autologin_enabled = guest_session_toggle_get_guest_autologin ();
	if (guest_session_toggle_on) {
		_tmp7_ = !enabled;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		guest_session_toggle_set_allow_guest (TRUE);
	} else {
		gboolean _tmp8_ = FALSE;
		if (guest_session_toggle_off) {
			_tmp8_ = enabled;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			guest_session_toggle_set_allow_guest (FALSE);
		} else {
			gboolean _tmp9_ = FALSE;
			if (guest_session_toggle_autologin_on) {
				_tmp9_ = !autologin_enabled;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				guest_session_toggle_set_guest_autologin (TRUE);
			} else {
				gboolean _tmp10_ = FALSE;
				if (guest_session_toggle_autologin_off) {
					_tmp10_ = autologin_enabled;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					guest_session_toggle_set_guest_autologin (FALSE);
				}
			}
		}
	}
	result = EXIT_SUCCESS;
	_g_option_context_free0 (context);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return guest_session_toggle_main (argv, argc);
}

gboolean
guest_session_toggle_set_allow_guest (gboolean enable)
{
	const gchar* _tmp0_ = NULL;
	gchar* value = NULL;
	gchar* _tmp1_;
	gboolean result;
	if (enable) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	_tmp1_ = g_strdup (_tmp0_);
	value = _tmp1_;
	result = guest_session_toggle_set_setting ("Seat:*", "allow-guest", value, GUEST_SESSION_TOGGLE_GUEST_SESSION_CONF);
	_g_free0 (value);
	return result;
}

gboolean
guest_session_toggle_get_allow_guest (void)
{
	gchar* value = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	_tmp0_ = guest_session_toggle_get_setting ("Seat:*", "allow-guest", "true");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	value = _tmp3_;
	result = g_strcmp0 (value, "true") == 0;
	_g_free0 (value);
	return result;
}

gboolean
guest_session_toggle_get_guest_autologin (void)
{
	gchar* value = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	_tmp0_ = guest_session_toggle_get_setting ("Seat:*", "autologin-guest", "false");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	value = _tmp3_;
	result = g_strcmp0 (value, "true") == 0;
	_g_free0 (value);
	return result;
}

gboolean
guest_session_toggle_set_guest_autologin (gboolean enable)
{
	const gchar* _tmp0_ = NULL;
	gchar* value = NULL;
	gchar* _tmp1_;
	gboolean result;
	if (enable) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	_tmp1_ = g_strdup (_tmp0_);
	value = _tmp1_;
	result = guest_session_toggle_set_setting ("Seat:*", "autologin-guest", value, GUEST_SESSION_TOGGLE_GUEST_SESSION_CONF);
	_g_free0 (value);
	return result;
}

gchar*
guest_session_toggle_get_setting (const gchar* group,
                                  const gchar* key,
                                  const gchar* default_value)
{
	gchar* value = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	_tmp0_ = guest_session_toggle_get_config_from_file (GUEST_SESSION_TOGGLE_LIGHTDM_CONF, group, key);
	_g_free0 (value);
	value = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		result = value;
		return result;
	}
	_tmp2_ = guest_session_toggle_get_config_from_directory (GUEST_SESSION_TOGGLE_LIGHTDM_CONF_D, group, key);
	_g_free0 (value);
	value = _tmp2_;
	_tmp3_ = value;
	if (_tmp3_ != NULL) {
		result = value;
		return result;
	}
	_tmp5_ = _tmp4_ = g_get_system_config_dirs ();
	_tmp6_ = guest_session_toggle_get_config_from_directories (_tmp5_, (gint) _vala_array_length (_tmp4_), group, key);
	_g_free0 (value);
	value = _tmp6_;
	_tmp7_ = value;
	if (_tmp7_ != NULL) {
		result = value;
		return result;
	}
	_tmp9_ = _tmp8_ = g_get_system_data_dirs ();
	_tmp10_ = guest_session_toggle_get_config_from_directories (_tmp9_, (gint) _vala_array_length (_tmp8_), group, key);
	_g_free0 (value);
	value = _tmp10_;
	_tmp11_ = value;
	if (_tmp11_ != NULL) {
		result = value;
		return result;
	}
	g_printerr ("'[%s] %s' is not set anywhere assuming default '%s'\n", group, key, default_value);
	_tmp12_ = g_strdup (default_value);
	result = _tmp12_;
	_g_free0 (value);
	return result;
}

gchar*
guest_session_toggle_get_config_from_directories (gchar** dirs,
                                                  gint dirs_length1,
                                                  const gchar* group,
                                                  const gchar* key)
{
	gchar* _result_ = NULL;
	gchar* result;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_result_ = NULL;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = dirs;
		dir_collection_length1 = dirs_length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				gchar* full_dir = NULL;
				const gchar* _tmp0_;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp0_ = dir;
				_tmp1_ = g_build_filename (_tmp0_, "lightdm", "lightdm.conf.d", NULL);
				full_dir = _tmp1_;
				_tmp2_ = full_dir;
				_tmp3_ = guest_session_toggle_get_config_from_directory (_tmp2_, group, key);
				_g_free0 (_result_);
				_result_ = _tmp3_;
				_tmp4_ = _result_;
				if (_tmp4_ != NULL) {
					result = _result_;
					_g_free0 (full_dir);
					return result;
				}
				_g_free0 (full_dir);
			}
		}
	}
	result = NULL;
	_g_free0 (_result_);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

gchar*
guest_session_toggle_get_config_from_directory (const gchar* path,
                                                const gchar* group,
                                                const gchar* key)
{
	GList* files = NULL;
	gchar* _result_ = NULL;
	GCompareFunc _tmp8_;
	GList* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	files = NULL;
	_result_ = NULL;
	{
		GDir* dir = NULL;
		GDir* _tmp0_;
		const gchar* name = NULL;
		_tmp0_ = g_dir_open (path, (guint) 0, &_inner_error0_);
		dir = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (_result_);
			(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		name = NULL;
		while (TRUE) {
			GDir* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp1_ = dir;
			_tmp2_ = g_dir_read_name (_tmp1_);
			name = _tmp2_;
			_tmp3_ = name;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = name;
			_tmp5_ = g_strdup (_tmp4_);
			files = g_list_prepend (files, _tmp5_);
		}
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_printerr ("Failed to open configuration directory %s: %s\n", path, _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_result_);
		(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = ((GCompareFunc) g_strcmp0);
	files = g_list_sort (files, _tmp8_);
	_tmp9_ = files;
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
		filename_collection = _tmp9_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			const gchar* filename = NULL;
			filename = (const gchar*) filename_it->data;
			{
				gchar* conf_path = NULL;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp10_ = filename;
				_tmp11_ = g_build_filename (path, _tmp10_, NULL);
				conf_path = _tmp11_;
				_tmp12_ = filename;
				if (g_str_has_suffix (_tmp12_, ".conf")) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp13_ = conf_path;
					_tmp14_ = guest_session_toggle_get_config_from_file (_tmp13_, group, key);
					_g_free0 (_result_);
					_result_ = _tmp14_;
					_tmp15_ = _result_;
					if (_tmp15_ != NULL) {
						result = _result_;
						_g_free0 (conf_path);
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
						return result;
					}
				} else {
					const gchar* _tmp16_;
					_tmp16_ = conf_path;
					g_printerr ("Ignoring configuration file %s, it does not have .conf suffix", _tmp16_);
				}
				_g_free0 (conf_path);
			}
		}
	}
	result = NULL;
	_g_free0 (_result_);
	(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
	return result;
}

gchar*
guest_session_toggle_get_config_from_file (const gchar* path,
                                           const gchar* group,
                                           const gchar* key)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GKeyFile* key_file = NULL;
		GKeyFile* _tmp0_;
		GKeyFile* _tmp1_;
		gchar* _tmp2_ = NULL;
		GKeyFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = g_key_file_new ();
		key_file = _tmp0_;
		_tmp1_ = key_file;
		g_key_file_load_from_file (_tmp1_, path, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (key_file);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = key_file;
		_tmp4_ = g_key_file_get_string (_tmp3_, group, key, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (key_file);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp2_);
		_g_key_file_unref0 (key_file);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_printerr ("Failed to open configuration file %s: %s\n", path, _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

gboolean
guest_session_toggle_set_setting (const gchar* group,
                                  const gchar* key,
                                  const gchar* value,
                                  const gchar* fallback_path)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gboolean result;
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (fallback_path != NULL, FALSE);
	if (guest_session_toggle_set_config_in_file (GUEST_SESSION_TOGGLE_LIGHTDM_CONF, group, key, value, FALSE)) {
		result = TRUE;
		return result;
	}
	if (guest_session_toggle_set_config_in_directory (GUEST_SESSION_TOGGLE_LIGHTDM_CONF_D, group, key, value)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = _tmp0_ = g_get_system_config_dirs ();
	if (guest_session_toggle_set_config_in_directories (_tmp1_, (gint) _vala_array_length (_tmp0_), group, key, value)) {
		result = TRUE;
		return result;
	}
	_tmp3_ = _tmp2_ = g_get_system_data_dirs ();
	if (guest_session_toggle_set_config_in_directories (_tmp3_, (gint) _vala_array_length (_tmp2_), group, key, value)) {
		result = TRUE;
		return result;
	}
	g_printerr ("'[%s] %s' is not set anywhere, creating '%s'\n", group, key, fallback_path);
	result = guest_session_toggle_set_config_in_file (fallback_path, group, key, value, TRUE);
	return result;
}

gboolean
guest_session_toggle_set_config_in_directories (gchar** dirs,
                                                gint dirs_length1,
                                                const gchar* group,
                                                const gchar* key,
                                                const gchar* value)
{
	gboolean result;
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = dirs;
		dir_collection_length1 = dirs_length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				gchar* full_dir = NULL;
				const gchar* _tmp0_;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				_tmp0_ = dir;
				_tmp1_ = g_build_filename (_tmp0_, "lightdm", "lightdm.conf.d", NULL);
				full_dir = _tmp1_;
				_tmp2_ = full_dir;
				if (guest_session_toggle_set_config_in_directory (_tmp2_, group, key, value)) {
					result = TRUE;
					_g_free0 (full_dir);
					return result;
				}
				_g_free0 (full_dir);
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
guest_session_toggle_set_config_in_directory (const gchar* path,
                                              const gchar* group,
                                              const gchar* key,
                                              const gchar* value)
{
	GList* files = NULL;
	GCompareFunc _tmp10_;
	GList* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	files = NULL;
	{
		GDir* dir = NULL;
		GDir* _tmp0_;
		const gchar* name = NULL;
		_tmp0_ = g_dir_open (path, (guint) 0, &_inner_error0_);
		dir = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		name = NULL;
		while (TRUE) {
			GDir* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = dir;
			_tmp3_ = g_dir_read_name (_tmp2_);
			name = _tmp3_;
			_tmp4_ = name;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = name;
			_tmp6_ = g_strdup (_tmp5_);
			files = g_list_prepend (files, _tmp6_);
		}
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_printerr ("Failed to open configuration directory %s: %s\n", path, _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = ((GCompareFunc) g_strcmp0);
	files = g_list_sort (files, _tmp10_);
	_tmp11_ = files;
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
		filename_collection = _tmp11_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			const gchar* filename = NULL;
			filename = (const gchar*) filename_it->data;
			{
				gchar* conf_path = NULL;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = filename;
				_tmp13_ = g_build_filename (path, _tmp12_, NULL);
				conf_path = _tmp13_;
				_tmp14_ = filename;
				if (g_str_has_suffix (_tmp14_, ".conf")) {
					const gchar* _tmp15_;
					_tmp15_ = conf_path;
					if (guest_session_toggle_set_config_in_file (_tmp15_, group, key, value, FALSE)) {
						result = TRUE;
						_g_free0 (conf_path);
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
						return result;
					}
				} else {
					const gchar* _tmp16_;
					_tmp16_ = conf_path;
					g_printerr ("Ignoring configuration file %s, it does not have .conf suffix", _tmp16_);
				}
				_g_free0 (conf_path);
			}
		}
	}
	result = FALSE;
	(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
	return result;
}

gboolean
guest_session_toggle_set_config_in_file (const gchar* path,
                                         const gchar* group,
                                         const gchar* key,
                                         const gchar* value,
                                         gboolean create)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	{
		GKeyFile* key_file = NULL;
		GKeyFile* _tmp0_;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = g_key_file_new ();
		key_file = _tmp0_;
		if (g_file_test (path, G_FILE_TEST_EXISTS)) {
			GKeyFile* _tmp1_;
			_tmp1_ = key_file;
			g_key_file_load_from_file (_tmp1_, path, G_KEY_FILE_KEEP_COMMENTS, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp2_ = FALSE;
				_g_key_file_unref0 (key_file);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp2_;
			}
		} else {
			if (!create) {
				result = FALSE;
				_g_key_file_unref0 (key_file);
				return result;
			}
		}
		if (create) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp4_ = FALSE;
			GKeyFile* _tmp5_;
			_tmp5_ = key_file;
			_tmp4_ = g_key_file_has_key (_tmp5_, group, key, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp6_ = FALSE;
				_g_key_file_unref0 (key_file);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp6_;
			}
			_tmp3_ = _tmp4_;
		}
		create = _tmp3_;
		if (create) {
			GKeyFile* _tmp7_;
			GKeyFile* _tmp8_;
			_tmp7_ = key_file;
			g_key_file_set_string (_tmp7_, group, key, value);
			_tmp8_ = key_file;
			g_key_file_save_to_file (_tmp8_, path, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp9_ = FALSE;
				_g_key_file_unref0 (key_file);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp9_;
			}
			result = TRUE;
			_g_key_file_unref0 (key_file);
			return result;
		}
		_g_key_file_unref0 (key_file);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_printerr ("Failed to load/save configuration file %s: %s\n", path, _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
	result = FALSE;
	return result;
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

