/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.util.PriorityQueue;

public abstract class DocIDMerger<T extends Sub> {
    public static <T extends Sub> DocIDMerger<T> of(List<T> subs, int maxCount, boolean indexIsSorted) throws IOException {
        if (indexIsSorted && maxCount > 1) {
            return new SortedDocIDMerger<T>(subs, maxCount);
        }
        return new SequentialDocIDMerger<T>(subs);
    }

    public static <T extends Sub> DocIDMerger<T> of(List<T> subs, boolean indexIsSorted) throws IOException {
        return DocIDMerger.of(subs, subs.size(), indexIsSorted);
    }

    public abstract void reset() throws IOException;

    public abstract T next() throws IOException;

    private DocIDMerger() {
    }

    private static class SortedDocIDMerger<T extends Sub>
    extends DocIDMerger<T> {
        private final List<T> subs;
        private T current;
        private final PriorityQueue<T> queue;
        private int queueMinDocID;

        private SortedDocIDMerger(List<T> subs, int maxCount) throws IOException {
            if (maxCount <= 1) {
                throw new IllegalArgumentException();
            }
            this.subs = subs;
            this.queue = new PriorityQueue<T>(maxCount - 1){

                @Override
                protected boolean lessThan(Sub a, Sub b) {
                    assert (a.mappedDocID != b.mappedDocID);
                    return a.mappedDocID < b.mappedDocID;
                }
            };
            this.reset();
        }

        private void setQueueMinDocID() {
            this.queueMinDocID = this.queue.size() > 0 ? ((Sub)this.queue.top()).mappedDocID : Integer.MAX_VALUE;
        }

        @Override
        public void reset() throws IOException {
            this.queue.clear();
            this.current = null;
            boolean first = true;
            for (Sub sub : this.subs) {
                if (first) {
                    sub.mappedDocID = -1;
                    this.current = sub;
                    first = false;
                    continue;
                }
                if (sub.nextMappedDoc() == Integer.MAX_VALUE) continue;
                this.queue.add(sub);
            }
            this.setQueueMinDocID();
        }

        @Override
        public T next() throws IOException {
            int nextDoc = ((Sub)this.current).nextMappedDoc();
            if (nextDoc < this.queueMinDocID) {
                return this.current;
            }
            if (nextDoc == Integer.MAX_VALUE) {
                this.current = this.queue.size() == 0 ? null : (Sub)this.queue.pop();
            } else if (this.queue.size() > 0) {
                assert (this.queueMinDocID == ((Sub)this.queue.top()).mappedDocID);
                assert (nextDoc > this.queueMinDocID);
                Sub newCurrent = (Sub)this.queue.top();
                this.queue.updateTop(this.current);
                this.current = newCurrent;
            }
            this.setQueueMinDocID();
            return this.current;
        }
    }

    private static class SequentialDocIDMerger<T extends Sub>
    extends DocIDMerger<T> {
        private final List<T> subs;
        private T current;
        private int nextIndex;

        private SequentialDocIDMerger(List<T> subs) throws IOException {
            this.subs = subs;
            this.reset();
        }

        @Override
        public void reset() throws IOException {
            if (this.subs.size() > 0) {
                this.current = (Sub)this.subs.get(0);
                this.nextIndex = 1;
            } else {
                this.current = null;
                this.nextIndex = 0;
            }
        }

        @Override
        public T next() throws IOException {
            while (((Sub)this.current).nextMappedDoc() == Integer.MAX_VALUE) {
                if (this.nextIndex == this.subs.size()) {
                    this.current = null;
                    return null;
                }
                this.current = (Sub)this.subs.get(this.nextIndex);
                ++this.nextIndex;
            }
            return this.current;
        }
    }

    public static abstract class Sub {
        public int mappedDocID;
        public final MergeState.DocMap docMap;

        protected Sub(MergeState.DocMap docMap) {
            this.docMap = docMap;
        }

        public abstract int nextDoc() throws IOException;

        public final int nextMappedDoc() throws IOException {
            int doc;
            int mappedDoc;
            do {
                if ((doc = this.nextDoc()) != Integer.MAX_VALUE) continue;
                this.mappedDocID = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while ((mappedDoc = this.docMap.get(doc)) == -1);
            this.mappedDocID = mappedDoc;
            return this.mappedDocID;
        }
    }
}

