/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ku extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Saeta Nav\u00een\u00ee ya Greenwich\u00ea",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Saeta Standard a Apiay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Apiay\u00ea",
               "",
               "Saeta Apiay\u00ea",
               "",
            };
        final String[] Cook = new String[] {
               "Saeta Standard a Girav\u00ean Cook\u00ea",
               "",
               "Saeta N\u00eevhav\u00een\u00ea ya Girav\u00ean Cook\u00ea",
               "",
               "Saeta Girav\u00ean Cook\u00ea",
               "",
            };
        final String[] Cuba = new String[] {
               "Saeta Standard a Kubay\u00ea",
               "SSK",
               "Saeta Hav\u00een\u00ea ya Kubay\u00ea",
               "SHK",
               "Saeta Kubay\u00ea",
               "SK",
            };
        final String[] Fiji = new String[] {
               "Saeta Standard a F\u00eejiy\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya F\u00eejiy\u00ea",
               "",
               "Saeta F\u00eejiy\u00ea",
               "",
            };
        final String[] Gulf = new String[] {
               "Saeta Standard a Kendav\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Saeta Standard a Hovd\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Hovd\u00ea",
               "",
               "Saeta Hovd\u00ea",
               "",
            };
        final String[] Iran = new String[] {
               "Saeta Standard a \u00ceran\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya \u00ceran\u00ea",
               "",
               "Saeta \u00ceran\u00ea",
               "",
            };
        final String[] Niue = new String[] {
               "Saeta Niuey\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Saeta Standard a Omsk\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Omsk\u00ea",
               "",
               "Saeta Omsk\u00ea",
               "",
            };
        final String[] Peru = new String[] {
               "Saeta Standard a Per\u00fby\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Per\u00fby\u00ea",
               "",
               "Saeta Per\u00fby\u00ea",
               "",
            };
        final String[] Truk = new String[] {
               "Saeta Chuuk\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Saeta Girava Wakey\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Saeta Standard a \u015e\u00eeliy\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya \u015e\u00eeliy\u00ea",
               "",
               "Saeta \u015e\u00eeliy\u00ea",
               "",
            };
        final String[] China = new String[] {
               "Saeta Standard a \u00c7\u00een\u00ea",
               "CST",
               "Saeta Hav\u00een\u00ea ya \u00c7\u00een\u00ea",
               "CDT",
               "Saeta \u00c7\u00een\u00ea",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Saeta Girav\u00ean Cocos\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Saeta Dav\u00ees\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Saeta Standard a Hindistan\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Saeta Standard a Japonyay\u00ea",
               "JST",
               "Saeta Hav\u015fn\u00ea ya Japonyay\u00ea",
               "JDT",
               "Saeta Japonyay\u00ea",
               "JT",
            };
        final String[] Korea = new String[] {
               "Saeta Standard a Korey\u00ea",
               "KST",
               "Saeta Hav\u00een\u00ea ya Korey\u00ea",
               "KST",
               "Saeta Korey\u00ea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Saeta Na\u00fbr\u00fby\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Saeta Nepal\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Saeta Palauy\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Saeta Standard a Samoay\u00ea",
               "SST",
               "Saeta Hav\u00een\u00ea ya Samoay\u00ea",
               "SST",
               "Saeta Samoay\u00ea",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Saeta Syoway\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Saeta Standard a Tongay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Tongay\u00ea",
               "",
               "Saeta Tongay\u00ea",
               "",
            };
        final String[] Yukon = new String[] {
               "Saeta Yukon\u00ea",
               "SY",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Saeta Standard a Alaskay\u00ea",
               "SSAK",
               "Saeta Hav\u00een\u00ea ya Alaskay\u00ea",
               "SHAK",
               "Saeta Alaskay\u00ea",
               "SAK",
            };
        final String[] Amazon = new String[] {
               "Saeta Standard a Amazon\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Amazon\u00ea",
               "",
               "Saeta Amazon\u00ea",
               "",
            };
        final String[] Azores = new String[] {
               "Saeta Standard a Azoran",
               "HMT",
               "Saeta Hav\u00een\u00ea ya Azoran",
               "HMT",
               "Saeta Azoran",
               "HMT",
            };
        final String[] Bhutan = new String[] {
               "Saeta B\u00fbtan\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Saeta Br\u00fbney Darusselam\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Saeta Standard a Girava Paskalyay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Girava Paskalyay\u00ea",
               "",
               "Saeta Girava Paskalyay\u00ea",
               "",
            };
        final String[] Guyana = new String[] {
               "Saeta Guyanay\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Saeta Standard a \u00cesra\u00eel\u00ea",
               "IST",
               "Saeta Hav\u00een\u00ea ya \u00cesra\u00eel\u00ea",
               "IDT",
               "Saeta \u00cesra\u00eel\u00ea",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Saeta Kosraey\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Saeta Mawson\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Saeta Standard a Moskovay\u00ea",
               "MSK",
               "Saeta Hav\u00een\u00ea ya Moskovay\u00ea",
               "MSK",
               "Saeta Moskovay\u00ea",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Saeta Ponapey\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Saeta Tah\u00eetiy\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Saeta Standard a Ta\u00eepeiy\u00ea",
               "CST",
               "Saeta Hav\u00een\u00ea ya Ta\u00eepeiy\u00ea",
               "CDT",
               "Saeta Ta\u00eepeiy\u00ea",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Saeta T\u00fbval\u00fby\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Saeta Vostok\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Saeta Wallis \u00fb Futunay\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Saeta Standard a Erebistan\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Erebistan\u00ea",
               "",
               "Saeta Erebistan\u00ea",
               "",
            };
        final String[] Armenia = new String[] {
               "Saeta Standard a Ermenistan\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Ermenistan\u00ea",
               "",
               "Saeta Ermenistan\u00ea",
               "",
            };
        final String[] Bolivia = new String[] {
               "Saeta Bol\u00eevyay\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Saeta Standard a Chatham\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Chatham\u00ea",
               "",
               "Saeta Chatham\u00ea",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Saeta Gerd\u00fbn\u00ee ya Hevdem\u00ee",
               "SGH",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Saeta Ekwador\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Saeta Gambier\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Saeta Standard a Gurcistan\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Gurcistan\u00ea",
               "",
               "Saeta Gurcistan\u00ea",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Saeta Standard a Irkutsk\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Irkutsk\u00ea",
               "",
               "Saeta Irkutsk\u00ea",
               "",
            };
        final String[] Magadan = new String[] {
               "Saeta Standard a Magadan\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Magadan\u00ea",
               "",
               "Saeta Magadan\u00ea",
               "",
            };
        final String[] Myanmar = new String[] {
               "Saeta Myanmar\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Saeta Standard a Girava Norfolk\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Girava Norfolk\u00ea",
               "",
               "Saeta Girava Norfolk\u00ea",
               "",
            };
        final String[] Noronha = new String[] {
               "Saeta Standard a Fernando de Noronhay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Fernando de Noronhay\u00ea",
               "",
               "Saeta Fernando de Noronhay\u00ea",
               "",
            };
        final String[] Reunion = new String[] {
               "Saeta R\u00e9union\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Saeta Rotheray\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Saeta Girav\u00ean Solomon\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Saeta Tokelauy\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Saeta Standard a \u00dbr\u00fbg\u00fbay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya \u00dbr\u00fbg\u00fbay\u00ea",
               "",
               "Saeta \u00dbr\u00fbg\u00fbay\u00ea",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Saeta Standard a Van\u00fbat\u00fby\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Van\u00fbat\u00fby\u00ea",
               "",
               "Saeta Van\u00fbat\u00fby\u00ea",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Saeta Standard a Yakutsk\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Yakutsk\u00ea",
               "",
               "Saeta Yakutsk\u00ea",
               "",
            };
        final String[] Atlantic = new String[] {
               "Saeta Standard a Atlant\u00eek\u00ea",
               "SSA",
               "Saeta Hav\u00een\u00ea ya Atlant\u00eek\u00ea",
               "SHA",
               "Saeta Atlant\u00eek\u00ea",
               "SA",
            };
        final String[] Brasilia = new String[] {
               "Saeta Standard a Bras\u00eelyay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Bras\u00eelyay\u00ea",
               "",
               "Saeta Bras\u00eelyay\u00ea",
               "",
            };
        final String[] Chamorro = new String[] {
               "Saeta Standard a Chamorroy\u00ea",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Saeta Standard a Kolombiyay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Kolombiyay\u00ea",
               "",
               "Saeta Kolombiyay\u00ea",
               "",
            };
        final String[] Falkland = new String[] {
               "Saeta Standard a Girav\u00ean Falkland\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Girav\u00ean Falkland\u00ea",
               "",
               "Saeta Girav\u00ean Falkland\u00ea",
               "",
            };
        final String[] Malaysia = new String[] {
               "Saeta Malezyay\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Saeta Mald\u00eevan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Saeta Standard a \u00dblanbatar\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya \u00dblanbatar\u00ea",
               "",
               "Saeta \u00dblanbatar\u00ea",
               "",
            };
        final String[] Pakistan = new String[] {
               "Saeta Standard a Pakistan\u00ea",
               "PKT",
               "Saeta Hav\u00een\u00ea ya Pakistan\u00ea",
               "PKST",
               "Saeta Pakistan\u00ea",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Saeta Standard a Parag\u00fbay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Parag\u00fbay\u00ea",
               "",
               "Saeta Parag\u00fbay\u00ea",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Saeta Pitcairn\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Saeta Standard a Saxal\u00een\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Saxal\u00een\u00ea",
               "",
               "Saeta Saxal\u00een\u00ea",
               "",
            };
        final String[] Suriname = new String[] {
               "Saeta Sur\u00eenam\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Saeta Standard a Arjant\u00een\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Arjant\u00een\u00ea",
               "",
               "Saeta Arjant\u00een\u00ea",
               "",
            };
        final String[] Christmas = new String[] {
               "Saeta Girava Christmas\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Saeta Galapagos\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Saeta Standard a Hong Kong\u00ea",
               "HKT",
               "Saeta Hav\u00een\u00ea ya Hong Kong\u00ea",
               "HKST",
               "Saeta Hong Kong\u00ea",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Saeta Hindi\u00e7\u00een\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Saeta Qirxizistan\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Saeta Standard a Lord Howey\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Lord Howey\u00ea",
               "",
               "Saeta Lord Howey\u00ea",
               "",
            };
        final String[] Marquesas = new String[] {
               "Saeta Marquesas\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Saeta Standard a Mauritius\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Mauritius\u00ea",
               "",
               "Saeta Mauritius\u00ea",
               "",
            };
        final String[] Singapore = new String[] {
               "Saeta Standard a S\u00eengap\u00fbr\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Saeta Venez\u00fbelay\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Saeta Standard a Volgograd\u00ea",
               "MSK",
               "Saeta Hav\u00een\u00ea ya Volgograd\u00ea",
               "MSK",
               "Saeta Volgograd\u00ea",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Saeta Standard a Azerbeycan\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Azerbeycan\u00ea",
               "",
               "Saeta Azerbeycan\u00ea",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Saeta Standard a Benglade\u015f\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Benglade\u015f\u00ea",
               "",
               "Saeta Benglade\u015f\u00ea",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Saeta Standard a Cape Verdey\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Cape Verdey\u00ea",
               "",
               "Saeta Cape Verdey\u00ea",
               "",
            };
        final String[] East_Timor = new String[] {
               "Saeta T\u00eem\u00fbra Rojhilat",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Saeta Sey\u015feler\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Saeta Tacikistan\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Saeta Standard a Ozbekistan\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Ozbekistan\u00ea",
               "",
               "Saeta Ozbekistan\u00ea",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Saeta Efxanistan\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Saeta Standard a Krasnoyarsk\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Krasnoyarsk\u00ea",
               "",
               "Saeta Krasnoyarsk\u00ea",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Saeta Standard a Zelandaya N\u00fb",
               "NZST",
               "Saeta Hav\u00een\u00ea ya Zelandaya N\u00fb",
               "NZDT",
               "Saeta Zelandaya N\u00fb",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Saeta Standard a Novosibirsk\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Novosibirsk\u00ea",
               "",
               "Saeta Novosibirsk\u00ea",
               "",
            };
        final String[] Philippines = new String[] {
               "Saeta Standard a F\u00eel\u00eep\u00een\u00ea",
               "PST",
               "Saeta Hav\u00een\u00ea ya F\u00eel\u00eep\u00een\u00ea",
               "PDT",
               "Saeta F\u00eel\u00eep\u00een\u00ea",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Saeta Standard a Vladivostok\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Vladivostok\u00ea",
               "",
               "Saeta Vladivostok\u00ea",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Saeta Okyan\u00fbsa Hind\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Saeta Girav\u00ean L\u00eeney\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Saeta Standard a Newfoundland\u00ea",
               "SSNF",
               "Saeta Hav\u00een\u00ea ya Newfoundland\u00ea",
               "SHNF",
               "Saeta Newfoundland\u00ea",
               "SNF",
            };
        final String[] Turkmenistan = new String[] {
               "Saeta Standard a Tirkmenistan\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Tirkmenistan\u00ea",
               "",
               "Saeta Tirkmenistan\u00ea",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Saeta Guiyanaya Frans\u00ee",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Saeta Standard a Kaledonyaya N\u00fb",
               "",
               "Saeta Hav\u00een\u00ea ya Kaledonyaya N\u00fb",
               "",
               "Saeta Kaledonyaya N\u00fb",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Saeta Georgiaya Ba\u015f\u00fbr",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Saeta Standard a Yekaterinburg\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Yekaterinburg\u00ea",
               "",
               "Saeta Yekaterinburg\u00ea",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Saeta Afr\u00eekaya Nav\u00een",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] Africa_Eastern = new String[] {
               "Saeta Afr\u00eekaya Rojhilat",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Saeta Standard a Afr\u00eekaya Rojava",
               "WAT",
               "Saeta Hav\u00een\u00ea ya Afr\u00eekaya Rojava",
               "WAT",
               "Saeta Afr\u00eekaya Rojava",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Saeta Dumont-d\u2019Urvilley\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Saeta Standard a Ewropaya Nav\u00een",
               "CET",
               "Saeta Hav\u00een\u00ea ya Ewropaya Nav\u00een",
               "CEST",
               "Saeta Ewropaya Nav\u00een",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Saeta Standard a Ewropaya Rojhilat",
               "EET",
               "Saeta Hav\u00een\u00ea ya Ewropaya Rojhilat",
               "EEST",
               "Saeta Ewropaya Rojhilat",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Saeta Standard a Ewropaya Rojava",
               "FMT",
               "Saeta Hav\u00een\u00ea ya Ewropaya Rojava",
               "FMT",
               "Saeta Ewropaya Rojava",
               "FMT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Saeta Standard a Pas\u00eef\u00eeka Meks\u00eekay\u00ea",
               "SSPM",
               "Saeta Hav\u00een\u00ea ya Pas\u00eef\u00eeka Meks\u00eekay\u00ea",
               "SHPM",
               "Saeta Pas\u00eef\u00eeka Meks\u00eekay\u00ea",
               "SPM",
            };
        final String[] Africa_Southern = new String[] {
               "Saeta Standard a Afr\u00eekaya Ba\u015f\u00fbr",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Saeta Standard a Navend\u00ee ya Amer\u00eekaya Bakur",
               "SSN",
               "Saeta Hav\u00een\u00ea ya Navend\u00ee ya Amer\u00eekaya Bakur",
               "SHN",
               "Saeta Navend\u00ee ya Amer\u00eekaya Bakur",
               "SN",
            };
        final String[] America_Eastern = new String[] {
               "Saeta Standard a Rojhilat ya Amer\u00eekaya Bakur",
               "SSR",
               "Saeta Hav\u00een\u00ea ya Rojhilat ya Amer\u00eekaya Bakur",
               "SHR",
               "Saeta Rojhilat a Amer\u00eekaya Bakur",
               "SR",
            };
        final String[] America_Pacific = new String[] {
               "Saeta Standard a Pas\u00eef\u00eek\u00ea ya Amer\u00eekaya Bakur",
               "SSP",
               "Saeta Hav\u00een\u00ea ya Pas\u00eef\u00eek\u00ea ya Amer\u00eekaya Bakur",
               "SHP",
               "Saeta Pas\u00eef\u00eek\u00ea ya Amer\u00eekaya Bakur",
               "SP",
            };
        final String[] French_Southern = new String[] {
               "Saeta Antarkt\u00eeka \u00fb Ba\u015f\u00fbr\u00ea Fransay\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Saeta Girav\u00ean Gilbert\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Saeta Standard a Hawaii-Aleutian\u00ea",
               "SSHA",
               "Saeta Hav\u00een\u00ea ya Hawaii-Aleutian\u00ea",
               "SHHA",
               "Saeta Hawaii-Aleutian\u00ea",
               "SHAL",
            };
        final String[] Phoenix_Islands = new String[] {
               "Saeta Girav\u00ean Phoen\u00eeks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saeta Standard a Saint Pierre \u00fb Miquelon\u00ea",
               "SSSPM",
               "Saeta Hav\u00een\u00ea ya Saint Pierre \u00fb Miquelon\u00ea",
               "SHSPM",
               "Saeta Saint Pierre \u00fb Miquelon\u00ea",
               "SSPM",
            };
        final String[] America_Mountain = new String[] {
               "Saeta Standard a \u00c7iyay\u00ee ya Amer\u00eekaya Bakur",
               "SS\u00c7",
               "Saeta Hav\u00een\u00ea ya \u00c7iyay\u00ee ya Amer\u00eekaya Bakur",
               "SH\u00c7",
               "Saeta \u00c7iyay\u00ee ya Amer\u00eekaya Bakur",
               "S\u00c7",
            };
        final String[] Marshall_Islands = new String[] {
               "Saeta Girav\u00ean Mar\u015fal\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Saeta Standard a Meks\u00eekoya Bakurrojava",
               "SSMBR",
               "Saeta Hav\u00een\u00ea ya Meks\u00eekoya Bakurrojava",
               "SHMBR",
               "Saeta Meks\u00eekoya Bakurrojava",
               "SMBR",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Saeta G\u00eeneya N\u00fb ya Pap\u00fbay\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Saeta Standard a Awistralyaya Nav\u00een",
               "ACST",
               "Saeta Hav\u00een\u00ea ya Awistralyaya Nav\u00een",
               "ACDT",
               "Saeta Awistralyaya Nav\u00een",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Saeta Standard a Awistralyaya Rojhilat",
               "AEST",
               "Saeta Hav\u00een\u00ea ya Awistralyaya Rojhilat",
               "AEDT",
               "Saeta Awistralyaya Rojhilat",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Saeta Standard a Awistralyaya Rojava",
               "",
               "Saeta Hav\u00een\u00ea ya Awistralyaya Rojava",
               "",
               "Saeta Awistralyaya Rojava",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Saeta Standard a Gr\u00eenlanda Rojhilat",
               "SSGR",
               "Saeta Hav\u00een\u00ea ya Gr\u00eenlanda Rojhilat",
               "SHGR",
               "Saeta Gr\u00eenlanda Rojhilat",
               "SGR",
            };
        final String[] Greenland_Western = new String[] {
               "Saeta Standard a Gr\u00eenlanda Rojava",
               "SSGRO",
               "Saeta Hav\u00een\u00ea ya Gr\u00eenlanda Rojava",
               "SHGRO",
               "Saeta Gr\u00eenlanda Rojava",
               "SGRO",
            };
        final String[] Indonesia_Central = new String[] {
               "Saeta Endonezyaya Nav\u00een",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Saeta Endonezyaya Rojhilat",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Saeta Endonezyaya Rojava",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Saeta Qazaxistana Rojhilat",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Saeta Qazaxistana Rojava",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Saeta Standard a Rojavaya Nav\u00een a Awistralyay\u00ea",
               "",
               "Saeta Hav\u00een\u00ea ya Rojavaya Nav\u00een a Awistralyay\u00ea",
               "",
               "Saeta Rojavaya Nav\u00een a Awistralyay\u00ea",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Saeta Nav\u00een\u00ee ya Greenwich\u00ea",
                    "GMT",
                    "Saeta Standard a \u00cerlanday\u00ea",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Saeta Nav\u00een\u00ee ya Greenwich\u00ea",
                    "GMT",
                    "Saeta Hav\u00een\u00ea ya Bir\u00eetanyay\u00ea",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Saeta Nav\u00een\u00ee ya Greenwich\u00ea",
                    "GMT",
                    "Saeta Hav\u00een\u00ea ya Bir\u00eetanyay\u00ea",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bak\u00fb" },
            { "timezone.excity.Asia/Dili", "D\u00eel\u00ee" },
            { "timezone.excity.Asia/Gaza", "Xeze" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Eman" },
            { "timezone.excity.Asia/Aqtau", "Aqtaw" },
            { "timezone.excity.Asia/Chita", "\u00c7\u00eeta" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Dubai", "D\u00fbba\u00ee" },
            { "timezone.excity.Asia/Kabul", "Kab\u00fbl" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Qeter" },
            { "timezone.excity.Asia/Seoul", "Se\u00fbl" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Cuba" },
            { "timezone.excity.Asia/Almaty", "Almat\u00ee" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Atyrau", "At\u00eerav" },
            { "timezone.excity.Asia/Beirut", "Beyr\u00fbt" },
            { "timezone.excity.Asia/Brunei", "Br\u00fbney" },
            { "timezone.excity.Asia/Kuwait", "Kuweyt" },
            { "timezone.excity.Asia/Manila", "Man\u00eela" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "Bajar\u00ea Ho Chi Minh\u00ea" },
            { "timezone.excity.Asia/Taipei", "Ta\u00eepe\u00ee" },
            { "timezone.excity.Asia/Urumqi", "\u00dbr\u00fbm\u00e7\u00ee" },
            { "timezone.excity.Etc/Unknown", "Bajar\u00ea Nenas" },
            { "timezone.excity.Europe/Kiev", "K\u00eeev" },
            { "timezone.excity.Europe/Riga", "R\u00eega" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Qah\u00eere" },
            { "timezone.excity.Africa/Ceuta", "Septe" },
            { "timezone.excity.Africa/Tunis", "T\u00fbnis" },
            { "timezone.excity.Asia/Baghdad", "Bexda" },
            { "timezone.excity.Asia/Bahrain", "Behreyn" },
            { "timezone.excity.Asia/Bishkek", "B\u00ee\u015fkek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Jakarta", "Cakarta" },
            { "timezone.excity.Asia/Karachi", "Kara\u00e7\u00ee" },
            { "timezone.excity.Asia/Kuching", "K\u00fb\u00e7\u00eeng" },
            { "timezone.excity.Asia/Nicosia", "Lefko\u015fe" },
            { "timezone.excity.Asia/Tbilisi", "Tifl\u00ees" },
            { "timezone.excity.Asia/Yerevan", "Rewan" },
            { "timezone.excity.Europe/Kirov", "K\u00eerov" },
            { "timezone.excity.Europe/Minsk", "M\u00eensk" },
            { "timezone.excity.Europe/Paris", "Par\u00ees" },
            { "timezone.excity.Europe/Sofia", "Sofya" },
            { "timezone.excity.Pacific/Fiji", "F\u00eej\u00ee" },
            { "timezone.excity.Africa/Kigali", "K\u00eegal\u00ee" },
            { "timezone.excity.Africa/Maseru", "Maser\u00fb" },
            { "timezone.excity.America/Aruba", "Ar\u00fbba" },
            { "timezone.excity.Asia/Ashgabat", "E\u015fqabat" },
            { "timezone.excity.Asia/Damascus", "\u015eam" },
            { "timezone.excity.Asia/Dushanbe", "Du\u015fenbe" },
            { "timezone.excity.Asia/Jayapura", "Cayap\u00fbra" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fb" },
            { "timezone.excity.Asia/Khandyga", "Xand\u00eega" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Sakhalin", "Saxal\u00een" },
            { "timezone.excity.Asia/Shanghai", "\u015eanghay" },
            { "timezone.excity.Asia/Tashkent", "Ta\u015fkent" },
            { "timezone.excity.Asia/Ust-Nera", "\u00dbst-Nera" },
            { "timezone.excity.Europe/Athens", "At\u00eena" },
            { "timezone.excity.Europe/Berlin", "Berl\u00een" },
            { "timezone.excity.Europe/Dublin", "D\u00fbbl\u00een" },
            { "timezone.excity.Europe/Lisbon", "L\u00eezbon" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Madrid", "Madr\u00eed" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskova" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Skopje", "Uskup" },
            { "timezone.excity.Europe/Tirane", "T\u00eeran" },
            { "timezone.excity.Europe/Vienna", "Viyana" },
            { "timezone.excity.Europe/Warsaw", "War\u015fova" },
            { "timezone.excity.Europe/Zurich", "Z\u00fbr\u00eeh" },
            { "timezone.excity.Indian/Comoro", "Komor" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Cezay\u00eer" },
            { "timezone.excity.Africa/Conakry", "Konakr\u00ee" },
            { "timezone.excity.Africa/Nairobi", "Na\u00eerob\u00ee" },
            { "timezone.excity.Africa/Tripoli", "Trabl\u00fbs" },
            { "timezone.excity.America/Belize", "Bel\u00eeze" },
            { "timezone.excity.America/Cancun", "Canc\u00fbn" },
            { "timezone.excity.America/Merida", "Mer\u00eeda" },
            { "timezone.excity.Asia/Jerusalem", "Quds" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u00e7atka" },
            { "timezone.excity.Asia/Qyzylorda", "Qizilorda" },
            { "timezone.excity.Asia/Samarkand", "Semerkand" },
            { "timezone.excity.Asia/Singapore", "S\u00eengap\u00fbr" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Tallinn", "Tal\u00een" },
            { "timezone.excity.Europe/Vatican", "Vat\u00eekan" },
            { "timezone.excity.Europe/Vilnius", "V\u00eeln\u00fbs" },
            { "timezone.excity.Pacific/Easter", "Girava Paskalyay\u00ea" },
            { "timezone.excity.Pacific/Tahiti", "Tah\u00eet\u00ee" },
            { "timezone.excity.Africa/Djibouti", "Cib\u00fbt\u00ee" },
            { "timezone.excity.Africa/Khartoum", "Xart\u00fbm" },
            { "timezone.excity.Africa/Kinshasa", "K\u00een\u015fasa" },
            { "timezone.excity.America/Jamaica", "Jama\u00eeka" },
            { "timezone.excity.Asia/Choibalsan", "\u00c7oybalsan" },
            { "timezone.excity.Atlantic/Azores", "Girav\u00ean Azor\u00ea" },
            { "timezone.excity.Atlantic/Canary", "Girav\u00ean Kanaryay\u00ea" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Bruksel" },
            { "timezone.excity.Europe/Budapest", "B\u00fbdape\u015ft" },
            { "timezone.excity.Europe/Busingen", "B\u00fbs\u00eengen" },
            { "timezone.excity.Europe/Chisinau", "Ki\u015f\u00eenew" },
            { "timezone.excity.Europe/Helsinki", "Hels\u00eenk\u00ee" },
            { "timezone.excity.Europe/Istanbul", "Stenbol" },
            { "timezone.excity.Europe/Sarajevo", "Saraybosna" },
            { "timezone.excity.Europe/Uzhgorod", "Ujgorod" },
            { "timezone.excity.Indian/Maldives", "Mald\u00eev" },
            { "timezone.excity.Africa/Mogadishu", "Mogad\u00ee\u015f\u00fb" },
            { "timezone.excity.America/Dominica", "Dom\u00een\u00eeka" },
            { "timezone.excity.Antarctica/Davis", "Dav\u00ees" },
            { "timezone.excity.Asia/Ulaanbaatar", "\u00dblanbatar" },
            { "timezone.excity.Atlantic/Bermuda", "Berm\u00fbda" },
            { "timezone.excity.Australia/Sydney", "S\u00eedney" },
            { "timezone.excity.Europe/Astrakhan", "Astraxan" },
            { "timezone.excity.Europe/Bucharest", "Bukre\u015f" },
            { "timezone.excity.Europe/Gibraltar", "G\u00eebraltar" },
            { "timezone.excity.Europe/Podgorica", "Podgor\u00eeka" },
            { "timezone.excity.Europe/Stockholm", "Stokholm" },
            { "timezone.excity.Africa/Casablanca", "Kazablanka" },
            { "timezone.excity.Africa/Libreville", "L\u00eebrev\u00eel" },
            { "timezone.excity.Asia/Kuala_Lumpur", "K\u00fbala L\u00fbmp\u00fbr" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhag" },
            { "timezone.excity.Europe/Luxembourg", "Luksemb\u00fbrg" },
            { "timezone.excity.Europe/San_Marino", "San Mar\u00eeno" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporojye" },
            { "timezone.excity.America/Costa_Rica", "Kosta R\u00eeka" },
            { "timezone.excity.Europe/Isle_of_Man", "Girava Man\u00ea" },
            { "timezone.excity.Europe/Kaliningrad", "Kal\u00een\u00eengrad" },
            { "timezone.excity.America/Puerto_Rico", "Porto R\u00eeko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daruselam" },
            { "timezone.excity.America/Ciudad_Juarez", "Ci\u00fbdad Juarez" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barthelemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eea Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgiaya Ba\u015f\u00fbr" },
            { "timezone.excity.America/North_Dakota/Beulah", "Be\u00fblah, Dakotaya Bakur" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakotaya Bakur" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakotaya Bakur" },
        };
        return data;
    }
}
