"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiCodeBlockImpl", {
  enumerable: true,
  get: function get() {
    return _code_block.EuiCodeBlockImpl;
  }
});
exports.OuiCodeBlockImpl = exports.PADDING_SIZES = exports.FONT_SIZES = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _refractor = require("refractor");

var _services = require("../../services");

var _button = require("../button");

var _common = require("../common");

var _copy = require("../copy");

var _focus_trap = require("../focus_trap");

var _i18n = require("../i18n");

var _inner_text = require("../inner_text");

var _mutation_observer = require("../observer/mutation_observer");

var _resize_observer = require("../observer/resize_observer");

var _overlay_mask = require("../overlay_mask");

var _code_block = require("../../eui_components/code/_code_block");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                   * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                   * compatible open source license.
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                   * GitHub history for details.
                                                                                                                                                                                                                   */ /*
                                                                                                                                                                                                                       * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                       * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                       * this work for additional information regarding copyright
                                                                                                                                                                                                                       * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                       * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                       * not use this file except in compliance with the License.
                                                                                                                                                                                                                       * You may obtain a copy of the License at
                                                                                                                                                                                                                       *
                                                                                                                                                                                                                       *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                       *
                                                                                                                                                                                                                       * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                       * software distributed under the License is distributed on an
                                                                                                                                                                                                                       * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                       * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                       * specific language governing permissions and limitations
                                                                                                                                                                                                                       * under the License.
                                                                                                                                                                                                                       */

var isAstElement = function isAstElement(node) {
  return node.hasOwnProperty('type') && node.type === 'element';
};

var nodeToHtml = function nodeToHtml(node, idx, nodes) {
  var depth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

  if (isAstElement(node)) {
    var properties = node.properties,
        tagName = node.tagName,
        children = node.children;
    return /*#__PURE__*/_react.default.createElement(tagName, _objectSpread(_objectSpread({}, properties), {}, {
      key: "node-".concat(depth, "-").concat(idx),
      className: (0, _classnames.default)(properties.className)
    }), children && children.map(function (el, i) {
      return nodeToHtml(el, i, nodes, depth + 1);
    }));
  }

  return node.value;
};

var addLineData = function addLineData(nodes) {
  var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    lineNumber: 1
  };
  return nodes.reduce(function (result, node) {
    var lineStart = data.lineNumber;

    if (node.type === 'text') {
      if (!node.value.match(/\r\n?|\n/)) {
        node.lineStart = lineStart;
        node.lineEnd = lineStart;
        result.push(node);
      } else {
        var lines = node.value.split(/\r\n?|\n/);
        lines.forEach(function (line, i) {
          var num = i === 0 ? data.lineNumber : ++data.lineNumber;
          result.push({
            type: 'text',
            value: i === lines.length - 1 ? line : "".concat(line, "\n"),
            lineStart: num,
            lineEnd: num
          });
        });
      }

      return result;
    }

    if (node.children && node.children.length) {
      var _first$lineStart, _last$lineEnd;

      var children = addLineData(node.children, data);
      var first = children[0];
      var last = children[children.length - 1];
      var start = (_first$lineStart = first.lineStart) !== null && _first$lineStart !== void 0 ? _first$lineStart : lineStart;
      var end = (_last$lineEnd = last.lineEnd) !== null && _last$lineEnd !== void 0 ? _last$lineEnd : lineStart;

      if (start !== end) {
        children.forEach(function (node) {
          result.push(node);
        });
      } else {
        node.lineStart = start;
        node.lineEnd = end;
        node.children = children;
        result.push(node);
      }

      return result;
    }

    result.push(node);
    return result;
  }, []);
};

function wrapLines(nodes) {
  var grouped = [];
  nodes.forEach(function (node) {
    var lineStart = node.lineStart - 1;

    if (grouped[lineStart]) {
      grouped[lineStart].push(node);
    } else {
      grouped[lineStart] = [node];
    }
  });
  var wrapped = [];
  grouped.forEach(function (node) {
    wrapped.push({
      type: 'element',
      tagName: 'span',
      properties: {
        className: ['ouiCodeBlock__line']
      },
      children: node
    });
  });
  return wrapped;
}

var highlightByLine = function highlightByLine(children, language) {
  return wrapLines(addLineData((0, _refractor.highlight)(children, language)));
};

var fontSizeToClassNameMap = {
  s: 'ouiCodeBlock--fontSmall',
  m: 'ouiCodeBlock--fontMedium',
  l: 'ouiCodeBlock--fontLarge'
};
var FONT_SIZES = (0, _common.keysOf)(fontSizeToClassNameMap);
exports.FONT_SIZES = FONT_SIZES;
var paddingSizeToClassNameMap = {
  none: '',
  s: 'ouiCodeBlock--paddingSmall',
  m: 'ouiCodeBlock--paddingMedium',
  l: 'ouiCodeBlock--paddingLarge'
};
var PADDING_SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
exports.PADDING_SIZES = PADDING_SIZES;

/**
 * This is the base component extended by OuiCode and OuiCodeBlock.
 * These components share the same propTypes definition with OuiCodeBlockImpl.
 */
var OuiCodeBlockImpl = function OuiCodeBlockImpl(_ref) {
  var _ref$transparentBackg = _ref.transparentBackground,
      transparentBackground = _ref$transparentBackg === void 0 ? false : _ref$transparentBackg,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? 's' : _ref$fontSize,
      _ref$isCopyable = _ref.isCopyable,
      isCopyable = _ref$isCopyable === void 0 ? false : _ref$isCopyable,
      _ref$whiteSpace = _ref.whiteSpace,
      whiteSpace = _ref$whiteSpace === void 0 ? 'pre-wrap' : _ref$whiteSpace,
      language = _ref.language,
      inline = _ref.inline,
      children = _ref.children,
      className = _ref.className,
      overflowHeight = _ref.overflowHeight,
      rest = _objectWithoutProperties(_ref, ["transparentBackground", "paddingSize", "fontSize", "isCopyable", "whiteSpace", "language", "inline", "children", "className", "overflowHeight"]);

  var _useState = (0, _react.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      isFullScreen = _useState2[0],
      setIsFullScreen = _useState2[1];

  var _useState3 = (0, _react.useState)(null),
      _useState4 = _slicedToArray(_useState3, 2),
      wrapperRef = _useState4[0],
      setWrapperRef = _useState4[1];

  var _useInnerText = (0, _inner_text.useInnerText)(''),
      _useInnerText2 = _slicedToArray(_useInnerText, 2),
      innerTextRef = _useInnerText2[0],
      _innerText = _useInnerText2[1];

  var innerText = (0, _react.useMemo)(function () {
    return _innerText === null || _innerText === void 0 ? void 0 : _innerText.replace(/[\r\n?]{2}|\n\n/g, '\n');
  }, [_innerText]);

  var _useState5 = (0, _react.useState)(-1),
      _useState6 = _slicedToArray(_useState5, 2),
      tabIndex = _useState6[0],
      setTabIndex = _useState6[1];

  var combinedRef = (0, _services.useCombinedRefs)([innerTextRef, setWrapperRef]);

  var _useResizeObserver = (0, _resize_observer.useResizeObserver)(wrapperRef),
      width = _useResizeObserver.width,
      height = _useResizeObserver.height;

  var content = (0, _react.useMemo)(function () {
    if (!language || typeof children !== 'string') {
      return children;
    }

    var nodes = inline ? (0, _refractor.highlight)(children, language) : highlightByLine(children, language);
    return nodes.length === 0 ? children : nodes.map(nodeToHtml);
  }, [children, language, inline]);

  var doesOverflow = function doesOverflow() {
    if (!wrapperRef) return;
    var clientWidth = wrapperRef.clientWidth,
        clientHeight = wrapperRef.clientHeight,
        scrollWidth = wrapperRef.scrollWidth,
        scrollHeight = wrapperRef.scrollHeight;
    var doesOverflow = scrollHeight > clientHeight || scrollWidth > clientWidth;
    setTabIndex(doesOverflow ? 0 : -1);
  };

  (0, _mutation_observer.useMutationObserver)(wrapperRef, doesOverflow, {
    subtree: true,
    childList: true
  });
  (0, _react.useEffect)(doesOverflow, [width, height, wrapperRef]);

  var onKeyDown = function onKeyDown(event) {
    if (event.key === _services.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      closeFullScreen();
    }
  };

  var toggleFullScreen = function toggleFullScreen() {
    setIsFullScreen(!isFullScreen);
  };

  var closeFullScreen = function closeFullScreen() {
    setIsFullScreen(false);
  };

  var classes = (0, _classnames.default)('ouiCodeBlock', fontSizeToClassNameMap[fontSize], paddingSizeToClassNameMap[paddingSize], {
    'ouiCodeBlock--transparentBackground': transparentBackground,
    'ouiCodeBlock--inline': inline,
    'ouiCodeBlock--hasControls': isCopyable || overflowHeight
  }, _defineProperty({
    prismjs: !(className === null || className === void 0 ? void 0 : className.includes('prismjs'))
  }, "language-".concat(language || 'none'), !(className === null || className === void 0 ? void 0 : className.includes('language'))), className);
  var codeClasses = (0, _classnames.default)('ouiCodeBlock__code', language);
  var preClasses = (0, _classnames.default)('ouiCodeBlock__pre', {
    'ouiCodeBlock__pre--whiteSpacePre': whiteSpace === 'pre',
    'ouiCodeBlock__pre--whiteSpacePreWrap': whiteSpace === 'pre-wrap'
  });
  var optionalStyles = {};

  if (overflowHeight) {
    optionalStyles.maxHeight = overflowHeight;
  }

  var codeSnippet = /*#__PURE__*/_react.default.createElement("code", _extends({
    className: codeClasses
  }, rest), content);

  var wrapperProps = {
    className: classes,
    style: optionalStyles
  };

  if (inline) {
    return /*#__PURE__*/_react.default.createElement("span", wrapperProps, codeSnippet);
  }

  var getCopyButton = function getCopyButton(textToCopy) {
    var copyButton;

    if (isCopyable && textToCopy) {
      copyButton = /*#__PURE__*/_react.default.createElement("div", {
        className: "ouiCodeBlock__copyButton"
      }, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        token: "ouiCodeBlock.copyButton",
        default: "Copy"
      }, function (copyButton) {
        return /*#__PURE__*/_react.default.createElement(_copy.OuiCopy, {
          textToCopy: textToCopy
        }, function (copy) {
          return /*#__PURE__*/_react.default.createElement(_button.OuiButtonIcon, {
            onClick: copy,
            iconType: "copy",
            color: "text",
            "aria-label": copyButton
          });
        });
      }));
    }

    return copyButton;
  };

  var fullScreenButton;

  if (!inline && overflowHeight) {
    fullScreenButton = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      tokens: ['ouiCodeBlock.fullscreenCollapse', 'ouiCodeBlock.fullscreenExpand'],
      defaults: ['Collapse', 'Expand']
    }, function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
          fullscreenCollapse = _ref3[0],
          fullscreenExpand = _ref3[1];

      return /*#__PURE__*/_react.default.createElement(_button.OuiButtonIcon, {
        className: "ouiCodeBlock__fullScreenButton",
        onClick: toggleFullScreen,
        iconType: isFullScreen ? 'cross' : 'fullScreen',
        color: "text",
        "aria-label": isFullScreen ? fullscreenCollapse : fullscreenExpand
      });
    });
  }

  var getCodeBlockControls = function getCodeBlockControls(textToCopy) {
    var codeBlockControls;
    var copyButton = getCopyButton(textToCopy);

    if (copyButton || fullScreenButton) {
      codeBlockControls = /*#__PURE__*/_react.default.createElement("div", {
        className: "ouiCodeBlock__controls"
      }, fullScreenButton, copyButton);
    }

    return codeBlockControls;
  };

  var getFullScreenDisplay = function getFullScreenDisplay(codeBlockControls) {
    var fullScreenDisplay;

    if (isFullScreen) {
      // Force fullscreen to use large font and padding.
      var fullScreenClasses = (0, _classnames.default)('ouiCodeBlock', fontSizeToClassNameMap[fontSize], 'ouiCodeBlock-paddingLarge', 'ouiCodeBlock-isFullScreen', className);
      fullScreenDisplay = /*#__PURE__*/_react.default.createElement(_overlay_mask.OuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_focus_trap.OuiFocusTrap, {
        clickOutsideDisables: true
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: fullScreenClasses
      }, /*#__PURE__*/_react.default.createElement("pre", {
        className: preClasses,
        tabIndex: 0
      }, /*#__PURE__*/_react.default.createElement("code", {
        className: codeClasses,
        onKeyDown: onKeyDown
      }, content)), codeBlockControls)));
    }

    return fullScreenDisplay;
  };

  var codeBlockControls = getCodeBlockControls(innerText);
  return /*#__PURE__*/_react.default.createElement("div", wrapperProps, /*#__PURE__*/_react.default.createElement("pre", {
    ref: combinedRef,
    style: optionalStyles,
    className: preClasses,
    tabIndex: tabIndex
  }, codeSnippet), codeBlockControls, getFullScreenDisplay(codeBlockControls));
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiCodeBlockImpl = OuiCodeBlockImpl;
OuiCodeBlockImpl.propTypes = {
  className: _propTypes.default.string,
  fontSize: _propTypes.default.oneOf(["s", "m", "l"]),

  /**
     * Displays the passed code in an inline format. Also removes any margins set.
     */
  inline: _propTypes.default.bool,

  /**
     * Displays an icon button to copy the code snippet to the clipboard.
     */
  isCopyable: _propTypes.default.bool,

  /**
     * Sets the syntax highlighting for a specific language
     * @see https://github.com/wooorm/refractor#syntaxes
     * for options
     */
  language: _propTypes.default.string,
  overflowHeight: _propTypes.default.number,
  paddingSize: _propTypes.default.oneOf(["none", "s", "m", "l"]),
  transparentBackground: _propTypes.default.bool,

  /**
     * Specify how `white-space` inside the element is handled.
     * `pre` respects line breaks/white space but doesn't force them to wrap the line
     * `pre-wrap` respects line breaks/white space but does force them to wrap the line when necessary.
     */
  whiteSpace: _propTypes.default.oneOf(["pre", "pre-wrap"])
};
/* OUI -> EUI Aliases: Build-Time */