/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.resthandler.RestSearchMonitorActionKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.SearchMonitorRequest;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/opensearch/alerting/resthandler/RestSearchMonitorAction;", "Lorg/opensearch/rest/BaseRestHandler;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;)V", "filterBy", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "searchMonitorResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/action/search/SearchResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "opensearch-alerting"})
public final class RestSearchMonitorAction
extends BaseRestHandler {
    @NotNull
    private final Settings settings;
    private volatile Boolean filterBy;

    public RestSearchMonitorAction(@NotNull Settings settings, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.settings = settings;
        this.filterBy = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> RestSearchMonitorAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public String getName() {
        return "search_monitor_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI + "/_search", RestRequest.Method.POST, AlertingPlugin.LEGACY_OPENDISTRO_MONITOR_BASE_URI + "/_search"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, AlertingPlugin.MONITOR_BASE_URI + "/_search", RestRequest.Method.GET, AlertingPlugin.LEGACY_OPENDISTRO_MONITOR_BASE_URI + "/_search")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestSearchMonitorActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.MONITOR_BASE_URI + "/_search");
        String index = request.param("index", ".opendistro-alerting-config");
        if (!Intrinsics.areEqual((Object)index, (Object)".opendistro-alerting-config") && !Intrinsics.areEqual((Object)index, (Object)".opendistro-alerting-alert*")) {
            throw new IllegalArgumentException("Invalid index name.");
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestHandlerUtilsKt.context(request));
        String[] stringArray = new String[]{index};
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)searchRequest, (String)"searchRequest");
        SearchMonitorRequest searchMonitorRequest = new SearchMonitorRequest(searchRequest);
        return arg_0 -> RestSearchMonitorAction.prepareRequest$lambda$1(client, searchMonitorRequest, this, arg_0);
    }

    private final RestResponseListener<SearchResponse> searchMonitorResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<SearchResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public RestResponse buildResponse(@NotNull SearchResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.isTimedOut()) {
                    return (RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response2.toString());
                }
                try {
                    for (SearchHit hit : response2.getHits()) {
                        Closeable closeable = (Closeable)XContentType.JSON.xContent().createParser(this.$channel.request().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        Throwable throwable = null;
                        try {
                            XContentParser hitsParser = (XContentParser)closeable;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)hitsParser, (String)"hitsParser");
                            String string = hit.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hit.id");
                            ScheduledJob monitor = ScheduledJob.Companion.parse(hitsParser, string, hit.getVersion());
                            XContentBuilder xcb = monitor.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
                            SearchHit searchHit = hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }
                catch (Exception e) {
                    RestSearchMonitorActionKt.access$getLog$p().info("The monitor parsing failed. Will return response as is.");
                }
                return (RestResponse)new BytesRestResponse(RestStatus.OK, response2.toXContent(this.$channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }

    private static final void _init_$lambda$0(RestSearchMonitorAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterBy = it;
    }

    private static final void prepareRequest$lambda$1(NodeClient $client, SearchMonitorRequest $searchMonitorRequest, RestSearchMonitorAction this$0, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$searchMonitorRequest, (String)"$searchMonitorRequest");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ActionRequest actionRequest = (ActionRequest)$searchMonitorRequest;
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        $client.execute(AlertingActions.SEARCH_MONITORS_ACTION_TYPE, actionRequest, (ActionListener)this$0.searchMonitorResponse(channel));
    }
}

