/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.lock;

import java.io.IOException;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010B5\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018\u00a8\u0006#"}, d2={"Lorg/opensearch/alerting/core/lock/LockModel;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "copyLock", "seqNo", "", "primaryTerm", "(Lorg/opensearch/alerting/core/lock/LockModel;JJ)V", "released", "", "(Lorg/opensearch/alerting/core/lock/LockModel;Z)V", "updateLockTime", "Ljava/time/Instant;", "(Lorg/opensearch/alerting/core/lock/LockModel;Ljava/time/Instant;Z)V", "scheduledJobId", "", "lockTime", "(Ljava/lang/String;Ljava/time/Instant;Z)V", "lockId", "(Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;ZJJ)V", "getLockId", "()Ljava/lang/String;", "getLockTime", "()Ljava/time/Instant;", "getPrimaryTerm", "()J", "getReleased", "()Z", "getScheduledJobId", "getSeqNo", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "Companion", "alerting-core"})
public final class LockModel
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String lockId;
    @NotNull
    private final String scheduledJobId;
    @NotNull
    private final Instant lockTime;
    private final boolean released;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    public static final String SCHEDULED_JOB_ID = "scheduled_job_id";
    @NotNull
    public static final String LOCK_TIME = "lock_time";
    @NotNull
    public static final String RELEASED = "released";

    public LockModel(@NotNull String lockId, @NotNull String scheduledJobId, @NotNull Instant lockTime, boolean released, long seqNo, long primaryTerm) {
        Intrinsics.checkNotNullParameter((Object)lockId, (String)"lockId");
        Intrinsics.checkNotNullParameter((Object)scheduledJobId, (String)"scheduledJobId");
        Intrinsics.checkNotNullParameter((Object)lockTime, (String)"lockTime");
        this.lockId = lockId;
        this.scheduledJobId = scheduledJobId;
        this.lockTime = lockTime;
        this.released = released;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    @NotNull
    public final String getLockId() {
        return this.lockId;
    }

    @NotNull
    public final String getScheduledJobId() {
        return this.scheduledJobId;
    }

    @NotNull
    public final Instant getLockTime() {
        return this.lockTime;
    }

    public final boolean getReleased() {
        return this.released;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public LockModel(@NotNull LockModel copyLock, long seqNo, long primaryTerm) {
        Intrinsics.checkNotNullParameter((Object)copyLock, (String)"copyLock");
        this(copyLock.lockId, copyLock.scheduledJobId, copyLock.lockTime, copyLock.released, seqNo, primaryTerm);
    }

    public LockModel(@NotNull LockModel copyLock, boolean released) {
        Intrinsics.checkNotNullParameter((Object)copyLock, (String)"copyLock");
        this(copyLock.lockId, copyLock.scheduledJobId, copyLock.lockTime, released, copyLock.seqNo, copyLock.primaryTerm);
    }

    public LockModel(@NotNull LockModel copyLock, @NotNull Instant updateLockTime, boolean released) {
        Intrinsics.checkNotNullParameter((Object)copyLock, (String)"copyLock");
        Intrinsics.checkNotNullParameter((Object)updateLockTime, (String)"updateLockTime");
        this(copyLock.lockId, copyLock.scheduledJobId, updateLockTime, released, copyLock.seqNo, copyLock.primaryTerm);
    }

    public LockModel(@NotNull String scheduledJobId, @NotNull Instant lockTime, boolean released) {
        Intrinsics.checkNotNullParameter((Object)scheduledJobId, (String)"scheduledJobId");
        Intrinsics.checkNotNullParameter((Object)lockTime, (String)"lockTime");
        this(Companion.generateLockId(scheduledJobId), scheduledJobId, lockTime, released, -2L, 0L);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().field(SCHEDULED_JOB_ID, this.scheduledJobId).field(LOCK_TIME, this.lockTime.getEpochSecond()).field(RELEASED, this.released).endObject();
        return builder;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LockModel parse(@NotNull XContentParser xcp, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, seqNo, primaryTerm);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/alerting/core/lock/LockModel$Companion;", "", "()V", "LOCK_TIME", "", "RELEASED", "SCHEDULED_JOB_ID", "generateLockId", "scheduledJobId", "parse", "Lorg/opensearch/alerting/core/lock/LockModel;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "seqNo", "", "primaryTerm", "alerting-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String generateLockId(@NotNull String scheduledJobId) {
            Intrinsics.checkNotNullParameter((Object)scheduledJobId, (String)"scheduledJobId");
            return scheduledJobId + "-lock";
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LockModel parse(@NotNull XContentParser xcp, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String scheduledJobId = null;
            Instant lockTime = null;
            boolean released = false;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case -929969823: {
                        if (string.equals(LockModel.LOCK_TIME)) {
                            n = 1;
                        }
                        break;
                    }
                    case 2091085999: {
                        if (string.equals(LockModel.SCHEDULED_JOB_ID)) {
                            n = 2;
                        }
                        break;
                    }
                    case -551298755: {
                        if (string.equals(LockModel.RELEASED)) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        break;
                    }
                    case 1: {
                        Intrinsics.checkNotNullExpressionValue((Object)Instant.ofEpochSecond(xcp.longValue()), (String)"ofEpochSecond(xcp.longValue())");
                        break;
                    }
                    case 3: {
                        released = xcp.booleanValue();
                    }
                }
            }
            String string = scheduledJobId;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scheduledJobId");
                string = null;
            }
            String string2 = this.generateLockId(string);
            Instant instant = lockTime;
            if (instant == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lockTime");
                instant = null;
            }
            return new LockModel(string2, scheduledJobId, instant, released, seqNo, primaryTerm);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

