# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
IntAna module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_intana.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _IntAna
else:
    import _IntAna

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IntAna.delete_SwigPyIterator

    def value(self):
        return _IntAna.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _IntAna.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _IntAna.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _IntAna.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _IntAna.SwigPyIterator_equal(self, x)

    def copy(self):
        return _IntAna.SwigPyIterator_copy(self)

    def next(self):
        return _IntAna.SwigPyIterator_next(self)

    def __next__(self):
        return _IntAna.SwigPyIterator___next__(self)

    def previous(self):
        return _IntAna.SwigPyIterator_previous(self)

    def advance(self, n):
        return _IntAna.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _IntAna.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _IntAna.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _IntAna.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _IntAna.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _IntAna.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _IntAna.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _IntAna:
_IntAna.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _IntAna.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection

from enum import IntEnum
from OCC.Core.Exception import *

IntAna_Point = _IntAna.IntAna_Point
IntAna_Line = _IntAna.IntAna_Line
IntAna_Circle = _IntAna.IntAna_Circle
IntAna_PointAndCircle = _IntAna.IntAna_PointAndCircle
IntAna_Ellipse = _IntAna.IntAna_Ellipse
IntAna_Parabola = _IntAna.IntAna_Parabola
IntAna_Hyperbola = _IntAna.IntAna_Hyperbola
IntAna_Empty = _IntAna.IntAna_Empty
IntAna_Same = _IntAna.IntAna_Same
IntAna_NoGeometricSolution = _IntAna.IntAna_NoGeometricSolution


class IntAna_ResultType(IntEnum):
	IntAna_Point = 0
	IntAna_Line = 1
	IntAna_Circle = 2
	IntAna_PointAndCircle = 3
	IntAna_Ellipse = 4
	IntAna_Parabola = 5
	IntAna_Hyperbola = 6
	IntAna_Empty = 7
	IntAna_Same = 8
	IntAna_NoGeometricSolution = 9
IntAna_Point = IntAna_ResultType.IntAna_Point
IntAna_Line = IntAna_ResultType.IntAna_Line
IntAna_Circle = IntAna_ResultType.IntAna_Circle
IntAna_PointAndCircle = IntAna_ResultType.IntAna_PointAndCircle
IntAna_Ellipse = IntAna_ResultType.IntAna_Ellipse
IntAna_Parabola = IntAna_ResultType.IntAna_Parabola
IntAna_Hyperbola = IntAna_ResultType.IntAna_Hyperbola
IntAna_Empty = IntAna_ResultType.IntAna_Empty
IntAna_Same = IntAna_ResultType.IntAna_Same
IntAna_NoGeometricSolution = IntAna_ResultType.IntAna_NoGeometricSolution

class IntAna_ListIteratorOfListOfCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _IntAna.IntAna_ListIteratorOfListOfCurve_swiginit(self, _IntAna.new_IntAna_ListIteratorOfListOfCurve(*args))

    def More(self):
        return _IntAna.IntAna_ListIteratorOfListOfCurve_More(self)

    def Next(self):
        return _IntAna.IntAna_ListIteratorOfListOfCurve_Next(self)

    def Value(self):
        return _IntAna.IntAna_ListIteratorOfListOfCurve_Value(self)

    def ChangeValue(self):
        return _IntAna.IntAna_ListIteratorOfListOfCurve_ChangeValue(self)
    __swig_destroy__ = _IntAna.delete_IntAna_ListIteratorOfListOfCurve

# Register IntAna_ListIteratorOfListOfCurve in _IntAna:
_IntAna.IntAna_ListIteratorOfListOfCurve_swigregister(IntAna_ListIteratorOfListOfCurve)
class IntAna_ListOfCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _IntAna.IntAna_ListOfCurve_begin(self)

    def end(self):
        return _IntAna.IntAna_ListOfCurve_end(self)

    def cbegin(self):
        return _IntAna.IntAna_ListOfCurve_cbegin(self)

    def cend(self):
        return _IntAna.IntAna_ListOfCurve_cend(self)

    def __init__(self, *args):
        _IntAna.IntAna_ListOfCurve_swiginit(self, _IntAna.new_IntAna_ListOfCurve(*args))

    def Size(self):
        return _IntAna.IntAna_ListOfCurve_Size(self)

    def Assign(self, theOther):
        return _IntAna.IntAna_ListOfCurve_Assign(self, theOther)

    def Set(self, theOther):
        return _IntAna.IntAna_ListOfCurve_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _IntAna.IntAna_ListOfCurve_Clear(self, theAllocator)

    def First(self):
        return _IntAna.IntAna_ListOfCurve_First(self)

    def Last(self):
        return _IntAna.IntAna_ListOfCurve_Last(self)

    def Append(self, *args):
        return _IntAna.IntAna_ListOfCurve_Append(self, *args)

    def Prepend(self, *args):
        return _IntAna.IntAna_ListOfCurve_Prepend(self, *args)

    def RemoveFirst(self):
        return _IntAna.IntAna_ListOfCurve_RemoveFirst(self)

    def Remove(self, theIter):
        return _IntAna.IntAna_ListOfCurve_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _IntAna.IntAna_ListOfCurve_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _IntAna.IntAna_ListOfCurve_InsertAfter(self, *args)

    def Reverse(self):
        return _IntAna.IntAna_ListOfCurve_Reverse(self)
    __swig_destroy__ = _IntAna.delete_IntAna_ListOfCurve

    def __len__(self):
        return self.Size()


# Register IntAna_ListOfCurve in _IntAna:
_IntAna.IntAna_ListOfCurve_swigregister(IntAna_ListOfCurve)
class IntAna_Curve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _IntAna.IntAna_Curve_swiginit(self, _IntAna.new_IntAna_Curve(*args))

    def D1u(self, *args):
        r"""

        Parameters
        ----------
        Theta: float
        P: gp_Pnt
        V: gp_Vec

        Return
        -------
        bool

        Description
        -----------
        Returns the point and the first derivative at parameter theta on the curve.

        """
        return _IntAna.IntAna_Curve_D1u(self, *args)

    def Domain(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theFirst: float
        theLast: float

        Description
        -----------
        Returns the paramatric domain of the curve.

        """
        return _IntAna.IntAna_Curve_Domain(self, *args)

    def FindParameter(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt
        theParams: TColStd_ListOfReal

        Return
        -------
        None

        Description
        -----------
        Tries to find the parameter of the point p on the curve. if the method returns false, the 'projection' is impossible. if the method returns true at least one parameter has been found. theparams is always sorted in ascending order.

        """
        return _IntAna.IntAna_Curve_FindParameter(self, *args)

    def IsConstant(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the function is constant.

        """
        return _IntAna.IntAna_Curve_IsConstant(self, *args)

    def IsFirstOpen(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the domain is open at the beginning.

        """
        return _IntAna.IntAna_Curve_IsFirstOpen(self, *args)

    def IsLastOpen(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the domain is open at the end.

        """
        return _IntAna.IntAna_Curve_IsLastOpen(self, *args)

    def IsOpen(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the curve is not infinite at the last parameter or at the first parameter of the domain.

        """
        return _IntAna.IntAna_Curve_IsOpen(self, *args)

    def SetConeQuadValues(self, *args):
        r"""

        Parameters
        ----------
        Cone: gp_Cone
        Qxx: float
        Qyy: float
        Qzz: float
        Qxy: float
        Qxz: float
        Qyz: float
        Qx: float
        Qy: float
        Qz: float
        Q1: float
        Tol: float
        DomInf: float
        DomSup: float
        TwoZForATheta: bool
        ZIsPositive: bool

        Return
        -------
        None

        Description
        -----------
        Sets the parameters used to compute points and derivative on the curve.

        """
        return _IntAna.IntAna_Curve_SetConeQuadValues(self, *args)

    def SetCylinderQuadValues(self, *args):
        r"""

        Parameters
        ----------
        Cylinder: gp_Cylinder
        Qxx: float
        Qyy: float
        Qzz: float
        Qxy: float
        Qxz: float
        Qyz: float
        Qx: float
        Qy: float
        Qz: float
        Q1: float
        Tol: float
        DomInf: float
        DomSup: float
        TwoZForATheta: bool
        ZIsPositive: bool

        Return
        -------
        None

        Description
        -----------
        Sets the parameters used to compute points and derivative on the curve.

        """
        return _IntAna.IntAna_Curve_SetCylinderQuadValues(self, *args)

    def SetDomain(self, *args):
        r"""

        Parameters
        ----------
        theFirst: float
        theLast: float

        Return
        -------
        None

        Description
        -----------
        Trims this curve.

        """
        return _IntAna.IntAna_Curve_SetDomain(self, *args)

    def SetIsFirstOpen(self, *args):
        r"""

        Parameters
        ----------
        Flag: bool

        Return
        -------
        None

        Description
        -----------
        If flag is true, the curve is not defined at the first parameter of its domain.

        """
        return _IntAna.IntAna_Curve_SetIsFirstOpen(self, *args)

    def SetIsLastOpen(self, *args):
        r"""

        Parameters
        ----------
        Flag: bool

        Return
        -------
        None

        Description
        -----------
        If flag is true, the curve is not defined at the first parameter of its domain.

        """
        return _IntAna.IntAna_Curve_SetIsLastOpen(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        Theta: float

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the point at parameter theta on the curve.

        """
        return _IntAna.IntAna_Curve_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntAna.delete_IntAna_Curve

# Register IntAna_Curve in _IntAna:
_IntAna.IntAna_Curve_swigregister(IntAna_Curve)
class IntAna_Int3Pln(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P1: gp_Pln
        P2: gp_Pln
        P3: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Determination of the intersection point between 3 planes.

        """
        _IntAna.IntAna_Int3Pln_swiginit(self, _IntAna.new_IntAna_Int3Pln(*args))

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the computation was successful.

        """
        return _IntAna.IntAna_Int3Pln_IsDone(self, *args)

    def IsEmpty(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there is no intersection point. if 2 planes are identical or parallel, isempty will return true.

        """
        return _IntAna.IntAna_Int3Pln_IsEmpty(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        P1: gp_Pln
        P2: gp_Pln
        P3: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Determination of the intersection point between 3 planes.

        """
        return _IntAna.IntAna_Int3Pln_Perform(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the intersection point.

        """
        return _IntAna.IntAna_Int3Pln_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntAna.delete_IntAna_Int3Pln

# Register IntAna_Int3Pln in _IntAna:
_IntAna.IntAna_Int3Pln_swigregister(IntAna_Int3Pln)
class IntAna_IntConicQuad(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        L: gp_Lin
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a line and a quadric.

        Parameters
        ----------
        C: gp_Circ
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a circle and a quadric.

        Parameters
        ----------
        E: gp_Elips
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between an ellipse and a quadric.

        Parameters
        ----------
        P: gp_Parab
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a parabola and a quadric.

        Parameters
        ----------
        H: gp_Hypr
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between an hyperbola and a quadric.

        Parameters
        ----------
        L: gp_Lin
        P: gp_Pln
        Tolang: float
        Tol: float (optional, default to 0)
        Len: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Intersection between a line and a plane. tolang is used to determine if the angle between two vectors is null. tol is used to check the distance between line and plane on the distance <len> from the origin of the line.

        Parameters
        ----------
        C: gp_Circ
        P: gp_Pln
        Tolang: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersection between a circle and a plane. tolang is used to determine if the angle between two vectors is null. tol is used to determine if a distance is null.

        Parameters
        ----------
        E: gp_Elips
        P: gp_Pln
        Tolang: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersection between an ellipse and a plane. tolang is used to determine if the angle between two vectors is null. tol is used to determine if a distance is null.

        Parameters
        ----------
        Pb: gp_Parab
        P: gp_Pln
        Tolang: float

        Return
        -------
        None

        Description
        -----------
        Intersection between a parabola and a plane. tolang is used to determine if the angle between two vectors is null.

        Parameters
        ----------
        H: gp_Hypr
        P: gp_Pln
        Tolang: float

        Return
        -------
        None

        Description
        -----------
        Intersection between an hyperbola and a plane. tolang is used to determine if the angle between two vectors is null.

        """
        _IntAna.IntAna_IntConicQuad_swiginit(self, _IntAna.new_IntAna_IntConicQuad(*args))

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the creation completed.

        """
        return _IntAna.IntAna_IntConicQuad_IsDone(self, *args)

    def IsInQuadric(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the conic is in the quadric.

        """
        return _IntAna.IntAna_IntConicQuad_IsInQuadric(self, *args)

    def IsParallel(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the line is in a quadric which is parallel to the quadric.

        """
        return _IntAna.IntAna_IntConicQuad_IsParallel(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of intersection point.

        """
        return _IntAna.IntAna_IntConicQuad_NbPoints(self, *args)

    def ParamOnConic(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the line of the intersection point of range n.

        """
        return _IntAna.IntAna_IntConicQuad_ParamOnConic(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Intersects a line and a quadric.

        Parameters
        ----------
        C: gp_Circ
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Intersects a circle and a quadric.

        Parameters
        ----------
        E: gp_Elips
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Intersects an ellipse and a quadric.

        Parameters
        ----------
        P: gp_Parab
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Intersects a parabola and a quadric.

        Parameters
        ----------
        H: gp_Hypr
        Q: IntAna_Quadric

        Return
        -------
        None

        Description
        -----------
        Intersects an hyperbola and a quadric.

        Parameters
        ----------
        L: gp_Lin
        P: gp_Pln
        Tolang: float
        Tol: float (optional, default to 0)
        Len: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Intersects a line and a plane. tolang is used to determine if the angle between two vectors is null. tol is used to check the distance between line and plane on the distance <len> from the origin of the line.

        Parameters
        ----------
        C: gp_Circ
        P: gp_Pln
        Tolang: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects a circle and a plane. tolang is used to determine if the angle between two vectors is null. tol is used to determine if a distance is null.

        Parameters
        ----------
        E: gp_Elips
        P: gp_Pln
        Tolang: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects an ellipse and a plane. tolang is used to determine if the angle between two vectors is null. tol is used to determine if a distance is null.

        Parameters
        ----------
        Pb: gp_Parab
        P: gp_Pln
        Tolang: float

        Return
        -------
        None

        Description
        -----------
        Intersects a parabola and a plane. tolang is used to determine if the angle between two vectors is null.

        Parameters
        ----------
        H: gp_Hypr
        P: gp_Pln
        Tolang: float

        Return
        -------
        None

        Description
        -----------
        Intersects an hyperbola and a plane. tolang is used to determine if the angle between two vectors is null.

        """
        return _IntAna.IntAna_IntConicQuad_Perform(self, *args)

    def Point(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the point of range n.

        """
        return _IntAna.IntAna_IntConicQuad_Point(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntAna.delete_IntAna_IntConicQuad

# Register IntAna_IntConicQuad in _IntAna:
_IntAna.IntAna_IntConicQuad_swigregister(IntAna_IntConicQuad)
class IntAna_IntLinTorus(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        L: gp_Lin
        T: gp_Torus

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a line and a torus.

        """
        _IntAna.IntAna_IntLinTorus_swiginit(self, _IntAna.new_IntAna_IntLinTorus(*args))

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the computation was successful.

        """
        return _IntAna.IntAna_IntLinTorus_IsDone(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of intersection points.

        """
        return _IntAna.IntAna_IntLinTorus_NbPoints(self, *args)

    def ParamOnLine(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the parameter on the line of the intersection point of range index.

        """
        return _IntAna.IntAna_IntLinTorus_ParamOnLine(self, *args)

    def ParamOnTorus(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        FI: float
        THETA: float

        Description
        -----------
        Returns the parameters on the torus of the intersection point of range index.

        """
        return _IntAna.IntAna_IntLinTorus_ParamOnTorus(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        L: gp_Lin
        T: gp_Torus

        Return
        -------
        None

        Description
        -----------
        Intersects a line and a torus.

        """
        return _IntAna.IntAna_IntLinTorus_Perform(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the intersection point of range index.

        """
        return _IntAna.IntAna_IntLinTorus_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntAna.delete_IntAna_IntLinTorus

# Register IntAna_IntLinTorus in _IntAna:
_IntAna.IntAna_IntLinTorus_swigregister(IntAna_IntLinTorus)
class IntAna_IntQuadQuad(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        C: gp_Cylinder
        Q: IntAna_Quadric
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a cylinder and a quadric . tol est a definir plus precisemment.

        Parameters
        ----------
        C: gp_Cone
        Q: IntAna_Quadric
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a cone and a quadric. tol est a definir plus precisemment.

        """
        _IntAna.IntAna_IntQuadQuad_swiginit(self, _IntAna.new_IntAna_IntQuadQuad(*args))

    def Curve(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        IntAna_Curve

        Description
        -----------
        Returns the curve of range n.

        """
        return _IntAna.IntAna_IntQuadQuad_Curve(self, *args)

    def HasNextCurve(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the curve i shares its last bound with another curve.

        """
        return _IntAna.IntAna_IntQuadQuad_HasNextCurve(self, *args)

    def HasPreviousCurve(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        bool

        Description
        -----------
        Returns true if the curve i shares its first bound with another curve.

        """
        return _IntAna.IntAna_IntQuadQuad_HasPreviousCurve(self, *args)

    def IdenticalElements(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the cylinder, the cone or the sphere is identical to the quadric.

        """
        return _IntAna.IntAna_IntQuadQuad_IdenticalElements(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the computation was successful.

        """
        return _IntAna.IntAna_IntQuadQuad_IsDone(self, *args)

    def NbCurve(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of curves solution.

        """
        return _IntAna.IntAna_IntQuadQuad_NbCurve(self, *args)

    def NbPnt(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of contact point.

        """
        return _IntAna.IntAna_IntQuadQuad_NbPnt(self, *args)

    def NextCurve(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        theOpposite: bool

        Description
        -----------
        If hasnextcurve(i) returns true, this function returns the index j of the curve which has a common bound with the curve i. if theopposite == true , then the last parameter of the curve i, and the last parameter of the curve j give the same point. else the last parameter of the curve i and the first parameter of the curve j are the same point.

        """
        return _IntAna.IntAna_IntQuadQuad_NextCurve(self, *args)

    def Parameters(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        U1: float
        U2: float

        Description
        -----------
        Returns the parameters on the 'explicit quadric' (i.e the cylinder or the cone, the first argument given to the constructor) of the point of range n.

        """
        return _IntAna.IntAna_IntQuadQuad_Parameters(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        C: gp_Cylinder
        Q: IntAna_Quadric
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects a cylinder and a quadric . tol est a definir plus precisemment.

        Parameters
        ----------
        C: gp_Cone
        Q: IntAna_Quadric
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects a cone and a quadric. tol est a definir plus precisemment.

        """
        return _IntAna.IntAna_IntQuadQuad_Perform(self, *args)

    def Point(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the point of range n.

        """
        return _IntAna.IntAna_IntQuadQuad_Point(self, *args)

    def PreviousCurve(self, *args):
        r"""

        Parameters
        ----------
        I: int

        Return
        -------
        theOpposite: bool

        Description
        -----------
        If haspreviouscurve(i) returns true, this function returns the index j of the curve which has a common bound with the curve i. if theopposite == true , then the first parameter of the curve i, and the first parameter of the curve j give the same point. else the first parameter of the curve i and the last parameter of the curve j are the same point.

        """
        return _IntAna.IntAna_IntQuadQuad_PreviousCurve(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntAna.delete_IntAna_IntQuadQuad

# Register IntAna_IntQuadQuad in _IntAna:
_IntAna.IntAna_IntQuadQuad_swigregister(IntAna_IntQuadQuad)
class IntAna_QuadQuadGeo(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        P1: gp_Pln
        P2: gp_Pln
        TolAng: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between two planes. tolang is the angular tolerance used to determine if the planes are parallel. tol is the tolerance used to determine if the planes are identical (only when they are parallel).

        Parameters
        ----------
        P: gp_Pln
        C: gp_Cylinder
        Tolang: float
        Tol: float
        H: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a plane and a cylinder. tolang is the angular tolerance used to determine if the axis of the cylinder is parallel to the plane. tol is the tolerance used to determine if the result is a circle or an ellipse. if the maximum distance between the ellipse solution and the circle centered at the ellipse center is less than tol, the result will be the circle. h is the height of the cylinder <cyl>. it is used to check whether the plane and cylinder are parallel.

        Parameters
        ----------
        P: gp_Pln
        S: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a plane and a sphere.

        Parameters
        ----------
        P: gp_Pln
        C: gp_Cone
        Tolang: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a plane and a cone. tolang is the angular tolerance used to determine if the axis of the cone is parallel or perpendicular to the plane, and if the generating line of the cone is parallel to the plane. tol is the tolerance used to determine if the apex of the cone is in the plane.

        Parameters
        ----------
        Cyl1: gp_Cylinder
        Cyl2: gp_Cylinder
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between two cylinders.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Sph: gp_Sphere
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a cylinder and a sphere.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Con: gp_Cone
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a cylinder and a cone.

        Parameters
        ----------
        Sph1: gp_Sphere
        Sph2: gp_Sphere
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between two spheres.

        Parameters
        ----------
        Sph: gp_Sphere
        Con: gp_Cone
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between a sphere and a cone.

        Parameters
        ----------
        Con1: gp_Cone
        Con2: gp_Cone
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between two cones.

        Parameters
        ----------
        Pln: gp_Pln
        Tor: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between plane and torus.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Tor: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between cylinder and torus.

        Parameters
        ----------
        Con: gp_Cone
        Tor: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between cone and torus.

        Parameters
        ----------
        Sph: gp_Sphere
        Tor: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between sphere and torus.

        Parameters
        ----------
        Tor1: gp_Torus
        Tor2: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Creates the intersection between two toruses.

        """
        _IntAna.IntAna_QuadQuadGeo_swiginit(self, _IntAna.new_IntAna_QuadQuadGeo(*args))

    def Circle(self, *args):
        r"""

        Parameters
        ----------
        Num: int

        Return
        -------
        gp_Circ

        Description
        -----------
        Returns the circle solution of range num.

        """
        return _IntAna.IntAna_QuadQuadGeo_Circle(self, *args)

    def Ellipse(self, *args):
        r"""

        Parameters
        ----------
        Num: int

        Return
        -------
        gp_Elips

        Description
        -----------
        Returns the ellipse solution of range num.

        """
        return _IntAna.IntAna_QuadQuadGeo_Ellipse(self, *args)

    def HasCommonGen(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _IntAna.IntAna_QuadQuadGeo_HasCommonGen(self, *args)

    def Hyperbola(self, *args):
        r"""

        Parameters
        ----------
        Num: int

        Return
        -------
        gp_Hypr

        Description
        -----------
        Returns the hyperbola solution of range num.

        """
        return _IntAna.IntAna_QuadQuadGeo_Hyperbola(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if the computation was successful.

        """
        return _IntAna.IntAna_QuadQuadGeo_IsDone(self, *args)

    def Line(self, *args):
        r"""

        Parameters
        ----------
        Num: int

        Return
        -------
        gp_Lin

        Description
        -----------
        Returns the line solution of range num.

        """
        return _IntAna.IntAna_QuadQuadGeo_Line(self, *args)

    def NbSolutions(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of intersections. the possible intersections are: - 1 point - 1 or 2 line(s) - 1 point and 1 line - 1 circle - 1 ellipse - 1 parabola - 1 or 2 hyperbola(s).

        """
        return _IntAna.IntAna_QuadQuadGeo_NbSolutions(self, *args)

    def PChar(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        No available documentation.

        """
        return _IntAna.IntAna_QuadQuadGeo_PChar(self, *args)

    def Parabola(self, *args):
        r"""

        Parameters
        ----------
        Num: int

        Return
        -------
        gp_Parab

        Description
        -----------
        Returns the parabola solution of range num.

        """
        return _IntAna.IntAna_QuadQuadGeo_Parabola(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        P1: gp_Pln
        P2: gp_Pln
        TolAng: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects two planes. tolang is the angular tolerance used to determine if the planes are parallel. tol is the tolerance used to determine if the planes are identical (only when they are parallel).

        Parameters
        ----------
        P: gp_Pln
        C: gp_Cylinder
        Tolang: float
        Tol: float
        H: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Intersects a plane and a cylinder. tolang is the angular tolerance used to determine if the axis of the cylinder is parallel to the plane. tol is the tolerance used to determine if the result is a circle or an ellipse. if the maximum distance between the ellipse solution and the circle centered at the ellipse center is less than tol, the result will be the circle. h is the height of the cylinder <cyl>. it is used to check whether the plane and cylinder are parallel.

        Parameters
        ----------
        P: gp_Pln
        S: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        Intersects a plane and a sphere.

        Parameters
        ----------
        P: gp_Pln
        C: gp_Cone
        Tolang: float
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects a plane and a cone. tolang is the angular tolerance used to determine if the axis of the cone is parallel or perpendicular to the plane, and if the generating line of the cone is parallel to the plane. tol is the tolerance used to determine if the apex of the cone is in the plane.

        Parameters
        ----------
        Cyl1: gp_Cylinder
        Cyl2: gp_Cylinder
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects two cylinders.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Sph: gp_Sphere
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects a cylinder and a sphere.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Con: gp_Cone
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects a cylinder and a cone.

        Parameters
        ----------
        Sph1: gp_Sphere
        Sph2: gp_Sphere
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects a two spheres.

        Parameters
        ----------
        Sph: gp_Sphere
        Con: gp_Cone
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects a sphere and a cone.

        Parameters
        ----------
        Con1: gp_Cone
        Con2: gp_Cone
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects two cones.

        Parameters
        ----------
        Pln: gp_Pln
        Tor: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects plane and torus.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Tor: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects cylinder and torus.

        Parameters
        ----------
        Con: gp_Cone
        Tor: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects cone and torus.

        Parameters
        ----------
        Sph: gp_Sphere
        Tor: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects sphere and torus.

        Parameters
        ----------
        Tor1: gp_Torus
        Tor2: gp_Torus
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Intersects two toruses.

        """
        return _IntAna.IntAna_QuadQuadGeo_Perform(self, *args)

    def Point(self, *args):
        r"""

        Parameters
        ----------
        Num: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the point solution of range num.

        """
        return _IntAna.IntAna_QuadQuadGeo_Point(self, *args)

    def TypeInter(self, *args):
        r"""
        Return
        -------
        IntAna_ResultType

        Description
        -----------
        Returns the type of intersection.

        """
        return _IntAna.IntAna_QuadQuadGeo_TypeInter(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntAna.delete_IntAna_QuadQuadGeo

# Register IntAna_QuadQuadGeo in _IntAna:
_IntAna.IntAna_QuadQuadGeo_swigregister(IntAna_QuadQuadGeo)
class IntAna_Quadric(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        P: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Creates a quadric from a pln.

        Parameters
        ----------
        Sph: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        Creates a quadric from a sphere.

        Parameters
        ----------
        Cyl: gp_Cylinder

        Return
        -------
        None

        Description
        -----------
        Creates a quadric from a cylinder.

        Parameters
        ----------
        Cone: gp_Cone

        Return
        -------
        None

        Description
        -----------
        Creates a quadric from a cone.

        """
        _IntAna.IntAna_Quadric_swiginit(self, _IntAna.new_IntAna_Quadric(*args))

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        xCXX: float
        xCYY: float
        xCZZ: float
        xCXY: float
        xCXZ: float
        xCYZ: float
        xCX: float
        xCY: float
        xCZ: float
        xCCte: float

        Description
        -----------
        Returns the coefficients of the polynomial equation which define the quadric: xcxx x**2 + xcyy y**2 + xczz z**2 + 2 ( xcxy x y + xcxz x z + xcyz y z ) + 2 ( xcx x + xcy y + xcz z ) + xccte.

        """
        return _IntAna.IntAna_Quadric_Coefficients(self, *args)

    def NewCoefficients(self, *args):
        r"""

        Parameters
        ----------
        Axis: gp_Ax3

        Return
        -------
        xCXX: float
        xCYY: float
        xCZZ: float
        xCXY: float
        xCXZ: float
        xCYZ: float
        xCX: float
        xCY: float
        xCZ: float
        xCCte: float

        Description
        -----------
        Returns the coefficients of the polynomial equation ( written in the natural coordinates system ) in the local coordinates system defined by axis.

        """
        return _IntAna.IntAna_Quadric_NewCoefficients(self, *args)

    def SetQuadric(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Initializes the quadric with a pln.

        Parameters
        ----------
        Sph: gp_Sphere

        Return
        -------
        None

        Description
        -----------
        Initialize the quadric with a sphere.

        Parameters
        ----------
        Con: gp_Cone

        Return
        -------
        None

        Description
        -----------
        Initializes the quadric with a cone.

        Parameters
        ----------
        Cyl: gp_Cylinder

        Return
        -------
        None

        Description
        -----------
        Initializes the quadric with a cylinder.

        """
        return _IntAna.IntAna_Quadric_SetQuadric(self, *args)

    def SpecialPoints(self, *args):
        r"""
        Return
        -------
        NCollection_List<gp_Pnt>

        Description
        -----------
        Returns the list of special points (with singularities).

        """
        return _IntAna.IntAna_Quadric_SpecialPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IntAna.delete_IntAna_Quadric

# Register IntAna_Quadric in _IntAna:
_IntAna.IntAna_Quadric_swigregister(IntAna_Quadric)



