# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
gp module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_gp.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _gp
else:
    import _gp

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gp.delete_SwigPyIterator

    def value(self):
        return _gp.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _gp.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _gp.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _gp.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _gp.SwigPyIterator_equal(self, x)

    def copy(self):
        return _gp.SwigPyIterator_copy(self)

    def next(self):
        return _gp.SwigPyIterator_next(self)

    def __next__(self):
        return _gp.SwigPyIterator___next__(self)

    def previous(self):
        return _gp.SwigPyIterator_previous(self)

    def advance(self, n):
        return _gp.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _gp.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _gp.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _gp.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _gp.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _gp.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _gp.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _gp:
_gp.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _gp.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColStd
import OCC.Core.TCollection

from enum import IntEnum
from OCC.Core.Exception import *

gp_EulerAngles = _gp.gp_EulerAngles
gp_YawPitchRoll = _gp.gp_YawPitchRoll
gp_Extrinsic_XYZ = _gp.gp_Extrinsic_XYZ
gp_Extrinsic_XZY = _gp.gp_Extrinsic_XZY
gp_Extrinsic_YZX = _gp.gp_Extrinsic_YZX
gp_Extrinsic_YXZ = _gp.gp_Extrinsic_YXZ
gp_Extrinsic_ZXY = _gp.gp_Extrinsic_ZXY
gp_Extrinsic_ZYX = _gp.gp_Extrinsic_ZYX
gp_Intrinsic_XYZ = _gp.gp_Intrinsic_XYZ
gp_Intrinsic_XZY = _gp.gp_Intrinsic_XZY
gp_Intrinsic_YZX = _gp.gp_Intrinsic_YZX
gp_Intrinsic_YXZ = _gp.gp_Intrinsic_YXZ
gp_Intrinsic_ZXY = _gp.gp_Intrinsic_ZXY
gp_Intrinsic_ZYX = _gp.gp_Intrinsic_ZYX
gp_Extrinsic_XYX = _gp.gp_Extrinsic_XYX
gp_Extrinsic_XZX = _gp.gp_Extrinsic_XZX
gp_Extrinsic_YZY = _gp.gp_Extrinsic_YZY
gp_Extrinsic_YXY = _gp.gp_Extrinsic_YXY
gp_Extrinsic_ZYZ = _gp.gp_Extrinsic_ZYZ
gp_Extrinsic_ZXZ = _gp.gp_Extrinsic_ZXZ
gp_Intrinsic_XYX = _gp.gp_Intrinsic_XYX
gp_Intrinsic_XZX = _gp.gp_Intrinsic_XZX
gp_Intrinsic_YZY = _gp.gp_Intrinsic_YZY
gp_Intrinsic_YXY = _gp.gp_Intrinsic_YXY
gp_Intrinsic_ZXZ = _gp.gp_Intrinsic_ZXZ
gp_Intrinsic_ZYZ = _gp.gp_Intrinsic_ZYZ
gp_Identity = _gp.gp_Identity
gp_Rotation = _gp.gp_Rotation
gp_Translation = _gp.gp_Translation
gp_PntMirror = _gp.gp_PntMirror
gp_Ax1Mirror = _gp.gp_Ax1Mirror
gp_Ax2Mirror = _gp.gp_Ax2Mirror
gp_Scale = _gp.gp_Scale
gp_CompoundTrsf = _gp.gp_CompoundTrsf
gp_Other = _gp.gp_Other


class gp_EulerSequence(IntEnum):
	gp_EulerAngles = 0
	gp_YawPitchRoll = 1
	gp_Extrinsic_XYZ = 2
	gp_Extrinsic_XZY = 3
	gp_Extrinsic_YZX = 4
	gp_Extrinsic_YXZ = 5
	gp_Extrinsic_ZXY = 6
	gp_Extrinsic_ZYX = 7
	gp_Intrinsic_XYZ = 8
	gp_Intrinsic_XZY = 9
	gp_Intrinsic_YZX = 10
	gp_Intrinsic_YXZ = 11
	gp_Intrinsic_ZXY = 12
	gp_Intrinsic_ZYX = 13
	gp_Extrinsic_XYX = 14
	gp_Extrinsic_XZX = 15
	gp_Extrinsic_YZY = 16
	gp_Extrinsic_YXY = 17
	gp_Extrinsic_ZYZ = 18
	gp_Extrinsic_ZXZ = 19
	gp_Intrinsic_XYX = 20
	gp_Intrinsic_XZX = 21
	gp_Intrinsic_YZY = 22
	gp_Intrinsic_YXY = 23
	gp_Intrinsic_ZXZ = 24
	gp_Intrinsic_ZYZ = 25
gp_EulerAngles = gp_EulerSequence.gp_EulerAngles
gp_YawPitchRoll = gp_EulerSequence.gp_YawPitchRoll
gp_Extrinsic_XYZ = gp_EulerSequence.gp_Extrinsic_XYZ
gp_Extrinsic_XZY = gp_EulerSequence.gp_Extrinsic_XZY
gp_Extrinsic_YZX = gp_EulerSequence.gp_Extrinsic_YZX
gp_Extrinsic_YXZ = gp_EulerSequence.gp_Extrinsic_YXZ
gp_Extrinsic_ZXY = gp_EulerSequence.gp_Extrinsic_ZXY
gp_Extrinsic_ZYX = gp_EulerSequence.gp_Extrinsic_ZYX
gp_Intrinsic_XYZ = gp_EulerSequence.gp_Intrinsic_XYZ
gp_Intrinsic_XZY = gp_EulerSequence.gp_Intrinsic_XZY
gp_Intrinsic_YZX = gp_EulerSequence.gp_Intrinsic_YZX
gp_Intrinsic_YXZ = gp_EulerSequence.gp_Intrinsic_YXZ
gp_Intrinsic_ZXY = gp_EulerSequence.gp_Intrinsic_ZXY
gp_Intrinsic_ZYX = gp_EulerSequence.gp_Intrinsic_ZYX
gp_Extrinsic_XYX = gp_EulerSequence.gp_Extrinsic_XYX
gp_Extrinsic_XZX = gp_EulerSequence.gp_Extrinsic_XZX
gp_Extrinsic_YZY = gp_EulerSequence.gp_Extrinsic_YZY
gp_Extrinsic_YXY = gp_EulerSequence.gp_Extrinsic_YXY
gp_Extrinsic_ZYZ = gp_EulerSequence.gp_Extrinsic_ZYZ
gp_Extrinsic_ZXZ = gp_EulerSequence.gp_Extrinsic_ZXZ
gp_Intrinsic_XYX = gp_EulerSequence.gp_Intrinsic_XYX
gp_Intrinsic_XZX = gp_EulerSequence.gp_Intrinsic_XZX
gp_Intrinsic_YZY = gp_EulerSequence.gp_Intrinsic_YZY
gp_Intrinsic_YXY = gp_EulerSequence.gp_Intrinsic_YXY
gp_Intrinsic_ZXZ = gp_EulerSequence.gp_Intrinsic_ZXZ
gp_Intrinsic_ZYZ = gp_EulerSequence.gp_Intrinsic_ZYZ

class gp_TrsfForm(IntEnum):
	gp_Identity = 0
	gp_Rotation = 1
	gp_Translation = 2
	gp_PntMirror = 3
	gp_Ax1Mirror = 4
	gp_Ax2Mirror = 5
	gp_Scale = 6
	gp_CompoundTrsf = 7
	gp_Other = 8
gp_Identity = gp_TrsfForm.gp_Identity
gp_Rotation = gp_TrsfForm.gp_Rotation
gp_Translation = gp_TrsfForm.gp_Translation
gp_PntMirror = gp_TrsfForm.gp_PntMirror
gp_Ax1Mirror = gp_TrsfForm.gp_Ax1Mirror
gp_Ax2Mirror = gp_TrsfForm.gp_Ax2Mirror
gp_Scale = gp_TrsfForm.gp_Scale
gp_CompoundTrsf = gp_TrsfForm.gp_CompoundTrsf
gp_Other = gp_TrsfForm.gp_Other

class gp_Vec2f(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Length():
        return _gp.gp_Vec2f_Length()

    def __init__(self, *args):
        _gp.gp_Vec2f_swiginit(self, _gp.new_gp_Vec2f(*args))

    def SetValues(self, theX, theY):
        return _gp.gp_Vec2f_SetValues(self, theX, theY)

    def xy(self):
        return _gp.gp_Vec2f_xy(self)

    def yx(self):
        return _gp.gp_Vec2f_yx(self)

    def x(self, *args):
        return _gp.gp_Vec2f_x(self, *args)

    def y(self, *args):
        return _gp.gp_Vec2f_y(self, *args)

    def IsEqual(self, theOther):
        return _gp.gp_Vec2f_IsEqual(self, theOther)

    def __eq__(self, theOther):
        return _gp.gp_Vec2f___eq__(self, theOther)

    def __ne__(self, theOther):
        return _gp.gp_Vec2f___ne__(self, theOther)

    def GetData(self):
        return _gp.gp_Vec2f_GetData(self)

    def ChangeData(self):
        return _gp.gp_Vec2f_ChangeData(self)

    def __iadd__(self, theAdd):
        return _gp.gp_Vec2f___iadd__(self, theAdd)

    def __isub__(self, theDec):
        return _gp.gp_Vec2f___isub__(self, theDec)

    def __neg__(self):
        return _gp.gp_Vec2f___neg__(self)

    def Multiply(self, theFactor):
        return _gp.gp_Vec2f_Multiply(self, theFactor)

    def Multiplied(self, theFactor):
        return _gp.gp_Vec2f_Multiplied(self, theFactor)

    def cwiseMin(self, theVec):
        return _gp.gp_Vec2f_cwiseMin(self, theVec)

    def cwiseMax(self, theVec):
        return _gp.gp_Vec2f_cwiseMax(self, theVec)

    def cwiseAbs(self):
        return _gp.gp_Vec2f_cwiseAbs(self)

    def maxComp(self):
        return _gp.gp_Vec2f_maxComp(self)

    def minComp(self):
        return _gp.gp_Vec2f_minComp(self)

    def __imul__(self, *args):
        return _gp.gp_Vec2f___imul__(self, *args)

    def __itruediv__(self, *args):
        return _gp.gp_Vec2f___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def __mul__(self, theFactor):
        return _gp.gp_Vec2f___mul__(self, theFactor)

    def __truediv__(self, *args):
        return _gp.gp_Vec2f___truediv__(self, *args)
    __div__ = __truediv__



    def Dot(self, theOther):
        return _gp.gp_Vec2f_Dot(self, theOther)

    def Modulus(self):
        return _gp.gp_Vec2f_Modulus(self)

    def SquareModulus(self):
        return _gp.gp_Vec2f_SquareModulus(self)

    @staticmethod
    def DX():
        return _gp.gp_Vec2f_DX()

    @staticmethod
    def DY():
        return _gp.gp_Vec2f_DY()

    def DumpJson(self, theOStream, theDepth=-1):
        return _gp.gp_Vec2f_DumpJson(self, theOStream, theDepth)
    __swig_destroy__ = _gp.delete_gp_Vec2f

# Register gp_Vec2f in _gp:
_gp.gp_Vec2f_swigregister(gp_Vec2f)
class gp_Vec3f(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Length():
        return _gp.gp_Vec3f_Length()

    def __init__(self, *args):
        _gp.gp_Vec3f_swiginit(self, _gp.new_gp_Vec3f(*args))

    def SetValues(self, *args):
        return _gp.gp_Vec3f_SetValues(self, *args)

    def xy(self):
        return _gp.gp_Vec3f_xy(self)

    def yx(self):
        return _gp.gp_Vec3f_yx(self)

    def xz(self):
        return _gp.gp_Vec3f_xz(self)

    def zx(self):
        return _gp.gp_Vec3f_zx(self)

    def yz(self):
        return _gp.gp_Vec3f_yz(self)

    def zy(self):
        return _gp.gp_Vec3f_zy(self)

    def xyz(self):
        return _gp.gp_Vec3f_xyz(self)

    def xzy(self):
        return _gp.gp_Vec3f_xzy(self)

    def yxz(self):
        return _gp.gp_Vec3f_yxz(self)

    def yzx(self):
        return _gp.gp_Vec3f_yzx(self)

    def zyx(self):
        return _gp.gp_Vec3f_zyx(self)

    def zxy(self):
        return _gp.gp_Vec3f_zxy(self)

    def x(self, *args):
        return _gp.gp_Vec3f_x(self, *args)

    def r(self, *args):
        return _gp.gp_Vec3f_r(self, *args)

    def y(self, *args):
        return _gp.gp_Vec3f_y(self, *args)

    def g(self, *args):
        return _gp.gp_Vec3f_g(self, *args)

    def z(self, *args):
        return _gp.gp_Vec3f_z(self, *args)

    def b(self, *args):
        return _gp.gp_Vec3f_b(self, *args)

    def IsEqual(self, theOther):
        return _gp.gp_Vec3f_IsEqual(self, theOther)

    def __eq__(self, theOther):
        return _gp.gp_Vec3f___eq__(self, theOther)

    def __ne__(self, theOther):
        return _gp.gp_Vec3f___ne__(self, theOther)

    def GetData(self):
        return _gp.gp_Vec3f_GetData(self)

    def ChangeData(self):
        return _gp.gp_Vec3f_ChangeData(self)

    def __iadd__(self, theAdd):
        return _gp.gp_Vec3f___iadd__(self, theAdd)

    def __neg__(self):
        return _gp.gp_Vec3f___neg__(self)

    def __isub__(self, theDec):
        return _gp.gp_Vec3f___isub__(self, theDec)

    def Multiply(self, theFactor):
        return _gp.gp_Vec3f_Multiply(self, theFactor)

    def __imul__(self, *args):
        return _gp.gp_Vec3f___imul__(self, *args)

    def __mul__(self, theFactor):
        return _gp.gp_Vec3f___mul__(self, theFactor)

    def Multiplied(self, theFactor):
        return _gp.gp_Vec3f_Multiplied(self, theFactor)

    def cwiseMin(self, theVec):
        return _gp.gp_Vec3f_cwiseMin(self, theVec)

    def cwiseMax(self, theVec):
        return _gp.gp_Vec3f_cwiseMax(self, theVec)

    def cwiseAbs(self):
        return _gp.gp_Vec3f_cwiseAbs(self)

    def maxComp(self):
        return _gp.gp_Vec3f_maxComp(self)

    def minComp(self):
        return _gp.gp_Vec3f_minComp(self)

    def __itruediv__(self, *args):
        return _gp.gp_Vec3f___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def __truediv__(self, *args):
        return _gp.gp_Vec3f___truediv__(self, *args)
    __div__ = __truediv__



    def Dot(self, theOther):
        return _gp.gp_Vec3f_Dot(self, theOther)

    def Modulus(self):
        return _gp.gp_Vec3f_Modulus(self)

    def SquareModulus(self):
        return _gp.gp_Vec3f_SquareModulus(self)

    def Normalize(self):
        return _gp.gp_Vec3f_Normalize(self)

    def Normalized(self):
        return _gp.gp_Vec3f_Normalized(self)

    @staticmethod
    def Cross(theVec1, theVec2):
        return _gp.gp_Vec3f_Cross(theVec1, theVec2)

    @staticmethod
    def GetLERP(theFrom, theTo, theT):
        return _gp.gp_Vec3f_GetLERP(theFrom, theTo, theT)

    @staticmethod
    def DX():
        return _gp.gp_Vec3f_DX()

    @staticmethod
    def DY():
        return _gp.gp_Vec3f_DY()

    @staticmethod
    def DZ():
        return _gp.gp_Vec3f_DZ()

    def DumpJson(self, theOStream, theDepth=-1):
        return _gp.gp_Vec3f_DumpJson(self, theOStream, theDepth)
    __swig_destroy__ = _gp.delete_gp_Vec3f

# Register gp_Vec3f in _gp:
_gp.gp_Vec3f_swigregister(gp_Vec3f)
class gp(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def DX(*args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns a unit vector with the combination (1,0,0).

        """
        return _gp.gp_DX(*args)

    @staticmethod
    def DX2d(*args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        Returns a unit vector with the combinations (1,0).

        """
        return _gp.gp_DX2d(*args)

    @staticmethod
    def DY(*args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns a unit vector with the combination (0,1,0).

        """
        return _gp.gp_DY(*args)

    @staticmethod
    def DY2d(*args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        Returns a unit vector with the combinations (0,1).

        """
        return _gp.gp_DY2d(*args)

    @staticmethod
    def DZ(*args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns a unit vector with the combination (0,0,1).

        """
        return _gp.gp_DZ(*args)

    @staticmethod
    def OX(*args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Identifies an axis where its origin is origin and its unit vector coordinates x = 1.0, y = z = 0.0.

        """
        return _gp.gp_OX(*args)

    @staticmethod
    def OX2d(*args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Identifies an axis where its origin is origin2d and its unit vector coordinates are: x = 1.0, y = 0.0.

        """
        return _gp.gp_OX2d(*args)

    @staticmethod
    def OY(*args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Identifies an axis where its origin is origin and its unit vector coordinates y = 1.0, x = z = 0.0.

        """
        return _gp.gp_OY(*args)

    @staticmethod
    def OY2d(*args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Identifies an axis where its origin is origin2d and its unit vector coordinates are y = 1.0, x = 0.0.

        """
        return _gp.gp_OY2d(*args)

    @staticmethod
    def OZ(*args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Identifies an axis where its origin is origin and its unit vector coordinates z = 1.0, y = x = 0.0.

        """
        return _gp.gp_OZ(*args)

    @staticmethod
    def Origin(*args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Identifies a cartesian point with coordinates x = y = z = 0.0.0.

        """
        return _gp.gp_Origin(*args)

    @staticmethod
    def Origin2d(*args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Identifies a cartesian point with coordinates x = y = 0.0.

        """
        return _gp.gp_Origin2d(*args)

    @staticmethod
    def Resolution(*args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Method of package gp //! in geometric computations, defines the tolerance criterion used to determine when two numbers can be considered equal. many class functions use this tolerance criterion, for example, to avoid division by zero in geometric computations. in the documentation, tolerance criterion is always referred to as gp::resolution().

        """
        return _gp.gp_Resolution(*args)

    @staticmethod
    def XOY(*args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates z = 1.0, x = y =0.0 and x direction coordinates x = 1.0, y = z = 0.0.

        """
        return _gp.gp_XOY(*args)

    @staticmethod
    def YOZ(*args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates x = 1.0, z = y =0.0 and x direction coordinates y = 1.0, x = z = 0.0 in 2d space.

        """
        return _gp.gp_YOZ(*args)

    @staticmethod
    def ZOX(*args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates y = 1.0, x = z =0.0 and x direction coordinates z = 1.0, x = y = 0.0.

        """
        return _gp.gp_ZOX(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _gp.gp_swiginit(self, _gp.new_gp())
    __swig_destroy__ = _gp.delete_gp

# Register gp in _gp:
_gp.gp_swigregister(gp)
class gp_Ax1(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an axis object representing z axis of the reference coordinate system.

        Parameters
        ----------
        theP: gp_Pnt
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        P is the location point and v is the direction of <self>.

        """
        _gp.gp_Ax1_swiginit(self, _gp.new_gp_Ax1(*args))

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax1

        Return
        -------
        float

        Description
        -----------
        Computes the angular value, in radians, between this.direction() and theother.direction(). returns the angle between 0 and 2*pi radians.

        """
        return _gp.gp_Ax1_Angle(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the direction of <self>.

        """
        return _gp.gp_Ax1_Direction(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Ax1_DumpJsonToString(self, depth)

    def InitFromJsonString(self, json_string):
        r"""InitFromJsonString(gp_Ax1 self, std::string json_string) -> bool"""
        return _gp.gp_Ax1_InitFromJsonString(self, json_string)

    def IsCoaxial(self, *args):
        r"""

        Parameters
        ----------
        Other: gp_Ax1
        AngularTolerance: float
        LinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if: . the angle between <self> and <other> is lower or equal to <angulartolerance> and . the distance between <self>.location() and <other> is lower or equal to <lineartolerance> and . the distance between <other>.location() and <self> is lower or equal to lineartolerance.

        """
        return _gp.gp_Ax1_IsCoaxial(self, *args)

    def IsNormal(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax1
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the direction of this and another axis are normal to each other. that is, if the angle between the two axes is equal to pi/2. note: the tolerance criterion is given by theangulartolerance.

        """
        return _gp.gp_Ax1_IsNormal(self, *args)

    def IsOpposite(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax1
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the direction of this and another axis are parallel with opposite orientation. that is, if the angle between the two axes is equal to pi. note: the tolerance criterion is given by theangulartolerance.

        """
        return _gp.gp_Ax1_IsOpposite(self, *args)

    def IsParallel(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax1
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the direction of this and another axis are parallel with same orientation or opposite orientation. that is, if the angle between the two axes is equal to 0 or pi. note: the tolerance criterion is given by theangulartolerance.

        """
        return _gp.gp_Ax1_IsParallel(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the location point of <self>.

        """
        return _gp.gp_Ax1_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to the point p which is the center of the symmetry and assigns the result to this axis.

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry and assigns the result to this axis.

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to a plane. the axis placement <a2> locates the plane of the symmetry: (location, xdirection, ydirection) and assigns the result to this axis.

        """
        return _gp.gp_Ax1_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        gp_Ax1

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to the point p which is the center of the symmetry and creates a new axis.

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        gp_Ax1

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry and creates a new axis.

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        gp_Ax1

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to a plane. the axis placement <a2> locates the plane of the symmetry: (location, xdirection, ydirection) and creates a new axis.

        """
        return _gp.gp_Ax1_Mirrored(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the unit vector of this axis and assigns the result to this axis.

        """
        return _gp.gp_Ax1_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Reverses the unit vector of this axis and creates a new one.

        """
        return _gp.gp_Ax1_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAngRad: float

        Return
        -------
        None

        Description
        -----------
        Rotates this axis at an angle theangrad (in radians) about the axis thea1 and assigns the result to this axis.

        """
        return _gp.gp_Ax1_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAngRad: float

        Return
        -------
        gp_Ax1

        Description
        -----------
        Rotates this axis at an angle theangrad (in radians) about the axis thea1 and creates a new one.

        """
        return _gp.gp_Ax1_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        Applies a scaling transformation to this axis with: - scale factor thes, and - center thep and assigns the result to this axis.

        """
        return _gp.gp_Ax1_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Ax1

        Description
        -----------
        Applies a scaling transformation to this axis with: - scale factor thes, and - center thep and creates a new axis.

        """
        return _gp.gp_Ax1_Scaled(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Assigns v as the 'direction' of this axis.

        """
        return _gp.gp_Ax1_SetDirection(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Assigns p as the origin of this axis.

        """
        return _gp.gp_Ax1_SetLocation(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Applies the transformation thet to this axis and assigns the result to this axis.

        """
        return _gp.gp_Ax1_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Ax1

        Description
        -----------
        Applies the transformation thet to this axis and creates a new one. //! translates an axis plaxement in the direction of the vector <v>. the magnitude of the translation is the vector's magnitude.

        """
        return _gp.gp_Ax1_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Translates this axis by the vector thev, and assigns the result to this axis.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Translates this axis by: the vector (thep1, thep2) defined from point thep1 to point thep2. and assigns the result to this axis.

        """
        return _gp.gp_Ax1_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Ax1

        Description
        -----------
        Translates this axis by the vector thev, and creates a new one.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Ax1

        Description
        -----------
        Translates this axis by: the vector (thep1, thep2) defined from point thep1 to point thep2. and creates a new one.

        """
        return _gp.gp_Ax1_Translated(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Ax1()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Ax1')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax1

# Register gp_Ax1 in _gp:
_gp.gp_Ax1_swigregister(gp_Ax1)
class gp_Ax2(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an object corresponding to the reference coordinate system (oxyz).

        Parameters
        ----------
        P: gp_Pnt
        N: gp_Dir
        Vx: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates an axis placement with an origin p such that: - n is the direction, and - the 'x direction' is normal to n, in the plane defined by the vectors (n, vx): 'x direction' = (n ^ vx) ^ n, exception: raises constructionerror if n and vx are parallel (same or opposite orientation).

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates - a coordinate system with an origin p, where v gives the 'main direction' (here, 'x direction' and 'y direction' are defined automatically).

        """
        _gp.gp_Ax2_swiginit(self, _gp.new_gp_Ax2(*args))

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax2

        Return
        -------
        float

        Description
        -----------
        Computes the angular value, in radians, between the main direction of <self> and the main direction of <theother>. returns the angle between 0 and pi in radians.

        """
        return _gp.gp_Ax2_Angle(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the main axis of <self>. it is the 'location' point and the main 'direction'.

        """
        return _gp.gp_Ax2_Axis(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the main direction of <self>.

        """
        return _gp.gp_Ax2_Direction(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Ax2_DumpJsonToString(self, depth)

    def InitFromJsonString(self, json_string):
        r"""InitFromJsonString(gp_Ax2 self, std::string json_string) -> bool"""
        return _gp.gp_Ax2_InitFromJsonString(self, json_string)

    def IsCoplanar(self, *args):
        r"""

        Parameters
        ----------
        Other: gp_Ax2
        LinearTolerance: float
        AngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        LinearTolerance: float
        AngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if . the distance between <self> and the 'location' point of a1 is lower of equal to lineartolerance and . the main direction of <self> and the direction of a1 are normal. note: the tolerance criterion for angular equality is given by angulartolerance.

        """
        return _gp.gp_Ax2_IsCoplanar(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the 'location' point (origin) of <self>.

        """
        return _gp.gp_Ax2_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Performs a symmetrical transformation of this coordinate system with respect to: - the point p, and assigns the result to this coordinate system. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Performs a symmetrical transformation of this coordinate system with respect to: - the axis a1, and assigns the result to this coordinate systeme. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Performs a symmetrical transformation of this coordinate system with respect to: - the plane defined by the origin, 'x direction' and 'y direction' of coordinate system a2 and assigns the result to this coordinate systeme. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        """
        return _gp.gp_Ax2_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        gp_Ax2

        Description
        -----------
        Performs a symmetrical transformation of this coordinate system with respect to: - the point p, and creates a new one. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        gp_Ax2

        Description
        -----------
        Performs a symmetrical transformation of this coordinate system with respect to: - the axis a1, and creates a new one. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        gp_Ax2

        Description
        -----------
        Performs a symmetrical transformation of this coordinate system with respect to: - the plane defined by the origin, 'x direction' and 'y direction' of coordinate system a2 and creates a new one. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        """
        return _gp.gp_Ax2_Mirrored(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Ax2

        Description
        -----------
        Rotates an axis placement. <thea1> is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Ax2_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Ax2

        Description
        -----------
        Applies a scaling transformation on the axis placement. the 'location' point of the axisplacement is modified. warnings: if the scale <s> is negative: . the main direction of the axis placement is not changed. . the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        """
        return _gp.gp_Ax2_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Assigns the origin and 'main direction' of the axis a1 to this coordinate system, then recomputes its 'x direction' and 'y direction'. note: the new 'x direction' is computed as follows: new 'x direction' = v1 ^(previous 'x direction' ^ v) where v is the 'direction' of a1. exceptions standard_constructionerror if a1 is parallel to the 'x direction' of this coordinate system.

        """
        return _gp.gp_Ax2_SetAxis(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the 'main direction' of this coordinate system, then recomputes its 'x direction' and 'y direction'. note: the new 'x direction' is computed as follows: new 'x direction' = v ^ (previous 'x direction' ^ v) exceptions standard_constructionerror if v is parallel to the 'x direction' of this coordinate system.

        """
        return _gp.gp_Ax2_SetDirection(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the 'location' point (origin) of <self>.

        """
        return _gp.gp_Ax2_SetLocation(self, *args)

    def SetXDirection(self, *args):
        r"""

        Parameters
        ----------
        theVx: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the 'xdirection' of <self>. the main direction 'direction' is not modified, the 'ydirection' is modified. if <vx> is not normal to the main direction then <xdirection> is computed as follows xdirection = direction ^ (vx ^ direction). exceptions standard_constructionerror if vx or vy is parallel to the 'main direction' of this coordinate system.

        """
        return _gp.gp_Ax2_SetXDirection(self, *args)

    def SetYDirection(self, *args):
        r"""

        Parameters
        ----------
        theVy: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the 'ydirection' of <self>. the main direction is not modified but the 'xdirection' is changed. if <vy> is not normal to the main direction then 'ydirection' is computed as follows ydirection = direction ^ (<vy> ^ direction). exceptions standard_constructionerror if vx or vy is parallel to the 'main direction' of this coordinate system.

        """
        return _gp.gp_Ax2_SetYDirection(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Ax2

        Description
        -----------
        Transforms an axis placement with a trsf. the 'location' point, the 'xdirection' and the 'ydirection' are transformed with thet. the resulting main 'direction' of <self> is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        """
        return _gp.gp_Ax2_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Ax2

        Description
        -----------
        Translates an axis plaxement in the direction of the vector <thev>. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Ax2

        Description
        -----------
        Translates an axis placement from the point <thep1> to the point <thep2>.

        """
        return _gp.gp_Ax2_Translated(self, *args)

    def XDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the 'xdirection' of <self>.

        """
        return _gp.gp_Ax2_XDirection(self, *args)

    def YDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the 'ydirection' of <self>.

        """
        return _gp.gp_Ax2_YDirection(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Ax2()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Ax2')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax2

# Register gp_Ax2 in _gp:
_gp.gp_Ax2_swigregister(gp_Ax2)
class gp_Ax22d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an object representing the reference coordinate system (oxy).

        Parameters
        ----------
        theP: gp_Pnt2d
        theVx: gp_Dir2d
        theVy: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Creates a coordinate system with origin thep and where: - thevx is the 'x direction', and - the 'y direction' is orthogonal to thevx and oriented so that the cross products thevx^'y direction' and thevx^thevy have the same sign. raises constructionerror if thevx and thevy are parallel (same or opposite orientation).

        Parameters
        ----------
        theP: gp_Pnt2d
        theV: gp_Dir2d
        theIsSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates - a coordinate system with origin thep and 'x direction' thev, which is: - right-handed if theissense is true (default value), or - left-handed if theissense is false.

        Parameters
        ----------
        theA: gp_Ax2d
        theIsSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates - a coordinate system where its origin is the origin of thea and its 'x direction' is the unit vector of thea, which is: - right-handed if theissense is true (default value), or - left-handed if theissense is false.

        """
        _gp.gp_Ax22d_swiginit(self, _gp.new_gp_Ax22d(*args))

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Ax22d_DumpJsonToString(self, depth)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the 'location' point (origin) of <self>.

        """
        return _gp.gp_Ax22d_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax22d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        gp_Ax22d

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to the point thep which is the center of the symmetry. warnings: the main direction of the axis placement is not changed. the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        gp_Ax22d

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry. the transformation is performed on the 'location' point, on the 'xdirection' and 'ydirection'. the resulting main 'direction' is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        """
        return _gp.gp_Ax22d_Mirrored(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax22d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        gp_Ax22d

        Description
        -----------
        Rotates an axis placement. <thea1> is the axis of the rotation . theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Ax22d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax22d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        gp_Ax22d

        Description
        -----------
        Applies a scaling transformation on the axis placement. the 'location' point of the axisplacement is modified. warnings: if the scale <thes> is negative: . the main direction of the axis placement is not changed. . the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        """
        return _gp.gp_Ax22d_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax22d

        Return
        -------
        None

        Description
        -----------
        Assigns the origin and the two unit vectors of the coordinate system thea1 to this coordinate system.

        """
        return _gp.gp_Ax22d_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Changes the 'location' point (origin) of <self>.

        """
        return _gp.gp_Ax22d_SetLocation(self, *args)

    def SetXAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes the xaxis and yaxis ('location' point and 'direction') of <self>. the 'ydirection' is recomputed in the same sense as before.

        """
        return _gp.gp_Ax22d_SetXAxis(self, *args)

    def SetXDirection(self, *args):
        r"""

        Parameters
        ----------
        theVx: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Assigns thevx to the 'x direction' of this coordinate system. the other unit vector of this coordinate system is recomputed, normal to thevx , without modifying the orientation (right-handed or left-handed) of this coordinate system.

        """
        return _gp.gp_Ax22d_SetXDirection(self, *args)

    def SetYAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes the xaxis and yaxis ('location' point and 'direction') of <self>. the 'xdirection' is recomputed in the same sense as before.

        """
        return _gp.gp_Ax22d_SetYAxis(self, *args)

    def SetYDirection(self, *args):
        r"""

        Parameters
        ----------
        theVy: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Assignsr thevy to the 'y direction' of this coordinate system. the other unit vector of this coordinate system is recomputed, normal to thevy, without modifying the orientation (right-handed or left-handed) of this coordinate system.

        """
        return _gp.gp_Ax22d_SetYDirection(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax22d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Ax22d

        Description
        -----------
        Transforms an axis placement with a trsf. the 'location' point, the 'xdirection' and the 'ydirection' are transformed with thet. the resulting main 'direction' of <self> is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        """
        return _gp.gp_Ax22d_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax22d_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Ax22d

        Description
        -----------
        Translates an axis plaxement in the direction of the vector <thev>. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        gp_Ax22d

        Description
        -----------
        Translates an axis placement from the point <thep1> to the point <thep2>.

        """
        return _gp.gp_Ax22d_Translated(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Returns an axis, for which - the origin is that of this coordinate system, and - the unit vector is either the 'x direction' of this coordinate system. note: the result is the 'x axis' of this coordinate system.

        """
        return _gp.gp_Ax22d_XAxis(self, *args)

    def XDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        Returns the 'xdirection' of <self>.

        """
        return _gp.gp_Ax22d_XDirection(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Returns an axis, for which - the origin is that of this coordinate system, and - the unit vector is either the 'y direction' of this coordinate system. note: the result is the 'y axis' of this coordinate system.

        """
        return _gp.gp_Ax22d_YAxis(self, *args)

    def YDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        Returns the 'ydirection' of <self>.

        """
        return _gp.gp_Ax22d_YDirection(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Ax22d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Ax22d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax22d

# Register gp_Ax22d in _gp:
_gp.gp_Ax22d_swigregister(gp_Ax22d)
class gp_Ax2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an axis object representing x axis of the reference co-ordinate system.

        Parameters
        ----------
        theP: gp_Pnt2d
        theV: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Creates an ax2d. <thep> is the 'location' point of the axis placement and thev is the 'direction' of the axis placement.

        """
        _gp.gp_Ax2d_swiginit(self, _gp.new_gp_Ax2d(*args))

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax2d

        Return
        -------
        float

        Description
        -----------
        Computes the angle, in radians, between this axis and the axis theother. the value of the angle is between -pi and pi.

        """
        return _gp.gp_Ax2d_Angle(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        Returns the direction of <self>.

        """
        return _gp.gp_Ax2d_Direction(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Ax2d_DumpJsonToString(self, depth)

    def IsCoaxial(self, *args):
        r"""

        Parameters
        ----------
        Other: gp_Ax2d
        AngularTolerance: float
        LinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if: . the angle between <self> and <other> is lower or equal to <angulartolerance> and . the distance between <self>.location() and <other> is lower or equal to <lineartolerance> and . the distance between <other>.location() and <self> is lower or equal to lineartolerance.

        """
        return _gp.gp_Ax2d_IsCoaxial(self, *args)

    def IsNormal(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if this axis and the axis theother are normal to each other. that is, if the angle between the two axes is equal to pi/2 or -pi/2. note: the tolerance criterion is given by theangulartolerance.

        """
        return _gp.gp_Ax2d_IsNormal(self, *args)

    def IsOpposite(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if this axis and the axis theother are parallel, and have opposite orientations. that is, if the angle between the two axes is equal to pi or -pi. note: the tolerance criterion is given by theangulartolerance.

        """
        return _gp.gp_Ax2d_IsOpposite(self, *args)

    def IsParallel(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if this axis and the axis theother are parallel, and have either the same or opposite orientations. that is, if the angle between the two axes is equal to 0, pi or -pi. note: the tolerance criterion is given by theangulartolerance.

        """
        return _gp.gp_Ax2d_IsParallel(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the origin of <self>.

        """
        return _gp.gp_Ax2d_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt2d

        Return
        -------
        gp_Ax2d

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Return
        -------
        gp_Ax2d

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Ax2d_Mirrored(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the direction of <self> and assigns the result to this axis.

        """
        return _gp.gp_Ax2d_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Computes a new axis placement with a direction opposite to the direction of <self>.

        """
        return _gp.gp_Ax2d_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        gp_Ax2d

        Description
        -----------
        Rotates an axis placement. <thep> is the center of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Ax2d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        gp_Ax2d

        Description
        -----------
        Applies a scaling transformation on the axis placement. the 'location' point of the axisplacement is modified. the 'direction' is reversed if the scale is negative.

        """
        return _gp.gp_Ax2d_Scaled(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Changes the direction of <self>.

        """
        return _gp.gp_Ax2d_SetDirection(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Changes the 'location' point (origin) of <self>.

        """
        return _gp.gp_Ax2d_SetLocation(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Ax2d

        Description
        -----------
        Transforms an axis placement with a trsf.

        """
        return _gp.gp_Ax2d_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax2d_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Ax2d

        Description
        -----------
        Translates an axis placement in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        gp_Ax2d

        Description
        -----------
        Translates an axis placement from the point thep1 to the point thep2.

        """
        return _gp.gp_Ax2d_Translated(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Ax2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Ax2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax2d

# Register gp_Ax2d in _gp:
_gp.gp_Ax2d_swigregister(gp_Ax2d)
class gp_Ax3(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an object corresponding to the reference coordinate system (oxyz).

        Parameters
        ----------
        theA: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Creates a coordinate system from a right-handed coordinate system.

        Parameters
        ----------
        theP: gp_Pnt
        theN: gp_Dir
        theVx: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates a right handed axis placement with the 'location' point thep and two directions, then gives the 'direction' and thevx gives the 'xdirection'. raises constructionerror if then and thevx are parallel (same or opposite orientation).

        Parameters
        ----------
        theP: gp_Pnt
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates an axis placement with the 'location' point <thep> and the normal direction <thev>.

        """
        _gp.gp_Ax3_swiginit(self, _gp.new_gp_Ax3(*args))

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax3

        Return
        -------
        float

        Description
        -----------
        Computes the angular value between the main direction of <self> and the main direction of <theother>. returns the angle between 0 and pi in radians.

        """
        return _gp.gp_Ax3_Angle(self, *args)

    def Ax2(self, *args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Computes a right-handed coordinate system with the same 'x direction' and 'y direction' as those of this coordinate system, then recomputes the 'main direction'. if this coordinate system is right-handed, the result returned is the same coordinate system. if this coordinate system is left-handed, the result is reversed.

        """
        return _gp.gp_Ax3_Ax2(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the main axis of <self>. it is the 'location' point and the main 'direction'.

        """
        return _gp.gp_Ax3_Axis(self, *args)

    def Direct(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the coordinate system is right-handed. i.e. xdirection().crossed(ydirection()).dot(direction()) > 0.

        """
        return _gp.gp_Ax3_Direct(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the main direction of <self>.

        """
        return _gp.gp_Ax3_Direction(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Ax3_DumpJsonToString(self, depth)

    def InitFromJsonString(self, json_string):
        r"""InitFromJsonString(gp_Ax3 self, std::string json_string) -> bool"""
        return _gp.gp_Ax3_InitFromJsonString(self, json_string)

    def IsCoplanar(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Ax3
        theLinearTolerance: float
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if . the distance between the 'location' point of <self> and <theother> is lower or equal to thelineartolerance and . the distance between the 'location' point of <theother> and <self> is lower or equal to thelineartolerance and . the main direction of <self> and the main direction of <theother> are parallel (same or opposite orientation).

        Parameters
        ----------
        theA1: gp_Ax1
        theLinearTolerance: float
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if . the distance between <self> and the 'location' point of thea1 is lower of equal to thelineartolerance and . the distance between thea1 and the 'location' point of <self> is lower or equal to thelineartolerance and . the main direction of <self> and the direction of thea1 are normal.

        """
        return _gp.gp_Ax3_IsCoplanar(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the 'location' point (origin) of <self>.

        """
        return _gp.gp_Ax3_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax3_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Ax3

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to the point thep which is the center of the symmetry. warnings: the main direction of the axis placement is not changed. the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Ax3

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry. the transformation is performed on the 'location' point, on the 'xdirection' and 'ydirection'. the resulting main 'direction' is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Ax3

        Description
        -----------
        Performs the symmetrical transformation of an axis placement with respect to a plane. the axis placement <thea2> locates the plane of the symmetry: (location, xdirection, ydirection). the transformation is performed on the 'location' point, on the 'xdirection' and 'ydirection'. the resulting main 'direction' is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        """
        return _gp.gp_Ax3_Mirrored(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax3_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Ax3

        Description
        -----------
        Rotates an axis placement. <thea1> is the axis of the rotation . theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Ax3_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax3_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Ax3

        Description
        -----------
        Applies a scaling transformation on the axis placement. the 'location' point of the axisplacement is modified. warnings: if the scale <thes> is negative: . the main direction of the axis placement is not changed. . the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        """
        return _gp.gp_Ax3_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Assigns the origin and 'main direction' of the axis thea1 to this coordinate system, then recomputes its 'x direction' and 'y direction'. note: - the new 'x direction' is computed as follows: new 'x direction' = v1 ^(previous 'x direction' ^ v) where v is the 'direction' of thea1. - the orientation of this coordinate system (right-handed or left-handed) is not modified. raises constructionerror if the 'direction' of <thea1> and the 'xdirection' of <self> are parallel (same or opposite orientation) because it is impossible to calculate the new 'xdirection' and the new 'ydirection'.

        """
        return _gp.gp_Ax3_SetAxis(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the main direction of this coordinate system, then recomputes its 'x direction' and 'y direction'. note: - the new 'x direction' is computed as follows: new 'x direction' = thev ^ (previous 'x direction' ^ thev). - the orientation of this coordinate system (left- or right-handed) is not modified. raises constructionerror if <thev> and the previous 'xdirection' are parallel because it is impossible to calculate the new 'xdirection' and the new 'ydirection'.

        """
        return _gp.gp_Ax3_SetDirection(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the 'location' point (origin) of <self>.

        """
        return _gp.gp_Ax3_SetLocation(self, *args)

    def SetXDirection(self, *args):
        r"""

        Parameters
        ----------
        theVx: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the 'xdirection' of <self>. the main direction 'direction' is not modified, the 'ydirection' is modified. if <thevx> is not normal to the main direction then <xdirection> is computed as follows xdirection = direction ^ (thevx ^ direction). raises constructionerror if <thevx> is parallel (same or opposite orientation) to the main direction of <self>.

        """
        return _gp.gp_Ax3_SetXDirection(self, *args)

    def SetYDirection(self, *args):
        r"""

        Parameters
        ----------
        theVy: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the 'ydirection' of <self>. the main direction is not modified but the 'xdirection' is changed. if <thevy> is not normal to the main direction then 'ydirection' is computed as follows ydirection = direction ^ (<thevy> ^ direction). raises constructionerror if <thevy> is parallel to the main direction of <self>.

        """
        return _gp.gp_Ax3_SetYDirection(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax3_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Ax3

        Description
        -----------
        Transforms an axis placement with a trsf. the 'location' point, the 'xdirection' and the 'ydirection' are transformed with thet. the resulting main 'direction' of <self> is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        """
        return _gp.gp_Ax3_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Ax3_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Ax3

        Description
        -----------
        Translates an axis plaxement in the direction of the vector <thev>. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Ax3

        Description
        -----------
        Translates an axis placement from the point <thep1> to the point <thep2>.

        """
        return _gp.gp_Ax3_Translated(self, *args)

    def XDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the 'xdirection' of <self>.

        """
        return _gp.gp_Ax3_XDirection(self, *args)

    def XReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the x direction of <self>.

        """
        return _gp.gp_Ax3_XReverse(self, *args)

    def YDirection(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the 'ydirection' of <self>.

        """
        return _gp.gp_Ax3_YDirection(self, *args)

    def YReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the y direction of <self>.

        """
        return _gp.gp_Ax3_YReverse(self, *args)

    def ZReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the z direction of <self>.

        """
        return _gp.gp_Ax3_ZReverse(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Ax3()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Ax3')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax3

# Register gp_Ax3 in _gp:
_gp.gp_Ax3_swigregister(gp_Ax3)
class gp_Circ(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite circle.

        Parameters
        ----------
        theA2: gp_Ax2
        theRadius: float

        Return
        -------
        None

        Description
        -----------
        A2 locates the circle and gives its orientation in 3d space. warnings: it is not forbidden to create a circle with theradius = 0.0 raises constructionerror if theradius < 0.0.

        """
        _gp.gp_Circ_swiginit(self, _gp.new_gp_Circ(*args))

    def Area(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the area of the circle.

        """
        return _gp.gp_Circ_Area(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the main axis of the circle. it is the axis perpendicular to the plane of the circle, passing through the 'location' point (center) of the circle.

        """
        return _gp.gp_Circ_Axis(self, *args)

    def Contains(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theLinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the point thep is on the circumference. the distance between <self> and <thep> must be lower or equal to thelineartolerance.

        """
        return _gp.gp_Circ_Contains(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Computes the minimum of distance between the point thep and any point on the circumference of the circle.

        """
        return _gp.gp_Circ_Distance(self, *args)

    def Length(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the circumference of the circle.

        """
        return _gp.gp_Circ_Length(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the center of the circle. it is the 'location' point of the local coordinate system of the circle.

        """
        return _gp.gp_Circ_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Circ

        Description
        -----------
        Performs the symmetrical transformation of a circle with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Circ

        Description
        -----------
        Performs the symmetrical transformation of a circle with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Circ

        Description
        -----------
        Performs the symmetrical transformation of a circle with respect to a plane. the axis placement thea2 locates the plane of the of the symmetry: (location, xdirection, ydirection).

        """
        return _gp.gp_Circ_Mirrored(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Returns the position of the circle. it is the local coordinate system of the circle.

        """
        return _gp.gp_Circ_Position(self, *args)

    def Radius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the radius of this circle.

        """
        return _gp.gp_Circ_Radius(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Circ

        Description
        -----------
        Rotates a circle. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Circ_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Circ

        Description
        -----------
        Scales a circle. thes is the scaling value. warnings: if thes is negative the radius stay positive but the 'xaxis' and the 'yaxis' are reversed as for an ellipse.

        """
        return _gp.gp_Circ_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Changes the main axis of the circle. it is the axis perpendicular to the plane of the circle. raises constructionerror if the direction of thea1 is parallel to the 'xaxis' of the circle.

        """
        return _gp.gp_Circ_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the 'location' point (center) of the circle.

        """
        return _gp.gp_Circ_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Changes the position of the circle.

        """
        return _gp.gp_Circ_SetPosition(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        theRadius: float

        Return
        -------
        None

        Description
        -----------
        Modifies the radius of this circle. warning. this class does not prevent the creation of a circle where theradius is null. exceptions standard_constructionerror if theradius is negative.

        """
        return _gp.gp_Circ_SetRadius(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between <self> and the point thep.

        """
        return _gp.gp_Circ_SquareDistance(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Circ

        Description
        -----------
        Transforms a circle with the transformation thet from class trsf.

        """
        return _gp.gp_Circ_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Circ

        Description
        -----------
        Translates a circle in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Circ

        Description
        -----------
        Translates a circle from the point thep1 to the point thep2.

        """
        return _gp.gp_Circ_Translated(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the 'xaxis' of the circle. this axis is perpendicular to the axis of the conic. this axis and the 'yaxis' define the plane of the conic.

        """
        return _gp.gp_Circ_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the 'yaxis' of the circle. this axis and the 'xaxis' define the plane of the conic. the 'yaxis' is perpendicular to the 'xaxis'.

        """
        return _gp.gp_Circ_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Circ()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Circ')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Circ

# Register gp_Circ in _gp:
_gp.gp_Circ_swigregister(gp_Circ)
class gp_Circ2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite circle.

        Parameters
        ----------
        theXAxis: gp_Ax2d
        theRadius: float
        theIsSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        The location point of thexaxis is the center of the circle. warnings: it is not forbidden to create a circle with theradius = 0.0 raises constructionerror if theradius < 0.0. raised if theradius < 0.0.

        Parameters
        ----------
        theAxis: gp_Ax22d
        theRadius: float

        Return
        -------
        None

        Description
        -----------
        Theaxis defines the xaxis and yaxis of the circle which defines the origin and the sense of parametrization. the location point of theaxis is the center of the circle. warnings: it is not forbidden to create a circle with theradius = 0.0 raises constructionerror if theradius < 0.0. raised if theradius < 0.0.

        """
        _gp.gp_Circ2d_swiginit(self, _gp.new_gp_Circ2d(*args))

    def Area(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the area of the circle.

        """
        return _gp.gp_Circ2d_Area(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax22d

        Description
        -----------
        Returns the position of the circle.

        """
        return _gp.gp_Circ2d_Axis(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA: float
        theB: float
        theC: float
        theD: float
        theE: float
        theF: float

        Description
        -----------
        Returns the normalized coefficients from the implicit equation of the circle: thea * (x**2) + theb * (y**2) + 2*thec*(x*y) + 2*thed*x + 2*thee*y + thef = 0.0.

        """
        return _gp.gp_Circ2d_Coefficients(self, *args)

    def Contains(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theLinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Does <self> contain thep ? returns true if the distance between thep and any point on the circumference of the circle is lower of equal to <thelineartolerance>.

        """
        return _gp.gp_Circ2d_Contains(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        float

        Description
        -----------
        Computes the minimum of distance between the point thep and any point on the circumference of the circle.

        """
        return _gp.gp_Circ2d_Distance(self, *args)

    def IsDirect(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the local coordinate system is direct and false in the other case.

        """
        return _gp.gp_Circ2d_IsDirect(self, *args)

    def Length(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the circumference of the circle.

        """
        return _gp.gp_Circ2d_Length(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the location point (center) of the circle.

        """
        return _gp.gp_Circ2d_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ2d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        gp_Circ2d

        Description
        -----------
        Performs the symmetrical transformation of a circle with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        gp_Circ2d

        Description
        -----------
        Performs the symmetrical transformation of a circle with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Circ2d_Mirrored(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax22d

        Description
        -----------
        Returns the position of the circle. idem axis(me).

        """
        return _gp.gp_Circ2d_Position(self, *args)

    def Radius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the radius value of the circle.

        """
        return _gp.gp_Circ2d_Radius(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the orientation of the local coordinate system of this circle (the 'y direction' is reversed) and therefore changes the implicit orientation of this circle. reverse assigns the result to this circle,.

        """
        return _gp.gp_Circ2d_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Circ2d

        Description
        -----------
        Reverses the orientation of the local coordinate system of this circle (the 'y direction' is reversed) and therefore changes the implicit orientation of this circle. reversed creates a new circle.

        """
        return _gp.gp_Circ2d_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        gp_Circ2d

        Description
        -----------
        Rotates a circle. thep is the center of the rotation. ang is the angular value of the rotation in radians.

        """
        return _gp.gp_Circ2d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ2d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        gp_Circ2d

        Description
        -----------
        Scales a circle. thes is the scaling value. warnings: if thes is negative the radius stay positive but the 'xaxis' and the 'yaxis' are reversed as for an ellipse.

        """
        return _gp.gp_Circ2d_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax22d

        Return
        -------
        None

        Description
        -----------
        Changes the x axis of the circle.

        """
        return _gp.gp_Circ2d_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Changes the location point (center) of the circle.

        """
        return _gp.gp_Circ2d_SetLocation(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        theRadius: float

        Return
        -------
        None

        Description
        -----------
        Modifies the radius of this circle. this class does not prevent the creation of a circle where theradius is null. exceptions standard_constructionerror if theradius is negative.

        """
        return _gp.gp_Circ2d_SetRadius(self, *args)

    def SetXAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes the x axis of the circle.

        """
        return _gp.gp_Circ2d_SetXAxis(self, *args)

    def SetYAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes the y axis of the circle.

        """
        return _gp.gp_Circ2d_SetYAxis(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between <self> and the point thep.

        """
        return _gp.gp_Circ2d_SquareDistance(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Circ2d

        Description
        -----------
        Transforms a circle with the transformation thet from class trsf2d.

        """
        return _gp.gp_Circ2d_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Circ2d_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Circ2d

        Description
        -----------
        Translates a circle in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        gp_Circ2d

        Description
        -----------
        Translates a circle from the point thep1 to the point thep2.

        """
        return _gp.gp_Circ2d_Translated(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Returns the x axis of the circle.

        """
        return _gp.gp_Circ2d_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Returns the y axis of the circle. reverses the direction of the circle.

        """
        return _gp.gp_Circ2d_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Circ2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Circ2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Circ2d

# Register gp_Circ2d in _gp:
_gp.gp_Circ2d_swigregister(gp_Circ2d)
class gp_Cone(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite cone.

        Parameters
        ----------
        theA3: gp_Ax3
        theAng: float
        theRadius: float

        Return
        -------
        None

        Description
        -----------
        Creates an infinite conical surface. thea3 locates the cone in the space and defines the reference plane of the surface. ang is the conical surface semi-angle. its absolute value is in range ]0, pi/2[. theradius is the radius of the circle in the reference plane of the cone. theraises constructionerror * if theradius is lower than 0.0 * abs(theang) < resolution from gp or abs(theang) >= (pi/2) - resolution.

        """
        _gp.gp_Cone_swiginit(self, _gp.new_gp_Cone(*args))

    def Apex(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Computes the cone's top. the apex of the cone is on the negative side of the symmetry axis of the cone.

        """
        return _gp.gp_Cone_Apex(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the symmetry axis of the cone.

        """
        return _gp.gp_Cone_Axis(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA1: float
        theA2: float
        theA3: float
        theB1: float
        theB2: float
        theB3: float
        theC1: float
        theC2: float
        theC3: float
        theD: float

        Description
        -----------
        Computes the coefficients of the implicit equation of the quadric in the absolute cartesian coordinates system: thea1.x**2 + thea2.y**2 + thea3.z**2 + 2.(theb1.x.y + theb2.x.z + theb3.y.z) + 2.(thec1.x + thec2.y + thec3.z) + thed = 0.0.

        """
        return _gp.gp_Cone_Coefficients(self, *args)

    def Direct(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the local coordinate system of this cone is right-handed.

        """
        return _gp.gp_Cone_Direct(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the 'location' point of the cone.

        """
        return _gp.gp_Cone_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cone_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Cone

        Description
        -----------
        Performs the symmetrical transformation of a cone with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Cone

        Description
        -----------
        Performs the symmetrical transformation of a cone with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Cone

        Description
        -----------
        Performs the symmetrical transformation of a cone with respect to a plane. the axis placement thea2 locates the plane of the of the symmetry: (location, xdirection, ydirection).

        """
        return _gp.gp_Cone_Mirrored(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Returns the local coordinates system of the cone.

        """
        return _gp.gp_Cone_Position(self, *args)

    def RefRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the radius of the cone in the reference plane.

        """
        return _gp.gp_Cone_RefRadius(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cone_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Cone

        Description
        -----------
        Rotates a cone. thea1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        """
        return _gp.gp_Cone_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cone_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Cone

        Description
        -----------
        Scales a cone. thes is the scaling value. the absolute value of thes is used to scale the cone.

        """
        return _gp.gp_Cone_Scaled(self, *args)

    def SemiAngle(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the half-angle at the apex of this cone. attention! semi-angle can be negative.

        """
        return _gp.gp_Cone_SemiAngle(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Changes the symmetry axis of the cone. raises constructionerror the direction of thea1 is parallel to the 'xdirection' of the coordinate system of the cone.

        """
        return _gp.gp_Cone_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theLoc: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the location of the cone.

        """
        return _gp.gp_Cone_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA3: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Changes the local coordinate system of the cone. this coordinate system defines the reference plane of the cone.

        """
        return _gp.gp_Cone_SetPosition(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        theR: float

        Return
        -------
        None

        Description
        -----------
        Changes the radius of the cone in the reference plane of the cone. raised if ther < 0.0.

        """
        return _gp.gp_Cone_SetRadius(self, *args)

    def SetSemiAngle(self, *args):
        r"""

        Parameters
        ----------
        theAng: float

        Return
        -------
        None

        Description
        -----------
        Changes the semi-angle of the cone. semi-angle can be negative. its absolute value abs(theang) is in range ]0,pi/2[. raises constructionerror if abs(theang) < resolution from gp or abs(theang) >= pi/2 - resolution.

        """
        return _gp.gp_Cone_SetSemiAngle(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cone_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Cone

        Description
        -----------
        Transforms a cone with the transformation thet from class trsf.

        """
        return _gp.gp_Cone_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cone_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Cone

        Description
        -----------
        Translates a cone in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Cone

        Description
        -----------
        Translates a cone from the point p1 to the point p2.

        """
        return _gp.gp_Cone_Translated(self, *args)

    def UReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the u parametrization of the cone reversing the yaxis.

        """
        return _gp.gp_Cone_UReverse(self, *args)

    def VReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the v parametrization of the cone reversing the zaxis.

        """
        return _gp.gp_Cone_VReverse(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the xaxis of the reference plane.

        """
        return _gp.gp_Cone_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the yaxis of the reference plane.

        """
        return _gp.gp_Cone_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Cone()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Cone')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Cone

# Register gp_Cone in _gp:
_gp.gp_Cone_swigregister(gp_Cone)
class gp_Cylinder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a indefinite cylinder.

        Parameters
        ----------
        theA3: gp_Ax3
        theRadius: float

        Return
        -------
        None

        Description
        -----------
        Creates a cylinder of radius radius, whose axis is the 'main axis' of thea3. thea3 is the local coordinate system of the cylinder. raises constructionerrord if theradius < 0.0.

        """
        _gp.gp_Cylinder_swiginit(self, _gp.new_gp_Cylinder(*args))

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the symmetry axis of the cylinder.

        """
        return _gp.gp_Cylinder_Axis(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA1: float
        theA2: float
        theA3: float
        theB1: float
        theB2: float
        theB3: float
        theC1: float
        theC2: float
        theC3: float
        theD: float

        Description
        -----------
        Computes the coefficients of the implicit equation of the quadric in the absolute cartesian coordinate system: thea1.x**2 + thea2.y**2 + thea3.z**2 + 2.(theb1.x.y + theb2.x.z + theb3.y.z) + 2.(thec1.x + thec2.y + thec3.z) + thed = 0.0.

        """
        return _gp.gp_Cylinder_Coefficients(self, *args)

    def Direct(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the local coordinate system of this cylinder is right-handed.

        """
        return _gp.gp_Cylinder_Direct(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the 'location' point of the cylinder.

        """
        return _gp.gp_Cylinder_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cylinder_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Cylinder

        Description
        -----------
        Performs the symmetrical transformation of a cylinder with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Cylinder

        Description
        -----------
        Performs the symmetrical transformation of a cylinder with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Cylinder

        Description
        -----------
        Performs the symmetrical transformation of a cylinder with respect to a plane. the axis placement thea2 locates the plane of the of the symmetry: (location, xdirection, ydirection).

        """
        return _gp.gp_Cylinder_Mirrored(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Returns the local coordinate system of the cylinder.

        """
        return _gp.gp_Cylinder_Position(self, *args)

    def Radius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the radius of the cylinder.

        """
        return _gp.gp_Cylinder_Radius(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cylinder_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Cylinder

        Description
        -----------
        Rotates a cylinder. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Cylinder_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cylinder_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Cylinder

        Description
        -----------
        Scales a cylinder. thes is the scaling value. the absolute value of thes is used to scale the cylinder.

        """
        return _gp.gp_Cylinder_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Changes the symmetry axis of the cylinder. raises constructionerror if the direction of thea1 is parallel to the 'xdirection' of the coordinate system of the cylinder.

        """
        return _gp.gp_Cylinder_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theLoc: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the location of the surface.

        """
        return _gp.gp_Cylinder_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA3: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Change the local coordinate system of the surface.

        """
        return _gp.gp_Cylinder_SetPosition(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        theR: float

        Return
        -------
        None

        Description
        -----------
        Modifies the radius of this cylinder. exceptions standard_constructionerror if ther is negative.

        """
        return _gp.gp_Cylinder_SetRadius(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cylinder_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Cylinder

        Description
        -----------
        Transforms a cylinder with the transformation thet from class trsf.

        """
        return _gp.gp_Cylinder_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Cylinder_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Cylinder

        Description
        -----------
        Translates a cylinder in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Cylinder

        Description
        -----------
        Translates a cylinder from the point thep1 to the point thep2.

        """
        return _gp.gp_Cylinder_Translated(self, *args)

    def UReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the u parametrization of the cylinder reversing the yaxis.

        """
        return _gp.gp_Cylinder_UReverse(self, *args)

    def VReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the v parametrization of the plane reversing the axis.

        """
        return _gp.gp_Cylinder_VReverse(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the axis x of the cylinder.

        """
        return _gp.gp_Cylinder_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the axis y of the cylinder.

        """
        return _gp.gp_Cylinder_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Cylinder()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Cylinder')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Cylinder

# Register gp_Cylinder in _gp:
_gp.gp_Cylinder_swigregister(gp_Cylinder)
class gp_Dir(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a direction corresponding to x axis.

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Normalizes the vector thev and creates a direction. raises constructionerror if thev.magnitude() <= resolution.

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Creates a direction from a triplet of coordinates. raises constructionerror if thecoord.modulus() <= resolution from gp.

        Parameters
        ----------
        theXv: float
        theYv: float
        theZv: float

        Return
        -------
        None

        Description
        -----------
        Creates a direction with its 3 cartesian coordinates. raises constructionerror if sqrt(thexv*thexv + theyv*theyv + thezv*thezv) <= resolution modification of the direction's coordinates if sqrt (thexv*thexv + theyv*theyv + thezv*thezv) <= resolution from gp where thexv, theyv ,thezv are the new coordinates it is not possible to construct the direction and the method raises the exception constructionerror.

        """
        _gp.gp_Dir_swiginit(self, _gp.new_gp_Dir(*args))

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir

        Return
        -------
        float

        Description
        -----------
        Computes the angular value in radians between <self> and <theother>. this value is always positive in 3d space. returns the angle in the range [0, pi].

        """
        return _gp.gp_Dir_Angle(self, *args)

    def AngleWithRef(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir
        theVRef: gp_Dir

        Return
        -------
        float

        Description
        -----------
        Computes the angular value between <self> and <theother>. <thevref> is the direction of reference normal to <self> and <theother> and its orientation gives the positive sense of rotation. if the cross product <self> ^ <theother> has the same orientation as <thevref> the angular value is positive else negative. returns the angular value in the range -pi and pi (in radians). raises domainerror if <self> and <theother> are not parallel this exception is raised when <thevref> is in the same plane as <self> and <theother> the tolerance criterion is resolution from package gp.

        """
        return _gp.gp_Dir_AngleWithRef(self, *args)

    def Coord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the coordinate of range theindex: theindex = 1 => x is returned ithendex = 2 => y is returned theindex = 3 => z is returned exceptions standard_outofrange if theindex is not 1, 2, or 3.

        Parameters
        ----------

        Return
        -------
        theXv: float
        theYv: float
        theZv: float

        Description
        -----------
        Returns for the unit vector its three coordinates thexv, theyv, and thezv.

        """
        return _gp.gp_Dir_Coord(self, *args)

    def Cross(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Computes the cross product between two directions raises the exception constructionerror if the two directions are parallel because the computed vector cannot be normalized to create a direction.

        """
        return _gp.gp_Dir_Cross(self, *args)

    def CrossCross(self, *args):
        r"""

        Parameters
        ----------
        theV1: gp_Dir
        theV2: gp_Dir

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir_CrossCross(self, *args)

    def CrossCrossed(self, *args):
        r"""

        Parameters
        ----------
        theV1: gp_Dir
        theV2: gp_Dir

        Return
        -------
        gp_Dir

        Description
        -----------
        Computes the double vector product this ^ (thev1 ^ thev2). - crosscrossed creates a new unit vector. exceptions standard_constructionerror if: - thev1 and thev2 are parallel, or - this unit vector and (thev1 ^ thev2) are parallel. this is because, in these conditions, the computed vector is null and cannot be normalized.

        """
        return _gp.gp_Dir_CrossCrossed(self, *args)

    def Crossed(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Dir

        Return
        -------
        gp_Dir

        Description
        -----------
        Computes the triple vector product. <self> ^ (v1 ^ v2) raises the exception constructionerror if v1 and v2 are parallel or <self> and (v1^v2) are parallel because the computed vector can't be normalized to create a direction.

        """
        return _gp.gp_Dir_Crossed(self, *args)

    def Dot(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir

        Return
        -------
        float

        Description
        -----------
        Computes the scalar product.

        """
        return _gp.gp_Dir_Dot(self, *args)

    def DotCross(self, *args):
        r"""

        Parameters
        ----------
        theV1: gp_Dir
        theV2: gp_Dir

        Return
        -------
        float

        Description
        -----------
        Computes the triple scalar product <self> * (thev1 ^ thev2). warnings: the computed vector thev1' = thev1 ^ thev2 is not normalized to create a unitary vector. so this method never raises an exception even if thev1 and thev2 are parallel.

        """
        return _gp.gp_Dir_DotCross(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Dir_DumpJsonToString(self, depth)

    def InitFromJsonString(self, json_string):
        r"""InitFromJsonString(gp_Dir self, std::string json_string) -> bool"""
        return _gp.gp_Dir_InitFromJsonString(self, json_string)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the angle between the two directions is lower or equal to theangulartolerance.

        """
        return _gp.gp_Dir_IsEqual(self, *args)

    def IsNormal(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the angle between this unit vector and the unit vector theother is equal to pi/2 (normal).

        """
        return _gp.gp_Dir_IsNormal(self, *args)

    def IsOpposite(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the angle between this unit vector and the unit vector theother is equal to pi (opposite).

        """
        return _gp.gp_Dir_IsOpposite(self, *args)

    def IsParallel(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the angle between this unit vector and the unit vector theother is equal to 0 or to pi. note: the tolerance criterion is given by theangulartolerance.

        """
        return _gp.gp_Dir_IsParallel(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir

        Return
        -------
        gp_Dir

        Description
        -----------
        Performs the symmetrical transformation of a direction with respect to the direction thev which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Dir

        Description
        -----------
        Performs the symmetrical transformation of a direction with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Dir

        Description
        -----------
        Performs the symmetrical transformation of a direction with respect to a plane. the axis placement thea2 locates the plane of the symmetry: (location, xdirection, ydirection).

        """
        return _gp.gp_Dir_Mirrored(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Reverses the orientation of a direction geometric transformations performs the symmetrical transformation of a direction with respect to the direction v which is the center of the symmetry.].

        """
        return _gp.gp_Dir_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Dir

        Description
        -----------
        Rotates a direction. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Dir_Rotated(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theXi: float

        Return
        -------
        None

        Description
        -----------
        For this unit vector, assigns the value xi to: - the x coordinate if theindex is 1, or - the y coordinate if theindex is 2, or - the z coordinate if theindex is 3, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_outofrange if theindex is not 1, 2, or 3. standard_constructionerror if either of the following is less than or equal to gp::resolution(): - sqrt(xv*xv + yv*yv + zv*zv), or - the modulus of the number triple formed by the new value thexi and the two other coordinates of this vector that were not directly modified.

        Parameters
        ----------
        theXv: float
        theYv: float
        theZv: float

        Return
        -------
        None

        Description
        -----------
        For this unit vector, assigns the values thexv, theyv and thezv to its three coordinates. remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly.

        """
        return _gp.gp_Dir_SetCoord(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        theX: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this unit vector.

        """
        return _gp.gp_Dir_SetX(self, *args)

    def SetXYZ(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Assigns the three coordinates of thecoord to this unit vector.

        """
        return _gp.gp_Dir_SetXYZ(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        theY: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the y coordinate of this unit vector.

        """
        return _gp.gp_Dir_SetY(self, *args)

    def SetZ(self, *args):
        r"""

        Parameters
        ----------
        theZ: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the z coordinate of this unit vector.

        """
        return _gp.gp_Dir_SetZ(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Dir

        Description
        -----------
        Transforms a direction with a 'trsf' from gp. warnings: if the scale factor of the 'trsf' thet is negative then the direction <self> is reversed.

        """
        return _gp.gp_Dir_Transformed(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the x coordinate for a unit vector.

        """
        return _gp.gp_Dir_X(self, *args)

    def XYZ(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        For this unit vector, returns its three coordinates as a number triplea.

        """
        return _gp.gp_Dir_XYZ(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the y coordinate for a unit vector.

        """
        return _gp.gp_Dir_Y(self, *args)

    def Z(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the z coordinate for a unit vector.

        """
        return _gp.gp_Dir_Z(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir___mul__(self, *args)

    def __neg__(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir___neg__(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Dir()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Dir')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Dir

# Register gp_Dir in _gp:
_gp.gp_Dir_swigregister(gp_Dir)
class gp_Dir2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a direction corresponding to x axis.

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Normalizes the vector thev and creates a direction. raises constructionerror if thev.magnitude() <= resolution from gp.

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Creates a direction from a doublet of coordinates. raises constructionerror if thecoord.modulus() <= resolution from gp.

        Parameters
        ----------
        theXv: float
        theYv: float

        Return
        -------
        None

        Description
        -----------
        Creates a direction with its 2 cartesian coordinates. raises constructionerror if sqrt(thexv*thexv + theyv*theyv) <= resolution from gp.

        """
        _gp.gp_Dir2d_swiginit(self, _gp.new_gp_Dir2d(*args))

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir2d

        Return
        -------
        float

        Description
        -----------
        Computes the angular value in radians between <self> and <theother>. returns the angle in the range [-pi, pi].

        """
        return _gp.gp_Dir2d_Angle(self, *args)

    def Coord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        For this unit vector returns the coordinate of range theindex: theindex = 1 => x is returned theindex = 2 => y is returned raises outofrange if theindex != {1, 2}.

        Parameters
        ----------

        Return
        -------
        theXv: float
        theYv: float

        Description
        -----------
        For this unit vector returns its two coordinates thexv and theyv. raises outofrange if theindex != {1, 2}.

        """
        return _gp.gp_Dir2d_Coord(self, *args)

    def Crossed(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Dir2d

        Return
        -------
        float

        Description
        -----------
        Computes the cross product between two directions.

        """
        return _gp.gp_Dir2d_Crossed(self, *args)

    def Dot(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir2d

        Return
        -------
        float

        Description
        -----------
        Computes the scalar product.

        """
        return _gp.gp_Dir2d_Dot(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Dir2d_DumpJsonToString(self, depth)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the two vectors have the same direction i.e. the angle between this unit vector and the unit vector theother is less than or equal to theangulartolerance.

        """
        return _gp.gp_Dir2d_IsEqual(self, *args)

    def IsNormal(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the angle between this unit vector and the unit vector theother is equal to pi/2 or -pi/2 (normal) i.e. abs(abs(<self>.angle(theother)) - pi/2.) <= theangulartolerance.

        """
        return _gp.gp_Dir2d_IsNormal(self, *args)

    def IsOpposite(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the angle between this unit vector and the unit vector theother is equal to pi or -pi (opposite). i.e. pi - abs(<self>.angle(theother)) <= theangulartolerance.

        """
        return _gp.gp_Dir2d_IsOpposite(self, *args)

    def IsParallel(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the angle between this unit vector and unit vector theother is equal to 0, pi or -pi. i.e. abs(angle(<self>, theother)) <= theangulartolerance or pi - abs(angle(<self>, theother)) <= theangulartolerance.

        """
        return _gp.gp_Dir2d_IsParallel(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir2d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir2d

        Return
        -------
        gp_Dir2d

        Description
        -----------
        Performs the symmetrical transformation of a direction with respect to the direction thev which is the center of the symmetry.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        gp_Dir2d

        Description
        -----------
        Performs the symmetrical transformation of a direction with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Dir2d_Mirrored(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir2d_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        Reverses the orientation of a direction.

        """
        return _gp.gp_Dir2d_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        Ang: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theAng: float

        Return
        -------
        gp_Dir2d

        Description
        -----------
        Rotates a direction. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Dir2d_Rotated(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theXi: float

        Return
        -------
        None

        Description
        -----------
        For this unit vector, assigns: the value thexi to: - the x coordinate if theindex is 1, or - the y coordinate if theindex is 2, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_outofrange if theindex is not 1 or 2. standard_constructionerror if either of the following is less than or equal to gp::resolution(): - sqrt(thexv*thexv + theyv*theyv), or - the modulus of the number pair formed by the new value thexi and the other coordinate of this vector that was not directly modified. raises outofrange if theindex != {1, 2}.

        Parameters
        ----------
        theXv: float
        theYv: float

        Return
        -------
        None

        Description
        -----------
        For this unit vector, assigns: - the values thexv and theyv to its two coordinates, warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_outofrange if theindex is not 1 or 2. standard_constructionerror if either of the following is less than or equal to gp::resolution(): - sqrt(thexv*thexv + theyv*theyv), or - the modulus of the number pair formed by the new value xi and the other coordinate of this vector that was not directly modified. raises outofrange if theindex != {1, 2}.

        """
        return _gp.gp_Dir2d_SetCoord(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        theX: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this unit vector, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_constructionerror if either of the following is less than or equal to gp::resolution(): - the modulus of coord, or - the modulus of the number pair formed from the new x or y coordinate and the other coordinate of this vector that was not directly modified.

        """
        return _gp.gp_Dir2d_SetX(self, *args)

    def SetXY(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Assigns: - the two coordinates of thecoord to this unit vector, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_constructionerror if either of the following is less than or equal to gp::resolution(): - the modulus of thecoord, or - the modulus of the number pair formed from the new x or y coordinate and the other coordinate of this vector that was not directly modified.

        """
        return _gp.gp_Dir2d_SetXY(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        theY: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the y coordinate of this unit vector, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_constructionerror if either of the following is less than or equal to gp::resolution(): - the modulus of coord, or - the modulus of the number pair formed from the new x or y coordinate and the other coordinate of this vector that was not directly modified.

        """
        return _gp.gp_Dir2d_SetY(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Dir2d

        Description
        -----------
        Transforms a direction with the 'trsf' thet. warnings: if the scale factor of the 'trsf' thet is negative then the direction <self> is reversed.

        """
        return _gp.gp_Dir2d_Transformed(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this unit vector, returns its x coordinate.

        """
        return _gp.gp_Dir2d_X(self, *args)

    def XY(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        For this unit vector, returns its two coordinates as a number pair. comparison between directions the precision value is an input data.

        """
        return _gp.gp_Dir2d_XY(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this unit vector, returns its y coordinate.

        """
        return _gp.gp_Dir2d_Y(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Dir2d

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir2d___mul__(self, *args)

    def __neg__(self, *args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Dir2d___neg__(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Dir2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Dir2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Dir2d

# Register gp_Dir2d in _gp:
_gp.gp_Dir2d_swigregister(gp_Dir2d)
class gp_Elips(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite ellipse.

        Parameters
        ----------
        theA2: gp_Ax2
        theMajorRadius: float
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        The major radius of the ellipse is on the 'xaxis' and the minor radius is on the 'yaxis' of the ellipse. the 'xaxis' is defined with the 'xdirection' of thea2 and the 'yaxis' is defined with the 'ydirection' of thea2. warnings: it is not forbidden to create an ellipse with themajorradius = theminorradius. raises constructionerror if themajorradius < theminorradius or theminorradius < 0.

        """
        _gp.gp_Elips_swiginit(self, _gp.new_gp_Elips(*args))

    def Area(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the area of the ellipse.

        """
        return _gp.gp_Elips_Area(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Computes the axis normal to the plane of the ellipse.

        """
        return _gp.gp_Elips_Axis(self, *args)

    def Directrix1(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Computes the first or second directrix of this ellipse. these are the lines, in the plane of the ellipse, normal to the major axis, at a distance equal to majorradius/e from the center of the ellipse, where e is the eccentricity of the ellipse. the first directrix (directrix1) is on the positive side of the major axis. the second directrix (directrix2) is on the negative side. the directrix is returned as an axis (gp_ax1 object), the origin of which is situated on the 'x axis' of the local coordinate system of this ellipse. exceptions standard_constructionerror if the eccentricity is null (the ellipse has degenerated into a circle).

        """
        return _gp.gp_Elips_Directrix1(self, *args)

    def Directrix2(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the 'yaxis' of the ellipse. exceptions standard_constructionerror if the eccentricity is null (the ellipse has degenerated into a circle).

        """
        return _gp.gp_Elips_Directrix2(self, *args)

    def Eccentricity(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the eccentricity of the ellipse between 0.0 and 1.0 if f is the distance between the center of the ellipse and the focus1 then the eccentricity e = f / majorradius. raises constructionerror if majorradius = 0.0.

        """
        return _gp.gp_Elips_Eccentricity(self, *args)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the focal distance. it is the distance between the two focus focus1 and focus2 of the ellipse.

        """
        return _gp.gp_Elips_Focal(self, *args)

    def Focus1(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the first focus of the ellipse. this focus is on the positive side of the 'xaxis' of the ellipse.

        """
        return _gp.gp_Elips_Focus1(self, *args)

    def Focus2(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the second focus of the ellipse. this focus is on the negative side of the 'xaxis' of the ellipse.

        """
        return _gp.gp_Elips_Focus2(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the center of the ellipse. it is the 'location' point of the coordinate system of the ellipse.

        """
        return _gp.gp_Elips_Location(self, *args)

    def MajorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major radius of the ellipse.

        """
        return _gp.gp_Elips_MajorRadius(self, *args)

    def MinorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the minor radius of the ellipse.

        """
        return _gp.gp_Elips_MinorRadius(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Elips

        Description
        -----------
        Performs the symmetrical transformation of an ellipse with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Elips

        Description
        -----------
        Performs the symmetrical transformation of an ellipse with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Elips

        Description
        -----------
        Performs the symmetrical transformation of an ellipse with respect to a plane. the axis placement thea2 locates the plane of the symmetry (location, xdirection, ydirection).

        """
        return _gp.gp_Elips_Mirrored(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns p = (1 - e * e) * majorradius where e is the eccentricity of the ellipse. returns 0 if majorradius = 0.

        """
        return _gp.gp_Elips_Parameter(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Returns the coordinate system of the ellipse.

        """
        return _gp.gp_Elips_Position(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Elips

        Description
        -----------
        Rotates an ellipse. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Elips_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Elips

        Description
        -----------
        Scales an ellipse. thes is the scaling value.

        """
        return _gp.gp_Elips_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Changes the axis normal to the plane of the ellipse. it modifies the definition of this plane. the 'xaxis' and the 'yaxis' are recomputed. the local coordinate system is redefined so that: - its origin and 'main direction' become those of the axis thea1 (the 'x direction' and 'y direction' are then recomputed in the same way as for any gp_ax2), or raises constructionerror if the direction of thea1 is parallel to the direction of the 'xaxis' of the ellipse.

        """
        return _gp.gp_Elips_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Modifies this ellipse, by redefining its local coordinate so that its origin becomes thep.

        """
        return _gp.gp_Elips_SetLocation(self, *args)

    def SetMajorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMajorRadius: float

        Return
        -------
        None

        Description
        -----------
        The major radius of the ellipse is on the 'xaxis' (major axis) of the ellipse. raises constructionerror if themajorradius < minorradius.

        """
        return _gp.gp_Elips_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        The minor radius of the ellipse is on the 'yaxis' (minor axis) of the ellipse. raises constructionerror if theminorradius > majorradius or minorradius < 0.

        """
        return _gp.gp_Elips_SetMinorRadius(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Modifies this ellipse, by redefining its local coordinate so that it becomes thea2.

        """
        return _gp.gp_Elips_SetPosition(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Elips

        Description
        -----------
        Transforms an ellipse with the transformation thet from class trsf.

        """
        return _gp.gp_Elips_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Elips

        Description
        -----------
        Translates an ellipse in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Elips

        Description
        -----------
        Translates an ellipse from the point thep1 to the point thep2.

        """
        return _gp.gp_Elips_Translated(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the 'xaxis' of the ellipse whose origin is the center of this ellipse. it is the major axis of the ellipse.

        """
        return _gp.gp_Elips_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the 'yaxis' of the ellipse whose unit vector is the 'x direction' or the 'y direction' of the local coordinate system of this ellipse. this is the minor axis of the ellipse.

        """
        return _gp.gp_Elips_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Elips()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Elips')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Elips

# Register gp_Elips in _gp:
_gp.gp_Elips_swigregister(gp_Elips)
class gp_Elips2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite ellipse.

        Parameters
        ----------
        theMajorAxis: gp_Ax2d
        theMajorRadius: float
        theMinorRadius: float
        theIsSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates an ellipse with the major axis, the major and the minor radius. the location of the themajoraxis is the center of the ellipse. the sense of parametrization is given by theissense. warnings: it is possible to create an ellipse with themajorradius = theminorradius. raises constructionerror if themajorradius < theminorradius or theminorradius < 0.0.

        Parameters
        ----------
        theA: gp_Ax22d
        theMajorRadius: float
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Creates an ellipse with radii majorradius and minorradius, positioned in the plane by coordinate system thea where: - the origin of thea is the center of the ellipse, - the 'x direction' of thea defines the major axis of the ellipse, that is, the major radius majorradius is measured along this axis, and - the 'y direction' of thea defines the minor axis of the ellipse, that is, the minor radius theminorradius is measured along this axis, and - the orientation (direct or indirect sense) of thea gives the orientation of the ellipse. warnings: it is possible to create an ellipse with themajorradius = theminorradius. raises constructionerror if themajorradius < theminorradius or theminorradius < 0.0.

        """
        _gp.gp_Elips2d_swiginit(self, _gp.new_gp_Elips2d(*args))

    def Area(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the area of the ellipse.

        """
        return _gp.gp_Elips2d_Area(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax22d

        Description
        -----------
        Returns the major axis of the ellipse.

        """
        return _gp.gp_Elips2d_Axis(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA: float
        theB: float
        theC: float
        theD: float
        theE: float
        theF: float

        Description
        -----------
        Returns the coefficients of the implicit equation of the ellipse. thea * (x**2) + theb * (y**2) + 2*thec*(x*y) + 2*thed*x + 2*thee*y + thef = 0.

        """
        return _gp.gp_Elips2d_Coefficients(self, *args)

    def Directrix1(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        This directrix is the line normal to the xaxis of the ellipse in the local plane (z = 0) at a distance d = majorradius / e from the center of the ellipse, where e is the eccentricity of the ellipse. this line is parallel to the 'yaxis'. the intersection point between directrix1 and the 'xaxis' is the location point of the directrix1. this point is on the positive side of the 'xaxis'. //! raised if eccentricity = 0.0. (the ellipse degenerates into a circle).

        """
        return _gp.gp_Elips2d_Directrix1(self, *args)

    def Directrix2(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the minor axis of the ellipse. //! raised if eccentricity = 0.0. (the ellipse degenerates into a circle).

        """
        return _gp.gp_Elips2d_Directrix2(self, *args)

    def Eccentricity(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the eccentricity of the ellipse between 0.0 and 1.0 if f is the distance between the center of the ellipse and the focus1 then the eccentricity e = f / majorradius. returns 0 if majorradius = 0.

        """
        return _gp.gp_Elips2d_Eccentricity(self, *args)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the distance between the center of the ellipse and focus1 or focus2.

        """
        return _gp.gp_Elips2d_Focal(self, *args)

    def Focus1(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the first focus of the ellipse. this focus is on the positive side of the major axis of the ellipse.

        """
        return _gp.gp_Elips2d_Focus1(self, *args)

    def Focus2(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the second focus of the ellipse. this focus is on the negative side of the major axis of the ellipse.

        """
        return _gp.gp_Elips2d_Focus2(self, *args)

    def IsDirect(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the local coordinate system is direct and false in the other case.

        """
        return _gp.gp_Elips2d_IsDirect(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the center of the ellipse.

        """
        return _gp.gp_Elips2d_Location(self, *args)

    def MajorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major radius of the ellipse.

        """
        return _gp.gp_Elips2d_MajorRadius(self, *args)

    def MinorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the minor radius of the ellipse.

        """
        return _gp.gp_Elips2d_MinorRadius(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips2d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        gp_Elips2d

        Description
        -----------
        Performs the symmetrical transformation of a ellipse with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        gp_Elips2d

        Description
        -----------
        Performs the symmetrical transformation of a ellipse with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Elips2d_Mirrored(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns p = (1 - e * e) * majorradius where e is the eccentricity of the ellipse. returns 0 if majorradius = 0.

        """
        return _gp.gp_Elips2d_Parameter(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips2d_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Elips2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips2d_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        gp_Elips2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips2d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips2d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        gp_Elips2d

        Description
        -----------
        Scales a ellipse. thes is the scaling value.

        """
        return _gp.gp_Elips2d_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax22d

        Return
        -------
        None

        Description
        -----------
        Modifies this ellipse, by redefining its local coordinate system so that it becomes thea.

        """
        return _gp.gp_Elips2d_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Modifies this ellipse, by redefining its local coordinate system so that - its origin becomes thep.

        """
        return _gp.gp_Elips2d_SetLocation(self, *args)

    def SetMajorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMajorRadius: float

        Return
        -------
        None

        Description
        -----------
        Changes the value of the major radius. raises constructionerror if themajorradius < minorradius.

        """
        return _gp.gp_Elips2d_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Changes the value of the minor radius. raises constructionerror if majorradius < theminorradius or minorradius < 0.0.

        """
        return _gp.gp_Elips2d_SetMinorRadius(self, *args)

    def SetXAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Modifies this ellipse, by redefining its local coordinate system so that its origin and its 'x direction' become those of the axis thea. the 'y direction' is then recomputed. the orientation of the local coordinate system is not modified.

        """
        return _gp.gp_Elips2d_SetXAxis(self, *args)

    def SetYAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Modifies this ellipse, by redefining its local coordinate system so that its origin and its 'y direction' become those of the axis thea. the 'x direction' is then recomputed. the orientation of the local coordinate system is not modified.

        """
        return _gp.gp_Elips2d_SetYAxis(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Elips2d

        Description
        -----------
        Transforms an ellipse with the transformation thet from class trsf2d.

        """
        return _gp.gp_Elips2d_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Elips2d_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Elips2d

        Description
        -----------
        Translates a ellipse in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        gp_Elips2d

        Description
        -----------
        Translates a ellipse from the point thep1 to the point thep2.

        """
        return _gp.gp_Elips2d_Translated(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Returns the major axis of the ellipse.

        """
        return _gp.gp_Elips2d_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Returns the minor axis of the ellipse. reverses the direction of the circle.

        """
        return _gp.gp_Elips2d_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Elips2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Elips2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Elips2d

# Register gp_Elips2d in _gp:
_gp.gp_Elips2d_swigregister(gp_Elips2d)
class gp_GTrsf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Returns the identity transformation.

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Converts the gp_trsf transformation thet into a general transformation, i.e. returns a gtrsf with the same matrix of coefficients as the trsf thet.

        Parameters
        ----------
        theM: gp_Mat
        theV: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Creates a transformation based on the matrix them and the vector thev where them defines the vectorial part of the transformation, and v the translation part, or.

        """
        _gp.gp_GTrsf_swiginit(self, _gp.new_gp_GTrsf(*args))

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_GTrsf_DumpJsonToString(self, depth)

    def Form(self, *args):
        r"""
        Return
        -------
        gp_TrsfForm

        Description
        -----------
        Returns the nature of the transformation. it can be an identity transformation, a rotation, a translation, a mirror transformation (relative to a point, an axis or a plane), a scaling transformation, a compound transformation or some other type of transformation.

        """
        return _gp.gp_GTrsf_Form(self, *args)

    def Invert(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf_Invert(self, *args)

    def Inverted(self, *args):
        r"""
        Return
        -------
        gp_GTrsf

        Description
        -----------
        Computes the reverse transformation. raises an exception if the matrix of the transformation is not inversible.

        """
        return _gp.gp_GTrsf_Inverted(self, *args)

    def IsNegative(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the determinant of the vectorial part of this transformation is negative.

        """
        return _gp.gp_GTrsf_IsNegative(self, *args)

    def IsSingular(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this transformation is singular (and therefore, cannot be inverted). note: the gauss lu decomposition is used to invert the transformation matrix. consequently, the transformation is considered as singular if the largest pivot found is less than or equal to gp::resolution(). warning if this transformation is singular, it cannot be inverted.

        """
        return _gp.gp_GTrsf_IsSingular(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_GTrsf

        Return
        -------
        gp_GTrsf

        Description
        -----------
        Computes the transformation composed from thet and <self>. in a c++ implementation you can also write tcomposed = <self> * thet. example: @code gp_gtrsf t1, t2, tcomp; ............... //composition: tcomp = t2.multiplied(t1); // or (tcomp = t2 * t1) // transformation of a point gp_xyz p(10.,3.,4.); gp_xyz p1(p); tcomp.transforms(p1); //using tcomp gp_xyz p2(p); t1.transforms(p2); //using t1 then t2 t2.transforms(p2); // p1 = p2 !!! @endcode.

        """
        return _gp.gp_GTrsf_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_GTrsf

        Return
        -------
        None

        Description
        -----------
        Computes the transformation composed with <self> and thet. <self> = <self> * thet.

        """
        return _gp.gp_GTrsf_Multiply(self, *args)

    def Power(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf_Power(self, *args)

    def Powered(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        gp_GTrsf

        Description
        -----------
        Computes: - the product of this transformation multiplied by itself then times, if then is positive, or - the product of the inverse of this transformation multiplied by itself |then| times, if then is negative. if then equals zero, the result is equal to the identity transformation. i.e.: <self> * <self> * .......* <self>, then time. if then =0 <self> = identity if then < 0 <self> = <self>.inverse() *...........* <self>.inverse(). //! raises an exception if n < 0 and if the matrix of the transformation not inversible.

        """
        return _gp.gp_GTrsf_Powered(self, *args)

    def PreMultiply(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_GTrsf

        Return
        -------
        None

        Description
        -----------
        Computes the product of the transformation thet and this transformation and assigns the result to this transformation. this = thet * this.

        """
        return _gp.gp_GTrsf_PreMultiply(self, *args)

    def SetAffinity(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theRatio: float

        Return
        -------
        None

        Description
        -----------
        Changes this transformation into an affinity of ratio theratio with respect to the axis thea1. note: an affinity is a point-by-point transformation that transforms any point p into a point p' such that if h is the orthogonal projection of p on the axis thea1 or the plane a2, the vectors hp and hp' satisfy: hp' = theratio * hp.

        Parameters
        ----------
        theA2: gp_Ax2
        theRatio: float

        Return
        -------
        None

        Description
        -----------
        Changes this transformation into an affinity of ratio theratio with respect to the plane defined by the origin, the 'x direction' and the 'y direction' of coordinate system thea2. note: an affinity is a point-by-point transformation that transforms any point p into a point p' such that if h is the orthogonal projection of p on the axis a1 or the plane thea2, the vectors hp and hp' satisfy: hp' = theratio * hp.

        """
        return _gp.gp_GTrsf_SetAffinity(self, *args)

    def SetForm(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Verify and set the shape of the gtrsf other or compoundtrsf ex: @code mygtrsf.setvalue(row1,col1,val1); mygtrsf.setvalue(row2,col2,val2); ... mygtrsf.setform(); @endcode.

        """
        return _gp.gp_GTrsf_SetForm(self, *args)

    def SetTranslationPart(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Replaces the translation part of this transformation by the coordinates of the number triple thecoord.

        """
        return _gp.gp_GTrsf_SetTranslationPart(self, *args)

    def SetTrsf(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Assigns the vectorial and translation parts of thet to this transformation.

        """
        return _gp.gp_GTrsf_SetTrsf(self, *args)

    def SetValue(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Replaces the coefficient (therow, thecol) of the matrix representing this transformation by thevalue. raises outofrange if therow < 1 or therow > 3 or thecol < 1 or thecol > 4.

        """
        return _gp.gp_GTrsf_SetValue(self, *args)

    def SetVectorialPart(self, *args):
        r"""

        Parameters
        ----------
        theMatrix: gp_Mat

        Return
        -------
        None

        Description
        -----------
        Replaces the vectorial part of this transformation by thematrix.

        """
        return _gp.gp_GTrsf_SetVectorialPart(self, *args)

    def Transforms(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------

        Return
        -------
        theX: float
        theY: float
        theZ: float

        Description
        -----------
        Transforms a triplet xyz with a gtrsf.

        """
        return _gp.gp_GTrsf_Transforms(self, *args)

    def TranslationPart(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the translation part of the gtrsf.

        """
        return _gp.gp_GTrsf_TranslationPart(self, *args)

    def Trsf(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf_Trsf(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int

        Return
        -------
        float

        Description
        -----------
        Returns the coefficients of the global matrix of transformation. raises outofrange if therow < 1 or therow > 3 or thecol < 1 or thecol > 4.

        """
        return _gp.gp_GTrsf_Value(self, *args)

    def VectorialPart(self, *args):
        r"""
        Return
        -------
        gp_Mat

        Description
        -----------
        Computes the vectorial part of the gtrsf. the returned matrix is a 3*3 matrix.

        """
        return _gp.gp_GTrsf_VectorialPart(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_GTrsf

        Return
        -------
        gp_GTrsf

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf___mul__(self, *args)

    def __imul_wrapper__(self, other):
        r"""Json string serializer."""
        return _gp.gp_GTrsf___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_GTrsf()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_GTrsf')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_GTrsf

# Register gp_GTrsf in _gp:
_gp.gp_GTrsf_swigregister(gp_GTrsf)
class gp_GTrsf2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Returns identity transformation.

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        Converts the gp_trsf2d transformation thet into a general transformation.

        Parameters
        ----------
        theM: gp_Mat2d
        theV: gp_XY

        Return
        -------
        None

        Description
        -----------
        Creates a transformation based on the matrix them and the vector thev where them defines the vectorial part of the transformation, and thev the translation part.

        """
        _gp.gp_GTrsf2d_swiginit(self, _gp.new_gp_GTrsf2d(*args))

    def Form(self, *args):
        r"""
        Return
        -------
        gp_TrsfForm

        Description
        -----------
        Returns the nature of the transformation. it can be an identity transformation, a rotation, a translation, a mirror transformation (relative to a point or axis), a scaling transformation, a compound transformation or some other type of transformation.

        """
        return _gp.gp_GTrsf2d_Form(self, *args)

    def Invert(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf2d_Invert(self, *args)

    def Inverted(self, *args):
        r"""
        Return
        -------
        gp_GTrsf2d

        Description
        -----------
        Computes the reverse transformation. raised an exception if the matrix of the transformation is not inversible.

        """
        return _gp.gp_GTrsf2d_Inverted(self, *args)

    def IsNegative(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the determinant of the vectorial part of this transformation is negative.

        """
        return _gp.gp_GTrsf2d_IsNegative(self, *args)

    def IsSingular(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this transformation is singular (and therefore, cannot be inverted). note: the gauss lu decomposition is used to invert the transformation matrix. consequently, the transformation is considered as singular if the largest pivot found is less than or equal to gp::resolution(). warning if this transformation is singular, it cannot be inverted.

        """
        return _gp.gp_GTrsf2d_IsSingular(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_GTrsf2d

        Return
        -------
        gp_GTrsf2d

        Description
        -----------
        Computes the transformation composed with thet and <self>. in a c++ implementation you can also write tcomposed = <self> * thet. example: @code gp_gtrsf2d t1, t2, tcomp; ............... //composition: tcomp = t2.multiplied(t1); // or (tcomp = t2 * t1) // transformation of a point gp_xy p(10.,3.); gp_xy p1(p); tcomp.transforms(p1); //using tcomp gp_xy p2(p); t1.transforms(p2); //using t1 then t2 t2.transforms(p2); // p1 = p2 !!! @endcode.

        """
        return _gp.gp_GTrsf2d_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_GTrsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf2d_Multiply(self, *args)

    def Power(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf2d_Power(self, *args)

    def Powered(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        gp_GTrsf2d

        Description
        -----------
        Computes the following composition of transformations <self> * <self> * .......* <self>, then time. if then = 0 <self> = identity if then < 0 <self> = <self>.inverse() *...........* <self>.inverse(). //! raises an exception if then < 0 and if the matrix of the transformation is not inversible.

        """
        return _gp.gp_GTrsf2d_Powered(self, *args)

    def PreMultiply(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_GTrsf2d

        Return
        -------
        None

        Description
        -----------
        Computes the product of the transformation thet and this transformation, and assigns the result to this transformation: this = thet * this.

        """
        return _gp.gp_GTrsf2d_PreMultiply(self, *args)

    def SetAffinity(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d
        theRatio: float

        Return
        -------
        None

        Description
        -----------
        Changes this transformation into an affinity of ratio theratio with respect to the axis thea. note: an affinity is a point-by-point transformation that transforms any point p into a point p' such that if h is the orthogonal projection of p on the axis thea, the vectors hp and hp' satisfy: hp' = theratio * hp.

        """
        return _gp.gp_GTrsf2d_SetAffinity(self, *args)

    def SetTranslationPart(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Replaces the translation part of this transformation by the coordinates of the number pair thecoord.

        """
        return _gp.gp_GTrsf2d_SetTranslationPart(self, *args)

    def SetTrsf2d(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        Assigns the vectorial and translation parts of thet to this transformation.

        """
        return _gp.gp_GTrsf2d_SetTrsf2d(self, *args)

    def SetValue(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Replaces the coefficient (therow, thecol) of the matrix representing this transformation by thevalue, raises outofrange if therow < 1 or therow > 2 or thecol < 1 or thecol > 3.

        """
        return _gp.gp_GTrsf2d_SetValue(self, *args)

    def SetVectorialPart(self, *args):
        r"""

        Parameters
        ----------
        theMatrix: gp_Mat2d

        Return
        -------
        None

        Description
        -----------
        Replaces the vectorial part of this transformation by thematrix.

        """
        return _gp.gp_GTrsf2d_SetVectorialPart(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        gp_XY

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf2d_Transformed(self, *args)

    def Transforms(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------

        Return
        -------
        theX: float
        theY: float

        Description
        -----------
        Applies this transformation to the coordinates: - of the number pair coord, or - x and y. //! note: - transforms modifies thex, they, or the coordinate pair coord, while - transformed creates a new coordinate pair.

        """
        return _gp.gp_GTrsf2d_Transforms(self, *args)

    def TranslationPart(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        Returns the translation part of the gtrsf2d.

        """
        return _gp.gp_GTrsf2d_TranslationPart(self, *args)

    def Trsf2d(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        Converts this transformation into a gp_trsf2d transformation. exceptions standard_constructionerror if this transformation cannot be converted, i.e. if its form is gp_other.

        """
        return _gp.gp_GTrsf2d_Trsf2d(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int

        Return
        -------
        float

        Description
        -----------
        Returns the coefficients of the global matrix of transformation. raised outofrange if therow < 1 or therow > 2 or thecol < 1 or thecol > 3.

        """
        return _gp.gp_GTrsf2d_Value(self, *args)

    def VectorialPart(self, *args):
        r"""
        Return
        -------
        gp_Mat2d

        Description
        -----------
        Computes the vectorial part of the gtrsf2d. the returned matrix is a 2*2 matrix.

        """
        return _gp.gp_GTrsf2d_VectorialPart(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_GTrsf2d

        Return
        -------
        gp_GTrsf2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_GTrsf2d___mul__(self, *args)

    def __imul_wrapper__(self, other):
        return _gp.gp_GTrsf2d___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_GTrsf2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_GTrsf2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_GTrsf2d

# Register gp_GTrsf2d in _gp:
_gp.gp_GTrsf2d_swigregister(gp_GTrsf2d)
class gp_Hypr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates of an indefinite hyperbola.

        Parameters
        ----------
        theA2: gp_Ax2
        theMajorRadius: float
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Creates a hyperbola with radius themajorradius and theminorradius, positioned in the space by the coordinate system thea2 such that: - the origin of thea2 is the center of the hyperbola, - the 'x direction' of thea2 defines the major axis of the hyperbola, that is, the major radius themajorradius is measured along this axis, and - the 'y direction' of thea2 defines the minor axis of the hyperbola, that is, the minor radius theminorradius is measured along this axis. note: this class does not prevent the creation of a hyperbola where: - themajoraxis is equal to theminoraxis, or - themajoraxis is less than theminoraxis. exceptions standard_constructionerror if themajoraxis or theminoraxis is negative. raises constructionerror if themajorradius < 0.0 or theminorradius < 0.0 raised if themajorradius < 0.0 or theminorradius < 0.0.

        """
        _gp.gp_Hypr_swiginit(self, _gp.new_gp_Hypr(*args))

    def Asymptote1(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = (b/a)*x where a is the major radius and b is the minor radius. raises constructionerror if majorradius = 0.0.

        """
        return _gp.gp_Hypr_Asymptote1(self, *args)

    def Asymptote2(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = -(b/a)*x. where a is the major radius and b is the minor radius. raises constructionerror if majorradius = 0.0.

        """
        return _gp.gp_Hypr_Asymptote2(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the axis passing through the center, and normal to the plane of this hyperbola.

        """
        return _gp.gp_Hypr_Axis(self, *args)

    def ConjugateBranch1(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        Computes the branch of hyperbola which is on the positive side of the 'yaxis' of <self>.

        """
        return _gp.gp_Hypr_ConjugateBranch1(self, *args)

    def ConjugateBranch2(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        Computes the branch of hyperbola which is on the negative side of the 'yaxis' of <self>.

        """
        return _gp.gp_Hypr_ConjugateBranch2(self, *args)

    def Directrix1(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        This directrix is the line normal to the xaxis of the hyperbola in the local plane (z = 0) at a distance d = majorradius / e from the center of the hyperbola, where e is the eccentricity of the hyperbola. this line is parallel to the 'yaxis'. the intersection point between the directrix1 and the 'xaxis' is the 'location' point of the directrix1. this point is on the positive side of the 'xaxis'.

        """
        return _gp.gp_Hypr_Directrix1(self, *args)

    def Directrix2(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the 'yaxis' of the hyperbola.

        """
        return _gp.gp_Hypr_Directrix2(self, *args)

    def Eccentricity(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the eccentricity of the hyperbola (e > 1). if f is the distance between the location of the hyperbola and the focus1 then the eccentricity e = f / majorradius. raises domainerror if majorradius = 0.0.

        """
        return _gp.gp_Hypr_Eccentricity(self, *args)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the focal distance. it is the distance between the the two focus of the hyperbola.

        """
        return _gp.gp_Hypr_Focal(self, *args)

    def Focus1(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the first focus of the hyperbola. this focus is on the positive side of the 'xaxis' of the hyperbola.

        """
        return _gp.gp_Hypr_Focus1(self, *args)

    def Focus2(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the second focus of the hyperbola. this focus is on the negative side of the 'xaxis' of the hyperbola.

        """
        return _gp.gp_Hypr_Focus2(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the location point of the hyperbola. it is the intersection point between the 'xaxis' and the 'yaxis'.

        """
        return _gp.gp_Hypr_Location(self, *args)

    def MajorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major radius of the hyperbola. it is the radius on the 'xaxis' of the hyperbola.

        """
        return _gp.gp_Hypr_MajorRadius(self, *args)

    def MinorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the minor radius of the hyperbola. it is the radius on the 'yaxis' of the hyperbola.

        """
        return _gp.gp_Hypr_MinorRadius(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Hypr

        Description
        -----------
        Performs the symmetrical transformation of an hyperbola with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Hypr

        Description
        -----------
        Performs the symmetrical transformation of an hyperbola with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Hypr

        Description
        -----------
        Performs the symmetrical transformation of an hyperbola with respect to a plane. the axis placement thea2 locates the plane of the symmetry (location, xdirection, ydirection).

        """
        return _gp.gp_Hypr_Mirrored(self, *args)

    def OtherBranch(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        Returns the branch of hyperbola obtained by doing the symmetrical transformation of <self> with respect to the 'yaxis' of <self>.

        """
        return _gp.gp_Hypr_OtherBranch(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns p = (e * e - 1) * majorradius where e is the eccentricity of the hyperbola. raises domainerror if majorradius = 0.0.

        """
        return _gp.gp_Hypr_Parameter(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Returns the coordinate system of the hyperbola.

        """
        return _gp.gp_Hypr_Position(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Hypr

        Description
        -----------
        Rotates an hyperbola. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Hypr_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Hypr

        Description
        -----------
        Scales an hyperbola. thes is the scaling value.

        """
        return _gp.gp_Hypr_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Modifies this hyperbola, by redefining its local coordinate system so that: - its origin and 'main direction' become those of the axis thea1 (the 'x direction' and 'y direction' are then recomputed in the same way as for any gp_ax2). raises constructionerror if the direction of thea1 is parallel to the direction of the 'xaxis' of the hyperbola.

        """
        return _gp.gp_Hypr_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Modifies this hyperbola, by redefining its local coordinate system so that its origin becomes thep.

        """
        return _gp.gp_Hypr_SetLocation(self, *args)

    def SetMajorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMajorRadius: float

        Return
        -------
        None

        Description
        -----------
        Modifies the major radius of this hyperbola. exceptions standard_constructionerror if themajorradius is negative.

        """
        return _gp.gp_Hypr_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Modifies the minor radius of this hyperbola. exceptions standard_constructionerror if theminorradius is negative.

        """
        return _gp.gp_Hypr_SetMinorRadius(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Modifies this hyperbola, by redefining its local coordinate system so that it becomes a2.

        """
        return _gp.gp_Hypr_SetPosition(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Hypr

        Description
        -----------
        Transforms an hyperbola with the transformation thet from class trsf.

        """
        return _gp.gp_Hypr_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Hypr

        Description
        -----------
        Translates an hyperbola in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Hypr

        Description
        -----------
        Translates an hyperbola from the point thep1 to the point thep2.

        """
        return _gp.gp_Hypr_Translated(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Computes an axis, whose - the origin is the center of this hyperbola, and - the unit vector is the 'x direction' of the local coordinate system of this hyperbola. these axes are, the major axis (the 'x axis') and of this hyperboreturns the 'xaxis' of the hyperbola.

        """
        return _gp.gp_Hypr_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Computes an axis, whose - the origin is the center of this hyperbola, and - the unit vector is the 'y direction' of the local coordinate system of this hyperbola. these axes are the minor axis (the 'y axis') of this hyperbola.

        """
        return _gp.gp_Hypr_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Hypr()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Hypr')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Hypr

# Register gp_Hypr in _gp:
_gp.gp_Hypr_swigregister(gp_Hypr)
class gp_Hypr2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates of an indefinite hyperbola.

        Parameters
        ----------
        theMajorAxis: gp_Ax2d
        theMajorRadius: float
        theMinorRadius: float
        theIsSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates a hyperbola with radii themajorradius and theminorradius, centered on the origin of themajoraxis and where the unit vector of themajoraxis is the 'x direction' of the local coordinate system of the hyperbola. this coordinate system is direct if theissense is true (the default value), and indirect if theissense is false. warnings: it is yet possible to create an hyperbola with themajorradius <= theminorradius. raises constructionerror if themajorradius < 0.0 or theminorradius < 0.0.

        Parameters
        ----------
        theA: gp_Ax22d
        theMajorRadius: float
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        A hyperbola with radii themajorradius and theminorradius, positioned in the plane by coordinate system thea where: - the origin of thea is the center of the hyperbola, - the 'x direction' of thea defines the major axis of the hyperbola, that is, the major radius themajorradius is measured along this axis, and - the 'y direction' of thea defines the minor axis of the hyperbola, that is, the minor radius theminorradius is measured along this axis, and - the orientation (direct or indirect sense) of thea gives the implicit orientation of the hyperbola. warnings: it is yet possible to create an hyperbola with themajorradius <= theminorradius. raises constructionerror if themajorradius < 0.0 or theminorradius < 0.0.

        """
        _gp.gp_Hypr2d_swiginit(self, _gp.new_gp_Hypr2d(*args))

    def Asymptote1(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = (b/a)*x where a is the major radius of the hyperbola and b the minor radius of the hyperbola. raises constructionerror if majorradius = 0.0.

        """
        return _gp.gp_Hypr2d_Asymptote1(self, *args)

    def Asymptote2(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = -(b/a)*x where a is the major radius of the hyperbola and b the minor radius of the hyperbola. raises constructionerror if majorradius = 0.0.

        """
        return _gp.gp_Hypr2d_Asymptote2(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax22d

        Description
        -----------
        Returns the axisplacement of the hyperbola.

        """
        return _gp.gp_Hypr2d_Axis(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA: float
        theB: float
        theC: float
        theD: float
        theE: float
        theF: float

        Description
        -----------
        Computes the coefficients of the implicit equation of the hyperbola: thea * (x**2) + theb * (y**2) + 2*thec*(x*y) + 2*thed*x + 2*thee*y + thef = 0.

        """
        return _gp.gp_Hypr2d_Coefficients(self, *args)

    def ConjugateBranch1(self, *args):
        r"""
        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Computes the branch of hyperbola which is on the positive side of the 'yaxis' of <self>.

        """
        return _gp.gp_Hypr2d_ConjugateBranch1(self, *args)

    def ConjugateBranch2(self, *args):
        r"""
        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Computes the branch of hyperbola which is on the negative side of the 'yaxis' of <self>.

        """
        return _gp.gp_Hypr2d_ConjugateBranch2(self, *args)

    def Directrix1(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Computes the directrix which is the line normal to the xaxis of the hyperbola in the local plane (z = 0) at a distance d = majorradius / e from the center of the hyperbola, where e is the eccentricity of the hyperbola. this line is parallel to the 'yaxis'. the intersection point between the 'directrix1' and the 'xaxis' is the 'location' point of the 'directrix1'. this point is on the positive side of the 'xaxis'.

        """
        return _gp.gp_Hypr2d_Directrix1(self, *args)

    def Directrix2(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the 'yaxis' of the hyperbola.

        """
        return _gp.gp_Hypr2d_Directrix2(self, *args)

    def Eccentricity(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the eccentricity of the hyperbola (e > 1). if f is the distance between the location of the hyperbola and the focus1 then the eccentricity e = f / majorradius. raises domainerror if majorradius = 0.0.

        """
        return _gp.gp_Hypr2d_Eccentricity(self, *args)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the focal distance. it is the distance between the 'location' of the hyperbola and 'focus1' or 'focus2'.

        """
        return _gp.gp_Hypr2d_Focal(self, *args)

    def Focus1(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the first focus of the hyperbola. this focus is on the positive side of the 'xaxis' of the hyperbola.

        """
        return _gp.gp_Hypr2d_Focus1(self, *args)

    def Focus2(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the second focus of the hyperbola. this focus is on the negative side of the 'xaxis' of the hyperbola.

        """
        return _gp.gp_Hypr2d_Focus2(self, *args)

    def IsDirect(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the local coordinate system is direct and false in the other case.

        """
        return _gp.gp_Hypr2d_IsDirect(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the location point of the hyperbola. it is the intersection point between the 'xaxis' and the 'yaxis'.

        """
        return _gp.gp_Hypr2d_Location(self, *args)

    def MajorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major radius of the hyperbola (it is the radius corresponding to the 'xaxis' of the hyperbola).

        """
        return _gp.gp_Hypr2d_MajorRadius(self, *args)

    def MinorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the minor radius of the hyperbola (it is the radius corresponding to the 'yaxis' of the hyperbola).

        """
        return _gp.gp_Hypr2d_MinorRadius(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr2d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Performs the symmetrical transformation of an hyperbola with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Performs the symmetrical transformation of an hyperbola with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Hypr2d_Mirrored(self, *args)

    def OtherBranch(self, *args):
        r"""
        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Returns the branch of hyperbola obtained by doing the symmetrical transformation of <self> with respect to the 'yaxis' of <self>.

        """
        return _gp.gp_Hypr2d_OtherBranch(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns p = (e * e - 1) * majorradius where e is the eccentricity of the hyperbola. raises domainerror if majorradius = 0.0.

        """
        return _gp.gp_Hypr2d_Parameter(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr2d_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Reverses the orientation of the local coordinate system of this hyperbola (the 'y axis' is reversed). therefore, the implicit orientation of this hyperbola is reversed. note: - reverse assigns the result to this hyperbola, while - reversed creates a new one.

        """
        return _gp.gp_Hypr2d_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Rotates an hyperbola. thep is the center of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Hypr2d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr2d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Scales an hyperbola. <thes> is the scaling value. if <thes> is positive only the location point is modified. but if <thes> is negative the 'xaxis' is reversed and the 'yaxis' too.

        """
        return _gp.gp_Hypr2d_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax22d

        Return
        -------
        None

        Description
        -----------
        Modifies this hyperbola, by redefining its local coordinate system so that it becomes thea.

        """
        return _gp.gp_Hypr2d_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Modifies this hyperbola, by redefining its local coordinate system so that its origin becomes thep.

        """
        return _gp.gp_Hypr2d_SetLocation(self, *args)

    def SetMajorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMajorRadius: float

        Return
        -------
        None

        Description
        -----------
        Modifies the major or minor radius of this hyperbola. exceptions standard_constructionerror if themajorradius or minorradius is negative.

        """
        return _gp.gp_Hypr2d_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Modifies the major or minor radius of this hyperbola. exceptions standard_constructionerror if majorradius or theminorradius is negative.

        """
        return _gp.gp_Hypr2d_SetMinorRadius(self, *args)

    def SetXAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes the major axis of the hyperbola. the minor axis is recomputed and the location of the hyperbola too.

        """
        return _gp.gp_Hypr2d_SetXAxis(self, *args)

    def SetYAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes the minor axis of the hyperbola.the minor axis is recomputed and the location of the hyperbola too.

        """
        return _gp.gp_Hypr2d_SetYAxis(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Transforms an hyperbola with the transformation thet from class trsf2d.

        """
        return _gp.gp_Hypr2d_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Hypr2d_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Translates an hyperbola in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Translates an hyperbola from the point thep1 to the point thep2.

        """
        return _gp.gp_Hypr2d_Translated(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Computes an axis whose - the origin is the center of this hyperbola, and - the unit vector is the 'x direction' or 'y direction' respectively of the local coordinate system of this hyperbola returns the major axis of the hyperbola.

        """
        return _gp.gp_Hypr2d_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Computes an axis whose - the origin is the center of this hyperbola, and - the unit vector is the 'x direction' or 'y direction' respectively of the local coordinate system of this hyperbola returns the minor axis of the hyperbola.

        """
        return _gp.gp_Hypr2d_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Hypr2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Hypr2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Hypr2d

# Register gp_Hypr2d in _gp:
_gp.gp_Hypr2d_swigregister(gp_Hypr2d)
class gp_Lin(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a line corresponding to z axis of the reference coordinate system.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Creates a line defined by axis thea1.

        Parameters
        ----------
        theP: gp_Pnt
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates a line passing through point thep and parallel to vector thev (thep and thev are, respectively, the origin and the unit vector of the positioning axis of the line).

        """
        _gp.gp_Lin_swiginit(self, _gp.new_gp_Lin(*args))

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Lin

        Return
        -------
        float

        Description
        -----------
        Computes the angle between two lines in radians.

        """
        return _gp.gp_Lin_Angle(self, *args)

    def Contains(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theLinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if this line contains the point thep, that is, if the distance between point thep and this line is less than or equal to thelineartolerance..

        """
        return _gp.gp_Lin_Contains(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the direction of the line.

        """
        return _gp.gp_Lin_Direction(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Computes the distance between <self> and the point thep.

        Parameters
        ----------
        theOther: gp_Lin

        Return
        -------
        float

        Description
        -----------
        Computes the distance between two lines.

        """
        return _gp.gp_Lin_Distance(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the location point (origin) of the line.

        """
        return _gp.gp_Lin_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Lin

        Description
        -----------
        Performs the symmetrical transformation of a line with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Lin

        Description
        -----------
        Performs the symmetrical transformation of a line with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Lin

        Description
        -----------
        Performs the symmetrical transformation of a line with respect to a plane. the axis placement <thea2> locates the plane of the symmetry: (location, xdirection, ydirection).

        """
        return _gp.gp_Lin_Mirrored(self, *args)

    def Normal(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Lin

        Description
        -----------
        Computes the line normal to the direction of <self>, passing through the point thep. raises constructionerror if the distance between <self> and the point thep is lower or equal to resolution from gp because there is an infinity of solutions in 3d space.

        """
        return _gp.gp_Lin_Normal(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the axis placement one axis with the same location and direction as <self>.

        """
        return _gp.gp_Lin_Position(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Lin

        Description
        -----------
        Reverses the direction of the line. note: - reverse assigns the result to this line, while - reversed creates a new one.

        """
        return _gp.gp_Lin_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Lin

        Description
        -----------
        Rotates a line. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        """
        return _gp.gp_Lin_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Lin

        Description
        -----------
        Scales a line. thes is the scaling value. the 'location' point (origin) of the line is modified. the 'direction' is reversed if the scale is negative.

        """
        return _gp.gp_Lin_Scaled(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes the direction of the line.

        """
        return _gp.gp_Lin_SetDirection(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the location point (origin) of the line.

        """
        return _gp.gp_Lin_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Complete redefinition of the line. the 'location' point of <thea1> is the origin of the line. the 'direction' of <thea1> is the direction of the line.

        """
        return _gp.gp_Lin_SetPosition(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between <self> and the point thep.

        Parameters
        ----------
        theOther: gp_Lin

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between two lines.

        """
        return _gp.gp_Lin_SquareDistance(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Lin

        Description
        -----------
        Transforms a line with the transformation thet from class trsf.

        """
        return _gp.gp_Lin_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Lin

        Description
        -----------
        Translates a line in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Lin

        Description
        -----------
        Translates a line from the point thep1 to the point thep2.

        """
        return _gp.gp_Lin_Translated(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Lin()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Lin')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Lin

# Register gp_Lin in _gp:
_gp.gp_Lin_swigregister(gp_Lin)
class gp_Lin2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a line corresponding to x axis of the reference coordinate system.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Creates a line located with thea.

        Parameters
        ----------
        theP: gp_Pnt2d
        theV: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        <thep> is the location point (origin) of the line and <thev> is the direction of the line.

        Parameters
        ----------
        theA: float
        theB: float
        theC: float

        Return
        -------
        None

        Description
        -----------
        Creates the line from the equation thea*x + theb*y + thec = 0.0 raises constructionerror if sqrt(thea*thea + theb*theb) <= resolution from gp. raised if sqrt(thea*thea + theb*theb) <= resolution from gp.

        """
        _gp.gp_Lin2d_swiginit(self, _gp.new_gp_Lin2d(*args))

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Lin2d

        Return
        -------
        float

        Description
        -----------
        Computes the angle between two lines in radians.

        """
        return _gp.gp_Lin2d_Angle(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA: float
        theB: float
        theC: float

        Description
        -----------
        Returns the normalized coefficients of the line: thea * x + theb * y + thec = 0.

        """
        return _gp.gp_Lin2d_Coefficients(self, *args)

    def Contains(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theLinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if this line contains the point thep, that is, if the distance between point thep and this line is less than or equal to thelineartolerance.

        """
        return _gp.gp_Lin2d_Contains(self, *args)

    def Direction(self, *args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        Returns the direction of the line.

        """
        return _gp.gp_Lin2d_Direction(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        float

        Description
        -----------
        Computes the distance between <self> and the point <thep>.

        Parameters
        ----------
        theOther: gp_Lin2d

        Return
        -------
        float

        Description
        -----------
        Computes the distance between two lines.

        """
        return _gp.gp_Lin2d_Distance(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the location point (origin) of the line.

        """
        return _gp.gp_Lin2d_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin2d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        gp_Lin2d

        Description
        -----------
        Performs the symmetrical transformation of a line with respect to the point <thep> which is the center of the symmetry.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        gp_Lin2d

        Description
        -----------
        Performs the symmetrical transformation of a line with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Lin2d_Mirrored(self, *args)

    def Normal(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        gp_Lin2d

        Description
        -----------
        Computes the line normal to the direction of <self>, passing through the point <thep>.

        """
        return _gp.gp_Lin2d_Normal(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Returns the axis placement one axis with the same location and direction as <self>.

        """
        return _gp.gp_Lin2d_Position(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin2d_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Lin2d

        Description
        -----------
        Reverses the positioning axis of this line. note: - reverse assigns the result to this line, while - reversed creates a new one.

        """
        return _gp.gp_Lin2d_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        gp_Lin2d

        Description
        -----------
        Rotates a line. thep is the center of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Lin2d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin2d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        gp_Lin2d

        Description
        -----------
        Scales a line. thes is the scaling value. only the origin of the line is modified.

        """
        return _gp.gp_Lin2d_Scaled(self, *args)

    def SetDirection(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Changes the direction of the line.

        """
        return _gp.gp_Lin2d_SetDirection(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Changes the origin of the line.

        """
        return _gp.gp_Lin2d_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Complete redefinition of the line. the 'location' point of <thea> is the origin of the line. the 'direction' of <thea> is the direction of the line.

        """
        return _gp.gp_Lin2d_SetPosition(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between <self> and the point <thep>.

        Parameters
        ----------
        theOther: gp_Lin2d

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between two lines.

        """
        return _gp.gp_Lin2d_SquareDistance(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Lin2d

        Description
        -----------
        Transforms a line with the transformation thet from class trsf2d.

        """
        return _gp.gp_Lin2d_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Lin2d_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Lin2d

        Description
        -----------
        Translates a line in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        gp_Lin2d

        Description
        -----------
        Translates a line from the point thep1 to the point thep2.

        """
        return _gp.gp_Lin2d_Translated(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Lin2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Lin2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Lin2d

# Register gp_Lin2d in _gp:
_gp.gp_Lin2d_swigregister(gp_Lin2d)
class gp_Mat(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a matrix with null coefficients.

        Parameters
        ----------
        theA11: float
        theA12: float
        theA13: float
        theA21: float
        theA22: float
        theA23: float
        theA31: float
        theA32: float
        theA33: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theCol1: gp_XYZ
        theCol2: gp_XYZ
        theCol3: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Creates a matrix. thecol1, thecol2, thecol3 are the 3 columns of the matrix.

        """
        _gp.gp_Mat_swiginit(self, _gp.new_gp_Mat(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat_Add(self, *args)

    def Added(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        gp_Mat

        Description
        -----------
        Computes the sum of this matrix and the matrix theother for each coefficient of the matrix: <self>.coef(i,j) + <theother>.coef(i,j).

        """
        return _gp.gp_Mat_Added(self, *args)

    def GetChangeValue(self, theRow, theCol):
        r"""GetChangeValue(gp_Mat self, Standard_Integer const theRow, Standard_Integer const theCol) -> Standard_Real"""
        return _gp.gp_Mat_GetChangeValue(self, theRow, theCol)

    def SetChangeValue(self, theRow, theCol, value):
        r"""SetChangeValue(gp_Mat self, Standard_Integer const theRow, Standard_Integer const theCol, Standard_Real value)"""
        return _gp.gp_Mat_SetChangeValue(self, theRow, theCol, value)

    def Column(self, *args):
        r"""

        Parameters
        ----------
        theCol: int

        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the column of thecol index. raises outofrange if thecol < 1 or thecol > 3.

        """
        return _gp.gp_Mat_Column(self, *args)

    def Determinant(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the determinant of the matrix.

        """
        return _gp.gp_Mat_Determinant(self, *args)

    def Diagonal(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the main diagonal of the matrix.

        """
        return _gp.gp_Mat_Diagonal(self, *args)

    def Divide(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat_Divide(self, *args)

    def Divided(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Mat

        Description
        -----------
        Divides all the coefficients of the matrix by scalar.

        """
        return _gp.gp_Mat_Divided(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Mat_DumpJsonToString(self, depth)

    def Invert(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat_Invert(self, *args)

    def Inverted(self, *args):
        r"""
        Return
        -------
        gp_Mat

        Description
        -----------
        Inverses the matrix and raises if the matrix is singular. - invert assigns the result to this matrix, while - inverted creates a new one. warning the gauss lu decomposition is used to invert the matrix. consequently, the matrix is considered as singular if the largest pivot found is less than or equal to gp::resolution(). exceptions standard_constructionerror if this matrix is singular, and therefore cannot be inverted.

        """
        return _gp.gp_Mat_Inverted(self, *args)

    def IsSingular(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        The gauss lu decomposition is used to invert the matrix (see math package) so the matrix is considered as singular if the largest pivot found is lower or equal to resolution from gp.

        """
        return _gp.gp_Mat_IsSingular(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        gp_Mat

        Description
        -----------
        Computes the product of two matrices <self> * <other>.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Mat

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        None

        Description
        -----------
        Computes the product of two matrices <self> = <other> * <self>.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        Multiplies all the coefficients of the matrix by scalar.

        """
        return _gp.gp_Mat_Multiply(self, *args)

    def Power(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat_Power(self, *args)

    def Powered(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        gp_Mat

        Description
        -----------
        Computes <self> = <self> * <self> * .......* <self>, then time. if then = 0 <self> = identity if then < 0 <self> = <self>.invert() *...........* <self>.invert(). if then < 0 an exception will be raised if the matrix is not inversible.

        """
        return _gp.gp_Mat_Powered(self, *args)

    def PreMultiply(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat_PreMultiply(self, *args)

    def Row(self, *args):
        r"""

        Parameters
        ----------
        theRow: int

        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the row of therow index. raises outofrange if therow < 1 or therow > 3.

        """
        return _gp.gp_Mat_Row(self, *args)

    def SetCol(self, *args):
        r"""

        Parameters
        ----------
        theCol: int
        theValue: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Assigns the three coordinates of thevalue to the column of index thecol of this matrix. raises outofrange if thecol < 1 or thecol > 3.

        """
        return _gp.gp_Mat_SetCol(self, *args)

    def SetCols(self, *args):
        r"""

        Parameters
        ----------
        theCol1: gp_XYZ
        theCol2: gp_XYZ
        theCol3: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Assigns the number triples thecol1, thecol2, thecol3 to the three columns of this matrix.

        """
        return _gp.gp_Mat_SetCols(self, *args)

    def SetCross(self, *args):
        r"""

        Parameters
        ----------
        theRef: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Modifies the matrix m so that applying it to any number triple (x, y, z) produces the same result as the cross product of theref and the number triple (x, y, z): i.e.: m * {x,y,z}t = theref.cross({x, y ,z}) this matrix is anti symmetric. to apply this matrix to the triplet {xyz} is the same as to do the cross product between the triplet theref and the triplet {xyz}. note: this matrix is anti-symmetric.

        """
        return _gp.gp_Mat_SetCross(self, *args)

    def SetDiagonal(self, *args):
        r"""

        Parameters
        ----------
        theX1: float
        theX2: float
        theX3: float

        Return
        -------
        None

        Description
        -----------
        Modifies the main diagonal of the matrix. @code <self>.value (1, 1) = thex1 <self>.value (2, 2) = thex2 <self>.value (3, 3) = thex3 @endcode the other coefficients of the matrix are not modified.

        """
        return _gp.gp_Mat_SetDiagonal(self, *args)

    def SetDot(self, *args):
        r"""

        Parameters
        ----------
        theRef: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Modifies this matrix so that applying it to any number triple (x, y, z) produces the same result as the scalar product of theref and the number triple (x, y, z): this * (x,y,z) = theref.(x,y,z) note: this matrix is symmetric.

        """
        return _gp.gp_Mat_SetDot(self, *args)

    def SetIdentity(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Modifies this matrix so that it represents the identity matrix.

        """
        return _gp.gp_Mat_SetIdentity(self, *args)

    def SetRotation(self, *args):
        r"""

        Parameters
        ----------
        theAxis: gp_XYZ
        theAng: float

        Return
        -------
        None

        Description
        -----------
        Modifies this matrix so that it represents a rotation. theang is the angular value in radians and the xyz axis gives the direction of the rotation. raises constructionerror if xyz.modulus() <= resolution().

        """
        return _gp.gp_Mat_SetRotation(self, *args)

    def SetRow(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theValue: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Assigns the three coordinates of value to the row of index therow of this matrix. raises outofrange if therow < 1 or therow > 3.

        """
        return _gp.gp_Mat_SetRow(self, *args)

    def SetRows(self, *args):
        r"""

        Parameters
        ----------
        theRow1: gp_XYZ
        theRow2: gp_XYZ
        theRow3: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Assigns the number triples therow1, therow2, therow3 to the three rows of this matrix.

        """
        return _gp.gp_Mat_SetRows(self, *args)

    def SetScale(self, *args):
        r"""

        Parameters
        ----------
        theS: float

        Return
        -------
        None

        Description
        -----------
        Modifies the matrix so that it represents a scaling transformation, where thes is the scale factor.: @code | thes 0.0 0.0 | <self> = | 0.0 thes 0.0 | | 0.0 0.0 thes | @endcode.

        """
        return _gp.gp_Mat_SetScale(self, *args)

    def SetValue(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Assigns <thevalue> to the coefficient of row therow, column thecol of this matrix. raises outofrange if therow < 1 or therow > 3 or thecol < 1 or thecol > 3.

        """
        return _gp.gp_Mat_SetValue(self, *args)

    def Subtract(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        gp_Mat

        Description
        -----------
        Computes for each coefficient of the matrix: <self>.coef(i,j) - <theother>.coef(i,j).

        """
        return _gp.gp_Mat_Subtracted(self, *args)

    def Transpose(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat_Transpose(self, *args)

    def Transposed(self, *args):
        r"""
        Return
        -------
        gp_Mat

        Description
        -----------
        Transposes the matrix. a(j, i) -> a (i, j).

        """
        return _gp.gp_Mat_Transposed(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int

        Return
        -------
        float

        Description
        -----------
        Returns the coefficient of range (therow, thecol) raises outofrange if therow < 1 or therow > 3 or thecol < 1 or thecol > 3.

        """
        return _gp.gp_Mat_Value(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        gp_Mat

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Mat

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Mat___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        gp_Mat

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat___add__(self, *args)

    def __iadd_wrapper__(self, other):
        r"""Json string serializer."""
        return _gp.gp_Mat___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat

        Return
        -------
        gp_Mat

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat___sub__(self, *args)

    def __isub_wrapper__(self, other):
        r"""Json string serializer."""
        return _gp.gp_Mat___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_Mat___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other):
        r"""Json string serializer."""
        return _gp.gp_Mat___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Mat()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Mat')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Mat

# Register gp_Mat in _gp:
_gp.gp_Mat_swigregister(gp_Mat)
class gp_Mat2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a matrix with null coefficients.

        Parameters
        ----------
        theCol1: gp_XY
        theCol2: gp_XY

        Return
        -------
        None

        Description
        -----------
        Thecol1, thecol2 are the 2 columns of the matrix.

        """
        _gp.gp_Mat2d_swiginit(self, _gp.new_gp_Mat2d(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        Other: gp_Mat2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d_Add(self, *args)

    def Added(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        gp_Mat2d

        Description
        -----------
        Computes the sum of this matrix and the matrix theother.for each coefficient of the matrix: @code <self>.coef(i,j) + <theother>.coef(i,j) @endcode note: - operator += assigns the result to this matrix, while - operator + creates a new one.

        """
        return _gp.gp_Mat2d_Added(self, *args)

    def GetChangeValue(self, theRow, theCol):
        r"""GetChangeValue(gp_Mat2d self, Standard_Integer const theRow, Standard_Integer const theCol) -> Standard_Real"""
        return _gp.gp_Mat2d_GetChangeValue(self, theRow, theCol)

    def SetChangeValue(self, theRow, theCol, value):
        r"""SetChangeValue(gp_Mat2d self, Standard_Integer const theRow, Standard_Integer const theCol, Standard_Real value)"""
        return _gp.gp_Mat2d_SetChangeValue(self, theRow, theCol, value)

    def Column(self, *args):
        r"""

        Parameters
        ----------
        theCol: int

        Return
        -------
        gp_XY

        Description
        -----------
        Returns the column of thecol index. raises outofrange if thecol < 1 or thecol > 2.

        """
        return _gp.gp_Mat2d_Column(self, *args)

    def Determinant(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the determinant of the matrix.

        """
        return _gp.gp_Mat2d_Determinant(self, *args)

    def Diagonal(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        Returns the main diagonal of the matrix.

        """
        return _gp.gp_Mat2d_Diagonal(self, *args)

    def Divide(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d_Divide(self, *args)

    def Divided(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Mat2d

        Description
        -----------
        Divides all the coefficients of the matrix by a scalar.

        """
        return _gp.gp_Mat2d_Divided(self, *args)

    def Invert(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d_Invert(self, *args)

    def Inverted(self, *args):
        r"""
        Return
        -------
        gp_Mat2d

        Description
        -----------
        Inverses the matrix and raises exception if the matrix is singular.

        """
        return _gp.gp_Mat2d_Inverted(self, *args)

    def IsSingular(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this matrix is singular (and therefore, cannot be inverted). the gauss lu decomposition is used to invert the matrix so the matrix is considered as singular if the largest pivot found is lower or equal to resolution from gp.

        """
        return _gp.gp_Mat2d_IsSingular(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        gp_Mat2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Mat2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        None

        Description
        -----------
        Computes the product of two matrices <self> * <theother>.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        Multiplies all the coefficients of the matrix by a scalar.

        """
        return _gp.gp_Mat2d_Multiply(self, *args)

    def Power(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d_Power(self, *args)

    def Powered(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        gp_Mat2d

        Description
        -----------
        Computes <self> = <self> * <self> * .......* <self>, then time. if then = 0 <self> = identity if then < 0 <self> = <self>.invert() *...........* <self>.invert(). if then < 0 an exception can be raised if the matrix is not inversible.

        """
        return _gp.gp_Mat2d_Powered(self, *args)

    def PreMultiply(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        None

        Description
        -----------
        Modifies this matrix by premultiplying it by the matrix other <self> = theother * <self>.

        """
        return _gp.gp_Mat2d_PreMultiply(self, *args)

    def Row(self, *args):
        r"""

        Parameters
        ----------
        theRow: int

        Return
        -------
        gp_XY

        Description
        -----------
        Returns the row of index therow. raised if therow < 1 or therow > 2.

        """
        return _gp.gp_Mat2d_Row(self, *args)

    def SetCol(self, *args):
        r"""

        Parameters
        ----------
        theCol: int
        theValue: gp_XY

        Return
        -------
        None

        Description
        -----------
        Assigns the two coordinates of thevalue to the column of range thecol of this matrix raises outofrange if thecol < 1 or thecol > 2.

        """
        return _gp.gp_Mat2d_SetCol(self, *args)

    def SetCols(self, *args):
        r"""

        Parameters
        ----------
        theCol1: gp_XY
        theCol2: gp_XY

        Return
        -------
        None

        Description
        -----------
        Assigns the number pairs thecol1, thecol2 to the two columns of this matrix.

        """
        return _gp.gp_Mat2d_SetCols(self, *args)

    def SetDiagonal(self, *args):
        r"""

        Parameters
        ----------
        theX1: float
        theX2: float

        Return
        -------
        None

        Description
        -----------
        Modifies the main diagonal of the matrix. @code <self>.value (1, 1) = thex1 <self>.value (2, 2) = thex2 @endcode the other coefficients of the matrix are not modified.

        """
        return _gp.gp_Mat2d_SetDiagonal(self, *args)

    def SetIdentity(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Modifies this matrix, so that it represents the identity matrix.

        """
        return _gp.gp_Mat2d_SetIdentity(self, *args)

    def SetRotation(self, *args):
        r"""

        Parameters
        ----------
        theAng: float

        Return
        -------
        None

        Description
        -----------
        Modifies this matrix, so that it represents a rotation. theang is the angular value in radian of the rotation.

        """
        return _gp.gp_Mat2d_SetRotation(self, *args)

    def SetRow(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theValue: gp_XY

        Return
        -------
        None

        Description
        -----------
        Assigns the two coordinates of thevalue to the row of index therow of this matrix. raises outofrange if therow < 1 or therow > 2.

        """
        return _gp.gp_Mat2d_SetRow(self, *args)

    def SetRows(self, *args):
        r"""

        Parameters
        ----------
        theRow1: gp_XY
        theRow2: gp_XY

        Return
        -------
        None

        Description
        -----------
        Assigns the number pairs therow1, therow2 to the two rows of this matrix.

        """
        return _gp.gp_Mat2d_SetRows(self, *args)

    def SetScale(self, *args):
        r"""

        Parameters
        ----------
        theS: float

        Return
        -------
        None

        Description
        -----------
        Modifies the matrix such that it represents a scaling transformation, where thes is the scale factor: @code | thes 0.0 | <self> = | 0.0 thes | @endcode.

        """
        return _gp.gp_Mat2d_SetScale(self, *args)

    def SetValue(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Assigns <thevalue> to the coefficient of row therow, column thecol of this matrix. raises outofrange if therow < 1 or therow > 2 or thecol < 1 or thecol > 2.

        """
        return _gp.gp_Mat2d_SetValue(self, *args)

    def Subtract(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        gp_Mat2d

        Description
        -----------
        Computes for each coefficient of the matrix: @code <self>.coef(i,j) - <theother>.coef(i,j) @endcode.

        """
        return _gp.gp_Mat2d_Subtracted(self, *args)

    def Transpose(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d_Transpose(self, *args)

    def Transposed(self, *args):
        r"""
        Return
        -------
        gp_Mat2d

        Description
        -----------
        Transposes the matrix. a(j, i) -> a (i, j).

        """
        return _gp.gp_Mat2d_Transposed(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int

        Return
        -------
        float

        Description
        -----------
        Returns the coefficient of range (ttheherow, thecol) raises outofrange if therow < 1 or therow > 2 or thecol < 1 or thecol > 2.

        """
        return _gp.gp_Mat2d_Value(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        gp_Mat2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Mat2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d___mul__(self, *args)

    def __imul_wrapper__(self, other):
        r"""__imul_wrapper__(gp_Mat2d self, Standard_Real const other)"""
        return _gp.gp_Mat2d___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        gp_Mat2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d___add__(self, *args)

    def __iadd_wrapper__(self, other):
        r"""__iadd_wrapper__(gp_Mat2d self, gp_Mat2d other)"""
        return _gp.gp_Mat2d___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Mat2d

        Return
        -------
        gp_Mat2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Mat2d___sub__(self, *args)

    def __isub_wrapper__(self, other):
        r"""__isub_wrapper__(gp_Mat2d self, gp_Mat2d other)"""
        return _gp.gp_Mat2d___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_Mat2d___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other):
        r"""__itruediv_wrapper__(gp_Mat2d self, Standard_Real const other)"""
        return _gp.gp_Mat2d___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Mat2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Mat2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Mat2d

# Register gp_Mat2d in _gp:
_gp.gp_Mat2d_swigregister(gp_Mat2d)
class gp_Parab(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite parabola.

        Parameters
        ----------
        theA2: gp_Ax2
        theFocal: float

        Return
        -------
        None

        Description
        -----------
        Creates a parabola with its local coordinate system 'thea2' and it's focal length 'focal'. the xdirection of thea2 defines the axis of symmetry of the parabola. the ydirection of thea2 is parallel to the directrix of the parabola. the location point of thea2 is the vertex of the parabola raises constructionerror if thefocal < 0.0 raised if thefocal < 0.0.

        Parameters
        ----------
        theD: gp_Ax1
        theF: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Thed is the directrix of the parabola and thef the focus point. the symmetry axis (xaxis) of the parabola is normal to the directrix and pass through the focus point thef, but its location point is the vertex of the parabola. the yaxis of the parabola is parallel to thed and its location point is the vertex of the parabola. the normal to the plane of the parabola is the cross product between the xaxis and the yaxis.

        """
        _gp.gp_Parab_swiginit(self, _gp.new_gp_Parab(*args))

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the main axis of the parabola. it is the axis normal to the plane of the parabola passing through the vertex of the parabola.

        """
        return _gp.gp_Parab_Axis(self, *args)

    def Directrix(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Computes the directrix of this parabola. the directrix is: - a line parallel to the 'y direction' of the local coordinate system of this parabola, and - located on the negative side of the axis of symmetry, at a distance from the apex which is equal to the focal length of this parabola. the directrix is returned as an axis (a gp_ax1 object), the origin of which is situated on the 'x axis' of this parabola.

        """
        return _gp.gp_Parab_Directrix(self, *args)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the distance between the vertex and the focus of the parabola.

        """
        return _gp.gp_Parab_Focal(self, *args)

    def Focus(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        - computes the focus of the parabola.

        """
        return _gp.gp_Parab_Focus(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the vertex of the parabola. it is the 'location' point of the coordinate system of the parabola.

        """
        return _gp.gp_Parab_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Parab

        Description
        -----------
        Performs the symmetrical transformation of a parabola with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Parab

        Description
        -----------
        Performs the symmetrical transformation of a parabola with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Parab

        Description
        -----------
        Performs the symmetrical transformation of a parabola with respect to a plane. the axis placement thea2 locates the plane of the symmetry (location, xdirection, ydirection).

        """
        return _gp.gp_Parab_Mirrored(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the parameter of the parabola. it is the distance between the focus and the directrix of the parabola. this distance is twice the focal length.

        """
        return _gp.gp_Parab_Parameter(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax2

        Description
        -----------
        Returns the local coordinate system of the parabola.

        """
        return _gp.gp_Parab_Position(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Parab

        Description
        -----------
        Rotates a parabola. thea1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        """
        return _gp.gp_Parab_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Parab

        Description
        -----------
        Scales a parabola. thes is the scaling value. if thes is negative the direction of the symmetry axis xaxis is reversed and the direction of the yaxis too.

        """
        return _gp.gp_Parab_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Modifies this parabola by redefining its local coordinate system so that - its origin and 'main direction' become those of the axis thea1 (the 'x direction' and 'y direction' are then recomputed in the same way as for any gp_ax2) raises constructionerror if the direction of thea1 is parallel to the previous xaxis of the parabola.

        """
        return _gp.gp_Parab_SetAxis(self, *args)

    def SetFocal(self, *args):
        r"""

        Parameters
        ----------
        theFocal: float

        Return
        -------
        None

        Description
        -----------
        Changes the focal distance of the parabola. raises constructionerror if thefocal < 0.0.

        """
        return _gp.gp_Parab_SetFocal(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the location of the parabola. it is the vertex of the parabola.

        """
        return _gp.gp_Parab_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Changes the local coordinate system of the parabola.

        """
        return _gp.gp_Parab_SetPosition(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Parab

        Description
        -----------
        Transforms a parabola with the transformation thet from class trsf.

        """
        return _gp.gp_Parab_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Parab

        Description
        -----------
        Translates a parabola in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Parab

        Description
        -----------
        Translates a parabola from the point thep1 to the point thep2.

        """
        return _gp.gp_Parab_Translated(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the symmetry axis of the parabola. the location point of the axis is the vertex of the parabola.

        """
        return _gp.gp_Parab_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        It is an axis parallel to the directrix of the parabola. the location point of this axis is the vertex of the parabola.

        """
        return _gp.gp_Parab_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Parab()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Parab')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Parab

# Register gp_Parab in _gp:
_gp.gp_Parab_swigregister(gp_Parab)
class gp_Parab2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite parabola.

        Parameters
        ----------
        theMirrorAxis: gp_Ax2d
        theFocalLength: float
        theSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates a parabola with its vertex point, its axis of symmetry ('xaxis') and its focal length. the sense of parametrization is given by thesense. if thesense == true (by default) then right-handed coordinate system is used, otherwise - left-handed. warnings: it is possible to have focallength = 0. in this case, the parabola looks like a line, which is parallel to the symmetry-axis. raises constructionerror if focallength < 0.0.

        Parameters
        ----------
        theAxes: gp_Ax22d
        theFocalLength: float

        Return
        -------
        None

        Description
        -----------
        Creates a parabola with its vertex point, its axis of symmetry ('xaxis'), correspond y-axis and its focal length. warnings: it is possible to have focallength = 0. in this case, the parabola looks like a line, which is parallel to the symmetry-axis. raises constructionerror if focal < 0.0.

        Parameters
        ----------
        theDirectrix: gp_Ax2d
        theFocus: gp_Pnt2d
        theSense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates a parabola with the directrix and the focus point. y-axis of the parabola (in user coordinate system - ucs) is the direction of thedirectrix. x-axis always directs from thedirectrix to thefocus point and always comes through thefocus. apex of the parabola is a middle point between the thefocus and the intersection point of thedirectrix and the x-axis. warnings: it is possible to have focallength = 0 (when thefocus lies in thedirectrix). in this case, x-direction of the parabola is defined by thesense parameter. if thesense == true (by default) then right-handed coordinate system is used, otherwise - left-handed. result parabola will look like a line, which is perpendicular to the directrix.

        """
        _gp.gp_Parab2d_swiginit(self, _gp.new_gp_Parab2d(*args))

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax22d

        Description
        -----------
        Returns the local coordinate system of the parabola. the 'location' point of this axis is the vertex of the parabola.

        """
        return _gp.gp_Parab2d_Axis(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA: float
        theB: float
        theC: float
        theD: float
        theE: float
        theF: float

        Description
        -----------
        Computes the coefficients of the implicit equation of the parabola (in wcs - world coordinate system). @code thea * (x**2) + theb * (y**2) + 2*thec*(x*y) + 2*thed*x + 2*thee*y + thef = 0. @endcode.

        """
        return _gp.gp_Parab2d_Coefficients(self, *args)

    def Directrix(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Computes the directrix of the parabola. the directrix is: - a line parallel to the 'y direction' of the local coordinate system of this parabola, and - located on the negative side of the axis of symmetry, at a distance from the apex which is equal to the focal length of this parabola. the directrix is returned as an axis (a gp_ax2d object), the origin of which is situated on the 'x axis' of this parabola.

        """
        return _gp.gp_Parab2d_Directrix(self, *args)

    def Focal(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the distance between the vertex and the focus of the parabola.

        """
        return _gp.gp_Parab2d_Focal(self, *args)

    def Focus(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the focus of the parabola.

        """
        return _gp.gp_Parab2d_Focus(self, *args)

    def IsDirect(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the local coordinate system is direct and false in the other case.

        """
        return _gp.gp_Parab2d_IsDirect(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns the vertex of the parabola.

        """
        return _gp.gp_Parab2d_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab2d_Mirror(self, *args)

    def MirrorAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax2d

        Description
        -----------
        Returns the symmetry axis of the parabola. the 'location' point of this axis is the vertex of the parabola.

        """
        return _gp.gp_Parab2d_MirrorAxis(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        gp_Parab2d

        Description
        -----------
        Performs the symmetrical transformation of a parabola with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        gp_Parab2d

        Description
        -----------
        Performs the symmetrical transformation of a parabola with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Parab2d_Mirrored(self, *args)

    def Parameter(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the distance between the focus and the directrix of the parabola.

        """
        return _gp.gp_Parab2d_Parameter(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab2d_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Parab2d

        Description
        -----------
        Reverses the orientation of the local coordinate system of this parabola (the 'y direction' is reversed). therefore, the implicit orientation of this parabola is reversed. note: - reverse assigns the result to this parabola, while - reversed creates a new one.

        """
        return _gp.gp_Parab2d_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        gp_Parab2d

        Description
        -----------
        Rotates a parabola. thep is the center of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Parab2d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab2d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        gp_Parab2d

        Description
        -----------
        Scales a parabola. thes is the scaling value. if thes is negative the direction of the symmetry axis 'xaxis' is reversed and the direction of the 'yaxis' too.

        """
        return _gp.gp_Parab2d_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax22d

        Return
        -------
        None

        Description
        -----------
        Changes the local coordinate system of the parabola. the 'location' point of a becomes the vertex of the parabola.

        """
        return _gp.gp_Parab2d_SetAxis(self, *args)

    def SetFocal(self, *args):
        r"""

        Parameters
        ----------
        theFocal: float

        Return
        -------
        None

        Description
        -----------
        Changes the focal distance of the parabola warnings: it is possible to have thefocal = 0. raises constructionerror if thefocal < 0.0.

        """
        return _gp.gp_Parab2d_SetFocal(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Changes the 'location' point of the parabola. it is the vertex of the parabola.

        """
        return _gp.gp_Parab2d_SetLocation(self, *args)

    def SetMirrorAxis(self, *args):
        r"""

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Modifies this parabola, by redefining its local coordinate system so that its origin and 'x direction' become those of the axis ma. the 'y direction' of the local coordinate system is then recomputed. the orientation of the local coordinate system is not modified.

        """
        return _gp.gp_Parab2d_SetMirrorAxis(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Parab2d

        Description
        -----------
        Transforms an parabola with the transformation thet from class trsf2d.

        """
        return _gp.gp_Parab2d_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Parab2d_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Parab2d

        Description
        -----------
        Translates a parabola in the direction of the vectorthe thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        gp_Parab2d

        Description
        -----------
        Translates a parabola from the point thep1 to the point thep2.

        """
        return _gp.gp_Parab2d_Translated(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Parab2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Parab2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Parab2d

# Register gp_Parab2d in _gp:
_gp.gp_Parab2d_swigregister(gp_Parab2d)
class gp_Pln(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a plane coincident with oxy plane of the reference coordinate system.

        Parameters
        ----------
        theA3: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        The coordinate system of the plane is defined with the axis placement thea3. the 'direction' of thea3 defines the normal to the plane. the 'location' of thea3 defines the location (origin) of the plane. the 'xdirection' and 'ydirection' of thea3 define the 'xaxis' and the 'yaxis' of the plane used to parametrize the plane.

        Parameters
        ----------
        theP: gp_Pnt
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates a plane with the 'location' point <thep> and the normal direction <thev>.

        Parameters
        ----------
        theA: float
        theB: float
        theC: float
        theD: float

        Return
        -------
        None

        Description
        -----------
        Creates a plane from its cartesian equation: @code thea * x + theb * y + thec * z + thed = 0.0 @endcode raises constructionerror if sqrt (thea*thea + theb*theb + thec*thec) <= resolution from gp.

        """
        _gp.gp_Pln_swiginit(self, _gp.new_gp_Pln(*args))

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the plane's normal axis.

        """
        return _gp.gp_Pln_Axis(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA: float
        theB: float
        theC: float
        theD: float

        Description
        -----------
        Returns the coefficients of the plane's cartesian equation: @code thea * x + theb * y + thec * z + thed = 0. @endcode.

        """
        return _gp.gp_Pln_Coefficients(self, *args)

    def Contains(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theLinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if this plane contains the point thep. this means that - the distance between point thep and this plane is less than or equal to thelineartolerance, or - line l is normal to the 'main axis' of the local coordinate system of this plane, within the tolerance angulartolerance, and the distance between the origin of line l and this plane is less than or equal to thelineartolerance.

        Parameters
        ----------
        theL: gp_Lin
        theLinearTolerance: float
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if this plane contains the line thel. this means that - the distance between point p and this plane is less than or equal to lineartolerance, or - line thel is normal to the 'main axis' of the local coordinate system of this plane, within the tolerance theangulartolerance, and the distance between the origin of line thel and this plane is less than or equal to thelineartolerance.

        """
        return _gp.gp_Pln_Contains(self, *args)

    def Direct(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the ax3 is right handed.

        """
        return _gp.gp_Pln_Direct(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Computes the distance between <self> and the point <thep>.

        Parameters
        ----------
        theL: gp_Lin

        Return
        -------
        float

        Description
        -----------
        Computes the distance between <self> and the line <thel>.

        Parameters
        ----------
        theOther: gp_Pln

        Return
        -------
        float

        Description
        -----------
        Computes the distance between two planes.

        """
        return _gp.gp_Pln_Distance(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Pln_DumpJsonToString(self, depth)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the plane's location (origin).

        """
        return _gp.gp_Pln_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pln_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Pln

        Description
        -----------
        Performs the symmetrical transformation of a plane with respect to the point <thep> which is the center of the symmetry warnings: the normal direction to the plane is not changed. the 'xaxis' and the 'yaxis' are reversed.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Pln

        Description
        -----------
        Performs the symmetrical transformation of a plane with respect to an axis placement which is the axis of the symmetry. the transformation is performed on the 'location' point, on the 'xaxis' and the 'yaxis'. the resulting normal direction is the cross product between the 'xdirection' and the 'ydirection' after transformation if the initial plane was right handed, else it is the opposite.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Pln

        Description
        -----------
        Performs the symmetrical transformation of a plane with respect to an axis placement. the axis placement <a2> locates the plane of the symmetry. the transformation is performed on the 'location' point, on the 'xaxis' and the 'yaxis'. the resulting normal direction is the cross product between the 'xdirection' and the 'ydirection' after transformation if the initial plane was right handed, else it is the opposite.

        """
        return _gp.gp_Pln_Mirrored(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Returns the local coordinate system of the plane .

        """
        return _gp.gp_Pln_Position(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pln_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Pln

        Description
        -----------
        Rotates a plane. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Pln_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pln_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Pln

        Description
        -----------
        Scales a plane. thes is the scaling value.

        """
        return _gp.gp_Pln_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Modifies this plane, by redefining its local coordinate system so that - its origin and 'main direction' become those of the axis thea1 (the 'x direction' and 'y direction' are then recomputed). raises constructionerror if the thea1 is parallel to the 'xaxis' of the plane.

        """
        return _gp.gp_Pln_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theLoc: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the origin of the plane.

        """
        return _gp.gp_Pln_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA3: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Changes the local coordinate system of the plane.

        """
        return _gp.gp_Pln_SetPosition(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between <self> and the point <thep>.

        Parameters
        ----------
        theL: gp_Lin

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between <self> and the line <thel>.

        Parameters
        ----------
        theOther: gp_Pln

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between two planes.

        """
        return _gp.gp_Pln_SquareDistance(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pln_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Pln

        Description
        -----------
        Transforms a plane with the transformation thet from class trsf. the transformation is performed on the 'location' point, on the 'xaxis' and the 'yaxis'. the resulting normal direction is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        """
        return _gp.gp_Pln_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pln_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Pln

        Description
        -----------
        Translates a plane in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Pln

        Description
        -----------
        Translates a plane from the point thep1 to the point thep2.

        """
        return _gp.gp_Pln_Translated(self, *args)

    def UReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the u parametrization of the plane reversing the xaxis.

        """
        return _gp.gp_Pln_UReverse(self, *args)

    def VReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the v parametrization of the plane reversing the yaxis.

        """
        return _gp.gp_Pln_VReverse(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the x axis of the plane.

        """
        return _gp.gp_Pln_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the y axis of the plane.

        """
        return _gp.gp_Pln_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Pln()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Pln')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Pln

# Register gp_Pln in _gp:
_gp.gp_Pln_swigregister(gp_Pln)
class gp_Pnt(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a point with zero coordinates.

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Creates a point from a xyz object.

        Parameters
        ----------
        theXp: float
        theYp: float
        theZp: float

        Return
        -------
        None

        Description
        -----------
        Creates a point with its 3 cartesian's coordinates: thexp, theyp, thezp.

        """
        _gp.gp_Pnt_swiginit(self, _gp.new_gp_Pnt(*args))

    def BaryCenter(self, *args):
        r"""

        Parameters
        ----------
        theAlpha: float
        theP: gp_Pnt
        theBeta: float

        Return
        -------
        None

        Description
        -----------
        Assigns the result of the following expression to this point (thealpha*this + thebeta*thep) / (thealpha + thebeta).

        """
        return _gp.gp_Pnt_BaryCenter(self, *args)

    def ChangeCoord(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the coordinates of this point. note: this syntax allows direct modification of the returned value.

        """
        return _gp.gp_Pnt_ChangeCoord(self, *args)

    def Coord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the coordinate of corresponding to the value of theindex: theindex = 1 => x is returned theindex = 2 => y is returned theindex = 3 => z is returned raises outofrange if theindex != {1, 2, 3}. raised if theindex != {1, 2, 3}.

        Parameters
        ----------

        Return
        -------
        theXp: float
        theYp: float
        theZp: float

        Description
        -----------
        For this point gives its three coordinates thexp, theyp and thezp.
        Return
        -------
        gp_XYZ

        Description
        -----------
        For this point, returns its three coordinates as a xyz object.

        """
        return _gp.gp_Pnt_Coord(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Computes the distance between two points.

        """
        return _gp.gp_Pnt_Distance(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Pnt_DumpJsonToString(self, depth)

    def InitFromJsonString(self, json_string):
        r"""InitFromJsonString(gp_Pnt self, std::string json_string) -> bool"""
        return _gp.gp_Pnt_InitFromJsonString(self, json_string)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Pnt
        theLinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Comparison returns true if the distance between the two points is lower or equal to thelineartolerance.

        """
        return _gp.gp_Pnt_IsEqual(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of a point with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Pnt

        Description
        -----------
        Performs the symmetrical transformation of a point with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Pnt

        Description
        -----------
        Performs the symmetrical transformation of a point with respect to a plane. the axis placement thea2 locates the plane of the symmetry: (location, xdirection, ydirection).

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Pnt

        Description
        -----------
        Rotates a point. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Pnt_Mirrored(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Pnt

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        Scales a point. thes is the scaling value.

        """
        return _gp.gp_Pnt_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Pnt

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt_Scaled(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theXi: float

        Return
        -------
        None

        Description
        -----------
        Changes the coordinate of range theindex: theindex = 1 => x is modified theindex = 2 => y is modified theindex = 3 => z is modified raised if theindex != {1, 2, 3}.

        Parameters
        ----------
        theXp: float
        theYp: float
        theZp: float

        Return
        -------
        None

        Description
        -----------
        For this point, assigns the values thexp, theyp and thezp to its three coordinates.

        """
        return _gp.gp_Pnt_SetCoord(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        theX: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this point.

        """
        return _gp.gp_Pnt_SetX(self, *args)

    def SetXYZ(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Assigns the three coordinates of thecoord to this point.

        """
        return _gp.gp_Pnt_SetXYZ(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        theY: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the y coordinate of this point.

        """
        return _gp.gp_Pnt_SetY(self, *args)

    def SetZ(self, *args):
        r"""

        Parameters
        ----------
        theZ: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the z coordinate of this point.

        """
        return _gp.gp_Pnt_SetZ(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Pnt

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between two points.

        """
        return _gp.gp_Pnt_SquareDistance(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Transforms a point with the transformation t.

        """
        return _gp.gp_Pnt_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Pnt

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Translates a point in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Translates a point from the point thep1 to the point thep2.

        """
        return _gp.gp_Pnt_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Pnt

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Pnt

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt_Translated(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this point, returns its x coordinate.

        """
        return _gp.gp_Pnt_X(self, *args)

    def XYZ(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        For this point, returns its three coordinates as a xyz object.

        """
        return _gp.gp_Pnt_XYZ(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this point, returns its y coordinate.

        """
        return _gp.gp_Pnt_Y(self, *args)

    def Z(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this point, returns its z coordinate.

        """
        return _gp.gp_Pnt_Z(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Pnt()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Pnt')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Pnt

# Register gp_Pnt in _gp:
_gp.gp_Pnt_swigregister(gp_Pnt)
class gp_Pnt2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a point with zero coordinates.

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Creates a point with a doublet of coordinates.

        Parameters
        ----------
        theXp: float
        theYp: float

        Return
        -------
        None

        Description
        -----------
        Creates a point with its 2 cartesian's coordinates: thexp, theyp.

        """
        _gp.gp_Pnt2d_swiginit(self, _gp.new_gp_Pnt2d(*args))

    def ChangeCoord(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        Returns the coordinates of this point. note: this syntax allows direct modification of the returned value.

        """
        return _gp.gp_Pnt2d_ChangeCoord(self, *args)

    def Coord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the coordinate of range theindex: theindex = 1 => x is returned theindex = 2 => y is returned raises outofrange if theindex != {1, 2}.

        Parameters
        ----------

        Return
        -------
        theXp: float
        theYp: float

        Description
        -----------
        For this point returns its two coordinates as a number pair.
        Return
        -------
        gp_XY

        Description
        -----------
        For this point, returns its two coordinates as a number pair.

        """
        return _gp.gp_Pnt2d_Coord(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Pnt2d

        Return
        -------
        float

        Description
        -----------
        Computes the distance between two points.

        """
        return _gp.gp_Pnt2d_Distance(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Pnt2d_DumpJsonToString(self, depth)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Pnt2d
        theLinearTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Comparison returns true if the distance between the two points is lower or equal to thelineartolerance.

        """
        return _gp.gp_Pnt2d_IsEqual(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of a point with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt2d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Performs the symmetrical transformation of a point with respect to an axis placement which is the axis.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt2d_Mirrored(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        Rotates a point. thea1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        """
        return _gp.gp_Pnt2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt2d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        None

        Description
        -----------
        Scales a point. thes is the scaling value.

        """
        return _gp.gp_Pnt2d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt2d_Scaled(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theXi: float

        Return
        -------
        None

        Description
        -----------
        Assigns the value xi to the coordinate that corresponds to theindex: theindex = 1 => x is modified theindex = 2 => y is modified raises outofrange if theindex != {1, 2}.

        Parameters
        ----------
        theXp: float
        theYp: float

        Return
        -------
        None

        Description
        -----------
        For this point, assigns the values thexp and theyp to its two coordinates.

        """
        return _gp.gp_Pnt2d_SetCoord(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        theX: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this point.

        """
        return _gp.gp_Pnt2d_SetX(self, *args)

    def SetXY(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Assigns the two coordinates of coord to this point.

        """
        return _gp.gp_Pnt2d_SetXY(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        theY: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the y coordinate of this point.

        """
        return _gp.gp_Pnt2d_SetY(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Pnt2d

        Return
        -------
        float

        Description
        -----------
        Computes the square distance between two points.

        """
        return _gp.gp_Pnt2d_SquareDistance(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        Transforms a point with the transformation thet.

        """
        return _gp.gp_Pnt2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt2d_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Translates a point in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Translates a point from the point thep1 to the point thep2.

        """
        return _gp.gp_Pnt2d_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Pnt2d_Translated(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this point, returns its x coordinate.

        """
        return _gp.gp_Pnt2d_X(self, *args)

    def XY(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        For this point, returns its two coordinates as a number pair.

        """
        return _gp.gp_Pnt2d_XY(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this point, returns its y coordinate.

        """
        return _gp.gp_Pnt2d_Y(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Pnt2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Pnt2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Pnt2d

# Register gp_Pnt2d in _gp:
_gp.gp_Pnt2d_swigregister(gp_Pnt2d)
class gp_Quaternion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an identity quaternion.

        Parameters
        ----------
        theX: float
        theY: float
        theZ: float
        theW: float

        Return
        -------
        None

        Description
        -----------
        Creates quaternion directly from component values.

        Parameters
        ----------
        theVecFrom: gp_Vec
        theVecTo: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Creates quaternion representing shortest-arc rotation operator producing vector thevecto from vector thevecfrom.

        Parameters
        ----------
        theVecFrom: gp_Vec
        theVecTo: gp_Vec
        theHelpCrossVec: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Creates quaternion representing shortest-arc rotation operator producing vector thevecto from vector thevecfrom. additional vector thehelpcrossvec defines preferred direction for rotation and is used when thevecto and thevecfrom are directed oppositely.

        Parameters
        ----------
        theAxis: gp_Vec
        theAngle: float

        Return
        -------
        None

        Description
        -----------
        Creates quaternion representing rotation on angle theangle around vector theaxis.

        Parameters
        ----------
        theMat: gp_Mat

        Return
        -------
        None

        Description
        -----------
        Creates quaternion from rotation matrix 3*3 (which should be orthonormal skew-symmetric matrix).

        """
        _gp.gp_Quaternion_swiginit(self, _gp.new_gp_Quaternion(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Adds components of other quaternion; result is 'rotations mix'.

        """
        return _gp.gp_Quaternion_Add(self, *args)

    def Added(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        gp_Quaternion

        Description
        -----------
        Makes sum of quaternion components; result is 'rotations mix'.

        """
        return _gp.gp_Quaternion_Added(self, *args)

    def Dot(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        float

        Description
        -----------
        Computes inner product / scalar product / dot.

        """
        return _gp.gp_Quaternion_Dot(self, *args)

    def GetEulerAngles(self, *args):
        r"""

        Parameters
        ----------
        theOrder: gp_EulerSequence

        Return
        -------
        theAlpha: float
        theBeta: float
        theGamma: float

        Description
        -----------
        Returns euler angles describing current rotation.

        """
        return _gp.gp_Quaternion_GetEulerAngles(self, *args)

    def GetMatrix(self, *args):
        r"""
        Return
        -------
        gp_Mat

        Description
        -----------
        Returns rotation operation as 3*3 matrix.

        """
        return _gp.gp_Quaternion_GetMatrix(self, *args)

    def GetRotationAngle(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return rotation angle from -pi to pi.

        """
        return _gp.gp_Quaternion_GetRotationAngle(self, *args)

    def GetVectorAndAngle(self, *args):
        r"""

        Parameters
        ----------
        theAxis: gp_Vec

        Return
        -------
        theAngle: float

        Description
        -----------
        Convert a quaternion to axis+angle representation, preserve the axis direction and angle from -pi to +pi.

        """
        return _gp.gp_Quaternion_GetVectorAndAngle(self, *args)

    def Invert(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Inverts quaternion (both rotation direction and norm).

        """
        return _gp.gp_Quaternion_Invert(self, *args)

    def Inverted(self, *args):
        r"""
        Return
        -------
        gp_Quaternion

        Description
        -----------
        Return inversed quaternion q^-1.

        """
        return _gp.gp_Quaternion_Inverted(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        bool

        Description
        -----------
        Simple equal test without precision.

        """
        return _gp.gp_Quaternion_IsEqual(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        gp_Quaternion

        Description
        -----------
        Multiply function - work the same as matrices multiplying. @code qq' = (cross(v,v') + wv' + w'v, ww' - dot(v,v')) @endcode result is rotation combination: q' than q (here q=this, q'=theq). notices that: @code qq' != q'q; qq^-1 = q; @endcode.

        """
        return _gp.gp_Quaternion_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Adds rotation by multiplication.

        Parameters
        ----------
        theVec: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        Rotates vector by quaternion as rotation operator.

        """
        return _gp.gp_Quaternion_Multiply(self, *args)

    def Negated(self, *args):
        r"""
        Return
        -------
        gp_Quaternion

        Description
        -----------
        Returns quaternion with all components negated. note that this operation does not affect neither rotation operator defined by quaternion nor its norm.

        """
        return _gp.gp_Quaternion_Negated(self, *args)

    def Norm(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns norm of quaternion.

        """
        return _gp.gp_Quaternion_Norm(self, *args)

    def Normalize(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Scale quaternion that its norm goes to 1. the appearing of 0 magnitude or near is a error, so we can be sure that can divide by magnitude.

        """
        return _gp.gp_Quaternion_Normalize(self, *args)

    def Normalized(self, *args):
        r"""
        Return
        -------
        gp_Quaternion

        Description
        -----------
        Returns quaternion scaled so that its norm goes to 1.

        """
        return _gp.gp_Quaternion_Normalized(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverse direction of rotation (conjugate quaternion).

        """
        return _gp.gp_Quaternion_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Quaternion

        Description
        -----------
        Return rotation with reversed direction (conjugated quaternion).

        """
        return _gp.gp_Quaternion_Reversed(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theScale: float

        Return
        -------
        None

        Description
        -----------
        Scale all components by quaternion by thescale; note that rotation is not changed by this operation (except 0-scaling).

        """
        return _gp.gp_Quaternion_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theScale: float

        Return
        -------
        gp_Quaternion

        Description
        -----------
        Returns scaled quaternion.

        """
        return _gp.gp_Quaternion_Scaled(self, *args)

    def Set(self, *args):
        r"""

        Parameters
        ----------
        theX: float
        theY: float
        theZ: float
        theW: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theQuaternion: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion_Set(self, *args)

    def SetEulerAngles(self, *args):
        r"""

        Parameters
        ----------
        theOrder: gp_EulerSequence
        theAlpha: float
        theBeta: float
        theGamma: float

        Return
        -------
        None

        Description
        -----------
        Create a unit quaternion representing rotation defined by generalized euler angles.

        """
        return _gp.gp_Quaternion_SetEulerAngles(self, *args)

    def SetIdent(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Make identity quaternion (zero-rotation).

        """
        return _gp.gp_Quaternion_SetIdent(self, *args)

    def SetMatrix(self, *args):
        r"""

        Parameters
        ----------
        theMat: gp_Mat

        Return
        -------
        None

        Description
        -----------
        Create a unit quaternion by rotation matrix matrix must contain only rotation (not scale or shear) //! for numerical stability we find first the greatest component of quaternion and than search others from this one.

        """
        return _gp.gp_Quaternion_SetMatrix(self, *args)

    def SetRotation(self, *args):
        r"""

        Parameters
        ----------
        theVecFrom: gp_Vec
        theVecTo: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Sets quaternion to shortest-arc rotation producing vector thevecto from vector thevecfrom. if vectors thevecfrom and thevecto are opposite then rotation axis is computed as thevecfrom ^ (1,0,0) or thevecfrom ^ (0,0,1).

        Parameters
        ----------
        theVecFrom: gp_Vec
        theVecTo: gp_Vec
        theHelpCrossVec: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Sets quaternion to shortest-arc rotation producing vector thevecto from vector thevecfrom. if vectors thevecfrom and thevecto are opposite then rotation axis is computed as thevecfrom ^ thehelpcrossvec.

        """
        return _gp.gp_Quaternion_SetRotation(self, *args)

    def SetVectorAndAngle(self, *args):
        r"""

        Parameters
        ----------
        theAxis: gp_Vec
        theAngle: float

        Return
        -------
        None

        Description
        -----------
        Create a unit quaternion from axis+angle representation.

        """
        return _gp.gp_Quaternion_SetVectorAndAngle(self, *args)

    def SquareNorm(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns square norm of quaternion.

        """
        return _gp.gp_Quaternion_SquareNorm(self, *args)

    def StabilizeLength(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Stabilize quaternion length within 1 - 1/4. this operation is a lot faster than normalization and preserve length goes to 0 or infinity.

        """
        return _gp.gp_Quaternion_StabilizeLength(self, *args)

    def Subtract(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Subtracts components of other quaternion; result is 'rotations mix'.

        """
        return _gp.gp_Quaternion_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        gp_Quaternion

        Description
        -----------
        Makes difference of quaternion components; result is 'rotations mix'.

        """
        return _gp.gp_Quaternion_Subtracted(self, *args)

    def W(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion_W(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion_X(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion_Y(self, *args)

    def Z(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion_Z(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theScale: float

        Return
        -------
        gp_Quaternion

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        gp_Quaternion

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theVec: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args):
        return _gp.gp_Quaternion___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        gp_Quaternion

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion___add__(self, *args)

    def __iadd_wrapper__(self, other):
        return _gp.gp_Quaternion___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __neg__(self, *args):
        r"""
        Return
        -------
        gp_Quaternion

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion___neg__(self, *args)

    def __sub__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Quaternion

        Return
        -------
        gp_Quaternion

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Quaternion___sub__(self, *args)

    def __isub_wrapper__(self, other):
        return _gp.gp_Quaternion___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Quaternion()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Quaternion')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Quaternion

# Register gp_Quaternion in _gp:
_gp.gp_Quaternion_swigregister(gp_Quaternion)
class gp_QuaternionNLerp(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor,.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Constructor with initialization.

        """
        _gp.gp_QuaternionNLerp_swiginit(self, _gp.new_gp_QuaternionNLerp(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Initialize the tool with start and end values.

        """
        return _gp.gp_QuaternionNLerp_Init(self, *args)

    def InitFromUnit(self, *args):
        r"""

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Initialize the tool with start and end unit quaternions.

        """
        return _gp.gp_QuaternionNLerp_InitFromUnit(self, *args)

    def Interpolate(self, *args):
        r"""

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion
        theT: float

        Return
        -------
        gp_Quaternion

        Description
        -----------
        Compute interpolated quaternion between two quaternions. @param thestart first quaternion @param theend second quaternion @param thet normalized interpolation coefficient within 0..1 range, with 0 pointing to thestart and 1 to theend.

        Parameters
        ----------
        theT: float
        theResultQ: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Set interpolated quaternion for thet position (from 0.0 to 1.0).

        """
        return _gp.gp_QuaternionNLerp_Interpolate(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_QuaternionNLerp()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_QuaternionNLerp')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_QuaternionNLerp

# Register gp_QuaternionNLerp in _gp:
_gp.gp_QuaternionNLerp_swigregister(gp_QuaternionNLerp)
class gp_QuaternionSLerp(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor,.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Constructor with initialization.

        """
        _gp.gp_QuaternionSLerp_swiginit(self, _gp.new_gp_QuaternionSLerp(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Initialize the tool with start and end values.

        """
        return _gp.gp_QuaternionSLerp_Init(self, *args)

    def InitFromUnit(self, *args):
        r"""

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Initialize the tool with start and end unit quaternions.

        """
        return _gp.gp_QuaternionSLerp_InitFromUnit(self, *args)

    def Interpolate(self, *args):
        r"""

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion
        theT: float

        Return
        -------
        gp_Quaternion

        Description
        -----------
        Compute interpolated quaternion between two quaternions. @param thestart first quaternion @param theend second quaternion @param thet normalized interpolation coefficient within 0..1 range, with 0 pointing to thestart and 1 to theend.

        Parameters
        ----------
        theT: float
        theResultQ: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Set interpolated quaternion for thet position (from 0.0 to 1.0).

        """
        return _gp.gp_QuaternionSLerp_Interpolate(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_QuaternionSLerp()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_QuaternionSLerp')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_QuaternionSLerp

# Register gp_QuaternionSLerp in _gp:
_gp.gp_QuaternionSLerp_swigregister(gp_QuaternionSLerp)
class gp_Sphere(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite sphere.

        Parameters
        ----------
        theA3: gp_Ax3
        theRadius: float

        Return
        -------
        None

        Description
        -----------
        Constructs a sphere with radius theradius, centered on the origin of thea3. thea3 is the local coordinate system of the sphere. warnings: it is not forbidden to create a sphere with null radius. raises constructionerror if theradius < 0.0.

        """
        _gp.gp_Sphere_swiginit(self, _gp.new_gp_Sphere(*args))

    def Area(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the area of the sphere.

        """
        return _gp.gp_Sphere_Area(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theA1: float
        theA2: float
        theA3: float
        theB1: float
        theB2: float
        theB3: float
        theC1: float
        theC2: float
        theC3: float
        theD: float

        Description
        -----------
        Computes the coefficients of the implicit equation of the quadric in the absolute cartesian coordinates system: @code thea1.x**2 + thea2.y**2 + thea3.z**2 + 2.(theb1.x.y + theb2.x.z + theb3.y.z) + 2.(thec1.x + thec2.y + thec3.z) + thed = 0.0 @endcode.

        """
        return _gp.gp_Sphere_Coefficients(self, *args)

    def Direct(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the local coordinate system of this sphere is right-handed.

        """
        return _gp.gp_Sphere_Direct(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        --- purpose ; returns the center of the sphere.

        """
        return _gp.gp_Sphere_Location(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Sphere_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Sphere

        Description
        -----------
        Performs the symmetrical transformation of a sphere with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Sphere

        Description
        -----------
        Performs the symmetrical transformation of a sphere with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Sphere

        Description
        -----------
        Performs the symmetrical transformation of a sphere with respect to a plane. the axis placement thea2 locates the plane of the of the symmetry: (location, xdirection, ydirection).

        """
        return _gp.gp_Sphere_Mirrored(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Returns the local coordinates system of the sphere.

        """
        return _gp.gp_Sphere_Position(self, *args)

    def Radius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the radius of the sphere.

        """
        return _gp.gp_Sphere_Radius(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Sphere_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Sphere

        Description
        -----------
        Rotates a sphere. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Sphere_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Sphere_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Sphere

        Description
        -----------
        Scales a sphere. thes is the scaling value. the absolute value of s is used to scale the sphere.

        """
        return _gp.gp_Sphere_Scaled(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theLoc: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the center of the sphere.

        """
        return _gp.gp_Sphere_SetLocation(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA3: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Changes the local coordinate system of the sphere.

        """
        return _gp.gp_Sphere_SetPosition(self, *args)

    def SetRadius(self, *args):
        r"""

        Parameters
        ----------
        theR: float

        Return
        -------
        None

        Description
        -----------
        Assigns ther the radius of the sphere. warnings: it is not forbidden to create a sphere with null radius. raises constructionerror if ther < 0.0.

        """
        return _gp.gp_Sphere_SetRadius(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Sphere_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Sphere

        Description
        -----------
        Transforms a sphere with the transformation thet from class trsf.

        """
        return _gp.gp_Sphere_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Sphere_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Sphere

        Description
        -----------
        Translates a sphere in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Sphere

        Description
        -----------
        Translates a sphere from the point thep1 to the point thep2.

        """
        return _gp.gp_Sphere_Translated(self, *args)

    def UReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the u parametrization of the sphere reversing the yaxis.

        """
        return _gp.gp_Sphere_UReverse(self, *args)

    def VReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the v parametrization of the sphere reversing the zaxis.

        """
        return _gp.gp_Sphere_VReverse(self, *args)

    def Volume(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the volume of the sphere.

        """
        return _gp.gp_Sphere_Volume(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the axis x of the sphere.

        """
        return _gp.gp_Sphere_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the axis y of the sphere.

        """
        return _gp.gp_Sphere_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Sphere()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Sphere')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Sphere

# Register gp_Sphere in _gp:
_gp.gp_Sphere_swigregister(gp_Sphere)
class gp_Torus(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an indefinite torus.

        Parameters
        ----------
        theA3: gp_Ax3
        theMajorRadius: float
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        A torus centered on the origin of coordinate system thea3, with major radius themajorradius and minor radius theminorradius, and with the reference plane defined by the origin, the 'x direction' and the 'y direction' of thea3. warnings: it is not forbidden to create a torus with themajorradius = theminorradius = 0.0 raises constructionerror if theminorradius < 0.0 or if themajorradius < 0.0.

        """
        _gp.gp_Torus_swiginit(self, _gp.new_gp_Torus(*args))

    def Area(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the area of the torus.

        """
        return _gp.gp_Torus_Area(self, *args)

    def Axis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the symmetry axis of the torus.

        """
        return _gp.gp_Torus_Axis(self, *args)

    def Coefficients(self, *args):
        r"""

        Parameters
        ----------
        theCoef: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Computes the coefficients of the implicit equation of the surface in the absolute cartesian coordinate system: @code coef(1) * x^4 + coef(2) * y^4 + coef(3) * z^4 + coef(4) * x^3 * y + coef(5) * x^3 * z + coef(6) * y^3 * x + coef(7) * y^3 * z + coef(8) * z^3 * x + coef(9) * z^3 * y + coef(10) * x^2 * y^2 + coef(11) * x^2 * z^2 + coef(12) * y^2 * z^2 + coef(13) * x^2 * y * z + coef(14) * x * y^2 * z + coef(15) * x * y * z^2 + coef(16) * x^3 + coef(17) * y^3 + coef(18) * z^3 + coef(19) * x^2 * y + coef(20) * x^2 * z + coef(21) * y^2 * x + coef(22) * y^2 * z + coef(23) * z^2 * x + coef(24) * z^2 * y + coef(25) * x * y * z + coef(26) * x^2 + coef(27) * y^2 + coef(28) * z^2 + coef(29) * x * y + coef(30) * x * z + coef(31) * y * z + coef(32) * x + coef(33) * y + coef(34) * z + coef(35) = 0.0 @endcode raises dimensionerror if the length of thecoef is lower than 35.

        """
        return _gp.gp_Torus_Coefficients(self, *args)

    def Direct(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the ax3, the local coordinate system of this torus, is right handed.

        """
        return _gp.gp_Torus_Direct(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the torus's location.

        """
        return _gp.gp_Torus_Location(self, *args)

    def MajorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the major radius of the torus.

        """
        return _gp.gp_Torus_MajorRadius(self, *args)

    def MinorRadius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the minor radius of the torus.

        """
        return _gp.gp_Torus_MinorRadius(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Torus_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        gp_Torus

        Description
        -----------
        Performs the symmetrical transformation of a torus with respect to the point thep which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Torus

        Description
        -----------
        Performs the symmetrical transformation of a torus with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Torus

        Description
        -----------
        Performs the symmetrical transformation of a torus with respect to a plane. the axis placement thea2 locates the plane of the of the symmetry: (location, xdirection, ydirection).

        """
        return _gp.gp_Torus_Mirrored(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Returns the local coordinates system of the torus.

        """
        return _gp.gp_Torus_Position(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Torus_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Torus

        Description
        -----------
        Rotates a torus. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Torus_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Torus_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        gp_Torus

        Description
        -----------
        Scales a torus. s is the scaling value. the absolute value of s is used to scale the torus.

        """
        return _gp.gp_Torus_Scaled(self, *args)

    def SetAxis(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Modifies this torus, by redefining its local coordinate system so that: - its origin and 'main direction' become those of the axis thea1 (the 'x direction' and 'y direction' are then recomputed). raises constructionerror if the direction of thea1 is parallel to the 'xdirection' of the coordinate system of the toroidal surface.

        """
        return _gp.gp_Torus_SetAxis(self, *args)

    def SetLocation(self, *args):
        r"""

        Parameters
        ----------
        theLoc: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Changes the location of the torus.

        """
        return _gp.gp_Torus_SetLocation(self, *args)

    def SetMajorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMajorRadius: float

        Return
        -------
        None

        Description
        -----------
        Assigns value to the major radius of this torus. raises constructionerror if themajorradius - minorradius <= resolution().

        """
        return _gp.gp_Torus_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args):
        r"""

        Parameters
        ----------
        theMinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Assigns value to the minor radius of this torus. raises constructionerror if theminorradius < 0.0 or if majorradius - theminorradius <= resolution from gp.

        """
        return _gp.gp_Torus_SetMinorRadius(self, *args)

    def SetPosition(self, *args):
        r"""

        Parameters
        ----------
        theA3: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Changes the local coordinate system of the surface.

        """
        return _gp.gp_Torus_SetPosition(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Torus_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Torus

        Description
        -----------
        Transforms a torus with the transformation thet from class trsf.

        """
        return _gp.gp_Torus_Transformed(self, *args)

    def Translate(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Torus_Translate(self, *args)

    def Translated(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Torus

        Description
        -----------
        Translates a torus in the direction of the vector thev. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        gp_Torus

        Description
        -----------
        Translates a torus from the point thep1 to the point thep2.

        """
        return _gp.gp_Torus_Translated(self, *args)

    def UReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the u parametrization of the torus reversing the yaxis.

        """
        return _gp.gp_Torus_UReverse(self, *args)

    def VReverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the v parametrization of the torus reversing the zaxis.

        """
        return _gp.gp_Torus_VReverse(self, *args)

    def Volume(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the volume of the torus.

        """
        return _gp.gp_Torus_Volume(self, *args)

    def XAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the axis x of the torus.

        """
        return _gp.gp_Torus_XAxis(self, *args)

    def YAxis(self, *args):
        r"""
        Return
        -------
        gp_Ax1

        Description
        -----------
        Returns the axis y of the torus.

        """
        return _gp.gp_Torus_YAxis(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Torus()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Torus')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Torus

# Register gp_Torus in _gp:
_gp.gp_Torus_swigregister(gp_Torus)
class gp_Trsf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Returns the identity transformation.

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        Creates a 3d transformation from the 2d transformation thet. the resulting transformation has a homogeneous vectorial part, v3, and a translation part, t3, built from thet: a11 a12 0 a13 v3 = a21 a22 0 t3 = a23 0 0 1. 0 it also has the same scale factor as thet. this guarantees (by projection) that the transformation which would be performed by thet in a plane (2d space) is performed by the resulting transformation in the xoy plane of the 3d space, (i.e. in the plane defined by the origin (0., 0., 0.) and the vectors dx (1., 0., 0.), and dy (0., 1., 0.)). the scale factor is applied to the entire space.

        """
        _gp.gp_Trsf_swiginit(self, _gp.new_gp_Trsf(*args))

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Trsf_DumpJsonToString(self, depth)

    def Form(self, *args):
        r"""
        Return
        -------
        gp_TrsfForm

        Description
        -----------
        Returns the nature of the transformation. it can be: an identity transformation, a rotation, a translation, a mirror transformation (relative to a point, an axis or a plane), a scaling transformation, or a compound transformation.

        """
        return _gp.gp_Trsf_Form(self, *args)

    def GetRotation(self, *args):
        r"""

        Parameters
        ----------
        theAxis: gp_XYZ

        Return
        -------
        theAngle: float

        Description
        -----------
        Returns the boolean true if there is non-zero rotation. in the presence of rotation, the output parameters store the axis and the angle of rotation. the method always returns positive value 'theangle', i.e., 0. < theangle <= pi. note that this rotation is defined only by the vectorial part of the transformation; generally you would need to check also the translational part to obtain the axis (gp_ax1) of rotation.
        Return
        -------
        gp_Quaternion

        Description
        -----------
        Returns quaternion representing rotational part of the transformation.

        """
        return _gp.gp_Trsf_GetRotation(self, *args)

    def HVectorialPart(self, *args):
        r"""
        Return
        -------
        gp_Mat

        Description
        -----------
        Computes the homogeneous vectorial part of the transformation. it is a 3*3 matrix which doesn't include the scale factor. in other words, the vectorial part of this transformation is equal to its homogeneous vectorial part, multiplied by the scale factor. the coefficients of this matrix must be multiplied by the scale factor to obtain the coefficients of the transformation.

        """
        return _gp.gp_Trsf_HVectorialPart(self, *args)

    def InitFromJsonString(self, json_string):
        r"""InitFromJsonString(gp_Trsf self, std::string json_string) -> bool"""
        return _gp.gp_Trsf_InitFromJsonString(self, json_string)

    def Invert(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf_Invert(self, *args)

    def Inverted(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        Computes the reverse transformation raises an exception if the matrix of the transformation is not inversible, it means that the scale factor is lower or equal to resolution from package gp. computes the transformation composed with t and <self>. in a c++ implementation you can also write tcomposed = <self> * t. example: @code gp_trsf t1, t2, tcomp; ............... tcomp = t2.multiplied(t1); // or (tcomp = t2 * t1) gp_pnt p1(10.,3.,4.); gp_pnt p2 = p1.transformed(tcomp); // using tcomp gp_pnt p3 = p1.transformed(t1); // using t1 then t2 p3.transform(t2); // p3 = p2 !!! @endcode.

        """
        return _gp.gp_Trsf_Inverted(self, *args)

    def IsNegative(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the determinant of the vectorial part of this transformation is negative.

        """
        return _gp.gp_Trsf_IsNegative(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Trsf

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Computes the transformation composed with <self> and thet. <self> = <self> * thet.

        """
        return _gp.gp_Trsf_Multiply(self, *args)

    def Power(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf_Power(self, *args)

    def Powered(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        gp_Trsf

        Description
        -----------
        Computes the following composition of transformations <self> * <self> * .......* <self>, then time. if then = 0 <self> = identity if then < 0 <self> = <self>.inverse() *...........* <self>.inverse(). //! raises if then < 0 and if the matrix of the transformation not inversible.

        """
        return _gp.gp_Trsf_Powered(self, *args)

    def PreMultiply(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Computes the transformation composed with <self> and t. <self> = thet * <self>.

        """
        return _gp.gp_Trsf_PreMultiply(self, *args)

    def ScaleFactor(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the scale factor.

        """
        return _gp.gp_Trsf_ScaleFactor(self, *args)

    def SetDisplacement(self, *args):
        r"""

        Parameters
        ----------
        theFromSystem1: gp_Ax3
        theToSystem2: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Modifies this transformation so that it transforms the coordinate system defined by thefromsystem1 into the one defined by thetosystem2. after this modification, this transformation transforms: - the origin of thefromsystem1 into the origin of thetosystem2, - the 'x direction' of thefromsystem1 into the 'x direction' of thetosystem2, - the 'y direction' of thefromsystem1 into the 'y direction' of thetosystem2, and - the 'main direction' of thefromsystem1 into the 'main direction' of thetosystem2. warning when you know the coordinates of a point in one coordinate system and you want to express these coordinates in another one, do not use the transformation resulting from this function. use the transformation that results from settransformation instead. setdisplacement and settransformation create related transformations: the vectorial part of one is the inverse of the vectorial part of the other.

        """
        return _gp.gp_Trsf_SetDisplacement(self, *args)

    def SetForm(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_TrsfForm

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf_SetForm(self, *args)

    def SetMirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a symmetrical transformation. thep is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a symmetrical transformation. thea1 is the center of the axial symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a symmetrical transformation. thea2 is the center of the planar symmetry and defines the plane of symmetry by its origin, 'x direction' and 'y direction'.

        """
        return _gp.gp_Trsf_SetMirror(self, *args)

    def SetRotation(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a rotation. thea1 is the rotation axis and theang is the angular value of the rotation in radians.

        Parameters
        ----------
        theR: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a rotation defined by quaternion. note that rotation is performed around origin, i.e. no translation is involved.

        """
        return _gp.gp_Trsf_SetRotation(self, *args)

    def SetRotationPart(self, *args):
        r"""

        Parameters
        ----------
        theR: gp_Quaternion

        Return
        -------
        None

        Description
        -----------
        Replaces the rotation part with specified quaternion.

        """
        return _gp.gp_Trsf_SetRotationPart(self, *args)

    def SetScale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt
        theS: float

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a scale. thep is the center of the scale and thes is the scaling value. raises constructionerror if <thes> is null.

        """
        return _gp.gp_Trsf_SetScale(self, *args)

    def SetScaleFactor(self, *args):
        r"""

        Parameters
        ----------
        theS: float

        Return
        -------
        None

        Description
        -----------
        Modifies the scale factor. raises constructionerror if thes is null.

        """
        return _gp.gp_Trsf_SetScaleFactor(self, *args)

    def SetTransformation(self, *args):
        r"""

        Parameters
        ----------
        theFromSystem1: gp_Ax3
        theToSystem2: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Modifies this transformation so that it transforms the coordinates of any point, (x, y, z), relative to a source coordinate system into the coordinates (x', y', z') which are relative to a target coordinate system, but which represent the same point the transformation is from the coordinate system 'thefromsystem1' to the coordinate system 'thetosystem2'. example: @code gp_ax3 thefromsystem1, thetosystem2; double x1, y1, z1; // are the coordinates of a point in the local system thefromsystem1 double x2, y2, z2; // are the coordinates of a point in the local system thetosystem2 gp_pnt p1 (x1, y1, z1) gp_trsf t; t.settransformation (thefromsystem1, thetosystem2); gp_pnt p2 = p1.transformed (t); p2.coord (x2, y2, z2); @endcode.

        Parameters
        ----------
        theToSystem: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Modifies this transformation so that it transforms the coordinates of any point, (x, y, z), relative to a source coordinate system into the coordinates (x', y', z') which are relative to a target coordinate system, but which represent the same point the transformation is from the default coordinate system @code {p(0.,0.,0.), vx (1.,0.,0.), vy (0.,1.,0.), vz (0., 0. ,1.) } @endcode to the local coordinate system defined with the ax3 thetosystem. use in the same way as the previous method. fromsystem1 is defaulted to the absolute coordinate system.

        Parameters
        ----------
        R: gp_Quaternion
        theT: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Sets transformation by directly specified rotation and translation.

        """
        return _gp.gp_Trsf_SetTransformation(self, *args)

    def SetTranslation(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a translation. thev is the vector of the translation.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a translation where the translation vector is the vector (thep1, thep2) defined from point thep1 to point thep2.

        """
        return _gp.gp_Trsf_SetTranslation(self, *args)

    def SetTranslationPart(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Replaces the translation vector with the vector thev.

        """
        return _gp.gp_Trsf_SetTranslationPart(self, *args)

    def SetValues(self, *args):
        r"""

        Parameters
        ----------
        a11: float
        a12: float
        a13: float
        a14: float
        a21: float
        a22: float
        a23: float
        a24: float
        a31: float
        a32: float
        a33: float
        a34: float

        Return
        -------
        None

        Description
        -----------
        Sets the coefficients of the transformation. the transformation of the point x,y,z is the point x',y',z' with: @code x' = a11 x + a12 y + a13 z + a14 y' = a21 x + a22 y + a23 z + a24 z' = a31 x + a32 y + a33 z + a34 @endcode the method value(i,j) will return aij. raises constructionerror if the determinant of the aij is null. the matrix is orthogonalized before future using.

        """
        return _gp.gp_Trsf_SetValues(self, *args)

    def Transforms(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theX: float
        theY: float
        theZ: float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Transformation of a triplet xyz with a trsf.

        """
        return _gp.gp_Trsf_Transforms(self, *args)

    def TranslationPart(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the translation part of the transformation's matrix.

        """
        return _gp.gp_Trsf_TranslationPart(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int

        Return
        -------
        float

        Description
        -----------
        Returns the coefficients of the transformation's matrix. it is a 3 rows * 4 columns matrix. this coefficient includes the scale factor. raises outofranged if therow < 1 or therow > 3 or thecol < 1 or thecol > 4.

        """
        return _gp.gp_Trsf_Value(self, *args)

    def VectorialPart(self, *args):
        r"""
        Return
        -------
        gp_Mat

        Description
        -----------
        Returns the vectorial part of the transformation. it is a 3*3 matrix which includes the scale factor.

        """
        return _gp.gp_Trsf_VectorialPart(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Trsf

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf___mul__(self, *args)

    def __imul_wrapper__(self, other):
        r"""__imul_wrapper__(gp_Trsf self, gp_Trsf other)"""
        return _gp.gp_Trsf___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Trsf()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Trsf')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Trsf

# Register gp_Trsf in _gp:
_gp.gp_Trsf_swigregister(gp_Trsf)
class gp_Trsf2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Returns identity transformation.

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Creates a 2d transformation in the xy plane from a 3d transformation .

        """
        _gp.gp_Trsf2d_swiginit(self, _gp.new_gp_Trsf2d(*args))

    def Form(self, *args):
        r"""
        Return
        -------
        gp_TrsfForm

        Description
        -----------
        Returns the nature of the transformation. it can be an identity transformation, a rotation, a translation, a mirror (relative to a point or an axis), a scaling transformation, or a compound transformation.

        """
        return _gp.gp_Trsf2d_Form(self, *args)

    def HVectorialPart(self, *args):
        r"""
        Return
        -------
        gp_Mat2d

        Description
        -----------
        Returns the homogeneous vectorial part of the transformation. it is a 2*2 matrix which doesn't include the scale factor. the coefficients of this matrix must be multiplied by the scale factor to obtain the coefficients of the transformation.

        """
        return _gp.gp_Trsf2d_HVectorialPart(self, *args)

    def Invert(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf2d_Invert(self, *args)

    def Inverted(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        Computes the reverse transformation. raises an exception if the matrix of the transformation is not inversible, it means that the scale factor is lower or equal to resolution from package gp.

        """
        return _gp.gp_Trsf2d_Inverted(self, *args)

    def IsNegative(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the determinant of the vectorial part of this transformation is negative..

        """
        return _gp.gp_Trsf2d_IsNegative(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Trsf2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf2d_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        Computes the transformation composed from <self> and thet. <self> = <self> * thet.

        """
        return _gp.gp_Trsf2d_Multiply(self, *args)

    def Power(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf2d_Power(self, *args)

    def Powered(self, *args):
        r"""

        Parameters
        ----------
        theN: int

        Return
        -------
        gp_Trsf2d

        Description
        -----------
        Computes the following composition of transformations <self> * <self> * .......* <self>, then time. if then = 0 <self> = identity if then < 0 <self> = <self>.inverse() *...........* <self>.inverse(). //! raises if then < 0 and if the matrix of the transformation not inversible.

        """
        return _gp.gp_Trsf2d_Powered(self, *args)

    def PreMultiply(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        Computes the transformation composed from <self> and thet. <self> = thet * <self>.

        """
        return _gp.gp_Trsf2d_PreMultiply(self, *args)

    def RotationPart(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the angle corresponding to the rotational component of the transformation matrix (operation opposite to setrotation()).

        """
        return _gp.gp_Trsf2d_RotationPart(self, *args)

    def ScaleFactor(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the scale factor.

        """
        return _gp.gp_Trsf2d_ScaleFactor(self, *args)

    def SetMirror(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a symmetrical transformation. thep is the center of the symmetry.

        Parameters
        ----------
        theA: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a symmetrical transformation. thea is the center of the axial symmetry.

        """
        return _gp.gp_Trsf2d_SetMirror(self, *args)

    def SetRotation(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theAng: float

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a rotation. thep is the rotation's center and theang is the angular value of the rotation in radian.

        """
        return _gp.gp_Trsf2d_SetRotation(self, *args)

    def SetScale(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt2d
        theS: float

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a scale. thep is the center of the scale and thes is the scaling value.

        """
        return _gp.gp_Trsf2d_SetScale(self, *args)

    def SetScaleFactor(self, *args):
        r"""

        Parameters
        ----------
        theS: float

        Return
        -------
        None

        Description
        -----------
        Modifies the scale factor.

        """
        return _gp.gp_Trsf2d_SetScaleFactor(self, *args)

    def SetTransformation(self, *args):
        r"""

        Parameters
        ----------
        theFromSystem1: gp_Ax2d
        theToSystem2: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes a transformation allowing passage from the coordinate system 'thefromsystem1' to the coordinate system 'thetosystem2'.

        Parameters
        ----------
        theToSystem: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Changes the transformation allowing passage from the basic coordinate system {p(0.,0.,0.), vx (1.,0.,0.), vy (0.,1.,0.)} to the local coordinate system defined with the ax2d thetosystem.

        """
        return _gp.gp_Trsf2d_SetTransformation(self, *args)

    def SetTranslation(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Changes the transformation into a translation. thev is the vector of the translation.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Makes the transformation into a translation from the point thep1 to the point thep2.

        """
        return _gp.gp_Trsf2d_SetTranslation(self, *args)

    def SetTranslationPart(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Replaces the translation vector with thev.

        """
        return _gp.gp_Trsf2d_SetTranslationPart(self, *args)

    def SetValues(self, *args):
        r"""

        Parameters
        ----------
        a11: float
        a12: float
        a13: float
        a21: float
        a22: float
        a23: float

        Return
        -------
        None

        Description
        -----------
        Sets the coefficients of the transformation. the transformation of the point x,y is the point x',y' with: @code x' = a11 x + a12 y + a13 y' = a21 x + a22 y + a23 @endcode the method value(i,j) will return aij. raises constructionerror if the determinant of the aij is null. if the matrix as not a uniform scale it will be orthogonalized before future using.

        """
        return _gp.gp_Trsf2d_SetValues(self, *args)

    def Transforms(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theX: float
        theY: float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Transforms a doublet xy with a trsf2d.

        """
        return _gp.gp_Trsf2d_Transforms(self, *args)

    def TranslationPart(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        Returns the translation part of the transformation's matrix.

        """
        return _gp.gp_Trsf2d_TranslationPart(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theRow: int
        theCol: int

        Return
        -------
        float

        Description
        -----------
        Returns the coefficients of the transformation's matrix. it is a 2 rows * 3 columns matrix. raises outofrange if therow < 1 or therow > 2 or thecol < 1 or thecol > 3.

        """
        return _gp.gp_Trsf2d_Value(self, *args)

    def VectorialPart(self, *args):
        r"""
        Return
        -------
        gp_Mat2d

        Description
        -----------
        Returns the vectorial part of the transformation. it is a 2*2 matrix which includes the scale factor.

        """
        return _gp.gp_Trsf2d_VectorialPart(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Trsf2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Trsf2d___mul__(self, *args)

    def __imul_wrapper__(self, other):
        return _gp.gp_Trsf2d___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Trsf2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Trsf2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Trsf2d

# Register gp_Trsf2d in _gp:
_gp.gp_Trsf2d_swigregister(gp_Trsf2d)
class gp_Vec(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a zero vector.

        Parameters
        ----------
        theV: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates a unitary vector from a direction thev.

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Creates a vector with a triplet of coordinates.

        Parameters
        ----------
        theXv: float
        theYv: float
        theZv: float

        Return
        -------
        None

        Description
        -----------
        Creates a point with its three cartesian coordinates.

        Parameters
        ----------
        theP1: gp_Pnt
        theP2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Creates a vector from two points. the length of the vector is the distance between thep1 and thep2.

        """
        _gp.gp_Vec_swiginit(self, _gp.new_gp_Vec(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Adds two vectors.

        """
        return _gp.gp_Vec_Add(self, *args)

    def Added(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        Adds two vectors.

        """
        return _gp.gp_Vec_Added(self, *args)

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec

        Return
        -------
        float

        Description
        -----------
        Computes the angular value between <self> and <theother> returns the angle value between 0 and pi in radian. raises vectorwithnullmagnitude if <self>.magnitude() <= resolution from gp or theother.magnitude() <= resolution because the angular value is indefinite if one of the vectors has a null magnitude.

        """
        return _gp.gp_Vec_Angle(self, *args)

    def AngleWithRef(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec
        theVRef: gp_Vec

        Return
        -------
        float

        Description
        -----------
        Computes the angle, in radians, between this vector and vector theother. the result is a value between -pi and pi. for this, thevref defines the positive sense of rotation: the angular value is positive, if the cross product this ^ theother has the same orientation as thevref relative to the plane defined by the vectors this and theother. otherwise, the angular value is negative. exceptions gp_vectorwithnullmagnitude if the magnitude of this vector, the vector theother, or the vector thevref is less than or equal to gp::resolution(). standard_domainerror if this vector, the vector theother, and the vector thevref are coplanar, unless this vector and the vector theother are parallel.

        """
        return _gp.gp_Vec_AngleWithRef(self, *args)

    def Coord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the coordinate of range theindex: theindex = 1 => x is returned theindex = 2 => y is returned theindex = 3 => z is returned raised if theindex != {1, 2, 3}.

        Parameters
        ----------

        Return
        -------
        theXv: float
        theYv: float
        theZv: float

        Description
        -----------
        For this vector returns its three coordinates thexv, theyv, and thezv inline.

        """
        return _gp.gp_Vec_Coord(self, *args)

    def Cross(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Computes the cross product between two vectors.

        """
        return _gp.gp_Vec_Cross(self, *args)

    def CrossCross(self, *args):
        r"""

        Parameters
        ----------
        theV1: gp_Vec
        theV2: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Computes the triple vector product. <self> ^= (thev1 ^ thev2).

        """
        return _gp.gp_Vec_CrossCross(self, *args)

    def CrossCrossed(self, *args):
        r"""

        Parameters
        ----------
        theV1: gp_Vec
        theV2: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        Computes the triple vector product. <self> ^ (thev1 ^ thev2).

        """
        return _gp.gp_Vec_CrossCrossed(self, *args)

    def CrossMagnitude(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec

        Return
        -------
        float

        Description
        -----------
        Computes the magnitude of the cross product between <self> and theright. returns || <self> ^ theright ||.

        """
        return _gp.gp_Vec_CrossMagnitude(self, *args)

    def CrossSquareMagnitude(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec

        Return
        -------
        float

        Description
        -----------
        Computes the square magnitude of the cross product between <self> and theright. returns || <self> ^ theright ||**2.

        """
        return _gp.gp_Vec_CrossSquareMagnitude(self, *args)

    def Crossed(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        Computes the cross product between two vectors.

        """
        return _gp.gp_Vec_Crossed(self, *args)

    def Divide(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        Divides a vector by a scalar.

        """
        return _gp.gp_Vec_Divide(self, *args)

    def Divided(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Vec

        Description
        -----------
        Divides a vector by a scalar.

        """
        return _gp.gp_Vec_Divided(self, *args)

    def Dot(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec

        Return
        -------
        float

        Description
        -----------
        Computes the scalar product.

        """
        return _gp.gp_Vec_Dot(self, *args)

    def DotCross(self, *args):
        r"""

        Parameters
        ----------
        theV1: gp_Vec
        theV2: gp_Vec

        Return
        -------
        float

        Description
        -----------
        Computes the triple scalar product <self> * (thev1 ^ thev2).

        """
        return _gp.gp_Vec_DotCross(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_Vec_DumpJsonToString(self, depth)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec
        theLinearTolerance: float
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the two vectors have the same magnitude value and the same direction. the precision values are thelineartolerance for the magnitude and theangulartolerance for the direction.

        """
        return _gp.gp_Vec_IsEqual(self, *args)

    def IsNormal(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if abs(<self>.angle(theother) - pi/2.) <= theangulartolerance raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or theother.magnitude() <= resolution from gp.

        """
        return _gp.gp_Vec_IsNormal(self, *args)

    def IsOpposite(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if pi - <self>.angle(theother) <= theangulartolerance raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or other.magnitude() <= resolution from gp.

        """
        return _gp.gp_Vec_IsOpposite(self, *args)

    def IsParallel(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if angle(<self>, theother) <= theangulartolerance or pi - angle(<self>, theother) <= theangulartolerance this definition means that two parallel vectors cannot define a plane but two vectors with opposite directions are considered as parallel. raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or other.magnitude() <= resolution from gp.

        """
        return _gp.gp_Vec_IsParallel(self, *args)

    def Magnitude(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the magnitude of this vector.

        """
        return _gp.gp_Vec_Magnitude(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        Performs the symmetrical transformation of a vector with respect to the vector thev which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax1

        Return
        -------
        gp_Vec

        Description
        -----------
        Performs the symmetrical transformation of a vector with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        theA2: gp_Ax2

        Return
        -------
        gp_Vec

        Description
        -----------
        Performs the symmetrical transformation of a vector with respect to a plane. the axis placement thea2 locates the plane of the symmetry: (location, xdirection, ydirection).

        """
        return _gp.gp_Vec_Mirrored(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Vec

        Description
        -----------
        Multiplies a vector by a scalar.

        """
        return _gp.gp_Vec_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        Multiplies a vector by a scalar.

        """
        return _gp.gp_Vec_Multiply(self, *args)

    def Normalize(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Normalizes a vector raises an exception if the magnitude of the vector is lower or equal to resolution from gp.

        """
        return _gp.gp_Vec_Normalize(self, *args)

    def Normalized(self, *args):
        r"""
        Return
        -------
        gp_Vec

        Description
        -----------
        Normalizes a vector raises an exception if the magnitude of the vector is lower or equal to resolution from gp.

        """
        return _gp.gp_Vec_Normalized(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the direction of a vector.

        """
        return _gp.gp_Vec_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Vec

        Description
        -----------
        Reverses the direction of a vector.

        """
        return _gp.gp_Vec_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theA1: gp_Ax1
        theAng: float

        Return
        -------
        gp_Vec

        Description
        -----------
        Rotates a vector. thea1 is the axis of the rotation. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Vec_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theS: float

        Return
        -------
        gp_Vec

        Description
        -----------
        Scales a vector. thes is the scaling value.

        """
        return _gp.gp_Vec_Scaled(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theXi: float

        Return
        -------
        None

        Description
        -----------
        Changes the coordinate of range theindex theindex = 1 => x is modified theindex = 2 => y is modified theindex = 3 => z is modified raised if theindex != {1, 2, 3}.

        Parameters
        ----------
        theXv: float
        theYv: float
        theZv: float

        Return
        -------
        None

        Description
        -----------
        For this vector, assigns - the values thexv, theyv and thezv to its three coordinates.

        """
        return _gp.gp_Vec_SetCoord(self, *args)

    def SetLinearForm(self, *args):
        r"""

        Parameters
        ----------
        theA1: float
        theV1: gp_Vec
        theA2: float
        theV2: gp_Vec
        theA3: float
        theV3: gp_Vec
        theV4: gp_Vec

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thea1 * thev1 + thea2 * thev2 + thea3 * thev3 + thev4.

        Parameters
        ----------
        theA1: float
        theV1: gp_Vec
        theA2: float
        theV2: gp_Vec
        theA3: float
        theV3: gp_Vec

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thea1 * thev1 + thea2 * thev2 + thea3 * thev3.

        Parameters
        ----------
        theA1: float
        theV1: gp_Vec
        theA2: float
        theV2: gp_Vec
        theV3: gp_Vec

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thea1 * thev1 + thea2 * thev2 + thev3.

        Parameters
        ----------
        theA1: float
        theV1: gp_Vec
        theA2: float
        theV2: gp_Vec

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thea1 * thev1 + thea2 * thev2.

        Parameters
        ----------
        theA1: float
        theV1: gp_Vec
        theV2: gp_Vec

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thea1 * thev1 + thev2.

        Parameters
        ----------
        theV1: gp_Vec
        theV2: gp_Vec

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thev1 + thev2.

        """
        return _gp.gp_Vec_SetLinearForm(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        theX: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this vector.

        """
        return _gp.gp_Vec_SetX(self, *args)

    def SetXYZ(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Assigns the three coordinates of thecoord to this vector.

        """
        return _gp.gp_Vec_SetXYZ(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        theY: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this vector.

        """
        return _gp.gp_Vec_SetY(self, *args)

    def SetZ(self, *args):
        r"""

        Parameters
        ----------
        theZ: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this vector.

        """
        return _gp.gp_Vec_SetZ(self, *args)

    def SquareMagnitude(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the square magnitude of this vector.

        """
        return _gp.gp_Vec_SquareMagnitude(self, *args)

    def Subtract(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Subtracts two vectors.

        """
        return _gp.gp_Vec_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        Subtracts two vectors.

        """
        return _gp.gp_Vec_Subtracted(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Transforms a vector with the transformation thet.

        """
        return _gp.gp_Vec_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf

        Return
        -------
        gp_Vec

        Description
        -----------
        Transforms a vector with the transformation thet.

        """
        return _gp.gp_Vec_Transformed(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this vector, returns its x coordinate.

        """
        return _gp.gp_Vec_X(self, *args)

    def XYZ(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        For this vector, returns - its three coordinates as a number triple.

        """
        return _gp.gp_Vec_XYZ(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this vector, returns its y coordinate.

        """
        return _gp.gp_Vec_Y(self, *args)

    def Z(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this vector, returns its z coordinate.

        """
        return _gp.gp_Vec_Z(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Vec

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theOther: gp_Vec

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec___mul__(self, *args)

    def __imul_wrapper__(self, other):
        r"""Json string serializer."""
        return _gp.gp_Vec___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec___add__(self, *args)

    def __iadd_wrapper__(self, other):
        r"""Json string serializer."""
        return _gp.gp_Vec___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec

        Return
        -------
        gp_Vec

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec___sub__(self, *args)

    def __neg__(self, *args):
        r"""
        Return
        -------
        gp_Vec

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec___neg__(self, *args)

    def __isub_wrapper__(self, other):
        r"""Json string serializer."""
        return _gp.gp_Vec___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_Vec___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other):
        r"""Json string serializer."""
        return _gp.gp_Vec___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Vec()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Vec')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Vec

# Register gp_Vec in _gp:
_gp.gp_Vec_swigregister(gp_Vec)
class gp_Vec2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a zero vector.

        Parameters
        ----------
        theV: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Creates a unitary vector from a direction thev.

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Creates a vector with a doublet of coordinates.

        Parameters
        ----------
        theXv: float
        theYv: float

        Return
        -------
        None

        Description
        -----------
        Creates a point with its two cartesian coordinates.

        Parameters
        ----------
        theP1: gp_Pnt2d
        theP2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Creates a vector from two points. the length of the vector is the distance between thep1 and thep2.

        """
        _gp.gp_Vec2d_swiginit(self, _gp.new_gp_Vec2d(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_Add(self, *args)

    def Added(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Adds two vectors.

        """
        return _gp.gp_Vec2d_Added(self, *args)

    def Angle(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d

        Return
        -------
        float

        Description
        -----------
        Computes the angular value between <self> and <theother> returns the angle value between -pi and pi in radian. the orientation is from <self> to theother. the positive sense is the trigonometric sense. raises vectorwithnullmagnitude if <self>.magnitude() <= resolution from gp or theother.magnitude() <= resolution because the angular value is indefinite if one of the vectors has a null magnitude.

        """
        return _gp.gp_Vec2d_Angle(self, *args)

    def Coord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the coordinate of range theindex: theindex = 1 => x is returned theindex = 2 => y is returned raised if theindex != {1, 2}.

        Parameters
        ----------

        Return
        -------
        theXv: float
        theYv: float

        Description
        -----------
        For this vector, returns its two coordinates thexv and theyv.

        """
        return _gp.gp_Vec2d_Coord(self, *args)

    def CrossMagnitude(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec2d

        Return
        -------
        float

        Description
        -----------
        Computes the magnitude of the cross product between <self> and theright. returns || <self> ^ theright ||.

        """
        return _gp.gp_Vec2d_CrossMagnitude(self, *args)

    def CrossSquareMagnitude(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec2d

        Return
        -------
        float

        Description
        -----------
        Computes the square magnitude of the cross product between <self> and theright. returns || <self> ^ theright ||**2.

        """
        return _gp.gp_Vec2d_CrossSquareMagnitude(self, *args)

    def Crossed(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec2d

        Return
        -------
        float

        Description
        -----------
        Computes the crossing product between two vectors.

        """
        return _gp.gp_Vec2d_Crossed(self, *args)

    def Divide(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_Divide(self, *args)

    def Divided(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Divides a vector by a scalar.

        """
        return _gp.gp_Vec2d_Divided(self, *args)

    def Dot(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d

        Return
        -------
        float

        Description
        -----------
        Computes the scalar product.

        """
        return _gp.gp_Vec2d_Dot(self, *args)

    def GetNormal(self, *args):
        r"""
        Return
        -------
        gp_Vec2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_GetNormal(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d
        theLinearTolerance: float
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the two vectors have the same magnitude value and the same direction. the precision values are thelineartolerance for the magnitude and theangulartolerance for the direction.

        """
        return _gp.gp_Vec2d_IsEqual(self, *args)

    def IsNormal(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if abs(abs(<self>.angle(theother)) - pi/2.) <= theangulartolerance raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or theother.magnitude() <= resolution from gp.

        """
        return _gp.gp_Vec2d_IsNormal(self, *args)

    def IsOpposite(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if pi - abs(<self>.angle(theother)) <= theangulartolerance raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or theother.magnitude() <= resolution from gp.

        """
        return _gp.gp_Vec2d_IsOpposite(self, *args)

    def IsParallel(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d
        theAngularTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if abs(angle(<self>, theother)) <= theangulartolerance or pi - abs(angle(<self>, theother)) <= theangulartolerance two vectors with opposite directions are considered as parallel. raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or theother.magnitude() <= resolution from gp.

        """
        return _gp.gp_Vec2d_IsParallel(self, *args)

    def Magnitude(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the magnitude of this vector.

        """
        return _gp.gp_Vec2d_Magnitude(self, *args)

    def Mirror(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of a vector with respect to the vector thev which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Performs the symmetrical transformation of a vector with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Vec2d_Mirror(self, *args)

    def Mirrored(self, *args):
        r"""

        Parameters
        ----------
        theV: gp_Vec2d

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Performs the symmetrical transformation of a vector with respect to the vector thev which is the center of the symmetry.

        Parameters
        ----------
        theA1: gp_Ax2d

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Performs the symmetrical transformation of a vector with respect to an axis placement which is the axis of the symmetry.

        """
        return _gp.gp_Vec2d_Mirrored(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Normalizes a vector raises an exception if the magnitude of the vector is lower or equal to resolution from package gp.

        """
        return _gp.gp_Vec2d_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_Multiply(self, *args)

    def Normalize(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_Normalize(self, *args)

    def Normalized(self, *args):
        r"""
        Return
        -------
        gp_Vec2d

        Description
        -----------
        Normalizes a vector raises an exception if the magnitude of the vector is lower or equal to resolution from package gp. reverses the direction of a vector.

        """
        return _gp.gp_Vec2d_Normalized(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_Vec2d

        Description
        -----------
        Reverses the direction of a vector.

        """
        return _gp.gp_Vec2d_Reversed(self, *args)

    def Rotate(self, *args):
        r"""

        Parameters
        ----------
        theAng: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_Rotate(self, *args)

    def Rotated(self, *args):
        r"""

        Parameters
        ----------
        theAng: float

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Rotates a vector. theang is the angular value of the rotation in radians.

        """
        return _gp.gp_Vec2d_Rotated(self, *args)

    def Scale(self, *args):
        r"""

        Parameters
        ----------
        theS: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_Scale(self, *args)

    def Scaled(self, *args):
        r"""

        Parameters
        ----------
        theS: float

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Scales a vector. thes is the scaling value.

        """
        return _gp.gp_Vec2d_Scaled(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theXi: float

        Return
        -------
        None

        Description
        -----------
        Changes the coordinate of range theindex theindex = 1 => x is modified theindex = 2 => y is modified raises outofrange if theindex != {1, 2}.

        Parameters
        ----------
        theXv: float
        theYv: float

        Return
        -------
        None

        Description
        -----------
        For this vector, assigns the values thexv and theyv to its two coordinates.

        """
        return _gp.gp_Vec2d_SetCoord(self, *args)

    def SetLinearForm(self, *args):
        r"""

        Parameters
        ----------
        theA1: float
        theV1: gp_Vec2d
        theA2: float
        theV2: gp_Vec2d
        theV3: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thea1 * thev1 + thea2 * thev2 + thev3.

        Parameters
        ----------
        theA1: float
        theV1: gp_Vec2d
        theA2: float
        theV2: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thea1 * thev1 + thea2 * thev2.

        Parameters
        ----------
        theA1: float
        theV1: gp_Vec2d
        theV2: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thea1 * thev1 + thev2.

        Parameters
        ----------
        theV1: gp_Vec2d
        theV2: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: thev1 + thev2.

        """
        return _gp.gp_Vec2d_SetLinearForm(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        theX: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this vector.

        """
        return _gp.gp_Vec2d_SetX(self, *args)

    def SetXY(self, *args):
        r"""

        Parameters
        ----------
        theCoord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Assigns the two coordinates of thecoord to this vector.

        """
        return _gp.gp_Vec2d_SetXY(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        theY: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the y coordinate of this vector.

        """
        return _gp.gp_Vec2d_SetY(self, *args)

    def SquareMagnitude(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the square magnitude of this vector.

        """
        return _gp.gp_Vec2d_SquareMagnitude(self, *args)

    def Subtract(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Subtracts two vectors.

        """
        return _gp.gp_Vec2d_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec2d

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Subtracts two vectors.

        """
        return _gp.gp_Vec2d_Subtracted(self, *args)

    def Transform(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d_Transform(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theT: gp_Trsf2d

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Transforms a vector with a trsf from gp.

        """
        return _gp.gp_Vec2d_Transformed(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this vector, returns its x coordinate.

        """
        return _gp.gp_Vec2d_X(self, *args)

    def XY(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        For this vector, returns its two coordinates as a number pair.

        """
        return _gp.gp_Vec2d_XY(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        For this vector, returns its y coordinate.

        """
        return _gp.gp_Vec2d_Y(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_Vec2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d___mul__(self, *args)

    def __imul_wrapper__(self, other):
        return _gp.gp_Vec2d___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_Vec2d

        Return
        -------
        gp_Vec2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d___add__(self, *args)

    def __iadd_wrapper__(self, other):
        return _gp.gp_Vec2d___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __neg__(self, *args):
        r"""
        Return
        -------
        gp_Vec2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d___neg__(self, *args)

    def __sub__(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_Vec2d

        Return
        -------
        gp_Vec2d

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_Vec2d___sub__(self, *args)

    def __isub_wrapper__(self, other):
        return _gp.gp_Vec2d___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_Vec2d___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other):
        return _gp.gp_Vec2d___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_Vec2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_Vec2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Vec2d

# Register gp_Vec2d in _gp:
_gp.gp_Vec2d_swigregister(gp_Vec2d)
class gp_XY(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates xy object with zero coordinates (0,0).

        Parameters
        ----------
        theX: float
        theY: float

        Return
        -------
        None

        Description
        -----------
        A number pair defined by the xy coordinates.

        """
        _gp.gp_XY_swiginit(self, _gp.new_gp_XY(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        None

        Description
        -----------
        Computes the sum of this number pair and number pair theother @code <self>.x() = <self>.x() + theother.x() <self>.y() = <self>.y() + theother.y() @endcode.

        """
        return _gp.gp_XY_Add(self, *args)

    def Added(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        gp_XY

        Description
        -----------
        Computes the sum of this number pair and number pair theother @code new.x() = <self>.x() + theother.x() new.y() = <self>.y() + theother.y() @endcode.

        """
        return _gp.gp_XY_Added(self, *args)

    def GetChangeCoord(self, theIndex):
        r"""GetChangeCoord(gp_XY self, Standard_Integer const theIndex) -> Standard_Real"""
        return _gp.gp_XY_GetChangeCoord(self, theIndex)

    def SetChangeCoord(self, theIndex, value):
        r"""SetChangeCoord(gp_XY self, Standard_Integer const theIndex, Standard_Real value)"""
        return _gp.gp_XY_SetChangeCoord(self, theIndex, value)

    def Coord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the coordinate of range theindex: theindex = 1 => x is returned theindex = 2 => y is returned raises outofrange if theindex != {1, 2}.

        Parameters
        ----------

        Return
        -------
        theX: float
        theY: float

        Description
        -----------
        For this number pair, returns its coordinates x and y.

        """
        return _gp.gp_XY_Coord(self, *args)

    def CrossMagnitude(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_XY

        Return
        -------
        float

        Description
        -----------
        Computes the magnitude of the cross product between <self> and theright. returns || <self> ^ theright ||.

        """
        return _gp.gp_XY_CrossMagnitude(self, *args)

    def CrossSquareMagnitude(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_XY

        Return
        -------
        float

        Description
        -----------
        Computes the square magnitude of the cross product between <self> and theright. returns || <self> ^ theright ||**2.

        """
        return _gp.gp_XY_CrossSquareMagnitude(self, *args)

    def Crossed(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        float

        Description
        -----------
        @code double d = <self>.x() * theother.y() - <self>.y() * theother.x() @endcode.

        """
        return _gp.gp_XY_Crossed(self, *args)

    def Divide(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        Divides <self> by a real.

        """
        return _gp.gp_XY_Divide(self, *args)

    def Divided(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_XY

        Description
        -----------
        Divides <self> by a real.

        """
        return _gp.gp_XY_Divided(self, *args)

    def Dot(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        float

        Description
        -----------
        Computes the scalar product between <self> and theother.

        """
        return _gp.gp_XY_Dot(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY
        theTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the coordinates of this number pair are equal to the respective coordinates of the number pair theother, within the specified tolerance thetolerance. i.e.: abs(<self>.x() - theother.x()) <= thetolerance and abs(<self>.y() - theother.y()) <= thetolerance and computations.

        """
        return _gp.gp_XY_IsEqual(self, *args)

    def Modulus(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes sqrt (x*x + y*y) where x and y are the two coordinates of this number pair.

        """
        return _gp.gp_XY_Modulus(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_XY

        Description
        -----------
        @code new.x() = <self>.x() * thescalar; new.y() = <self>.y() * thescalar; @endcode.

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        gp_XY

        Description
        -----------
        @code new.x() = <self>.x() * theother.x(); new.y() = <self>.y() * theother.y(); @endcode.

        Parameters
        ----------
        theMatrix: gp_Mat2d

        Return
        -------
        gp_XY

        Description
        -----------
        New = thematrix * <self>.

        """
        return _gp.gp_XY_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x() * thescalar; <self>.y() = <self>.y() * thescalar; @endcode.

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x() * theother.x(); <self>.y() = <self>.y() * theother.y(); @endcode.

        Parameters
        ----------
        theMatrix: gp_Mat2d

        Return
        -------
        None

        Description
        -----------
        <self> = thematrix * <self>.

        """
        return _gp.gp_XY_Multiply(self, *args)

    def Normalize(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x()/ <self>.modulus() <self>.y() = <self>.y()/ <self>.modulus() @endcode raises constructionerror if <self>.modulus() <= resolution from gp.

        """
        return _gp.gp_XY_Normalize(self, *args)

    def Normalized(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        @code new.x() = <self>.x()/ <self>.modulus() new.y() = <self>.y()/ <self>.modulus() @endcode raises constructionerror if <self>.modulus() <= resolution from gp.

        """
        return _gp.gp_XY_Normalized(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = -<self>.x() <self>.y() = -<self>.y().

        """
        return _gp.gp_XY_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        @code new.x() = -<self>.x() new.y() = -<self>.y() @endcode.

        """
        return _gp.gp_XY_Reversed(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theXi: float

        Return
        -------
        None

        Description
        -----------
        Modifies the coordinate of range theindex theindex = 1 => x is modified theindex = 2 => y is modified raises outofrange if theindex != {1, 2}.

        Parameters
        ----------
        theX: float
        theY: float

        Return
        -------
        None

        Description
        -----------
        For this number pair, assigns the values thex and they to its coordinates.

        """
        return _gp.gp_XY_SetCoord(self, *args)

    def SetLinearForm(self, *args):
        r"""

        Parameters
        ----------
        theA1: float
        theXY1: gp_XY
        theA2: float
        theXY2: gp_XY

        Return
        -------
        None

        Description
        -----------
        Computes the following linear combination and assigns the result to this number pair: @code thea1 * thexy1 + thea2 * thexy2 @endcode.

        Parameters
        ----------
        theA1: float
        theXY1: gp_XY
        theA2: float
        theXY2: gp_XY
        theXY3: gp_XY

        Return
        -------
        None

        Description
        -----------
        -- computes the following linear combination and assigns the result to this number pair: @code thea1 * thexy1 + thea2 * thexy2 + thexy3 @endcode.

        Parameters
        ----------
        theA1: float
        theXY1: gp_XY
        theXY2: gp_XY

        Return
        -------
        None

        Description
        -----------
        Computes the following linear combination and assigns the result to this number pair: @code thea1 * thexy1 + thexy2 @endcode.

        Parameters
        ----------
        theXY1: gp_XY
        theXY2: gp_XY

        Return
        -------
        None

        Description
        -----------
        Computes the following linear combination and assigns the result to this number pair: @code thexy1 + thexy2 @endcode.

        """
        return _gp.gp_XY_SetLinearForm(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        theX: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate of this number pair.

        """
        return _gp.gp_XY_SetX(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        theY: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the y coordinate of this number pair.

        """
        return _gp.gp_XY_SetY(self, *args)

    def SquareModulus(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes x*x + y*y where x and y are the two coordinates of this number pair.

        """
        return _gp.gp_XY_SquareModulus(self, *args)

    def Subtract(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x() - theother.x() <self>.y() = <self>.y() - theother.y() @endcode.

        """
        return _gp.gp_XY_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        gp_XY

        Description
        -----------
        @code new.x() = <self>.x() - theother.x() new.y() = <self>.y() - theother.y() @endcode.

        """
        return _gp.gp_XY_Subtracted(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the x coordinate of this number pair.

        """
        return _gp.gp_XY_X(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the y coordinate of this number pair.

        """
        return _gp.gp_XY_Y(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_XY

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theMatrix: gp_Mat2d

        Return
        -------
        gp_XY

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_XY___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args):
        r"""
        __imul_wrapper__(gp_XY self, Standard_Real const other)
        __imul_wrapper__(gp_XY self, gp_XY other)
        __imul_wrapper__(gp_XY self, gp_Mat2d other)
        """
        return _gp.gp_XY___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        gp_XY

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_XY___add__(self, *args)

    def __iadd_wrapper__(self, other):
        r"""__iadd_wrapper__(gp_XY self, gp_XY other)"""
        return _gp.gp_XY___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __neg__(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_XY___neg__(self, *args)

    def __sub__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XY

        Return
        -------
        gp_XY

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_XY___sub__(self, *args)

    def __isub_wrapper__(self, other):
        r"""__isub_wrapper__(gp_XY self, gp_XY other)"""
        return _gp.gp_XY___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_XY___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other):
        r"""__itruediv_wrapper__(gp_XY self, Standard_Real const other)"""
        return _gp.gp_XY___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_XY()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_XY')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_XY

# Register gp_XY in _gp:
_gp.gp_XY_swigregister(gp_XY)
class gp_XYZ(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an xyz object with zero coordinates (0,0,0).

        Parameters
        ----------
        theX: float
        theY: float
        theZ: float

        Return
        -------
        None

        Description
        -----------
        Creates an xyz with given coordinates.

        """
        _gp.gp_XYZ_swiginit(self, _gp.new_gp_XYZ(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x() + theother.x() <self>.y() = <self>.y() + theother.y() <self>.z() = <self>.z() + theother.z() @endcode.

        """
        return _gp.gp_XYZ_Add(self, *args)

    def Added(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        gp_XYZ

        Description
        -----------
        @code new.x() = <self>.x() + theother.x() new.y() = <self>.y() + theother.y() new.z() = <self>.z() + theother.z() @endcode.

        """
        return _gp.gp_XYZ_Added(self, *args)

    def GetChangeCoord(self, theIndex):
        r"""GetChangeCoord(gp_XYZ self, Standard_Integer const theIndex) -> Standard_Real"""
        return _gp.gp_XYZ_GetChangeCoord(self, theIndex)

    def SetChangeCoord(self, theIndex, value):
        r"""SetChangeCoord(gp_XYZ self, Standard_Integer const theIndex, Standard_Real value)"""
        return _gp.gp_XYZ_SetChangeCoord(self, theIndex, value)

    def ChangeData(self, *args):
        r"""
        Return
        -------
        float *

        Description
        -----------
        Returns a ptr to coordinates location. is useful for algorithms, but does not perform any checks!.

        """
        return _gp.gp_XYZ_ChangeData(self, *args)

    def Coord(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the coordinate of range theindex: theindex = 1 => x is returned theindex = 2 => y is returned theindex = 3 => z is returned //! raises outofrange if theindex != {1, 2, 3}.

        Parameters
        ----------

        Return
        -------
        theX: float
        theY: float
        theZ: float

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_XYZ_Coord(self, *args)

    def Cross(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.y() * theother.z() - <self>.z() * theother.y() <self>.y() = <self>.z() * theother.x() - <self>.x() * theother.z() <self>.z() = <self>.x() * theother.y() - <self>.y() * theother.x() @endcode.

        """
        return _gp.gp_XYZ_Cross(self, *args)

    def CrossCross(self, *args):
        r"""

        Parameters
        ----------
        theCoord1: gp_XYZ
        theCoord2: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Triple vector product computes <self> = <self>.cross(thecoord1.cross(thecoord2)).

        """
        return _gp.gp_XYZ_CrossCross(self, *args)

    def CrossCrossed(self, *args):
        r"""

        Parameters
        ----------
        theCoord1: gp_XYZ
        theCoord2: gp_XYZ

        Return
        -------
        gp_XYZ

        Description
        -----------
        Triple vector product computes new = <self>.cross(thecoord1.cross(thecoord2)).

        """
        return _gp.gp_XYZ_CrossCrossed(self, *args)

    def CrossMagnitude(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_XYZ

        Return
        -------
        float

        Description
        -----------
        Computes the magnitude of the cross product between <self> and theright. returns || <self> ^ theright ||.

        """
        return _gp.gp_XYZ_CrossMagnitude(self, *args)

    def CrossSquareMagnitude(self, *args):
        r"""

        Parameters
        ----------
        theRight: gp_XYZ

        Return
        -------
        float

        Description
        -----------
        Computes the square magnitude of the cross product between <self> and theright. returns || <self> ^ theright ||**2.

        """
        return _gp.gp_XYZ_CrossSquareMagnitude(self, *args)

    def Crossed(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        gp_XYZ

        Description
        -----------
        @code new.x() = <self>.y() * theother.z() - <self>.z() * theother.y() new.y() = <self>.z() * theother.x() - <self>.x() * theother.z() new.z() = <self>.x() * theother.y() - <self>.y() * theother.x() @endcode.

        """
        return _gp.gp_XYZ_Crossed(self, *args)

    def Divide(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        Divides <self> by a real.

        """
        return _gp.gp_XYZ_Divide(self, *args)

    def Divided(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_XYZ

        Description
        -----------
        Divides <self> by a real.

        """
        return _gp.gp_XYZ_Divided(self, *args)

    def Dot(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        float

        Description
        -----------
        Computes the scalar product between <self> and theother.

        """
        return _gp.gp_XYZ_Dot(self, *args)

    def DotCross(self, *args):
        r"""

        Parameters
        ----------
        theCoord1: gp_XYZ
        theCoord2: gp_XYZ

        Return
        -------
        float

        Description
        -----------
        Computes the triple scalar product.

        """
        return _gp.gp_XYZ_DotCross(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _gp.gp_XYZ_DumpJsonToString(self, depth)

    def GetData(self, *args):
        r"""
        Return
        -------
        float *

        Description
        -----------
        Returns a const ptr to coordinates location. is useful for algorithms, but does not perform any checks!.

        """
        return _gp.gp_XYZ_GetData(self, *args)

    def InitFromJsonString(self, json_string):
        r"""InitFromJsonString(gp_XYZ self, std::string json_string) -> bool"""
        return _gp.gp_XYZ_InitFromJsonString(self, json_string)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ
        theTolerance: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if he coordinates of this xyz object are equal to the respective coordinates other, within the specified tolerance thetolerance. i.e.: abs(<self>.x() - theother.x()) <= thetolerance and abs(<self>.y() - theother.y()) <= thetolerance and abs(<self>.z() - theother.z()) <= thetolerance.

        """
        return _gp.gp_XYZ_IsEqual(self, *args)

    def Modulus(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes sqrt (x*x + y*y + z*z) where x, y and z are the three coordinates of this xyz object.

        """
        return _gp.gp_XYZ_Modulus(self, *args)

    def Multiplied(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_XYZ

        Description
        -----------
        @code new.x() = <self>.x() * thescalar; new.y() = <self>.y() * thescalar; new.z() = <self>.z() * thescalar; @endcode.

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        gp_XYZ

        Description
        -----------
        @code new.x() = <self>.x() * theother.x(); new.y() = <self>.y() * theother.y(); new.z() = <self>.z() * theother.z(); @endcode.

        Parameters
        ----------
        theMatrix: gp_Mat

        Return
        -------
        gp_XYZ

        Description
        -----------
        New = thematrix * <self>.

        """
        return _gp.gp_XYZ_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""

        Parameters
        ----------
        theScalar: float

        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x() * thescalar; <self>.y() = <self>.y() * thescalar; <self>.z() = <self>.z() * thescalar; @endcode.

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x() * theother.x(); <self>.y() = <self>.y() * theother.y(); <self>.z() = <self>.z() * theother.z(); @endcode.

        Parameters
        ----------
        theMatrix: gp_Mat

        Return
        -------
        None

        Description
        -----------
        <self> = thematrix * <self>.

        """
        return _gp.gp_XYZ_Multiply(self, *args)

    def Normalize(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x()/ <self>.modulus() <self>.y() = <self>.y()/ <self>.modulus() <self>.z() = <self>.z()/ <self>.modulus() @endcode raised if <self>.modulus() <= resolution from gp.

        """
        return _gp.gp_XYZ_Normalize(self, *args)

    def Normalized(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        @code new.x() = <self>.x()/ <self>.modulus() new.y() = <self>.y()/ <self>.modulus() new.z() = <self>.z()/ <self>.modulus() @endcode raised if <self>.modulus() <= resolution from gp.

        """
        return _gp.gp_XYZ_Normalized(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = -<self>.x() <self>.y() = -<self>.y() <self>.z() = -<self>.z() @endcode.

        """
        return _gp.gp_XYZ_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        @code new.x() = -<self>.x() new.y() = -<self>.y() new.z() = -<self>.z() @endcode.

        """
        return _gp.gp_XYZ_Reversed(self, *args)

    def SetCoord(self, *args):
        r"""

        Parameters
        ----------
        theX: float
        theY: float
        theZ: float

        Return
        -------
        None

        Description
        -----------
        For this xyz object, assigns the values thex, they and thez to its three coordinates.

        Parameters
        ----------
        theIndex: int
        theXi: float

        Return
        -------
        None

        Description
        -----------
        Modifies the coordinate of range theindex theindex = 1 => x is modified theindex = 2 => y is modified theindex = 3 => z is modified raises outofrange if theindex != {1, 2, 3}.

        """
        return _gp.gp_XYZ_SetCoord(self, *args)

    def SetLinearForm(self, *args):
        r"""

        Parameters
        ----------
        theA1: float
        theXYZ1: gp_XYZ
        theA2: float
        theXYZ2: gp_XYZ
        theA3: float
        theXYZ3: gp_XYZ
        theXYZ4: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: @code thea1 * thexyz1 + thea2 * thexyz2 + thea3 * thexyz3 + thexyz4 @endcode.

        Parameters
        ----------
        theA1: float
        theXYZ1: gp_XYZ
        theA2: float
        theXYZ2: gp_XYZ
        theA3: float
        theXYZ3: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: @code thea1 * thexyz1 + thea2 * thexyz2 + thea3 * thexyz3 @endcode.

        Parameters
        ----------
        theA1: float
        theXYZ1: gp_XYZ
        theA2: float
        theXYZ2: gp_XYZ
        theXYZ3: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: @code thea1 * thexyz1 + thea2 * thexyz2 + thexyz3 @endcode.

        Parameters
        ----------
        theA1: float
        theXYZ1: gp_XYZ
        theA2: float
        theXYZ2: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: @code thea1 * thexyz1 + thea2 * thexyz2 @endcode.

        Parameters
        ----------
        theA1: float
        theXYZ1: gp_XYZ
        theXYZ2: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: @code thea1 * thexyz1 + thexyz2 @endcode.

        Parameters
        ----------
        theXYZ1: gp_XYZ
        theXYZ2: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        <self> is set to the following linear form: @code thexyz1 + thexyz2 @endcode.

        """
        return _gp.gp_XYZ_SetLinearForm(self, *args)

    def SetX(self, *args):
        r"""

        Parameters
        ----------
        theX: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the x coordinate.

        """
        return _gp.gp_XYZ_SetX(self, *args)

    def SetY(self, *args):
        r"""

        Parameters
        ----------
        theY: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the y coordinate.

        """
        return _gp.gp_XYZ_SetY(self, *args)

    def SetZ(self, *args):
        r"""

        Parameters
        ----------
        theZ: float

        Return
        -------
        None

        Description
        -----------
        Assigns the given value to the z coordinate.

        """
        return _gp.gp_XYZ_SetZ(self, *args)

    def SquareModulus(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes x*x + y*y + z*z where x, y and z are the three coordinates of this xyz object.

        """
        return _gp.gp_XYZ_SquareModulus(self, *args)

    def Subtract(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        @code <self>.x() = <self>.x() - theother.x() <self>.y() = <self>.y() - theother.y() <self>.z() = <self>.z() - theother.z() @endcode.

        """
        return _gp.gp_XYZ_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        gp_XYZ

        Description
        -----------
        @code new.x() = <self>.x() - theother.x() new.y() = <self>.y() - theother.y() new.z() = <self>.z() - theother.z() @endcode.

        """
        return _gp.gp_XYZ_Subtracted(self, *args)

    def X(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the x coordinate.

        """
        return _gp.gp_XYZ_X(self, *args)

    def Y(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the y coordinate.

        """
        return _gp.gp_XYZ_Y(self, *args)

    def Z(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the z coordinate.

        """
        return _gp.gp_XYZ_Z(self, *args)

    def __mul__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theScalar: float

        Return
        -------
        gp_XYZ

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theMatrix: gp_Mat

        Return
        -------
        gp_XYZ

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_XYZ___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args):
        r"""
        __imul_wrapper__(gp_XYZ self, Standard_Real const other)
        __imul_wrapper__(gp_XYZ self, gp_XYZ other)
        __imul_wrapper__(gp_XYZ self, gp_Mat other)
        """
        return _gp.gp_XYZ___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        gp_XYZ

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_XYZ___add__(self, *args)

    def __iadd_wrapper__(self, other):
        r"""__iadd_wrapper__(gp_XYZ self, gp_XYZ other)"""
        return _gp.gp_XYZ___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args):
        r"""

        Parameters
        ----------
        theOther: gp_XYZ

        Return
        -------
        gp_XYZ

        Description
        -----------
        No available documentation.

        """
        return _gp.gp_XYZ___sub__(self, *args)

    def __isub_wrapper__(self, other):
        r"""__isub_wrapper__(gp_XYZ self, gp_XYZ other)"""
        return _gp.gp_XYZ___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_XYZ___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other):
        r"""__itruediv_wrapper__(gp_XYZ self, Standard_Real const other)"""
        return _gp.gp_XYZ___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = gp_XYZ()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of gp_XYZ')


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_XYZ

# Register gp_XYZ in _gp:
_gp.gp_XYZ_swigregister(gp_XYZ)



@deprecated
def gp_DX(*args):
	return gp.DX(*args)

@deprecated
def gp_DX2d(*args):
	return gp.DX2d(*args)

@deprecated
def gp_DY(*args):
	return gp.DY(*args)

@deprecated
def gp_DY2d(*args):
	return gp.DY2d(*args)

@deprecated
def gp_DZ(*args):
	return gp.DZ(*args)

@deprecated
def gp_OX(*args):
	return gp.OX(*args)

@deprecated
def gp_OX2d(*args):
	return gp.OX2d(*args)

@deprecated
def gp_OY(*args):
	return gp.OY(*args)

@deprecated
def gp_OY2d(*args):
	return gp.OY2d(*args)

@deprecated
def gp_OZ(*args):
	return gp.OZ(*args)

@deprecated
def gp_Origin(*args):
	return gp.Origin(*args)

@deprecated
def gp_Origin2d(*args):
	return gp.Origin2d(*args)

@deprecated
def gp_Resolution(*args):
	return gp.Resolution(*args)

@deprecated
def gp_XOY(*args):
	return gp.XOY(*args)

@deprecated
def gp_YOZ(*args):
	return gp.YOZ(*args)

@deprecated
def gp_ZOX(*args):
	return gp.ZOX(*args)

@deprecated
def gp_QuaternionNLerp_Interpolate(*args):
	return gp_QuaternionNLerp.Interpolate(*args)

@deprecated
def gp_QuaternionSLerp_Interpolate(*args):
	return gp_QuaternionSLerp.Interpolate(*args)



