/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.components;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;

public final class MessageComponent
extends JPanel {
    public MessageComponent(String message) {
        JLabel notSupportedLabel = new JLabel(message, 0);
        notSupportedLabel.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)notSupportedLabel, "Center");
    }

    public static JComponent notAvailable() {
        return new MessageComponent("Not available for this JFR snapshot.");
    }

    public static JComponent scrollable(String message) {
        MessageComponent cm = new MessageComponent(message);
        cm.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return new ScrollableContainer((JComponent)cm);
    }

    public static JComponent noData(String viewName, String[] eventTypes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String eventType : eventTypes) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(eventType);
        }
        return MessageComponent.scrollable("<html><b>No " + viewName + " data recorded.</b><br><br><br>To analyze the " + viewName + " data make sure the JFR snapshot contains events of the following type(s):<br><br><code>" + sb.toString() + "</code></html>");
    }
}

