
use builtin;
use str;

set edit:completion:arg-completer[jj] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'jj'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'jj'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand abandon 'Abandon a revision'
            cand backout 'Apply the reverse of a revision on top of another revision'
            cand bench 'Commands for benchmarking internal operations'
            cand branch 'Manage branches'
            cand cat 'Print contents of files in a revision'
            cand checkout 'Create a new, empty change and edit it in the working copy (DEPRECATED, use `jj new`)'
            cand chmod 'Sets or removes the executable bit for paths in the repo'
            cand commit 'Update the description and create a new change on top'
            cand config 'Manage config options'
            cand debug 'Low-level commands not intended for users'
            cand describe 'Update the change description or other metadata'
            cand diff 'Compare file contents between two revisions'
            cand diffedit 'Touch up the content changes in a revision with a diff editor'
            cand duplicate 'Create a new change with the same content as an existing one'
            cand edit 'Sets the specified revision as the working-copy revision'
            cand files 'List files in a revision'
            cand fix 'Update files with formatting fixes or other changes'
            cand git 'Commands for working with Git remotes and the underlying Git repo'
            cand init 'Create a new repo in the given directory'
            cand interdiff 'Compare the changes of two commits'
            cand log 'Show revision history'
            cand merge 'Merge work from multiple branches (DEPRECATED, use `jj new`)'
            cand move 'Move changes from one revision into another (DEPRECATED, use `jj squash`)'
            cand new 'Create a new, empty change and (by default) edit it in the working copy'
            cand next 'Move the working-copy commit to the child revision'
            cand obslog 'Show how a change has evolved over time'
            cand operation 'Commands for working with the operation log'
            cand parallelize 'Parallelize revisions by making them siblings'
            cand prev 'Change the working copy revision relative to the parent revision'
            cand rebase 'Move revisions to different parent(s)'
            cand resolve 'Resolve a conflicted file with an external merge tool'
            cand restore 'Restore paths from another revision'
            cand revert 'A dummy command that accepts any arguments'
            cand root 'Show the current workspace root directory'
            cand run 'Run a command across a set of revisions.'
            cand show 'Show commit description and changes in a revision'
            cand sparse 'Manage which paths from the working-copy commit are present in the working copy'
            cand split 'Split a revision in two'
            cand squash 'Move changes from a revision into another revision'
            cand status 'Show high-level repo status'
            cand tag 'Manage tags'
            cand util 'Infrequently used commands such as for generating shell completions'
            cand undo 'Undo an operation (shortcut for `jj op undo`)'
            cand unsquash 'Move changes from a revision''s parent into the revision'
            cand untrack 'Stop tracking specified paths in the working copy'
            cand version 'Display version information'
            cand workspace 'Commands for working with workspaces'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;abandon'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -s 'Do not print every abandoned commit on a separate line'
            cand --summary 'Do not print every abandoned commit on a separate line'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;backout'= {
            cand -r 'The revision to apply the reverse of'
            cand --revision 'The revision to apply the reverse of'
            cand -d 'The revision to apply the reverse changes on top of'
            cand --destination 'The revision to apply the reverse changes on top of'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand commonancestors 'Find the common ancestor(s) of a set of commits'
            cand isancestor 'Checks if the first commit is an ancestor of the second commit'
            cand resolveprefix 'Resolve a commit ID prefix'
            cand revset 'Walk the revisions in the revset'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;bench;commonancestors'= {
            cand -s 'Name of baseline to save results'
            cand --save-baseline 'Name of baseline to save results'
            cand -b 'Name of baseline to compare with'
            cand --baseline 'Name of baseline to compare with'
            cand --sample-size 'Sample size for the benchmarks, which must be at least 10'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench;isancestor'= {
            cand -s 'Name of baseline to save results'
            cand --save-baseline 'Name of baseline to save results'
            cand -b 'Name of baseline to compare with'
            cand --baseline 'Name of baseline to compare with'
            cand --sample-size 'Sample size for the benchmarks, which must be at least 10'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench;resolveprefix'= {
            cand -s 'Name of baseline to save results'
            cand --save-baseline 'Name of baseline to save results'
            cand -b 'Name of baseline to compare with'
            cand --baseline 'Name of baseline to compare with'
            cand --sample-size 'Sample size for the benchmarks, which must be at least 10'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench;revset'= {
            cand -f 'Read revsets from file'
            cand --file 'Read revsets from file'
            cand -s 'Name of baseline to save results'
            cand --save-baseline 'Name of baseline to save results'
            cand -b 'Name of baseline to compare with'
            cand --baseline 'Name of baseline to compare with'
            cand --sample-size 'Sample size for the benchmarks, which must be at least 10'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;bench;help'= {
            cand commonancestors 'Find the common ancestor(s) of a set of commits'
            cand isancestor 'Checks if the first commit is an ancestor of the second commit'
            cand resolveprefix 'Resolve a commit ID prefix'
            cand revset 'Walk the revisions in the revset'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;bench;help;commonancestors'= {
        }
        &'jj;bench;help;isancestor'= {
        }
        &'jj;bench;help;resolveprefix'= {
        }
        &'jj;bench;help;revset'= {
        }
        &'jj;bench;help;help'= {
        }
        &'jj;branch'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand create 'Create a new branch'
            cand delete 'Delete an existing branch and propagate the deletion to remotes on the next push'
            cand forget 'Forget everything about a branch, including its local and remote targets'
            cand list 'List branches and their targets'
            cand rename 'Rename `old` branch name to `new` branch name'
            cand set 'Update an existing branch to point to a certain commit'
            cand track 'Start tracking given remote branches'
            cand untrack 'Stop tracking given remote branches'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;branch;create'= {
            cand -r 'The branch''s target revision'
            cand --revision 'The branch''s target revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;branch;delete'= {
            cand --glob 'Deprecated. Please prefix the pattern with `glob:` instead'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;branch;forget'= {
            cand --glob 'Deprecated. Please prefix the pattern with `glob:` instead'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;branch;list'= {
            cand -r 'Show branches whose local targets are in the given revisions'
            cand --revisions 'Show branches whose local targets are in the given revisions'
            cand -T 'Render each branch using the given template'
            cand --template 'Render each branch using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -a 'Show all tracking and non-tracking remote branches including the ones whose targets are synchronized with the local branches'
            cand --all-remotes 'Show all tracking and non-tracking remote branches including the ones whose targets are synchronized with the local branches'
            cand -t 'Show remote tracked branches only. Omits local Git-tracking branches by default'
            cand --tracked 'Show remote tracked branches only. Omits local Git-tracking branches by default'
            cand -c 'Show conflicted branches only'
            cand --conflicted 'Show conflicted branches only'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;branch;rename'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;branch;set'= {
            cand -r 'The branch''s target revision'
            cand --revision 'The branch''s target revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -B 'Allow moving the branch backwards or sideways'
            cand --allow-backwards 'Allow moving the branch backwards or sideways'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;branch;track'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;branch;untrack'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;branch;help'= {
            cand create 'Create a new branch'
            cand delete 'Delete an existing branch and propagate the deletion to remotes on the next push'
            cand forget 'Forget everything about a branch, including its local and remote targets'
            cand list 'List branches and their targets'
            cand rename 'Rename `old` branch name to `new` branch name'
            cand set 'Update an existing branch to point to a certain commit'
            cand track 'Start tracking given remote branches'
            cand untrack 'Stop tracking given remote branches'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;branch;help;create'= {
        }
        &'jj;branch;help;delete'= {
        }
        &'jj;branch;help;forget'= {
        }
        &'jj;branch;help;list'= {
        }
        &'jj;branch;help;rename'= {
        }
        &'jj;branch;help;set'= {
        }
        &'jj;branch;help;track'= {
        }
        &'jj;branch;help;untrack'= {
        }
        &'jj;branch;help;help'= {
        }
        &'jj;cat'= {
            cand -r 'The revision to get the file contents from'
            cand --revision 'The revision to get the file contents from'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;checkout'= {
            cand -m 'The change description to use'
            cand --message 'The change description to use'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;chmod'= {
            cand -r 'The revision to update'
            cand --revision 'The revision to update'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;commit'= {
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -m 'The change description to use (don''t open editor)'
            cand --message 'The change description to use (don''t open editor)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -i 'Interactively choose which changes to include in the first commit'
            cand --interactive 'Interactively choose which changes to include in the first commit'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'List variables set in config file, along with their values'
            cand get 'Get the value of a given config option.'
            cand set 'Update config file to set the given option to a given value'
            cand edit 'Start an editor on a jj config file'
            cand path 'Print the path to the config file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;config;list'= {
            cand -T 'Render each variable using the given template'
            cand --template 'Render each variable using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --include-defaults 'Whether to explicitly include built-in default values in the list'
            cand --include-overridden 'Allow printing overridden values'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;get'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;set'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;edit'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;path'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --user 'Target the user-level config'
            cand --repo 'Target the repo-level config'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;config;help'= {
            cand list 'List variables set in config file, along with their values'
            cand get 'Get the value of a given config option.'
            cand set 'Update config file to set the given option to a given value'
            cand edit 'Start an editor on a jj config file'
            cand path 'Print the path to the config file'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;config;help;list'= {
        }
        &'jj;config;help;get'= {
        }
        &'jj;config;help;set'= {
        }
        &'jj;config;help;edit'= {
        }
        &'jj;config;help;path'= {
        }
        &'jj;config;help;help'= {
        }
        &'jj;debug'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand fileset 'Parse fileset expression'
            cand revset 'Evaluate revset to full commit IDs'
            cand workingcopy 'Show information about the working copy state'
            cand template 'Parse a template'
            cand index 'Show commit index stats'
            cand reindex 'Rebuild commit index'
            cand operation 'Show information about an operation and its view'
            cand tree 'List the recursive entries of a tree'
            cand watchman 'watchman'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;debug;fileset'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;revset'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;workingcopy'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;template'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;index'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;reindex'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;operation'= {
            cand --display 'display'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;tree'= {
            cand -r 'r'
            cand --revision 'revision'
            cand --id 'id'
            cand --dir 'dir'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand status 'Check whether `watchman` is enabled and whether it''s correctly installed'
            cand query-clock 'query-clock'
            cand query-changed-files 'query-changed-files'
            cand reset-clock 'reset-clock'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;debug;watchman;status'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman;query-clock'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman;query-changed-files'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman;reset-clock'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;debug;watchman;help'= {
            cand status 'Check whether `watchman` is enabled and whether it''s correctly installed'
            cand query-clock 'query-clock'
            cand query-changed-files 'query-changed-files'
            cand reset-clock 'reset-clock'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;debug;watchman;help;status'= {
        }
        &'jj;debug;watchman;help;query-clock'= {
        }
        &'jj;debug;watchman;help;query-changed-files'= {
        }
        &'jj;debug;watchman;help;reset-clock'= {
        }
        &'jj;debug;watchman;help;help'= {
        }
        &'jj;debug;help'= {
            cand fileset 'Parse fileset expression'
            cand revset 'Evaluate revset to full commit IDs'
            cand workingcopy 'Show information about the working copy state'
            cand template 'Parse a template'
            cand index 'Show commit index stats'
            cand reindex 'Rebuild commit index'
            cand operation 'Show information about an operation and its view'
            cand tree 'List the recursive entries of a tree'
            cand watchman 'watchman'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;debug;help;fileset'= {
        }
        &'jj;debug;help;revset'= {
        }
        &'jj;debug;help;workingcopy'= {
        }
        &'jj;debug;help;template'= {
        }
        &'jj;debug;help;index'= {
        }
        &'jj;debug;help;reindex'= {
        }
        &'jj;debug;help;operation'= {
        }
        &'jj;debug;help;tree'= {
        }
        &'jj;debug;help;watchman'= {
            cand status 'Check whether `watchman` is enabled and whether it''s correctly installed'
            cand query-clock 'query-clock'
            cand query-changed-files 'query-changed-files'
            cand reset-clock 'reset-clock'
        }
        &'jj;debug;help;watchman;status'= {
        }
        &'jj;debug;help;watchman;query-clock'= {
        }
        &'jj;debug;help;watchman;query-changed-files'= {
        }
        &'jj;debug;help;watchman;reset-clock'= {
        }
        &'jj;debug;help;help'= {
        }
        &'jj;describe'= {
            cand -m 'The change description to use (don''t open editor)'
            cand --message 'The change description to use (don''t open editor)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand --stdin 'Read the change description from stdin'
            cand --no-edit 'Don''t open an editor'
            cand --reset-author 'Reset the author to the configured user'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;diff'= {
            cand -r 'Show changes in this revision, compared to its parent(s)'
            cand --revision 'Show changes in this revision, compared to its parent(s)'
            cand --from 'Show changes from this revision'
            cand --to 'Show changes to this revision'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;diffedit'= {
            cand -r 'The revision to touch up. Defaults to @ if neither --to nor --from are specified'
            cand --revision 'The revision to touch up. Defaults to @ if neither --to nor --from are specified'
            cand --from 'Show changes from this revision. Defaults to @ if --to is specified'
            cand --to 'Edit changes in this revision. Defaults to @ if --from is specified'
            cand --tool 'Specify diff editor to be used'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;duplicate'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;edit'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;files'= {
            cand -r 'The revision to list files in'
            cand --revision 'The revision to list files in'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;fix'= {
            cand -s 'Fix files in the specified revision(s) and their descendants'
            cand --source 'Fix files in the specified revision(s) and their descendants'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand remote 'Manage Git remotes'
            cand init 'Create a new Git backed repo'
            cand fetch 'Fetch from a Git remote'
            cand clone 'Create a new repo backed by a clone of a Git repo'
            cand push 'Push to a Git remote'
            cand import 'Update repo with changes made in the underlying Git repo'
            cand export 'Update the underlying Git repo with changes made in the repo'
            cand submodule 'FOR INTERNAL USE ONLY Interact with git submodules'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;git;remote'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand add 'Add a Git remote'
            cand remove 'Remove a Git remote and forget its branches'
            cand rename 'Rename a Git remote'
            cand list 'List Git remotes'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;git;remote;add'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote;remove'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote;rename'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote;list'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;remote;help'= {
            cand add 'Add a Git remote'
            cand remove 'Remove a Git remote and forget its branches'
            cand rename 'Rename a Git remote'
            cand list 'List Git remotes'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;git;remote;help;add'= {
        }
        &'jj;git;remote;help;remove'= {
        }
        &'jj;git;remote;help;rename'= {
        }
        &'jj;git;remote;help;list'= {
        }
        &'jj;git;remote;help;help'= {
        }
        &'jj;git;init'= {
            cand --git-repo 'Specifies a path to an **existing** git repository to be used as the backing git repo for the newly created `jj` repo'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --colocate 'Specifies that the `jj` repo should also be a valid `git` repo, allowing the use of both `jj` and `git` commands in the same directory'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;fetch'= {
            cand -b 'Fetch only some of the branches'
            cand --branch 'Fetch only some of the branches'
            cand --remote 'The remote to fetch from (only named remotes are supported, can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --all-remotes 'Fetch from all remotes'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;clone'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --colocate 'Whether or not to colocate the Jujutsu repo with the git repo'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;push'= {
            cand --remote 'The remote to push to (only named remotes are supported)'
            cand -b 'Push only this branch, or branches matching a pattern (can be repeated)'
            cand --branch 'Push only this branch, or branches matching a pattern (can be repeated)'
            cand -r 'Push branches pointing to these commits (can be repeated)'
            cand --revisions 'Push branches pointing to these commits (can be repeated)'
            cand -c 'Push this commit by creating a branch based on its change ID (can be repeated)'
            cand --change 'Push this commit by creating a branch based on its change ID (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --all 'Push all branches (including deleted branches)'
            cand --tracked 'Push all tracked branches (including deleted branches)'
            cand --deleted 'Push all deleted branches'
            cand --allow-empty-description 'Allow pushing commits with empty descriptions'
            cand --dry-run 'Only display what will change on the remote'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;import'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;export'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;submodule'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand print-gitmodules 'Print the relevant contents from .gitmodules. For debugging purposes only'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;git;submodule;print-gitmodules'= {
            cand -r 'Read .gitmodules from the given revision'
            cand --revisions 'Read .gitmodules from the given revision'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;git;submodule;help'= {
            cand print-gitmodules 'Print the relevant contents from .gitmodules. For debugging purposes only'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;git;submodule;help;print-gitmodules'= {
        }
        &'jj;git;submodule;help;help'= {
        }
        &'jj;git;help'= {
            cand remote 'Manage Git remotes'
            cand init 'Create a new Git backed repo'
            cand fetch 'Fetch from a Git remote'
            cand clone 'Create a new repo backed by a clone of a Git repo'
            cand push 'Push to a Git remote'
            cand import 'Update repo with changes made in the underlying Git repo'
            cand export 'Update the underlying Git repo with changes made in the repo'
            cand submodule 'FOR INTERNAL USE ONLY Interact with git submodules'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;git;help;remote'= {
            cand add 'Add a Git remote'
            cand remove 'Remove a Git remote and forget its branches'
            cand rename 'Rename a Git remote'
            cand list 'List Git remotes'
        }
        &'jj;git;help;remote;add'= {
        }
        &'jj;git;help;remote;remove'= {
        }
        &'jj;git;help;remote;rename'= {
        }
        &'jj;git;help;remote;list'= {
        }
        &'jj;git;help;init'= {
        }
        &'jj;git;help;fetch'= {
        }
        &'jj;git;help;clone'= {
        }
        &'jj;git;help;push'= {
        }
        &'jj;git;help;import'= {
        }
        &'jj;git;help;export'= {
        }
        &'jj;git;help;submodule'= {
            cand print-gitmodules 'Print the relevant contents from .gitmodules. For debugging purposes only'
        }
        &'jj;git;help;submodule;print-gitmodules'= {
        }
        &'jj;git;help;help'= {
        }
        &'jj;init'= {
            cand --git-repo 'DEPRECATED: Use `jj git init` Path to a git repo the jj repo will be backed by'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --git 'DEPRECATED: Use `jj git init` Use the Git backend, creating a jj repo backed by a Git repo'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;interdiff'= {
            cand --from 'Show changes from this revision'
            cand --to 'Show changes to this revision'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;log'= {
            cand -r 'Which revisions to show. If no paths nor revisions are specified, this defaults to the `revsets.log` setting, or `@ | ancestors(immutable_heads().., 2) | trunk()` if it is not set'
            cand --revisions 'Which revisions to show. If no paths nor revisions are specified, this defaults to the `revsets.log` setting, or `@ | ancestors(immutable_heads().., 2) | trunk()` if it is not set'
            cand -l 'Limit number of revisions to show'
            cand --limit 'Limit number of revisions to show'
            cand -T 'Render each revision using the given template'
            cand --template 'Render each revision using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --reversed 'Show revisions in the opposite order (older revisions first)'
            cand --no-graph 'Don''t show the graph, show a flat list of revisions'
            cand -p 'Show patch'
            cand --patch 'Show patch'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;merge'= {
            cand -m 'The change description to use'
            cand --message 'The change description to use'
            cand -A 'Insert the new change after the given commit(s)'
            cand --insert-after 'Insert the new change after the given commit(s)'
            cand --after 'Insert the new change after the given commit(s)'
            cand -B 'Insert the new change before the given commit(s)'
            cand --insert-before 'Insert the new change before the given commit(s)'
            cand --before 'Insert the new change before the given commit(s)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand -L 'Deprecated. Please prefix the revset with `all:` instead'
            cand --allow-large-revsets 'Deprecated. Please prefix the revset with `all:` instead'
            cand --no-edit 'Do not edit the newly created change'
            cand --edit 'No-op flag to pair with --no-edit'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;move'= {
            cand -f 'Move part of this change into the destination'
            cand --from 'Move part of this change into the destination'
            cand -t 'Move part of the source into this change'
            cand --to 'Move part of the source into this change'
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -i 'Interactively choose which parts to move'
            cand --interactive 'Interactively choose which parts to move'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;new'= {
            cand -m 'The change description to use'
            cand --message 'The change description to use'
            cand -A 'Insert the new change after the given commit(s)'
            cand --insert-after 'Insert the new change after the given commit(s)'
            cand --after 'Insert the new change after the given commit(s)'
            cand -B 'Insert the new change before the given commit(s)'
            cand --insert-before 'Insert the new change before the given commit(s)'
            cand --before 'Insert the new change before the given commit(s)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand -L 'Deprecated. Please prefix the revset with `all:` instead'
            cand --allow-large-revsets 'Deprecated. Please prefix the revset with `all:` instead'
            cand --no-edit 'Do not edit the newly created change'
            cand --edit 'No-op flag to pair with --no-edit'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;next'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -e 'Instead of creating a new working-copy commit on top of the target commit (like `jj new`), edit the target commit directly (like `jj edit`)'
            cand --edit 'Instead of creating a new working-copy commit on top of the target commit (like `jj new`), edit the target commit directly (like `jj edit`)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;obslog'= {
            cand -r 'r'
            cand --revision 'revision'
            cand -l 'Limit number of revisions to show'
            cand --limit 'Limit number of revisions to show'
            cand -T 'Render each revision using the given template'
            cand --template 'Render each revision using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --no-graph 'Don''t show the graph, show a flat list of revisions'
            cand -p 'Show patch compared to the previous version of this change'
            cand --patch 'Show patch compared to the previous version of this change'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand abandon 'Abandon operation history'
            cand log 'Show the operation log'
            cand undo 'Create a new operation that undoes an earlier operation'
            cand restore 'Create a new operation that restores the repo to an earlier state'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;operation;abandon'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;log'= {
            cand -l 'Limit number of operations to show'
            cand --limit 'Limit number of operations to show'
            cand -T 'Render each operation using the given template'
            cand --template 'Render each operation using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --no-graph 'Don''t show the graph, show a flat list of operations'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;undo'= {
            cand --what 'What portions of the local state to restore (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;restore'= {
            cand --what 'What portions of the local state to restore (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;operation;help'= {
            cand abandon 'Abandon operation history'
            cand log 'Show the operation log'
            cand undo 'Create a new operation that undoes an earlier operation'
            cand restore 'Create a new operation that restores the repo to an earlier state'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;operation;help;abandon'= {
        }
        &'jj;operation;help;log'= {
        }
        &'jj;operation;help;undo'= {
        }
        &'jj;operation;help;restore'= {
        }
        &'jj;operation;help;help'= {
        }
        &'jj;parallelize'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;prev'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -e 'Edit the parent directly, instead of moving the working-copy commit'
            cand --edit 'Edit the parent directly, instead of moving the working-copy commit'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;rebase'= {
            cand -b 'Rebase the whole branch relative to destination''s ancestors (can be repeated)'
            cand --branch 'Rebase the whole branch relative to destination''s ancestors (can be repeated)'
            cand -s 'Rebase specified revision(s) together with their trees of descendants (can be repeated)'
            cand --source 'Rebase specified revision(s) together with their trees of descendants (can be repeated)'
            cand -r 'Rebase the given revisions, rebasing descendants onto this revision''s parent(s)'
            cand --revisions 'Rebase the given revisions, rebasing descendants onto this revision''s parent(s)'
            cand -d 'The revision(s) to rebase onto (can be repeated to create a merge commit)'
            cand --destination 'The revision(s) to rebase onto (can be repeated to create a merge commit)'
            cand -A 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand --insert-after 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand --after 'The revision(s) to insert after (can be repeated to create a merge commit)'
            cand -B 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand --insert-before 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand --before 'The revision(s) to insert before (can be repeated to create a merge commit)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --skip-empty 'If true, when rebasing would produce an empty commit, the commit is abandoned. It will not be abandoned if it was already empty before the rebase. Will never skip merge commits with multiple non-empty parents'
            cand -L 'Deprecated. Please prefix the revset with `all:` instead'
            cand --allow-large-revsets 'Deprecated. Please prefix the revset with `all:` instead'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;resolve'= {
            cand -r 'r'
            cand --revision 'revision'
            cand --tool 'Specify 3-way merge tool to be used'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -l 'Instead of resolving one conflict, list all the conflicts'
            cand --list 'Instead of resolving one conflict, list all the conflicts'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;restore'= {
            cand --from 'Revision to restore from (source)'
            cand --to 'Revision to restore into (destination)'
            cand -c 'Undo the changes in a revision as compared to the merge of its parents'
            cand --changes-in 'Undo the changes in a revision as compared to the merge of its parents'
            cand -r 'Prints an error. DO NOT USE'
            cand --revision 'Prints an error. DO NOT USE'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;revert'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;root'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;run'= {
            cand -r 'The revisions to change'
            cand --revisions 'The revisions to change'
            cand -j 'How many processes should run in parallel, uses by default all cores'
            cand --jobs 'How many processes should run in parallel, uses by default all cores'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -x 'A no-op option to match the interface of `git rebase -x`'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;show'= {
            cand -T 'Render a revision using the given template'
            cand --template 'Render a revision using the given template'
            cand --tool 'Generate diff by external command'
            cand --context 'Number of lines of context to show'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -r 'Ignored (but lets you pass `-r` for consistency with other commands)'
            cand -s 'For each path, show only whether it was modified, added, or deleted'
            cand --summary 'For each path, show only whether it was modified, added, or deleted'
            cand --stat 'Show a histogram of the changes'
            cand --types 'For each path, show only its type before and after'
            cand --git 'Show a Git-format diff'
            cand --color-words 'Show a word-level diff with changes indicated only by color'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'List the patterns that are currently present in the working copy'
            cand set 'Update the patterns that are present in the working copy'
            cand reset 'Reset the patterns to include all files in the working copy'
            cand edit 'Start an editor to update the patterns that are present in the working copy'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;sparse;list'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse;set'= {
            cand --add 'Patterns to add to the working copy'
            cand --remove 'Patterns to remove from the working copy'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --clear 'Include no files in the working copy (combine with --add)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse;reset'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse;edit'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;sparse;help'= {
            cand list 'List the patterns that are currently present in the working copy'
            cand set 'Update the patterns that are present in the working copy'
            cand reset 'Reset the patterns to include all files in the working copy'
            cand edit 'Start an editor to update the patterns that are present in the working copy'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;sparse;help;list'= {
        }
        &'jj;sparse;help;set'= {
        }
        &'jj;sparse;help;reset'= {
        }
        &'jj;sparse;help;edit'= {
        }
        &'jj;sparse;help;help'= {
        }
        &'jj;split'= {
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -r 'The revision to split'
            cand --revision 'The revision to split'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -i 'Interactively choose which parts to split. This is the default if no paths are provided'
            cand --interactive 'Interactively choose which parts to split. This is the default if no paths are provided'
            cand -s 'Split the revision into two siblings instead of a parent and child'
            cand --siblings 'Split the revision into two siblings instead of a parent and child'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;squash'= {
            cand -r 'Revision to squash into its parent (default: @)'
            cand --revision 'Revision to squash into its parent (default: @)'
            cand --from 'Revision(s) to squash from (default: @)'
            cand --into 'Revision to squash into (default: @)'
            cand --to 'Revision to squash into (default: @)'
            cand -m 'The description to use for squashed revision (don''t open editor)'
            cand --message 'The description to use for squashed revision (don''t open editor)'
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -u 'Use the description of the destination revision and discard the description(s) of the source revision(s)'
            cand --use-destination-message 'Use the description of the destination revision and discard the description(s) of the source revision(s)'
            cand -i 'Interactively choose which parts to squash'
            cand --interactive 'Interactively choose which parts to squash'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;status'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;tag'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'List tags'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;tag;list'= {
            cand -T 'Render each tag using the given template'
            cand --template 'Render each tag using the given template'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;tag;help'= {
            cand list 'List tags'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;tag;help;list'= {
        }
        &'jj;tag;help;help'= {
        }
        &'jj;util'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand completion 'Print a command-line-completion script'
            cand gc 'Run backend-dependent garbage collection'
            cand mangen 'Print a ROFF (manpage)'
            cand markdown-help 'Print the CLI help for all subcommands in Markdown'
            cand config-schema 'Print the JSON schema for the jj TOML config format'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;util;completion'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --bash 'Deprecated. Use the SHELL positional argument instead'
            cand --fish 'Deprecated. Use the SHELL positional argument instead'
            cand --zsh 'Deprecated. Use the SHELL positional argument instead'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;gc'= {
            cand --expire 'Time threshold'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;mangen'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;markdown-help'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;config-schema'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;util;help'= {
            cand completion 'Print a command-line-completion script'
            cand gc 'Run backend-dependent garbage collection'
            cand mangen 'Print a ROFF (manpage)'
            cand markdown-help 'Print the CLI help for all subcommands in Markdown'
            cand config-schema 'Print the JSON schema for the jj TOML config format'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;util;help;completion'= {
        }
        &'jj;util;help;gc'= {
        }
        &'jj;util;help;mangen'= {
        }
        &'jj;util;help;markdown-help'= {
        }
        &'jj;util;help;config-schema'= {
        }
        &'jj;util;help;help'= {
        }
        &'jj;undo'= {
            cand --what 'What portions of the local state to restore (can be repeated)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;unsquash'= {
            cand -r 'r'
            cand --revision 'revision'
            cand --tool 'Specify diff editor to be used (implies --interactive)'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand -i 'Interactively choose which parts to unsquash'
            cand --interactive 'Interactively choose which parts to unsquash'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;untrack'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;version'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand add 'Add a workspace'
            cand forget 'Stop tracking a workspace''s working-copy commit in the repo'
            cand list 'List workspaces'
            cand root 'Show the current workspace root directory'
            cand update-stale 'Update a workspace that has become stale'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;workspace;add'= {
            cand --name 'A name for the workspace'
            cand -r 'A list of parent revisions for the working-copy commit of the newly created workspace. You may specify nothing, or any number of parents'
            cand --revision 'A list of parent revisions for the working-copy commit of the newly created workspace. You may specify nothing, or any number of parents'
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;forget'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;list'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;root'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;update-stale'= {
            cand -R 'Path to repository to operate on'
            cand --repository 'Path to repository to operate on'
            cand --at-operation 'Operation to load the repo at'
            cand --at-op 'Operation to load the repo at'
            cand --color 'When to colorize output (always, never, debug, auto)'
            cand --config-toml 'Additional configuration options (can be repeated)'
            cand --ignore-working-copy 'Don''t snapshot the working copy, and don''t update it'
            cand --ignore-immutable 'Allow rewriting immutable commits'
            cand --debug 'Enable debug logging'
            cand --quiet 'Silence non-primary command output'
            cand --no-pager 'Disable the pager'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'jj;workspace;help'= {
            cand add 'Add a workspace'
            cand forget 'Stop tracking a workspace''s working-copy commit in the repo'
            cand list 'List workspaces'
            cand root 'Show the current workspace root directory'
            cand update-stale 'Update a workspace that has become stale'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;workspace;help;add'= {
        }
        &'jj;workspace;help;forget'= {
        }
        &'jj;workspace;help;list'= {
        }
        &'jj;workspace;help;root'= {
        }
        &'jj;workspace;help;update-stale'= {
        }
        &'jj;workspace;help;help'= {
        }
        &'jj;help'= {
            cand abandon 'Abandon a revision'
            cand backout 'Apply the reverse of a revision on top of another revision'
            cand bench 'Commands for benchmarking internal operations'
            cand branch 'Manage branches'
            cand cat 'Print contents of files in a revision'
            cand checkout 'Create a new, empty change and edit it in the working copy (DEPRECATED, use `jj new`)'
            cand chmod 'Sets or removes the executable bit for paths in the repo'
            cand commit 'Update the description and create a new change on top'
            cand config 'Manage config options'
            cand debug 'Low-level commands not intended for users'
            cand describe 'Update the change description or other metadata'
            cand diff 'Compare file contents between two revisions'
            cand diffedit 'Touch up the content changes in a revision with a diff editor'
            cand duplicate 'Create a new change with the same content as an existing one'
            cand edit 'Sets the specified revision as the working-copy revision'
            cand files 'List files in a revision'
            cand fix 'Update files with formatting fixes or other changes'
            cand git 'Commands for working with Git remotes and the underlying Git repo'
            cand init 'Create a new repo in the given directory'
            cand interdiff 'Compare the changes of two commits'
            cand log 'Show revision history'
            cand merge 'Merge work from multiple branches (DEPRECATED, use `jj new`)'
            cand move 'Move changes from one revision into another (DEPRECATED, use `jj squash`)'
            cand new 'Create a new, empty change and (by default) edit it in the working copy'
            cand next 'Move the working-copy commit to the child revision'
            cand obslog 'Show how a change has evolved over time'
            cand operation 'Commands for working with the operation log'
            cand parallelize 'Parallelize revisions by making them siblings'
            cand prev 'Change the working copy revision relative to the parent revision'
            cand rebase 'Move revisions to different parent(s)'
            cand resolve 'Resolve a conflicted file with an external merge tool'
            cand restore 'Restore paths from another revision'
            cand revert 'A dummy command that accepts any arguments'
            cand root 'Show the current workspace root directory'
            cand run 'Run a command across a set of revisions.'
            cand show 'Show commit description and changes in a revision'
            cand sparse 'Manage which paths from the working-copy commit are present in the working copy'
            cand split 'Split a revision in two'
            cand squash 'Move changes from a revision into another revision'
            cand status 'Show high-level repo status'
            cand tag 'Manage tags'
            cand util 'Infrequently used commands such as for generating shell completions'
            cand undo 'Undo an operation (shortcut for `jj op undo`)'
            cand unsquash 'Move changes from a revision''s parent into the revision'
            cand untrack 'Stop tracking specified paths in the working copy'
            cand version 'Display version information'
            cand workspace 'Commands for working with workspaces'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'jj;help;abandon'= {
        }
        &'jj;help;backout'= {
        }
        &'jj;help;bench'= {
            cand commonancestors 'Find the common ancestor(s) of a set of commits'
            cand isancestor 'Checks if the first commit is an ancestor of the second commit'
            cand resolveprefix 'Resolve a commit ID prefix'
            cand revset 'Walk the revisions in the revset'
        }
        &'jj;help;bench;commonancestors'= {
        }
        &'jj;help;bench;isancestor'= {
        }
        &'jj;help;bench;resolveprefix'= {
        }
        &'jj;help;bench;revset'= {
        }
        &'jj;help;branch'= {
            cand create 'Create a new branch'
            cand delete 'Delete an existing branch and propagate the deletion to remotes on the next push'
            cand forget 'Forget everything about a branch, including its local and remote targets'
            cand list 'List branches and their targets'
            cand rename 'Rename `old` branch name to `new` branch name'
            cand set 'Update an existing branch to point to a certain commit'
            cand track 'Start tracking given remote branches'
            cand untrack 'Stop tracking given remote branches'
        }
        &'jj;help;branch;create'= {
        }
        &'jj;help;branch;delete'= {
        }
        &'jj;help;branch;forget'= {
        }
        &'jj;help;branch;list'= {
        }
        &'jj;help;branch;rename'= {
        }
        &'jj;help;branch;set'= {
        }
        &'jj;help;branch;track'= {
        }
        &'jj;help;branch;untrack'= {
        }
        &'jj;help;cat'= {
        }
        &'jj;help;checkout'= {
        }
        &'jj;help;chmod'= {
        }
        &'jj;help;commit'= {
        }
        &'jj;help;config'= {
            cand list 'List variables set in config file, along with their values'
            cand get 'Get the value of a given config option.'
            cand set 'Update config file to set the given option to a given value'
            cand edit 'Start an editor on a jj config file'
            cand path 'Print the path to the config file'
        }
        &'jj;help;config;list'= {
        }
        &'jj;help;config;get'= {
        }
        &'jj;help;config;set'= {
        }
        &'jj;help;config;edit'= {
        }
        &'jj;help;config;path'= {
        }
        &'jj;help;debug'= {
            cand fileset 'Parse fileset expression'
            cand revset 'Evaluate revset to full commit IDs'
            cand workingcopy 'Show information about the working copy state'
            cand template 'Parse a template'
            cand index 'Show commit index stats'
            cand reindex 'Rebuild commit index'
            cand operation 'Show information about an operation and its view'
            cand tree 'List the recursive entries of a tree'
            cand watchman 'watchman'
        }
        &'jj;help;debug;fileset'= {
        }
        &'jj;help;debug;revset'= {
        }
        &'jj;help;debug;workingcopy'= {
        }
        &'jj;help;debug;template'= {
        }
        &'jj;help;debug;index'= {
        }
        &'jj;help;debug;reindex'= {
        }
        &'jj;help;debug;operation'= {
        }
        &'jj;help;debug;tree'= {
        }
        &'jj;help;debug;watchman'= {
            cand status 'Check whether `watchman` is enabled and whether it''s correctly installed'
            cand query-clock 'query-clock'
            cand query-changed-files 'query-changed-files'
            cand reset-clock 'reset-clock'
        }
        &'jj;help;debug;watchman;status'= {
        }
        &'jj;help;debug;watchman;query-clock'= {
        }
        &'jj;help;debug;watchman;query-changed-files'= {
        }
        &'jj;help;debug;watchman;reset-clock'= {
        }
        &'jj;help;describe'= {
        }
        &'jj;help;diff'= {
        }
        &'jj;help;diffedit'= {
        }
        &'jj;help;duplicate'= {
        }
        &'jj;help;edit'= {
        }
        &'jj;help;files'= {
        }
        &'jj;help;fix'= {
        }
        &'jj;help;git'= {
            cand remote 'Manage Git remotes'
            cand init 'Create a new Git backed repo'
            cand fetch 'Fetch from a Git remote'
            cand clone 'Create a new repo backed by a clone of a Git repo'
            cand push 'Push to a Git remote'
            cand import 'Update repo with changes made in the underlying Git repo'
            cand export 'Update the underlying Git repo with changes made in the repo'
            cand submodule 'FOR INTERNAL USE ONLY Interact with git submodules'
        }
        &'jj;help;git;remote'= {
            cand add 'Add a Git remote'
            cand remove 'Remove a Git remote and forget its branches'
            cand rename 'Rename a Git remote'
            cand list 'List Git remotes'
        }
        &'jj;help;git;remote;add'= {
        }
        &'jj;help;git;remote;remove'= {
        }
        &'jj;help;git;remote;rename'= {
        }
        &'jj;help;git;remote;list'= {
        }
        &'jj;help;git;init'= {
        }
        &'jj;help;git;fetch'= {
        }
        &'jj;help;git;clone'= {
        }
        &'jj;help;git;push'= {
        }
        &'jj;help;git;import'= {
        }
        &'jj;help;git;export'= {
        }
        &'jj;help;git;submodule'= {
            cand print-gitmodules 'Print the relevant contents from .gitmodules. For debugging purposes only'
        }
        &'jj;help;git;submodule;print-gitmodules'= {
        }
        &'jj;help;init'= {
        }
        &'jj;help;interdiff'= {
        }
        &'jj;help;log'= {
        }
        &'jj;help;merge'= {
        }
        &'jj;help;move'= {
        }
        &'jj;help;new'= {
        }
        &'jj;help;next'= {
        }
        &'jj;help;obslog'= {
        }
        &'jj;help;operation'= {
            cand abandon 'Abandon operation history'
            cand log 'Show the operation log'
            cand undo 'Create a new operation that undoes an earlier operation'
            cand restore 'Create a new operation that restores the repo to an earlier state'
        }
        &'jj;help;operation;abandon'= {
        }
        &'jj;help;operation;log'= {
        }
        &'jj;help;operation;undo'= {
        }
        &'jj;help;operation;restore'= {
        }
        &'jj;help;parallelize'= {
        }
        &'jj;help;prev'= {
        }
        &'jj;help;rebase'= {
        }
        &'jj;help;resolve'= {
        }
        &'jj;help;restore'= {
        }
        &'jj;help;revert'= {
        }
        &'jj;help;root'= {
        }
        &'jj;help;run'= {
        }
        &'jj;help;show'= {
        }
        &'jj;help;sparse'= {
            cand list 'List the patterns that are currently present in the working copy'
            cand set 'Update the patterns that are present in the working copy'
            cand reset 'Reset the patterns to include all files in the working copy'
            cand edit 'Start an editor to update the patterns that are present in the working copy'
        }
        &'jj;help;sparse;list'= {
        }
        &'jj;help;sparse;set'= {
        }
        &'jj;help;sparse;reset'= {
        }
        &'jj;help;sparse;edit'= {
        }
        &'jj;help;split'= {
        }
        &'jj;help;squash'= {
        }
        &'jj;help;status'= {
        }
        &'jj;help;tag'= {
            cand list 'List tags'
        }
        &'jj;help;tag;list'= {
        }
        &'jj;help;util'= {
            cand completion 'Print a command-line-completion script'
            cand gc 'Run backend-dependent garbage collection'
            cand mangen 'Print a ROFF (manpage)'
            cand markdown-help 'Print the CLI help for all subcommands in Markdown'
            cand config-schema 'Print the JSON schema for the jj TOML config format'
        }
        &'jj;help;util;completion'= {
        }
        &'jj;help;util;gc'= {
        }
        &'jj;help;util;mangen'= {
        }
        &'jj;help;util;markdown-help'= {
        }
        &'jj;help;util;config-schema'= {
        }
        &'jj;help;undo'= {
        }
        &'jj;help;unsquash'= {
        }
        &'jj;help;untrack'= {
        }
        &'jj;help;version'= {
        }
        &'jj;help;workspace'= {
            cand add 'Add a workspace'
            cand forget 'Stop tracking a workspace''s working-copy commit in the repo'
            cand list 'List workspaces'
            cand root 'Show the current workspace root directory'
            cand update-stale 'Update a workspace that has become stale'
        }
        &'jj;help;workspace;add'= {
        }
        &'jj;help;workspace;forget'= {
        }
        &'jj;help;workspace;list'= {
        }
        &'jj;help;workspace;root'= {
        }
        &'jj;help;workspace;update-stale'= {
        }
        &'jj;help;help'= {
        }
    ]
    $completions[$command]
}
