"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const exposes = __importStar(require("../lib/exposes"));
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const legacy = __importStar(require("../lib/legacy"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const reporting = __importStar(require("../lib/reporting"));
const e = exposes.presets;
const ea = exposes.access;
const definitions = [
    {
        zigbeeModel: ['Thermostat'],
        model: '1TST-EU',
        vendor: 'eCozy',
        description: 'Smart heating thermostat',
        fromZigbee: [fromZigbee_1.default.battery, legacy.fz.thermostat_att_report],
        toZigbee: [toZigbee_1.default.thermostat_local_temperature, toZigbee_1.default.thermostat_local_temperature_calibration, toZigbee_1.default.thermostat_occupancy,
            toZigbee_1.default.thermostat_occupied_heating_setpoint, toZigbee_1.default.thermostat_unoccupied_heating_setpoint, toZigbee_1.default.thermostat_setpoint_raise_lower,
            toZigbee_1.default.thermostat_remote_sensing, toZigbee_1.default.thermostat_control_sequence_of_operation, toZigbee_1.default.thermostat_system_mode,
            toZigbee_1.default.thermostat_weekly_schedule, toZigbee_1.default.thermostat_clear_weekly_schedule, toZigbee_1.default.thermostat_relay_status_log,
            toZigbee_1.default.thermostat_pi_heating_demand, toZigbee_1.default.thermostat_running_state],
        exposes: [e.battery(), e.climate().withSetpoint('occupied_heating_setpoint', 7, 30, 1).withLocalTemperature()
                .withSystemMode(['off', 'auto', 'heat']).withRunningState(['idle', 'heat'])
                .withLocalTemperatureCalibration()
                .withPiHeatingDemand(ea.STATE_GET)],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(3);
            const binds = ['genBasic', 'genPowerCfg', 'genIdentify', 'genTime', 'genPollCtrl', 'hvacThermostat', 'hvacUserInterfaceCfg'];
            await reporting.bind(endpoint, coordinatorEndpoint, binds);
            await reporting.thermostatTemperature(endpoint);
        },
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=ecozy.js.map