/// <reference types="node" />
import Buffalo from '../../buffalo/buffalo';
import { ActiveEndpointsResponse, BindingTableResponse, EndDeviceAnnounce, IEEEAddressResponse, LQITableResponse, MatchDescriptorsResponse, NetworkAddressResponse, NodeDescriptorResponse, ParentAnnounceResponse, PowerDescriptorResponse, RoutingTableResponse, SimpleDescriptorResponse, SystemServerDiscoveryResponse, NwkUpdateResponse, NwkEnhancedUpdateResponse, NwkIEEEJoiningListResponse, NwkUnsolicitedEnhancedUpdateResponse, NwkBeaconSurveyResponse, StartKeyNegotiationResponse, RetrieveAuthenticationTokenResponse, GetAuthenticationLevelResponse, SetConfigurationResponse, GetConfigurationResponse, ChallengeResponse, APSFrameCounterChallengeTLV, AuthenticationTokenIdTLV, Curve25519PublicPointTLV, FragmentationParametersGlobalTLV, SelectedKeyNegotiationMethodTLV, ClearAllBindingsReqEUI64TLV, TargetIEEEAddressTLV, NextPanIdChangeGlobalTLV, NextChannelChangeGlobalTLV, ConfigurationParametersGlobalTLV, DeviceEUI64ListTLV, BeaconSurveyConfigurationTLV, TLV, LocalTLVReader, ServerMask } from './definition/tstypes';
import { LeaveRequestFlags } from './definition/enums';
import { ClusterId as ZdoClusterId } from './definition/clusters';
import { ClusterId, EUI64, NodeId, ProfileId } from '../tstypes';
export declare class BuffaloZdo extends Buffalo {
    /**
     * Set the position of the internal position tracker.
     * TODO: move to base `Buffalo` class
     * @param position
     */
    setPosition(position: number): void;
    /**
     * Set the byte at given position without affecting the internal position tracker.
     * TODO: move to base `Buffalo` class
     * @param position
     * @param value
     */
    setByte(position: number, value: number): void;
    /**
     * Get the byte at given position without affecting the internal position tracker.
     * TODO: move to base `Buffalo` class
     * @param position
     * @returns
     */
    getByte(position: number): number;
    /**
     * Check if internal buffer has enough bytes to satisfy: (current position + given count).
     * TODO: move to base `Buffalo` class
     * @param count
     * @returns True if has given more bytes
     */
    isMoreBy(count: number): boolean;
    private writeManufacturerSpecificGlobalTLV;
    private readManufacturerSpecificGlobalTLV;
    private writeSupportedKeyNegotiationMethodsGlobalTLV;
    private readSupportedKeyNegotiationMethodsGlobalTLV;
    private writePanIdConflictReportGlobalTLV;
    private readPanIdConflictReportGlobalTLV;
    private writeNextPanIdChangeGlobalTLV;
    private readNextPanIdChangeGlobalTLV;
    private writeNextChannelChangeGlobalTLV;
    private readNextChannelChangeGlobalTLV;
    private writeSymmetricPassphraseGlobalTLV;
    private readSymmetricPassphraseGlobalTLV;
    private writeRouterInformationGlobalTLV;
    private readRouterInformationGlobalTLV;
    private writeFragmentationParametersGlobalTLV;
    private readFragmentationParametersGlobalTLV;
    private writeJoinerEncapsulationGlobalTLV;
    private readJoinerEncapsulationGlobalTLV;
    private writeBeaconAppendixEncapsulationGlobalTLV;
    private readBeaconAppendixEncapsulationGlobalTLV;
    private writeConfigurationParametersGlobalTLV;
    private readConfigurationParametersGlobalTLV;
    private writeDeviceCapabilityExtensionGlobalTLV;
    private readDeviceCapabilityExtensionGlobalTLV;
    writeGlobalTLV(tlv: TLV): void;
    readGlobalTLV(tagId: number, length: number): TLV['tlv'];
    writeGlobalTLVs(tlvs: TLV[]): void;
    private readCurve25519PublicPointTLV;
    private readAPSFrameCounterResponseTLV;
    private readBeaconSurveyResultsTLV;
    private readPotentialParentsTLV;
    private readDeviceAuthenticationLevelTLV;
    private readProcessingStatusTLV;
    /**
     * ANNEX I ZIGBEE TLV DEFINITIONS AND FORMAT
     *
     * Unknown tags => TLV ignored
     * Duplicate tags => reject message except for MANUFACTURER_SPECIFIC_GLOBAL_TLV
     * Malformed TLVs => reject message
     *
     * @param localTLVReaders Mapping of tagID to local TLV reader function
     * @param encapsulated Default false. If true, this is reading inside an encapsuled TLV (excludes further encapsulation)
     * @returns
     */
    readTLVs(localTLVReaders?: Map<number, LocalTLVReader>, encapsulated?: boolean): TLV[];
    /**
     * @see ClusterId.NETWORK_ADDRESS_REQUEST
     * @param target IEEE address for the request
     * @param reportKids True to request that the target list their children in the response. [request type = 0x01]
     * @param childStartIndex The index of the first child to list in the response. Ignored if reportKids is false.
     */
    static buildNetworkAddressRequest(target: EUI64, reportKids: boolean, childStartIndex: number): Buffer;
    /**
     * @see ClusterId.IEEE_ADDRESS_REQUEST
     * Can be sent to target, or to another node that will send to target.
     * @param target NWK address for the request
     * @param reportKids True to request that the target list their children in the response. [request type = 0x01]
     * @param childStartIndex The index of the first child to list in the response. Ignored if reportKids is false.
     */
    static buildIeeeAddressRequest(target: NodeId, reportKids: boolean, childStartIndex: number): Buffer;
    /**
     * @see ClusterId.NODE_DESCRIPTOR_REQUEST
     * @param target NWK address for the request
     */
    static buildNodeDescriptorRequest(target: NodeId, fragmentationParameters?: FragmentationParametersGlobalTLV): Buffer;
    /**
     * @see ClusterId.POWER_DESCRIPTOR_REQUEST
     * @param target NWK address for the request
     */
    static buildPowerDescriptorRequest(target: NodeId): Buffer;
    /**
     * @see ClusterId.SIMPLE_DESCRIPTOR_REQUEST
     * @param target NWK address for the request
     * @param targetEndpoint The endpoint on the destination
     */
    static buildSimpleDescriptorRequest(target: NodeId, targetEndpoint: number): Buffer;
    /**
     * @see ClusterId.ACTIVE_ENDPOINTS_REQUEST
     * @param target NWK address for the request
     */
    static buildActiveEndpointsRequest(target: NodeId): Buffer;
    /**
     * @see ClusterId.MATCH_DESCRIPTORS_REQUEST
     * @param target NWK address for the request
     * @param profileId Profile ID to be matched at the destination
     * @param inClusterList List of Input ClusterIDs to be used for matching
     * @param outClusterList List of Output ClusterIDs to be used for matching
     */
    static buildMatchDescriptorRequest(target: NodeId, profileId: ProfileId, inClusterList: ClusterId[], outClusterList: ClusterId[]): Buffer;
    /**
     * @see ClusterId.SYSTEM_SERVER_DISCOVERY_REQUEST
     * @param serverMask See Table 2-34 for bit assignments.
     */
    static buildSystemServiceDiscoveryRequest(serverMask: ServerMask): Buffer;
    /**
     * @see ClusterId.PARENT_ANNOUNCE
     * @param children The IEEE addresses of the children bound to the parent.
     */
    static buildParentAnnounce(children: EUI64[]): Buffer;
    /**
     * @see ClusterId.BIND_REQUEST
     *
     * @param source The IEEE address for the source.
     * @param sourceEndpoint The source endpoint for the binding entry.
     * @param clusterId The identifier of the cluster on the source device that is bound to the destination.
     * @param type The addressing mode for the destination address used in this command, either ::UNICAST_BINDING, ::MULTICAST_BINDING.
     * @param destination The destination address for the binding entry. IEEE for ::UNICAST_BINDING.
     * @param groupAddress The destination address for the binding entry. Group ID for ::MULTICAST_BINDING.
     * @param destinationEndpoint The destination endpoint for the binding entry. Only if ::UNICAST_BINDING.
     */
    static buildBindRequest(source: EUI64, sourceEndpoint: number, clusterId: ClusterId, type: number, destination: EUI64, groupAddress: number, destinationEndpoint: number): Buffer;
    /**
     * @see ClusterId.UNBIND_REQUEST
     *
     * @param source The IEEE address for the source.
     * @param sourceEndpoint The source endpoint for the binding entry.
     * @param clusterId The identifier of the cluster on the source device that is bound to the destination.
     * @param type The addressing mode for the destination address used in this command, either ::UNICAST_BINDING, ::MULTICAST_BINDING.
     * @param destination The destination address for the binding entry. IEEE for ::UNICAST_BINDING.
     * @param groupAddress The destination address for the binding entry. Group ID for ::MULTICAST_BINDING.
     * @param destinationEndpoint The destination endpoint for the binding entry. Only if ::UNICAST_BINDING.
     */
    static buildUnbindRequest(source: EUI64, sourceEndpoint: number, clusterId: ClusterId, type: ClusterId, destination: EUI64, groupAddress: number, destinationEndpoint: number): Buffer;
    /**
     * @see ClusterId.CLEAR_ALL_BINDINGS_REQUEST
     */
    static buildClearAllBindingsRequest(tlv: ClearAllBindingsReqEUI64TLV): Buffer;
    /**
     * @see ClusterId.LQI_TABLE_REQUEST
     * @param startIndex Starting Index for the requested elements of the Neighbor Table.
     */
    static buildLqiTableRequest(startIndex: number): Buffer;
    /**
     * @see ClusterId.ROUTING_TABLE_REQUEST
     * @param startIndex Starting Index for the requested elements of the Neighbor Table.
     */
    static buildRoutingTableRequest(startIndex: number): Buffer;
    /**
     * @see ClusterId.BINDING_TABLE_REQUEST
     * @param startIndex Starting Index for the requested elements of the Neighbor Table.
     */
    static buildBindingTableRequest(startIndex: number): Buffer;
    /**
     * @see ClusterId.LEAVE_REQUEST
     * @param deviceAddress All zeros if the target is to remove itself from the network or
     *   the EUI64 of a child of the target device to remove that child.
     * @param leaveRequestFlags A bitmask of leave options. Include ::AND_REJOIN if the target is to rejoin the network immediately after leaving.
     */
    static buildLeaveRequest(deviceAddress: EUI64, leaveRequestFlags: LeaveRequestFlags): Buffer;
    /**
     * @see ClusterId.PERMIT_JOINING_REQUEST
     * @param duration A value of 0x00 disables joining. A value of 0xFF enables joining. Any other value enables joining for that number of seconds.
     * @param authentication Controls Trust Center authentication behavior.
     *   This field SHALL always have a value of 1, indicating a request to change the Trust Center policy.
     *   If a frame is received with a value of 0, it shall be treated as having a value of 1.
     */
    static buildPermitJoining(duration: number, authentication: number, tlvs: TLV[]): Buffer;
    /**
     * @see ClusterId.NWK_UPDATE_REQUEST
     * @param channels See Table 3-7 for details on the 32-bit field structure..
     * @param duration A value used to calculate the length of time to spend scanning each channel.
     *   The time spent scanning each channel is (aBaseSuperframeDuration * (2n + 1)) symbols, where n is the value of the duration parameter.
     *   If has a value of 0xfe this is a request for channel change.
     *   If has a value of 0xff this is a request to change the apsChannelMaskList and nwkManagerAddr attributes.
     * @param count This field represents the number of energy scans to be conducted and reported.
     *   This field SHALL be present only if the duration is within the range of 0x00 to 0x05.
     * @param nwkUpdateId The value of the nwkUpdateId contained in this request.
     *   This value is set by the Network Channel Manager prior to sending the message.
     *   This field SHALL only be present if the duration is 0xfe or 0xff.
     *   If the ScanDuration is 0xff, then the value in the nwkUpdateID SHALL be ignored.
     * @param nwkManagerAddr This field SHALL be present only if the duration is set to 0xff, and, where present,
     *   indicates the NWK address for the device with the Network Manager bit set in its Node Descriptor.
     */
    private static buildNwkUpdateRequest;
    /**
     * Shortcut for @see BuffaloZdo.buildNwkUpdateRequest
     */
    static buildScanChannelsRequest(scanChannels: number[], duration: number, count: number): Buffer;
    /**
     * Shortcut for @see BuffaloZdo.buildNwkUpdateRequest
     */
    static buildChannelChangeRequest(channel: number, nwkUpdateId: number | null): Buffer;
    /**
     * Shortcut for @see BuffaloZdo.buildNwkUpdateRequest
     */
    static buildSetActiveChannelsAndNwkManagerIdRequest(channels: number[], nwkUpdateId: number | null, nwkManagerAddr: NodeId): Buffer;
    /**
     * @see ClusterId.NWK_ENHANCED_UPDATE_REQUEST
     * @param channelPages The set of channels (32-bit bitmap) for each channel page.
     *   The five most significant bits (b27,..., b31) represent the binary encoded Channel Page.
     *   The 27 least significant bits (b0, b1,... b26) indicate which channels are to be scanned
     *   (1 = scan, 0 = do not scan) for each of the 27 valid channels
     *   If duration is in the range 0x00 to 0x05, SHALL be restricted to a single page.
     * @param duration A value used to calculate the length of time to spend scanning each channel.
     *   The time spent scanning each channel is (aBaseSuperframeDuration * (2n + 1)) symbols, where n is the value of the duration parameter.
     *   If has a value of 0xfe this is a request for channel change.
     *   If has a value of 0xff this is a request to change the apsChannelMaskList and nwkManagerAddr attributes.
     * @param count This field represents the number of energy scans to be conducted and reported.
     *   This field SHALL be present only if the duration is within the range of 0x00 to 0x05.
     * @param nwkUpdateId The value of the nwkUpdateId contained in this request.
     *   This value is set by the Network Channel Manager prior to sending the message.
     *   This field SHALL only be present if the duration is 0xfe or 0xff.
     *   If the ScanDuration is 0xff, then the value in the nwkUpdateID SHALL be ignored.
     * @param nwkManagerAddr This field SHALL be present only if the duration is set to 0xff, and, where present,
     *   indicates the NWK address for the device with the Network Manager bit set in its Node Descriptor.
     * @param configurationBitmask Defined in defined in section 2.4.3.3.12.
     *   The configurationBitmask must be added to the end of the list of parameters.
     *   This octet may or may not be present.
     *   If not present then assumption should be that it is enhanced active scan.
     *   Bit 0: This bit determines whether to do an Active Scan or Enhanced Active Scan.
     *          When the bit is set to 1 it indicates an Enhanced Active Scan.
     *          And in case of Enhanced Active scan EBR shall be sent with EPID filter instead of PJOIN filter.
     *   Bit 1-7: Reserved
     */
    private static buildNwkEnhancedUpdateRequest;
    /**
     * Shortcut for @see BuffaloZdo.buildNwkEnhancedUpdateRequest
     */
    static buildEnhancedScanChannelsRequest(channelPages: number[], duration: number, count: number, configurationBitmask: number | null): Buffer;
    /**
     * Shortcut for @see BuffaloZdo.buildNwkEnhancedUpdateRequest
     */
    static buildEnhancedChannelChangeRequest(channelPage: number, nwkUpdateId: number | null, configurationBitmask: number | null): Buffer;
    /**
     * Shortcut for @see BuffaloZdo.buildNwkEnhancedUpdateRequest
     */
    static buildEnhancedSetActiveChannelsAndNwkManagerIdRequest(channelPages: number[], nwkUpdateId: number | null, nwkManagerAddr: NodeId, configurationBitmask: number | null): Buffer;
    /**
     * @see ClusterId.NWK_IEEE_JOINING_LIST_REQUEST
     * @param startIndex The starting index into the receiving device’s nwkIeeeJoiningList that SHALL be sent back.
     */
    static buildNwkIEEEJoiningListRequest(startIndex: number): Buffer;
    /**
     * @see ClusterId.NWK_BEACON_SURVEY_REQUEST
     */
    static buildNwkBeaconSurveyRequest(tlv: BeaconSurveyConfigurationTLV): Buffer;
    /**
     * @see ClusterId.START_KEY_NEGOTIATION_REQUEST
     */
    static buildStartKeyNegotiationRequest(tlv: Curve25519PublicPointTLV): Buffer;
    /**
     * @see ClusterId.RETRIEVE_AUTHENTICATION_TOKEN_REQUEST
     */
    static buildRetrieveAuthenticationTokenRequest(tlv: AuthenticationTokenIdTLV): Buffer;
    /**
     * @see ClusterId.GET_AUTHENTICATION_LEVEL_REQUEST
     */
    static buildGetAuthenticationLevelRequest(tlv: TargetIEEEAddressTLV): Buffer;
    /**
     * @see ClusterId.SET_CONFIGURATION_REQUEST
     */
    static buildSetConfigurationRequest(nextPanIdChange: NextPanIdChangeGlobalTLV, nextChannelChange: NextChannelChangeGlobalTLV, configurationParameters: ConfigurationParametersGlobalTLV): Buffer;
    /**
     * @see ClusterId.GET_CONFIGURATION_REQUEST
     * @param tlvIds The IDs of each TLV that are being requested.
     *   Maximum number dependent on the underlying maximum size of the message as allowed by fragmentation.
     */
    static buildGetConfigurationRequest(tlvIds: number[]): Buffer;
    /**
     * @see ClusterId.START_KEY_UPDATE_REQUEST
     */
    static buildStartKeyUpdateRequest(selectedKeyNegotiationMethod: SelectedKeyNegotiationMethodTLV, fragmentationParameters: FragmentationParametersGlobalTLV): Buffer;
    /**
     * @see ClusterId.DECOMMISSION_REQUEST
     */
    static buildDecommissionRequest(tlv: DeviceEUI64ListTLV): Buffer;
    /**
     * @see ClusterId.CHALLENGE_REQUEST
     */
    static buildChallengeRequest(tlv: APSFrameCounterChallengeTLV): Buffer;
    static readResponse(clusterId: ZdoClusterId, buffer: Buffer): unknown;
    /**
     * @see ClusterId.NETWORK_ADDRESS_RESPONSE
     */
    readNetworkAddressResponse(): NetworkAddressResponse;
    /**
     * @see ClusterId.IEEE_ADDRESS_RESPONSE
     */
    readIEEEAddressResponse(): IEEEAddressResponse;
    /**
     * @see ClusterId.NODE_DESCRIPTOR_RESPONSE
     */
    readNodeDescriptorResponse(): NodeDescriptorResponse;
    /**
     * @see ClusterId.POWER_DESCRIPTOR_RESPONSE
     */
    readPowerDescriptorResponse(): PowerDescriptorResponse;
    /**
     * @see ClusterId.SIMPLE_DESCRIPTOR_RESPONSE
     */
    readSimpleDescriptorResponse(): SimpleDescriptorResponse;
    /**
     * @see ClusterId.ACTIVE_ENDPOINTS_RESPONSE
     */
    readActiveEndpointsResponse(): ActiveEndpointsResponse;
    /**
     * @see ClusterId.MATCH_DESCRIPTORS_RESPONSE
     */
    readMatchDescriptorsResponse(): MatchDescriptorsResponse;
    /**
     * @see ClusterId.END_DEVICE_ANNOUNCE
     */
    readEndDeviceAnnounce(): EndDeviceAnnounce;
    /**
     * @see ClusterId.SYSTEM_SERVER_DISCOVERY_RESPONSE
     */
    readSystemServerDiscoveryResponse(): SystemServerDiscoveryResponse;
    /**
     * @see ClusterId.PARENT_ANNOUNCE_RESPONSE
     */
    readParentAnnounceResponse(): ParentAnnounceResponse;
    /**
     * @see ClusterId.BIND_RESPONSE
     * @returns No response payload, throws if not success
     */
    readBindResponse(): void;
    /**
     * @see ClusterId.UNBIND_RESPONSE
     * @returns No response payload, throws if not success
     */
    readUnbindResponse(): void;
    /**
     * @see ClusterId.CLEAR_ALL_BINDINGS_RESPONSE
     * @returns No response payload, throws if not success
     */
    readClearAllBindingsResponse(): void;
    /**
     * @see ClusterId.LQI_TABLE_RESPONSE
     */
    readLQITableResponse(): LQITableResponse;
    /**
     * @see ClusterId.ROUTING_TABLE_RESPONSE
     */
    readRoutingTableResponse(): RoutingTableResponse;
    /**
     * @see ClusterId.BINDING_TABLE_RESPONSE
     */
    readBindingTableResponse(): BindingTableResponse;
    /**
     * @see ClusterId.LEAVE_RESPONSE
     * @returns No response payload, throws if not success
     */
    readLeaveResponse(): void;
    /**
     * @see ClusterId.PERMIT_JOINING_RESPONSE
     * @returns No response payload, throws if not success
     */
    readPermitJoiningResponse(): void;
    /**
     * @see ClusterId.NWK_UPDATE_RESPONSE
     */
    readNwkUpdateResponse(): NwkUpdateResponse;
    /**
     * @see ClusterId.NWK_ENHANCED_UPDATE_RESPONSE
     */
    readNwkEnhancedUpdateResponse(): NwkEnhancedUpdateResponse;
    /**
     * @see ClusterId.NWK_IEEE_JOINING_LIST_REPONSE
     */
    readNwkIEEEJoiningListResponse(): NwkIEEEJoiningListResponse;
    /**
     * @see ClusterId.NWK_UNSOLICITED_ENHANCED_UPDATE_RESPONSE
     */
    readNwkUnsolicitedEnhancedUpdateResponse(): NwkUnsolicitedEnhancedUpdateResponse;
    /**
     * @see ClusterId.NWK_BEACON_SURVEY_RESPONSE
     */
    readNwkBeaconSurveyResponse(): NwkBeaconSurveyResponse;
    /**
     * @see ClusterId.START_KEY_NEGOTIATION_RESPONSE
     */
    readStartKeyNegotiationResponse(): StartKeyNegotiationResponse;
    /**
     * @see ClusterId.RETRIEVE_AUTHENTICATION_TOKEN_RESPONSE
     */
    readRetrieveAuthenticationTokenResponse(): RetrieveAuthenticationTokenResponse;
    /**
     * @see ClusterId.GET_AUTHENTICATION_LEVEL_RESPONSE
     */
    readGetAuthenticationLevelResponse(): GetAuthenticationLevelResponse;
    /**
     * @see ClusterId.SET_CONFIGURATION_RESPONSE
     */
    readSetConfigurationResponse(): SetConfigurationResponse;
    /**
     * @see ClusterId.GET_CONFIGURATION_RESPONSE
     */
    readGetConfigurationResponse(): GetConfigurationResponse;
    /**
     * @see ClusterId.START_KEY_UPDATE_RESPONSE
     * @returns No response payload, throws if not success
     */
    readStartKeyUpdateResponse(): void;
    /**
     * @see ClusterId.DECOMMISSION_RESPONSE
     * @returns No response payload, throws if not success
     */
    readDecommissionResponse(): void;
    /**
     * @see ClusterId.CHALLENGE_RESPONSE
     */
    readChallengeResponse(): ChallengeResponse;
}
//# sourceMappingURL=buffaloZdo.d.ts.map