/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum FrameField {
    LASTLINE,
    BACKREF,
    VISIBILITY,
    BLOCK,
    SELF,
    METHODNAME,
    LINE,
    CLASS,
    FILENAME,
    SCOPE;

    private final int bit = 1 << this.ordinal();

    public boolean needsFrame() {
        switch (this) {
            case LASTLINE: 
            case BACKREF: 
            case VISIBILITY: 
            case BLOCK: 
            case SELF: 
            case METHODNAME: 
            case CLASS: {
                return true;
            }
        }
        return false;
    }

    public static boolean needsFrame(int bits) {
        return (bits & (FrameField.LASTLINE.bit | FrameField.BACKREF.bit | FrameField.VISIBILITY.bit | FrameField.BLOCK.bit | FrameField.SELF.bit | FrameField.METHODNAME.bit | FrameField.CLASS.bit)) != 0;
    }

    public static boolean needsScope(int bits) {
        return (bits & FrameField.SCOPE.bit) != 0;
    }

    public boolean needsScope() {
        return this == SCOPE;
    }

    public static int pack(FrameField[] frameFields) {
        int bits = 0;
        for (FrameField frameField : frameFields) {
            bits |= frameField.bit;
        }
        return bits;
    }

    public static Set<FrameField> unpack(int bits) {
        HashSet<FrameField> frameFields = Collections.EMPTY_SET;
        for (FrameField frameField : FrameField.values()) {
            if ((bits & frameField.bit) == 0) continue;
            if (frameFields == Collections.EMPTY_SET) {
                frameFields = new HashSet<FrameField>();
            }
            frameFields.add(frameField);
        }
        return frameFields;
    }
}

