
#ifndef KCONFIGCORE_EXPORT_H
#define KCONFIGCORE_EXPORT_H

#ifdef KCONFIGCORE_STATIC_DEFINE
#  define KCONFIGCORE_EXPORT
#  define KCONFIGCORE_NO_EXPORT
#else
#  ifndef KCONFIGCORE_EXPORT
#    ifdef KF6ConfigCore_EXPORTS
        /* We are building this library */
#      define KCONFIGCORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KCONFIGCORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KCONFIGCORE_NO_EXPORT
#    define KCONFIGCORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KCONFIGCORE_DECL_DEPRECATED
#  define KCONFIGCORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KCONFIGCORE_DECL_DEPRECATED_EXPORT
#  define KCONFIGCORE_DECL_DEPRECATED_EXPORT KCONFIGCORE_EXPORT KCONFIGCORE_DECL_DEPRECATED
#endif

#ifndef KCONFIGCORE_DECL_DEPRECATED_NO_EXPORT
#  define KCONFIGCORE_DECL_DEPRECATED_NO_EXPORT KCONFIGCORE_NO_EXPORT KCONFIGCORE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCONFIGCORE_NO_DEPRECATED
#    define KCONFIGCORE_NO_DEPRECATED
#  endif
#endif
#include <kconfig_version.h>

#define KCONFIGCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KCONFIGCORE_NO_DEPRECATED) && !defined(KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCONFIGCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCONFIGCORE_NO_DEPRECATED_WARNINGS) && !defined(KCONFIGCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCONFIGCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCONFIGCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCONFIGCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCONFIGCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCONFIGCORE_NO_DEPRECATED)
#  undef KCONFIGCORE_DEPRECATED
#  define KCONFIGCORE_DEPRECATED_EXPORT KCONFIGCORE_EXPORT
#  define KCONFIGCORE_DEPRECATED_NO_EXPORT KCONFIGCORE_NO_EXPORT
#elif defined(KCONFIGCORE_NO_DEPRECATED_WARNINGS)
#  define KCONFIGCORE_DEPRECATED
#  define KCONFIGCORE_DEPRECATED_EXPORT KCONFIGCORE_EXPORT
#  define KCONFIGCORE_DEPRECATED_NO_EXPORT KCONFIGCORE_NO_EXPORT
#else
#  define KCONFIGCORE_DEPRECATED KCONFIGCORE_DECL_DEPRECATED
#  define KCONFIGCORE_DEPRECATED_EXPORT KCONFIGCORE_DECL_DEPRECATED_EXPORT
#  define KCONFIGCORE_DEPRECATED_NO_EXPORT KCONFIGCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCONFIGCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCONFIGCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCONFIGCORE_NO_DEPRECATED
#  define KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KCONFIG_VERSION
#endif
#ifdef KCONFIGCORE_NO_DEPRECATED_WARNINGS
#  define KCONFIGCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCONFIGCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCONFIGCORE_DEPRECATED_WARNINGS_SINCE KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCONFIGCORE_DEPRECATED_WARNINGS_SINCE KCONFIG_VERSION
#  endif
#endif

#ifndef KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCONFIGCORE_DEPRECATED
#  define KCONFIGCORE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCONFIGCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCONFIGCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KCONFIGCORE_DEPRECATED_WARNINGS_SINCE >= 0x60300
#  define KCONFIGCORE_DEPRECATED_VERSION_6_3(text) KCONFIGCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KCONFIGCORE_DEPRECATED_VERSION_6_3(text)
#endif
#define KCONFIGCORE_DEPRECATED_VERSION_6(minor, text)      KCONFIGCORE_DEPRECATED_VERSION_6_##minor(text)
#define KCONFIGCORE_DEPRECATED_VERSION(major, minor, text) KCONFIGCORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KCONFIGCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCONFIGCORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KCONFIGCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KCONFIGCORE_DEPRECATED_VERSION(major, minor, text)
#  define KCONFIGCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCONFIGCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KCONFIGCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KCONFIGCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KCONFIGCORE_EXPORT_H */
