
#ifndef KSVG_EXPORT_H
#define KSVG_EXPORT_H

#ifdef KSVG_STATIC_DEFINE
#  define KSVG_EXPORT
#  define KSVG_NO_EXPORT
#else
#  ifndef KSVG_EXPORT
#    ifdef KF6Svg_EXPORTS
        /* We are building this library */
#      define KSVG_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KSVG_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KSVG_NO_EXPORT
#    define KSVG_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KSVG_DECL_DEPRECATED
#  define KSVG_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KSVG_DECL_DEPRECATED_EXPORT
#  define KSVG_DECL_DEPRECATED_EXPORT KSVG_EXPORT KSVG_DECL_DEPRECATED
#endif

#ifndef KSVG_DECL_DEPRECATED_NO_EXPORT
#  define KSVG_DECL_DEPRECATED_NO_EXPORT KSVG_NO_EXPORT KSVG_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KSVG_NO_DEPRECATED
#    define KSVG_NO_DEPRECATED
#  endif
#endif
#include <ksvg_version.h>

#define KSVG_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KSVG_NO_DEPRECATED) && !defined(KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KSVG_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KSVG_NO_DEPRECATED_WARNINGS) && !defined(KSVG_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KSVG_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KSVG_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KSVG_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KSVG_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KSVG_NO_DEPRECATED)
#  undef KSVG_DEPRECATED
#  define KSVG_DEPRECATED_EXPORT KSVG_EXPORT
#  define KSVG_DEPRECATED_NO_EXPORT KSVG_NO_EXPORT
#elif defined(KSVG_NO_DEPRECATED_WARNINGS)
#  define KSVG_DEPRECATED
#  define KSVG_DEPRECATED_EXPORT KSVG_EXPORT
#  define KSVG_DEPRECATED_NO_EXPORT KSVG_NO_EXPORT
#else
#  define KSVG_DEPRECATED KSVG_DECL_DEPRECATED
#  define KSVG_DEPRECATED_EXPORT KSVG_DECL_DEPRECATED_EXPORT
#  define KSVG_DEPRECATED_NO_EXPORT KSVG_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KSVG_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KSVG_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KSVG_NO_DEPRECATED
#  define KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT KSVG_VERSION
#endif
#ifdef KSVG_NO_DEPRECATED_WARNINGS
#  define KSVG_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KSVG_DEPRECATED_WARNINGS_SINCE
#  ifdef KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KSVG_DEPRECATED_WARNINGS_SINCE KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KSVG_DEPRECATED_WARNINGS_SINCE KSVG_VERSION
#  endif
#endif

#ifndef KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KSVG_DEPRECATED
#  define KSVG_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KSVG_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KSVG_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KSVG_EXPORT_H */
