"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOW_BASE_API = exports.MONITOR_BASE_API = exports.EMAIL_GROUP_BASE_API = exports.EMAIL_ACCOUNT_BASE_API = exports.DESTINATION_BASE_API = exports.DEFAULT_HEADERS = exports.CROSS_CLUSTER_BASE_API = exports.CLUSTER = exports.API_ROUTE_PREFIX = exports.AD_BASE_API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_ROUTE_PREFIX = exports.API_ROUTE_PREFIX = '/_plugins/_alerting';
const MONITOR_BASE_API = exports.MONITOR_BASE_API = `${API_ROUTE_PREFIX}/monitors`;
const WORKFLOW_BASE_API = exports.WORKFLOW_BASE_API = `${API_ROUTE_PREFIX}/workflows`;
const CROSS_CLUSTER_BASE_API = exports.CROSS_CLUSTER_BASE_API = `${API_ROUTE_PREFIX}/remote`;
const AD_BASE_API = exports.AD_BASE_API = `/_plugins/_anomaly_detection/detectors`;
const DESTINATION_BASE_API = exports.DESTINATION_BASE_API = `${API_ROUTE_PREFIX}/destinations`;
const EMAIL_ACCOUNT_BASE_API = exports.EMAIL_ACCOUNT_BASE_API = `${DESTINATION_BASE_API}/email_accounts`;
const EMAIL_GROUP_BASE_API = exports.EMAIL_GROUP_BASE_API = `${DESTINATION_BASE_API}/email_groups`;
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch-Dashboards'
};
const CLUSTER = exports.CLUSTER = {
  ADMIN: 'admin',
  ALERTING: 'opensearch_alerting',
  AD_ALERTING: 'alerting_ad',
  DATA: 'data'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJBUElfUk9VVEVfUFJFRklYIiwiZXhwb3J0cyIsIk1PTklUT1JfQkFTRV9BUEkiLCJXT1JLRkxPV19CQVNFX0FQSSIsIkNST1NTX0NMVVNURVJfQkFTRV9BUEkiLCJBRF9CQVNFX0FQSSIsIkRFU1RJTkFUSU9OX0JBU0VfQVBJIiwiRU1BSUxfQUNDT1VOVF9CQVNFX0FQSSIsIkVNQUlMX0dST1VQX0JBU0VfQVBJIiwiREVGQVVMVF9IRUFERVJTIiwiQWNjZXB0IiwiQ0xVU1RFUiIsIkFETUlOIiwiQUxFUlRJTkciLCJBRF9BTEVSVElORyIsIkRBVEEiXSwic291cmNlcyI6WyJjb25zdGFudHMuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5leHBvcnQgY29uc3QgQVBJX1JPVVRFX1BSRUZJWCA9ICcvX3BsdWdpbnMvX2FsZXJ0aW5nJztcbmV4cG9ydCBjb25zdCBNT05JVE9SX0JBU0VfQVBJID0gYCR7QVBJX1JPVVRFX1BSRUZJWH0vbW9uaXRvcnNgO1xuZXhwb3J0IGNvbnN0IFdPUktGTE9XX0JBU0VfQVBJID0gYCR7QVBJX1JPVVRFX1BSRUZJWH0vd29ya2Zsb3dzYDtcbmV4cG9ydCBjb25zdCBDUk9TU19DTFVTVEVSX0JBU0VfQVBJID0gYCR7QVBJX1JPVVRFX1BSRUZJWH0vcmVtb3RlYDtcbmV4cG9ydCBjb25zdCBBRF9CQVNFX0FQSSA9IGAvX3BsdWdpbnMvX2Fub21hbHlfZGV0ZWN0aW9uL2RldGVjdG9yc2A7XG5leHBvcnQgY29uc3QgREVTVElOQVRJT05fQkFTRV9BUEkgPSBgJHtBUElfUk9VVEVfUFJFRklYfS9kZXN0aW5hdGlvbnNgO1xuZXhwb3J0IGNvbnN0IEVNQUlMX0FDQ09VTlRfQkFTRV9BUEkgPSBgJHtERVNUSU5BVElPTl9CQVNFX0FQSX0vZW1haWxfYWNjb3VudHNgO1xuZXhwb3J0IGNvbnN0IEVNQUlMX0dST1VQX0JBU0VfQVBJID0gYCR7REVTVElOQVRJT05fQkFTRV9BUEl9L2VtYWlsX2dyb3Vwc2A7XG5leHBvcnQgY29uc3QgREVGQVVMVF9IRUFERVJTID0ge1xuICAnQ29udGVudC1UeXBlJzogJ2FwcGxpY2F0aW9uL2pzb24nLFxuICBBY2NlcHQ6ICdhcHBsaWNhdGlvbi9qc29uJyxcbiAgJ1VzZXItQWdlbnQnOiAnT3BlblNlYXJjaC1EYXNoYm9hcmRzJyxcbn07XG5leHBvcnQgY29uc3QgQ0xVU1RFUiA9IHtcbiAgQURNSU46ICdhZG1pbicsXG4gIEFMRVJUSU5HOiAnb3BlbnNlYXJjaF9hbGVydGluZycsXG4gIEFEX0FMRVJUSU5HOiAnYWxlcnRpbmdfYWQnLFxuICBEQVRBOiAnZGF0YScsXG59O1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTs7QUFFTyxNQUFNQSxnQkFBZ0IsR0FBQUMsT0FBQSxDQUFBRCxnQkFBQSxHQUFHLHFCQUFxQjtBQUM5QyxNQUFNRSxnQkFBZ0IsR0FBQUQsT0FBQSxDQUFBQyxnQkFBQSxHQUFJLEdBQUVGLGdCQUFpQixXQUFVO0FBQ3ZELE1BQU1HLGlCQUFpQixHQUFBRixPQUFBLENBQUFFLGlCQUFBLEdBQUksR0FBRUgsZ0JBQWlCLFlBQVc7QUFDekQsTUFBTUksc0JBQXNCLEdBQUFILE9BQUEsQ0FBQUcsc0JBQUEsR0FBSSxHQUFFSixnQkFBaUIsU0FBUTtBQUMzRCxNQUFNSyxXQUFXLEdBQUFKLE9BQUEsQ0FBQUksV0FBQSxHQUFJLHdDQUF1QztBQUM1RCxNQUFNQyxvQkFBb0IsR0FBQUwsT0FBQSxDQUFBSyxvQkFBQSxHQUFJLEdBQUVOLGdCQUFpQixlQUFjO0FBQy9ELE1BQU1PLHNCQUFzQixHQUFBTixPQUFBLENBQUFNLHNCQUFBLEdBQUksR0FBRUQsb0JBQXFCLGlCQUFnQjtBQUN2RSxNQUFNRSxvQkFBb0IsR0FBQVAsT0FBQSxDQUFBTyxvQkFBQSxHQUFJLEdBQUVGLG9CQUFxQixlQUFjO0FBQ25FLE1BQU1HLGVBQWUsR0FBQVIsT0FBQSxDQUFBUSxlQUFBLEdBQUc7RUFDN0IsY0FBYyxFQUFFLGtCQUFrQjtFQUNsQ0MsTUFBTSxFQUFFLGtCQUFrQjtFQUMxQixZQUFZLEVBQUU7QUFDaEIsQ0FBQztBQUNNLE1BQU1DLE9BQU8sR0FBQVYsT0FBQSxDQUFBVSxPQUFBLEdBQUc7RUFDckJDLEtBQUssRUFBRSxPQUFPO0VBQ2RDLFFBQVEsRUFBRSxxQkFBcUI7RUFDL0JDLFdBQVcsRUFBRSxhQUFhO0VBQzFCQyxJQUFJLEVBQUU7QUFDUixDQUFDIn0=