"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = translate;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function translate(server, service) {
  server.post({
    path: '/api/sql_console/translatesql',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.translateSQL(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: '/api/sql_console/translateppl',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.translatePPL(request);
    return response.ok({
      body: retVal
    });
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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