"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class QueryService {
  constructor(client) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "describeQueryPostInternal", async (request, format, responseFormat, body) => {
      try {
        const params = {
          body: JSON.stringify(body)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeQueryJobIdInternal", async (request, format, jobId, responseFormat) => {
      try {
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, {
          jobId: jobId
        });
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeQueryGetInternalSync", async (request, format, responseFormat) => {
      try {
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async request => {
      return this.describeQueryPostInternal(request, 'sql.sqlQuery', 'json', request.body);
    });
    _defineProperty(this, "describePPLQuery", async request => {
      return this.describeQueryPostInternal(request, 'sql.pplQuery', 'json', request.body);
    });
    _defineProperty(this, "describeSQLCsv", async request => {
      return this.describeQueryPostInternal(request, 'sql.sqlCsv', null, request.body);
    });
    _defineProperty(this, "describePPLCsv", async request => {
      return this.describeQueryPostInternal(request, 'sql.pplCsv', null, request.body);
    });
    _defineProperty(this, "describeSQLJson", async request => {
      return this.describeQueryPostInternal(request, 'sql.sqlJson', 'json', request.body);
    });
    _defineProperty(this, "describePPLJson", async request => {
      return this.describeQueryPostInternal(request, 'sql.pplJson', 'json', request.body);
    });
    _defineProperty(this, "describeSQLText", async request => {
      return this.describeQueryPostInternal(request, 'sql.sqlText', null, request.body);
    });
    _defineProperty(this, "describePPLText", async request => {
      return this.describeQueryPostInternal(request, 'sql.pplText', null, request.body);
    });
    _defineProperty(this, "describeSQLAsyncQuery", async request => {
      return this.describeQueryPostInternal(request, 'sql.sparkSqlQuery', null, request.body);
    });
    _defineProperty(this, "describeSQLAsyncGetQuery", async (request, jobId) => {
      return this.describeQueryJobIdInternal(request, 'sql.sparkSqlGetQuery', jobId, null);
    });
    _defineProperty(this, "describeSyncQueryDataSources", async request => {
      return this.describeQueryGetInternalSync(request, 'sql.datasourcesGetQuery', null);
    });
    _defineProperty(this, "describeAsyncDeleteQuery", async (request, jobId) => {
      return this.describeQueryJobIdInternal(request, 'sql.asyncDeleteQuery', jobId, null);
    });
    this.client = client;
  }
}
exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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