/**
 * Flatten a 2-dimensional array into a 1-dimensional one.
 */
export declare function flattenArray<T>(nestedArray: T[][]): T[];
/**
 * Remove all duplicates from the list.
 * Doesn't preserve ordering.
 */
export declare function uniq<A>(a: A[]): A[];
/**
 * Removed all duplicates from the list based on the hash function.
 * First element matching the hash function wins.
 */
export declare function uniqueBasedOnHash<A extends Record<string, any>>(list: A[], elementToHash: (a: A) => string, __result?: A[]): A[];
